/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.HavingOrBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractQueryBuilder;
import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeGathererVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.PaginatedCriteriaBuilderImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.keyset.SimpleKeysetLink;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.AttributeAccessor;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractFullQueryBuilder<T, X extends FullQueryBuilder<T, X>, Z, W, FinalSetReturn extends BaseFinalSetOperationBuilderImpl<T, ?, ?>>
extends AbstractQueryBuilder<T, X, Z, W, FinalSetReturn>
implements FullQueryBuilder<T, X> {
    protected static final Set<ClauseType> NO_CLAUSE_EXCLUSION = EnumSet.noneOf(ClauseType.class);
    protected static final Set<ClauseType> OBJECT_QUERY_WITHOUT_GROUP_BY_EXCLUSIONS = EnumSet.of(ClauseType.GROUP_BY);
    protected static final Set<ClauseType> COUNT_QUERY_CLAUSE_EXCLUSIONS = EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT);
    protected static final Set<ClauseType> COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS = EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT, ClauseType.GROUP_BY);
    protected static final Set<ClauseType> ID_QUERY_CLAUSE_EXCLUSIONS = EnumSet.of(ClauseType.SELECT);
    protected static final Set<ClauseType> ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS = EnumSet.of(ClauseType.SELECT, ClauseType.GROUP_BY);
    protected long cachedMaximumCount;
    protected String cachedCountQueryString;
    protected String cachedExternalCountQueryString;
    protected Set<JoinNode> cachedIdentifierExpressionsToUseNonRootJoinNodes;
    private boolean createdPaginatedBuilder = false;
    private boolean explicitPaginatedIdentifier = false;
    private ResolvedExpression[] entityIdentifierExpressions;
    private ResolvedExpression[] uniqueIdentifierExpressions;
    private JoinNodeGathererVisitor joinNodeGathererVisitor;

    protected AbstractFullQueryBuilder(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> builder) {
        super(builder);
        this.entityIdentifierExpressions = builder.entityIdentifierExpressions;
    }

    public AbstractFullQueryBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, FinalSetReturn finalSetOperationBuilder) {
        super(mainQuery, isMainQuery, clazz, alias, finalSetOperationBuilder);
    }

    @Override
    protected void prepareForModification(ClauseType changedClause) {
        super.prepareForModification(changedClause);
        this.cachedMaximumCount = Long.MAX_VALUE;
        this.cachedCountQueryString = null;
        this.cachedExternalCountQueryString = null;
        this.cachedIdentifierExpressionsToUseNonRootJoinNodes = null;
        this.uniqueIdentifierExpressions = null;
    }

    @Override
    AbstractCommonQueryBuilder<T, X, Z, W, FinalSetReturn> copy(QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        throw new UnsupportedOperationException("This should only be used on CTEs!");
    }

    public <Y> FullQueryBuilder<Y, ?> copy(Class<Y> resultClass) {
        return this.copyCriteriaBuilder((Class)resultClass, true);
    }

    public <Y> CriteriaBuilderImpl<Y> copyCriteriaBuilder(Class<Y> resultClass, boolean copyOrderBy) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling copy() on a CriteriaBuilder that was transformed to a PaginatedCriteriaBuilder is not allowed.");
        }
        this.prepareAndCheck(null);
        MainQuery mainQuery = this.cbf.createMainQuery(this.getEntityManager());
        mainQuery.copyConfiguration(this.mainQuery.getQueryConfiguration());
        CriteriaBuilderImpl<Y> newBuilder = new CriteriaBuilderImpl<Y>(mainQuery, true, resultClass, null);
        newBuilder.fromClassExplicitlySet = true;
        newBuilder.applyFrom(this, true, true, false, copyOrderBy, Collections.emptySet(), Collections.emptySet(), new IdentityHashMap<JoinManager, JoinManager>(), ExpressionCopyContext.EMPTY);
        return newBuilder;
    }

    public CriteriaBuilder<Object[]> createPageIdQuery(int firstResult, int maxResults, String identifierExpression) {
        return this.createPageIdQuery(null, firstResult, maxResults, this.getIdentifierExpressionsToUse(identifierExpression, null));
    }

    public CriteriaBuilder<Object[]> createPageIdQuery(KeysetPage keysetPage, int firstResult, int maxResults, String identifierExpression) {
        return this.createPageIdQuery(keysetPage, firstResult, maxResults, this.getIdentifierExpressionsToUse(identifierExpression, null));
    }

    public CriteriaBuilder<Object[]> createPageIdQuery(int firstResult, int maxResults, String identifierExpression, String ... identifierExpressions) {
        return this.createPageIdQuery(null, firstResult, maxResults, this.getIdentifierExpressionsToUse(identifierExpression, identifierExpressions));
    }

    public CriteriaBuilder<Object[]> createPageIdQuery(KeysetPage keysetPage, int firstResult, int maxResults, String identifierExpression, String ... identifierExpressions) {
        return this.createPageIdQuery(keysetPage, firstResult, maxResults, this.getIdentifierExpressionsToUse(identifierExpression, identifierExpressions));
    }

    private ResolvedExpression[] getIdentifierExpressionsToUse(String identifierExpression, String[] identifierExpressions) {
        ResolvedExpression[] resolvedExpressions = this.getIdentifierExpressions(identifierExpression, identifierExpressions);
        ResolvedExpression[] uniqueResolvedExpressions = this.functionalDependencyAnalyzerVisitor.getFunctionalDependencyRootExpressions(this.whereManager.rootPredicate.getPredicate(), resolvedExpressions, this.joinManager.getRoots().get(0));
        if (uniqueResolvedExpressions != null) {
            return uniqueResolvedExpressions;
        }
        return resolvedExpressions;
    }

    protected CriteriaBuilder<Object[]> createPageIdQuery(KeysetPage keysetPage, int firstResult, int maxResults, ResolvedExpression[] identifierExpressionsToUse) {
        this.prepareAndCheck(null);
        MainQuery mainQuery = this.cbf.createMainQuery(this.getEntityManager());
        mainQuery.copyConfiguration(this.mainQuery.getQueryConfiguration());
        CriteriaBuilderImpl<Object[]> newBuilder = new CriteriaBuilderImpl<Object[]>(mainQuery, true, Object[].class, null);
        newBuilder.fromClassExplicitlySet = true;
        this.applyPageIdQueryInto(newBuilder, keysetPage, firstResult, maxResults, identifierExpressionsToUse, false);
        return newBuilder;
    }

    protected void applyPageIdQueryInto(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> newBuilder, KeysetPage keysetPage, int firstResult, int maxResults, ResolvedExpression[] identifierExpressionsToUse, boolean withAlias) {
        ExpressionCopyContext expressionCopyContext = newBuilder.applyFrom(this, true, false, false, false, ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, this.getIdentifierExpressionsToUseNonRootJoinNodes(identifierExpressionsToUse), new IdentityHashMap<JoinManager, JoinManager>(), ExpressionCopyContext.EMPTY);
        newBuilder.setFirstResult(firstResult);
        newBuilder.setMaxResults(maxResults);
        List<OrderByExpression> orderByExpressions = this.orderByManager.getOrderByExpressions(false, this.whereManager.rootPredicate.getPredicate(), this.hasGroupBy ? Arrays.asList(this.getIdentifierExpressions()) : Collections.emptyList(), null);
        if (!orderByExpressions.get(orderByExpressions.size() - 1).isResultUnique()) {
            throw new IllegalStateException("The order by items of the query builder are not guaranteed to produce unique tuples! Consider also ordering by the entity identifier!");
        }
        if (keysetPage != null) {
            KeysetMode keysetMode = KeysetPaginationHelper.getKeysetMode(keysetPage, null, firstResult, maxResults);
            if (keysetMode == KeysetMode.NONE) {
                newBuilder.keysetManager.setKeysetLink(null);
            } else if (keysetMode == KeysetMode.NEXT) {
                newBuilder.keysetManager.setKeysetLink(new SimpleKeysetLink(keysetPage.getHighest(), keysetMode));
            } else {
                newBuilder.keysetManager.setKeysetLink(new SimpleKeysetLink(keysetPage.getLowest(), keysetMode));
            }
            newBuilder.keysetManager.initialize(orderByExpressions);
        }
        HashMap<String, Integer> identifierExpressionStringMap = new HashMap<String, Integer>(identifierExpressionsToUse.length);
        for (int i = 0; i < identifierExpressionsToUse.length; ++i) {
            identifierExpressionStringMap.put(identifierExpressionsToUse[i].getExpressionString(), i);
        }
        String[] identifierToUseSelectAliases = newBuilder.orderByManager.applyFrom(this.orderByManager, identifierExpressionStringMap);
        if (withAlias) {
            for (int i = 0; i < identifierExpressionsToUse.length; ++i) {
                ArrayList<Object> args = new ArrayList<Object>(2);
                args.add(identifierExpressionsToUse[i].getExpression().copy(expressionCopyContext));
                args.add(new StringLiteral("synth_col_" + i));
                newBuilder.selectManager.select((Expression)new FunctionExpression("alias", args), identifierToUseSelectAliases[i]);
            }
        } else {
            for (int i = 0; i < identifierExpressionsToUse.length; ++i) {
                newBuilder.selectManager.select(identifierExpressionsToUse[i].getExpression().copy(expressionCopyContext), identifierToUseSelectAliases[i]);
            }
        }
    }

    private String getCountQueryStringWithoutCheck(long maximumCount) {
        if (this.cachedMaximumCount != maximumCount) {
            this.cachedMaximumCount = maximumCount;
            this.cachedCountQueryString = null;
            this.cachedExternalCountQueryString = null;
        }
        if (this.cachedCountQueryString == null) {
            this.cachedCountQueryString = this.buildPageCountQueryString(false, true, this.cachedMaximumCount);
        }
        return this.cachedCountQueryString;
    }

    private String getExternalCountQueryString(long maximumCount) {
        if (this.cachedMaximumCount != maximumCount) {
            this.cachedMaximumCount = maximumCount;
            this.cachedCountQueryString = null;
            this.cachedExternalCountQueryString = null;
        }
        if (this.cachedExternalCountQueryString == null) {
            this.cachedExternalCountQueryString = this.buildPageCountQueryString(true, true, this.cachedMaximumCount);
        }
        return this.cachedExternalCountQueryString;
    }

    protected String buildPageCountQueryString(boolean externalRepresentation, boolean countAll, long maximumCount) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        if (this.useCountWrapper(countAll)) {
            if (externalRepresentation) {
                sbSelectFrom.append("SELECT COUNT(*) FROM (");
                this.buildBaseQueryString(sbSelectFrom, externalRepresentation, null, true);
                if (maximumCount != Long.MAX_VALUE) {
                    sbSelectFrom.append(" LIMIT ").append(maximumCount);
                }
                sbSelectFrom.append(')');
            } else {
                this.buildBaseQueryString(sbSelectFrom, externalRepresentation, null, true);
            }
        } else {
            this.buildPageCountQueryString(sbSelectFrom, externalRepresentation, countAll && !this.hasGroupBy && !this.selectManager.isDistinct(), maximumCount);
        }
        return sbSelectFrom.toString();
    }

    protected final boolean useCountWrapper(boolean countAll) {
        return this.isComplexCountQuery() || !this.mainQuery.dbmsDialect.supportsCountTuple() && countAll && (this.hasGroupBy || this.selectManager.isDistinct());
    }

    protected final boolean isComplexCountQuery() {
        return !this.havingManager.isEmpty() || this.hasGroupBy && this.selectManager.isDistinct() || this.hasLimit() && !(this instanceof PaginatedCriteriaBuilderImpl);
    }

    protected final String getDualNodeAlias() {
        return "dual_";
    }

    protected final JoinNode createDualNode() {
        return JoinNode.createSimpleValuesRootNode(this.mainQuery, Long.class, 1, new JoinAliasInfo(this.getDualNodeAlias(), this.getDualNodeAlias(), false, true, null));
    }

    protected final void buildPageCountQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, boolean countAll, long maximumCount) {
        block34: {
            Set<JoinNode> countNodesToFetch;
            ArrayList<String> optionalWhereClauseConjuncts;
            ArrayList<String> whereClauseConjuncts;
            boolean isResultUnique;
            int countEndIdx;
            int countStartIdx;
            block35: {
                block33: {
                    boolean isResultUnique2;
                    int countEndIdx2;
                    sbSelectFrom.append("SELECT ");
                    countStartIdx = sbSelectFrom.length();
                    if (maximumCount == Long.MAX_VALUE) break block33;
                    Set<JoinNode> alwaysIncludedNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
                    Set<ClauseType> clauseExclusions = countAll ? NO_CLAUSE_EXCLUSION : COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS;
                    List<JoinNode> entityFunctions = this.joinManager.getEntityFunctions(clauseExclusions, true, alwaysIncludedNodes);
                    List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(null, entityFunctions);
                    JoinNode valuesNode = this.createDualNode();
                    if (externalRepresentation) {
                        sbSelectFrom.append("COUNT(*)");
                        this.appendPageCountQueryStringExtensions(sbSelectFrom);
                        sbSelectFrom.append(" FROM ");
                    } else {
                        sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("count_wrapper", 1));
                        if (!this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                            sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("limit", 1));
                        }
                        for (int i = 0; i < entityFunctionNodes.size(); ++i) {
                            sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("entity_function", 1));
                        }
                    }
                    sbSelectFrom.append("(SELECT ");
                    countStartIdx = sbSelectFrom.length();
                    String aliasFunctionInvocation = this.mainQuery.jpaProvider.getCustomFunctionInvocation("alias", 1);
                    if (countAll) {
                        sbSelectFrom.append(aliasFunctionInvocation);
                        sbSelectFrom.append("1, 'c')");
                        countEndIdx2 = sbSelectFrom.length() - 1;
                        isResultUnique2 = true;
                    } else {
                        sbSelectFrom.append("DISTINCT ");
                        isResultUnique2 = this.appendIdentifierExpressions(sbSelectFrom, true);
                        countEndIdx2 = sbSelectFrom.length() - 1;
                    }
                    ArrayList<String> whereClauseConjuncts2 = new ArrayList<String>();
                    ArrayList<String> optionalWhereClauseConjuncts2 = new ArrayList<String>();
                    Set<JoinNode> countNodesToFetch2 = Collections.emptySet();
                    if (countAll) {
                        this.joinManager.buildClause(sbSelectFrom, clauseExclusions, null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts2, whereClauseConjuncts2, this.explicitVersionEntities, countNodesToFetch2, Collections.emptySet(), null, true);
                        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts2, optionalWhereClauseConjuncts2);
                    } else {
                        Set<JoinNode> identifierExpressionsToUseNonRootJoinNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
                        Set<JoinNode> collectionJoinNodes = this.joinManager.buildClause(sbSelectFrom, clauseExclusions, null, true, externalRepresentation, true, false, optionalWhereClauseConjuncts2, whereClauseConjuncts2, this.explicitVersionEntities, countNodesToFetch2, identifierExpressionsToUseNonRootJoinNodes, null, true);
                        boolean hasCollectionJoinUsages = collectionJoinNodes.size() > 0;
                        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts2, optionalWhereClauseConjuncts2);
                        if (!hasCollectionJoinUsages && isResultUnique2) {
                            int i = countStartIdx;
                            int j = 0;
                            while (i < countEndIdx2) {
                                sbSelectFrom.setCharAt(i, ' ');
                                ++i;
                                ++j;
                            }
                            String suffix = "1, 'c'";
                            sbSelectFrom.replace(countEndIdx2 - (aliasFunctionInvocation.length() + suffix.length()), countEndIdx2 - suffix.length(), aliasFunctionInvocation);
                            sbSelectFrom.replace(countEndIdx2 - suffix.length(), countEndIdx2, suffix);
                        }
                    }
                    if (externalRepresentation) {
                        sbSelectFrom.append(" LIMIT ").append(maximumCount).append(')');
                    } else {
                        if (!this.mainQuery.dbmsDialect.supportsLimitWithoutOrderBy() || this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                            sbSelectFrom.append(" ORDER BY ");
                            sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("null_subquery", 0));
                            sbSelectFrom.append(')');
                        }
                        if (this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                            sbSelectFrom.append(" LIMIT ").append(maximumCount);
                        }
                        sbSelectFrom.append(')');
                        this.finishEntityFunctionNodes(sbSelectFrom, entityFunctionNodes);
                        if (!this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                            sbSelectFrom.append(", ").append(maximumCount).append(")");
                        }
                        sbSelectFrom.append(")");
                        this.appendPageCountQueryStringExtensions(sbSelectFrom);
                        sbSelectFrom.append(" FROM ").append(valuesNode.getValueType().getName()).append(" ").append(valuesNode.getAlias());
                        sbSelectFrom.append(" WHERE ");
                        this.joinManager.renderPlaceholderRequiringPredicate(sbSelectFrom, valuesNode, valuesNode.getAlias(), externalRepresentation, true);
                    }
                    break block34;
                }
                if (countAll) {
                    if (this.mainQuery.jpaProvider.supportsCountStar()) {
                        sbSelectFrom.append("COUNT(*)");
                    } else if (this.mainQuery.jpaProvider.supportsCustomFunctions()) {
                        sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("count_star", 0)).append(')');
                    } else {
                        sbSelectFrom.append("COUNT(");
                        this.appendIdentifierExpressions(sbSelectFrom, false);
                        sbSelectFrom.append(")");
                    }
                    countEndIdx = sbSelectFrom.length() - 1;
                    isResultUnique = true;
                } else if (this.mainQuery.jpaProvider.supportsCustomFunctions() && !this.mainQuery.jpaProvider.supportsCountTuple()) {
                    sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("count_tuple", 1));
                    sbSelectFrom.append("'DISTINCT',");
                    if (this.selectManager.isDistinct()) {
                        this.selectManager.buildSelectItems(sbSelectFrom, false, externalRepresentation, false);
                        isResultUnique = false;
                    } else {
                        isResultUnique = this.appendIdentifierExpressions(sbSelectFrom, false);
                    }
                    sbSelectFrom.append(")");
                    countEndIdx = sbSelectFrom.length() - 1;
                    this.appendPageCountQueryStringExtensions(sbSelectFrom);
                } else {
                    sbSelectFrom.append("COUNT(");
                    sbSelectFrom.append("DISTINCT (");
                    if (this.selectManager.isDistinct()) {
                        this.selectManager.buildSelectItems(sbSelectFrom, false, externalRepresentation, false);
                        isResultUnique = false;
                    } else {
                        isResultUnique = this.appendIdentifierExpressions(sbSelectFrom, false);
                    }
                    sbSelectFrom.append("))");
                    countEndIdx = sbSelectFrom.length() - 1;
                    this.appendPageCountQueryStringExtensions(sbSelectFrom);
                }
                whereClauseConjuncts = new ArrayList<String>();
                optionalWhereClauseConjuncts = new ArrayList<String>();
                countNodesToFetch = Collections.emptySet();
                if (!countAll) break block35;
                this.joinManager.buildClause(sbSelectFrom, NO_CLAUSE_EXCLUSION, null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, countNodesToFetch, Collections.emptySet(), null, true);
                this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
                break block34;
            }
            Set<JoinNode> identifierExpressionsToUseNonRootJoinNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
            Set<JoinNode> collectionJoinNodes = this.joinManager.buildClause(sbSelectFrom, COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, null, true, externalRepresentation, true, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, countNodesToFetch, identifierExpressionsToUseNonRootJoinNodes, null, true);
            boolean hasCollectionJoinUsages = collectionJoinNodes.size() > 0;
            this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
            if (hasCollectionJoinUsages || !isResultUnique) break block34;
            if (this.mainQuery.jpaProvider.supportsCustomFunctions()) {
                String countStar = this.mainQuery.jpaProvider.supportsCountStar() ? "COUNT(*" : this.mainQuery.jpaProvider.getCustomFunctionInvocation("count_star", 0);
                int i = countStartIdx;
                int j = 0;
                while (i < countEndIdx) {
                    if (j < countStar.length()) {
                        sbSelectFrom.setCharAt(i, countStar.charAt(j));
                    } else {
                        sbSelectFrom.setCharAt(i, ' ');
                    }
                    ++i;
                    ++j;
                }
            } else {
                int i;
                countEndIdx = i + "DISTINCT ".length();
                for (i = countStartIdx + "COUNT(".length(); i < countEndIdx; ++i) {
                    sbSelectFrom.setCharAt(i, ' ');
                }
            }
        }
    }

    protected void finishEntityFunctionNodes(StringBuilder sbSelectFrom, List<EntityFunctionNode> entityFunctionNodes) {
        for (EntityFunctionNode node : entityFunctionNodes) {
            String subquery = node.getSubquery();
            String aliases = node.getAliases();
            String syntheticPredicate = node.getSyntheticPredicate();
            sbSelectFrom.append(",'");
            sbSelectFrom.append(node.getEntityName());
            sbSelectFrom.append("',");
            TypeUtils.STRING_CONVERTER.appendTo((Object)subquery, sbSelectFrom);
            sbSelectFrom.append(",'");
            if (aliases != null) {
                sbSelectFrom.append(aliases);
            }
            sbSelectFrom.append("','");
            if (syntheticPredicate != null) {
                sbSelectFrom.append(syntheticPredicate);
            }
            sbSelectFrom.append("')");
        }
    }

    protected void appendPageCountQueryStringExtensions(StringBuilder sbSelectFrom) {
    }

    protected boolean appendIdentifierExpressions(StringBuilder sbSelectFrom, boolean alias) {
        boolean isResultUnique;
        ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
        ResolvedExpression[] resultUniqueExpressions = this.getUniqueIdentifierExpressions();
        if (resultUniqueExpressions == null) {
            isResultUnique = false;
        } else {
            identifierExpressions = resultUniqueExpressions;
            isResultUnique = resultUniqueExpressions == this.entityIdentifierExpressions || this.functionalDependencyAnalyzerVisitor.isResultUnique();
        }
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        for (int i = 0; i < identifierExpressions.length; ++i) {
            if (alias) {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("alias", 1));
            }
            identifierExpressions[i].getExpression().accept((Expression.Visitor)this.queryGenerator);
            if (alias) {
                sbSelectFrom.append(", 'c").append(i).append("')");
            }
            sbSelectFrom.append(", ");
        }
        sbSelectFrom.setLength(sbSelectFrom.length() - 2);
        return isResultUnique;
    }

    protected ResolvedExpression[] getUniqueIdentifierExpressions() {
        if (this.uniqueIdentifierExpressions == null) {
            ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
            this.uniqueIdentifierExpressions = identifierExpressions == this.entityIdentifierExpressions ? identifierExpressions : this.functionalDependencyAnalyzerVisitor.getFunctionalDependencyRootExpressions(this.whereManager.rootPredicate.getPredicate(), identifierExpressions, this.joinManager.getRoots().get(0));
        }
        return this.uniqueIdentifierExpressions;
    }

    protected ResolvedExpression[] getIdentifierExpressionsToUse() {
        ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
        ResolvedExpression[] resultUniqueExpressions = this.getUniqueIdentifierExpressions();
        if (resultUniqueExpressions == null) {
            return identifierExpressions;
        }
        return resultUniqueExpressions;
    }

    protected Set<JoinNode> getIdentifierExpressionsToUseNonRootJoinNodes() {
        if (this.cachedIdentifierExpressionsToUseNonRootJoinNodes == null) {
            this.cachedIdentifierExpressionsToUseNonRootJoinNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes(this.getIdentifierExpressionsToUse());
        }
        return this.cachedIdentifierExpressionsToUseNonRootJoinNodes;
    }

    protected Set<JoinNode> getIdentifierExpressionsToUseNonRootJoinNodes(ResolvedExpression[] identifierExpressionsToUse) {
        if (this.joinNodeGathererVisitor == null) {
            this.joinNodeGathererVisitor = new JoinNodeGathererVisitor();
        }
        Set<JoinNode> joinNodes = this.joinNodeGathererVisitor.collectNonRootJoinNodes(identifierExpressionsToUse);
        Iterator<JoinNode> iterator = joinNodes.iterator();
        block0: while (iterator.hasNext()) {
            JoinTreeNode parentTreeNode;
            JoinNode joinNode = iterator.next();
            while ((parentTreeNode = joinNode.getParentTreeNode()) != null) {
                if (parentTreeNode.isOptional() || parentTreeNode.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE) continue block0;
                joinNode = joinNode.getParent();
            }
            iterator.remove();
        }
        return joinNodes;
    }

    protected ResolvedExpression[] getIdentifierExpressions() {
        if (this.hasGroupBy) {
            return this.getGroupByIdentifierExpressions();
        }
        return this.getQueryRootEntityIdentifierExpressions();
    }

    public String getCountQueryString() {
        this.prepareAndCheck(null);
        return this.getExternalCountQueryString(Long.MAX_VALUE);
    }

    public String getCountQueryString(long maximumCount) {
        this.prepareAndCheck(null);
        return this.getExternalCountQueryString(maximumCount);
    }

    public TypedQuery<Long> getCountQuery() {
        this.prepareAndCheck(null);
        return this.getCountQuery(this.getCountQueryStringWithoutCheck(Long.MAX_VALUE), this.useCountWrapper(true));
    }

    public TypedQuery<Long> getCountQuery(long maximumCount) {
        this.prepareAndCheck(null);
        return this.getCountQuery(this.getCountQueryStringWithoutCheck(maximumCount), this.useCountWrapper(true));
    }

    protected TypedQuery<Long> getCountQuery(String countQueryString, boolean useCountWrapper) {
        Map<String, ValuesParameterBinder> valuesBinders;
        Map<String, String> valuesParameters;
        Collection<ParameterManager.ParameterImpl<?>> parameters;
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        Set<JoinNode> alwaysIncludedNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
        List<JoinNode> entityFunctions = null;
        boolean normalQueryMode = !useCountWrapper && (!this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && (entityFunctions = this.joinManager.getEntityFunctions(COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, true, alwaysIncludedNodes)).isEmpty() && keyRestrictedLeftJoins.isEmpty());
        JoinNode dualNode = null;
        if (this.cachedMaximumCount == Long.MAX_VALUE) {
            if (normalQueryMode && AbstractFullQueryBuilder.isEmpty(keyRestrictedLeftJoins, COUNT_QUERY_CLAUSE_EXCLUSIONS)) {
                TypedQuery countQuery = this.em.createQuery(countQueryString, Long.class);
                if (this.isCacheable()) {
                    this.mainQuery.jpaProvider.setCacheable((Query)countQuery);
                }
                this.parameterManager.parameterizeQuery((Query)countQuery);
                return this.parameterManager.getCriteriaNameMapping() == null ? countQuery : new TypedQueryWrapper(countQuery, this.parameterManager.getCriteriaNameMapping());
            }
            parameters = this.parameterManager.getParameterImpls();
            valuesParameters = this.parameterManager.getValuesParameters();
            valuesBinders = this.parameterManager.getValuesBinders();
        } else {
            parameters = new ArrayList(this.parameterManager.getParameters());
            valuesParameters = new HashMap<String, String>(this.parameterManager.getValuesParameters());
            valuesBinders = this.parameterManager.getValuesBinders();
            dualNode = this.createDualNode();
            entityFunctions = new ArrayList<JoinNode>();
            entityFunctions.add(dualNode);
            String valueParameterName = dualNode.getAlias() + "_value_0";
            String[][] parameterNames = new String[1][1];
            parameterNames[0][0] = valueParameterName;
            ParameterManager.ValuesParameterWrapper valuesParameterWrapper = new ParameterManager.ValuesParameterWrapper(dualNode.getJavaType(), parameterNames, new AttributeAccessor[1]);
            parameters.add(new ParameterManager.ParameterImpl<ParameterManager.ValuesParameterWrapper>(dualNode.getAlias(), false, null, null, valuesParameterWrapper));
            valuesParameters.put(valueParameterName, dualNode.getAlias());
            valuesBinders.put(dualNode.getAlias(), valuesParameterWrapper.getBinder());
        }
        if (entityFunctions == null) {
            entityFunctions = this.joinManager.getEntityFunctions(COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, true, alwaysIncludedNodes);
        }
        Query baseQuery = this.em.createQuery(countQueryString);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        String limit = null;
        String offset = null;
        if (this.firstResult != 0) {
            offset = Integer.toString(this.firstResult);
        }
        if (this.maxResults != Integer.MAX_VALUE) {
            limit = Integer.toString(this.maxResults);
        }
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases(baseQuery, keyRestrictedLeftJoins, COUNT_QUERY_CLAUSE_EXCLUSIONS);
        ArrayList<EntityFunctionNode> entityFunctionNodes = new ArrayList<EntityFunctionNode>();
        if (dualNode == null) {
            this.collectEntityFunctionNodes(entityFunctionNodes, baseQuery, entityFunctions);
        } else {
            this.collectEntityFunctionNodes(entityFunctionNodes, baseQuery, entityFunctions, Collections.emptyList(), false, 0);
        }
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, baseQuery, parameters, parameterListNames, limit, offset, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), useCountWrapper ? this.getCountExampleQuery() : null);
        CustomSQLTypedQuery<Long> countQuery = new CustomSQLTypedQuery<Long>(querySpecification, baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), valuesParameters, valuesBinders);
        if (dualNode == null) {
            this.parameterManager.parameterizeQuery(countQuery);
        } else {
            this.parameterManager.parameterizeQuery(countQuery, dualNode.getAlias());
            countQuery.setParameter(dualNode.getAlias(), Collections.singleton(0L));
        }
        return countQuery;
    }

    protected Query getCountExampleQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.mainQuery.jpaProvider.supportsCountStar()) {
            sb.append("COUNT(*)");
        } else if (this.mainQuery.jpaProvider.supportsCustomFunctions()) {
            sb.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("count_star", 0)).append(')');
        } else {
            sb.append("COUNT(e)");
        }
        sb.append(" FROM ValuesEntity e");
        String exampleQueryString = sb.toString();
        return this.em.createQuery(exampleQueryString);
    }

    public PaginatedCriteriaBuilder<T> page(int firstRow, int pageSize) {
        return this.pageBy(firstRow, pageSize, (ResolvedExpression[])null);
    }

    public PaginatedCriteriaBuilder<T> page(Object entityId, int pageSize) {
        return this.pageByAndNavigate(entityId, pageSize, this.getQueryRootEntityIdentifierExpressions());
    }

    public PaginatedCriteriaBuilder<T> pageAndNavigate(Object entityId, int pageSize) {
        return this.pageByAndNavigate(entityId, pageSize, this.getQueryRootEntityIdentifierExpressions());
    }

    public PaginatedCriteriaBuilder<T> page(KeysetPage keysetPage, int firstRow, int pageSize) {
        return this.pageBy(keysetPage, firstRow, pageSize, (ResolvedExpression[])null);
    }

    public PaginatedCriteriaBuilder<T> pageBy(int firstRow, int pageSize, String identifierExpression) {
        return this.pageBy(firstRow, pageSize, this.getIdentifierExpressions(identifierExpression, null));
    }

    public PaginatedCriteriaBuilder<T> pageByAndNavigate(Object entityId, int pageSize, String identifierExpression) {
        return this.pageByAndNavigate(entityId, pageSize, this.getIdentifierExpressions(identifierExpression, null));
    }

    public PaginatedCriteriaBuilder<T> pageBy(KeysetPage keysetPage, int firstRow, int pageSize, String identifierExpression) {
        return this.pageBy(keysetPage, firstRow, pageSize, this.getIdentifierExpressions(identifierExpression, null));
    }

    public PaginatedCriteriaBuilder<T> pageBy(int firstRow, int pageSize, String identifierExpression, String ... identifierExpressions) {
        return this.pageBy(firstRow, pageSize, this.getIdentifierExpressions(identifierExpression, identifierExpressions));
    }

    public PaginatedCriteriaBuilder<T> pageByAndNavigate(Object entityId, int pageSize, String identifierExpression, String ... identifierExpressions) {
        return this.pageByAndNavigate(entityId, pageSize, this.getIdentifierExpressions(identifierExpression, identifierExpressions));
    }

    public PaginatedCriteriaBuilder<T> pageBy(KeysetPage keysetPage, int firstRow, int pageSize, String identifierExpression, String ... identifierExpressions) {
        return this.pageBy(keysetPage, firstRow, pageSize, this.getIdentifierExpressions(identifierExpression, identifierExpressions));
    }

    protected ResolvedExpression[] getQueryRootEntityIdentifierExpressions() {
        if (this.entityIdentifierExpressions == null) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
            Set idAttributes = JpaMetamodelUtils.getIdAttributes(this.mainQuery.metamodel.entity(rootNode.getJavaType()));
            ArrayList<ResolvedExpression> identifierExpressions = new ArrayList<ResolvedExpression>(idAttributes.size());
            StringBuilder sb = new StringBuilder();
            this.addAttributes("", idAttributes, identifierExpressions, sb, rootNode);
            this.entityIdentifierExpressions = identifierExpressions.toArray(new ResolvedExpression[identifierExpressions.size()]);
        }
        return this.entityIdentifierExpressions;
    }

    private void addAttributes(String prefix, Set<SingularAttribute<?, ?>> attributes, List<ResolvedExpression> resolvedExpressions, StringBuilder sb, JoinNode rootNode) {
        for (SingularAttribute<?, ?> attribute : attributes) {
            String attributeName = prefix.isEmpty() ? attribute.getName() : prefix + attribute.getName();
            if (attribute.getType() instanceof EmbeddableType) {
                TreeSet subAttributes = new TreeSet(JpaMetamodelUtils.ATTRIBUTE_NAME_COMPARATOR);
                subAttributes.addAll(((EmbeddableType)attribute.getType()).getSingularAttributes());
                this.addAttributes(attributeName + ".", subAttributes, resolvedExpressions, sb, rootNode);
                continue;
            }
            sb.setLength(0);
            rootNode.appendDeReference(sb, attributeName, false);
            PathExpression expression = (PathExpression)rootNode.createExpression(attributeName);
            JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
            expression.setPathReference((PathReference)new SimplePathReference(rootNode, attributeName, this.getMetamodel().type(jpaMetamodelAccessor.getAttributePath((Metamodel)this.getMetamodel(), rootNode.getManagedType(), attributeName).getAttributeClass())));
            resolvedExpressions.add(new ResolvedExpression(sb.toString(), (Expression)expression));
        }
    }

    private ResolvedExpression[] getIdentifierExpressions(String identifierExpression, String[] identifierExpressions) {
        if (identifierExpression == null) {
            throw new IllegalArgumentException("Invalid null identifier expression passed to page()!");
        }
        ArrayList<ResolvedExpression> resolvedExpressions = new ArrayList<ResolvedExpression>(identifierExpressions == null ? 1 : identifierExpression.length() + 1);
        Expression expression = this.expressionFactory.createSimpleExpression(identifierExpression, false);
        this.joinManager.implicitJoin(expression, true, true, false, null, null, JoinType.INNER, null, new HashSet<String>(), false, false, true, false, false, false);
        StringBuilder sb = new StringBuilder();
        this.implicitJoinWhereClause();
        this.functionalDependencyAnalyzerVisitor.clear(this.whereManager.rootPredicate.getPredicate(), this.joinManager.getRoots().get(0), true);
        this.functionalDependencyAnalyzerVisitor.analyzeFormsUniqueTuple(expression);
        this.queryGenerator.setQueryBuffer(sb);
        if (this.functionalDependencyAnalyzerVisitor.getSplittedOffExpressions().isEmpty()) {
            sb.setLength(0);
            expression.accept((Expression.Visitor)this.queryGenerator);
            resolvedExpressions.add(new ResolvedExpression(sb.toString(), expression));
        } else {
            for (Expression splittedOffExpression : this.functionalDependencyAnalyzerVisitor.getSplittedOffExpressions()) {
                sb.setLength(0);
                splittedOffExpression.accept((Expression.Visitor)this.queryGenerator);
                resolvedExpressions.add(new ResolvedExpression(sb.toString(), splittedOffExpression));
            }
        }
        if (identifierExpressions != null) {
            for (String expressionString : identifierExpressions) {
                expression = this.expressionFactory.createSimpleExpression(expressionString, false);
                this.joinManager.implicitJoin(expression, true, true, false, null, null, JoinType.INNER, null, new HashSet<String>(), false, false, true, false, false, false);
                this.functionalDependencyAnalyzerVisitor.analyzeFormsUniqueTuple(expression);
                if (this.functionalDependencyAnalyzerVisitor.getSplittedOffExpressions().isEmpty()) {
                    sb.setLength(0);
                    expression.accept((Expression.Visitor)this.queryGenerator);
                    ResolvedExpression resolvedExpression = new ResolvedExpression(sb.toString(), expression);
                    if (resolvedExpressions.contains(resolvedExpression)) {
                        throw new IllegalArgumentException("Duplicate identifier expression '" + expressionString + "' in " + Arrays.toString(identifierExpressions) + "!");
                    }
                    resolvedExpressions.add(resolvedExpression);
                    continue;
                }
                for (Expression splittedOffExpression : this.functionalDependencyAnalyzerVisitor.getSplittedOffExpressions()) {
                    sb.setLength(0);
                    splittedOffExpression.accept((Expression.Visitor)this.queryGenerator);
                    ResolvedExpression resolvedExpression = new ResolvedExpression(sb.toString(), splittedOffExpression);
                    if (resolvedExpressions.contains(resolvedExpression)) {
                        throw new IllegalArgumentException("Duplicate identifier expression '" + expressionString + "' in " + Arrays.toString(identifierExpressions) + "!");
                    }
                    resolvedExpressions.add(resolvedExpression);
                }
            }
        }
        ResolvedExpression[] entries = resolvedExpressions.toArray(new ResolvedExpression[resolvedExpressions.size()]);
        if (!this.functionalDependencyAnalyzerVisitor.isResultUnique()) {
            throw new IllegalArgumentException("The identifier expressions [" + AbstractFullQueryBuilder.expressionString(entries) + "] do not form a unique tuple which is required for pagination!");
        }
        return entries;
    }

    private PaginatedCriteriaBuilder<T> pageBy(int firstRow, int pageSize, ResolvedExpression[] identifierExpressions) {
        this.prepareForModification(ClauseType.GROUP_BY);
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.havingManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a HAVING query");
        }
        this.createdPaginatedBuilder = true;
        this.explicitPaginatedIdentifier = identifierExpressions != null;
        return new PaginatedCriteriaBuilderImpl(this, false, null, firstRow, pageSize, identifierExpressions);
    }

    private PaginatedCriteriaBuilder<T> pageByAndNavigate(Object entityId, int pageSize, ResolvedExpression[] identifierExpressions) {
        this.prepareForModification(ClauseType.GROUP_BY);
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.havingManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a HAVING query");
        }
        this.checkEntityId(entityId, identifierExpressions);
        this.createdPaginatedBuilder = true;
        this.explicitPaginatedIdentifier = identifierExpressions != null;
        return new PaginatedCriteriaBuilderImpl(this, false, entityId, pageSize, identifierExpressions);
    }

    private PaginatedCriteriaBuilder<T> pageBy(KeysetPage keysetPage, int firstRow, int pageSize, ResolvedExpression[] identifierExpressions) {
        this.prepareForModification(ClauseType.GROUP_BY);
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.havingManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a HAVING query");
        }
        this.createdPaginatedBuilder = true;
        this.explicitPaginatedIdentifier = identifierExpressions != null;
        return new PaginatedCriteriaBuilderImpl(this, true, keysetPage, firstRow, pageSize, identifierExpressions);
    }

    protected static String expressionString(ResolvedExpression[] identifierExpressions) {
        StringBuilder sb = new StringBuilder();
        for (ResolvedExpression identifierExpression : identifierExpressions) {
            sb.append(identifierExpression.getExpressionString()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    private void checkEntityId(Object entityId, ResolvedExpression[] identifierExpressions) {
        if (entityId == null) {
            throw new IllegalArgumentException("Invalid null entity id given");
        }
        if (identifierExpressions.length == 0) {
            throw new IllegalArgumentException("Empty identifier expressions given");
        }
        if (identifierExpressions.length > 1) {
            if (!entityId.getClass().isArray()) {
                throw new IllegalArgumentException("The type of the given entity id '" + entityId.getClass().getName() + "' is not an array of the identifier components " + Arrays.toString(identifierExpressions) + " !");
            }
            Object[] entityIdComponents = (Object[])entityId;
            if (entityIdComponents.length != identifierExpressions.length) {
                throw new IllegalArgumentException("The number of entity id components is '" + entityIdComponents.length + "' which does not match the number of identifier component expressions " + identifierExpressions.length + " !");
            }
            for (int i = 0; i < identifierExpressions.length; ++i) {
                this.checkEntityIdComponent(entityIdComponents[i], identifierExpressions[i].getExpression(), identifierExpressions[i].getExpressionString());
            }
        } else {
            this.checkEntityIdComponent(entityId, identifierExpressions[0].getExpression(), "identifier");
        }
    }

    private void checkEntityIdComponent(Object component, Expression expression, String componentName) {
        AttributeHolder attribute = JpaUtils.getAttributeForJoining(this.getMetamodel(), expression);
        Class type = attribute.getAttributeType().getJavaType();
        if (type == null || !type.isInstance(component)) {
            throw new IllegalArgumentException("The type of the given " + componentName + " '" + component.getClass().getName() + "' is not an instance of the expected type '" + JpaMetamodelUtils.getTypeName(attribute.getAttributeType()) + "'");
        }
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Class<Y> clazz) {
        this.prepareForModification(ClauseType.SELECT);
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, clazz);
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Constructor<Y> constructor) {
        this.prepareForModification(ClauseType.SELECT);
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, constructor);
    }

    public <Y> FullQueryBuilder<Y, ?> selectNew(ObjectBuilder<Y> objectBuilder) {
        this.prepareForModification(ClauseType.SELECT);
        if (objectBuilder == null) {
            throw new NullPointerException("objectBuilder");
        }
        this.verifyBuilderEnded();
        this.selectManager.selectNew(this, objectBuilder);
        return this;
    }

    public X fetch(String path) {
        this.prepareForModification(ClauseType.JOIN);
        this.verifyBuilderEnded();
        this.joinManager.implicitJoin((Expression)this.expressionFactory.createPathExpression(path), true, true, true, null, null, null, null, new HashSet<String>(), false, false, true, false, true, false);
        return (X)this;
    }

    public X fetch(String ... paths) {
        if (paths.length != 0) {
            this.prepareForModification(ClauseType.JOIN);
            this.verifyBuilderEnded();
            HashSet<String> currentlyResolvingAliases = new HashSet<String>();
            for (String path : paths) {
                this.joinManager.implicitJoin((Expression)this.expressionFactory.createPathExpression(path), true, true, true, null, null, null, null, currentlyResolvingAliases, false, false, true, false, true, false);
            }
        }
        return (X)this;
    }

    public X innerJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.INNER, true);
    }

    public X innerJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.INNER, true);
    }

    public X leftJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.LEFT, true);
    }

    public X leftJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.LEFT, true);
    }

    public X rightJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.RIGHT, true);
    }

    public X rightJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.RIGHT, true);
    }

    public X join(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, false);
    }

    public X joinDefault(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, true);
    }

    private X join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        this.prepareForModification(ClauseType.JOIN);
        this.checkJoinPreconditions(path, alias, type, defaultJoin);
        this.verifyBuilderEnded();
        this.joinManager.join(path, alias, type, fetch, defaultJoin, null);
        return (X)this;
    }

    @Override
    public X distinct() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.distinct());
    }

    @Override
    public RestrictionBuilder<X> having(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.having(expression);
    }

    @Override
    public CaseWhenStarterBuilder<RestrictionBuilder<X>> havingCase() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingCase();
    }

    @Override
    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<X>> havingSimpleCase(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSimpleCase(expression);
    }

    @Override
    public HavingOrBuilder<X> havingOr() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingOr();
    }

    @Override
    public SubqueryInitiator<X> havingExists() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingExists();
    }

    @Override
    public SubqueryInitiator<X> havingNotExists() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingNotExists();
    }

    @Override
    public SubqueryBuilder<X> havingExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingExists(criteriaBuilder);
    }

    @Override
    public SubqueryBuilder<X> havingNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingNotExists(criteriaBuilder);
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<X>> havingSubquery() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSubquery();
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<X>> havingSubquery(String subqueryAlias, String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSubquery(subqueryAlias, expression);
    }

    @Override
    public MultipleSubqueryInitiator<RestrictionBuilder<X>> havingSubqueries(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSubqueries(expression);
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<X>> havingSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSubquery(criteriaBuilder);
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<X>> havingSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.havingSubquery(subqueryAlias, expression, criteriaBuilder);
    }

    @Override
    public X setHavingExpression(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.setHavingExpression(expression));
    }

    @Override
    public MultipleSubqueryInitiator<X> setHavingExpressionSubqueries(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return super.setHavingExpressionSubqueries(expression);
    }

    @Override
    public X groupBy(String ... paths) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot add a GROUP BY clause when paginating by the expressions [" + AbstractFullQueryBuilder.expressionString(this.getIdentifierExpressions()) + "]");
        }
        return (X)((FullQueryBuilder)super.groupBy(paths));
    }

    @Override
    public X groupBy(String expression) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot add a GROUP BY clause when paginating by the expressions [" + AbstractFullQueryBuilder.expressionString(this.getIdentifierExpressions()) + "]");
        }
        return (X)((FullQueryBuilder)super.groupBy(expression));
    }

    @Override
    public X groupByRollup(String ... expressions) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot use grouping sets when paginating");
        }
        return (X)((FullQueryBuilder)super.groupByRollup(expressions));
    }

    @Override
    public X groupByCube(String ... expressions) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot use grouping sets when paginating");
        }
        return (X)((FullQueryBuilder)super.groupByCube(expressions));
    }

    @Override
    public X groupByRollup(String[] ... expressions) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot use grouping sets when paginating");
        }
        return (X)((FullQueryBuilder)super.groupByRollup(expressions));
    }

    @Override
    public X groupByCube(String[] ... expressions) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot use grouping sets when paginating");
        }
        return (X)((FullQueryBuilder)super.groupByCube(expressions));
    }

    @Override
    public X groupByGroupingSets(String[] ... expressions) {
        if (this.explicitPaginatedIdentifier) {
            throw new IllegalStateException("Cannot use grouping sets when paginating");
        }
        return (X)((FullQueryBuilder)super.groupByGroupingSets(expressions));
    }
}

