/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ConjunctionPathExpressionFindingVisitor;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.ImplicitJoinCorrelationPathReplacementVisitor;
import com.blazebit.persistence.impl.ImplicitJoinNotAllowedException;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoVisitor;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorImpl;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.WindowManager;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.spi.ExtendedManagedType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JoinVisitor
extends VisitorAdapter
implements SelectInfoVisitor,
JoinNodeVisitor,
PredicateBuilderEndedListener,
SubqueryBuilderListener<Object> {
    private final AssociationParameterTransformerFactory parameterTransformerFactory;
    private final EntityMetamodelImpl metamodel;
    private final WindowManager windowManager;
    private final JoinVisitor parentVisitor;
    private final JoinManager joinManager;
    private final ParameterManager parameterManager;
    private final boolean needsSingleValuedAssociationIdRemoval;
    private final List<JoinNode> fetchableNodes;
    private final Set<String> currentlyResolvingAliases;
    private final ImplicitJoinCorrelationPathReplacementVisitor correlationPathReplacementVisitor;
    private JoinNode currentJoinNode;
    private boolean reuseExisting;
    private boolean joinRequired;
    private boolean joinWithObjectLeafAllowed = true;
    private boolean joinAllowed;
    private PathElementExpression relativeExpressionPrefix;
    private ClauseType fromClause;
    private ConjunctionPathExpressionFindingVisitor conjunctionPathExpressionFindingVisitor;

    public JoinVisitor(MainQuery mainQuery, WindowManager windowManager, JoinVisitor parentVisitor, JoinManager joinManager, ParameterManager parameterManager, boolean needsSingleValuedAssociationIdRemoval) {
        this.parameterTransformerFactory = mainQuery.parameterTransformerFactory;
        this.metamodel = mainQuery.metamodel;
        this.windowManager = windowManager;
        this.parentVisitor = parentVisitor;
        this.joinManager = joinManager;
        this.parameterManager = parameterManager;
        this.needsSingleValuedAssociationIdRemoval = needsSingleValuedAssociationIdRemoval;
        this.fetchableNodes = new ArrayList<JoinNode>();
        this.currentlyResolvingAliases = new HashSet<String>();
        this.correlationPathReplacementVisitor = new ImplicitJoinCorrelationPathReplacementVisitor();
        this.joinRequired = true;
    }

    public void reset() {
        this.currentJoinNode = null;
        this.reuseExisting = false;
        this.joinRequired = true;
        this.joinWithObjectLeafAllowed = true;
        this.joinAllowed = false;
        this.relativeExpressionPrefix = null;
        this.fromClause = null;
    }

    public PathElementExpression getRelativeExpressionPrefix() {
        return this.relativeExpressionPrefix;
    }

    public void setRelativeExpressionPrefix(PathElementExpression relativeExpressionPrefix) {
        this.relativeExpressionPrefix = relativeExpressionPrefix;
    }

    public ClauseType getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(ClauseType fromClause) {
        this.fromClause = fromClause;
        this.joinAllowed = fromClause != ClauseType.JOIN;
    }

    public JoinNode getCurrentJoinNode() {
        return this.currentJoinNode;
    }

    public void setCurrentJoinNode(JoinNode currentJoinNode) {
        this.currentJoinNode = currentJoinNode;
    }

    public boolean setReuseExisting(boolean reuseExisting) {
        boolean old = this.reuseExisting;
        this.reuseExisting = reuseExisting;
        return old;
    }

    public List<JoinNode> getFetchableNodes() {
        return this.fetchableNodes;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder o) {
    }

    @Override
    public void onReplaceBuilder(SubqueryInternalBuilder<Object> oldBuilder, SubqueryInternalBuilder<Object> newBuilder) {
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<Object> builder) {
    }

    @Override
    public void onBuilderStarted(SubqueryInternalBuilder<Object> builder) {
    }

    @Override
    public void onInitiatorStarted(SubqueryInitiator<?> initiator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(JoinNode node) {
        if (node.getOnPredicate() != null) {
            this.currentJoinNode = node;
            try {
                node.getOnPredicate().accept((Expression.Visitor)this);
                if (!this.correlationPathReplacementVisitor.getPathsToCorrelate().isEmpty()) {
                    SubqueryInitiatorImpl subqueryInitiator = (SubqueryInitiatorImpl)this.joinManager.getSubqueryInitFactory().createSubqueryInitiator(null, this, true, this.fromClause);
                    AbstractCommonQueryBuilder subqueryBuilder = null;
                    ArrayList<Predicate> additionalPredicates = new ArrayList<Predicate>(this.correlationPathReplacementVisitor.getRootsToCorrelate().size());
                    for (ImplicitJoinCorrelationPathReplacementVisitor.RootCorrelationEntry entry : this.correlationPathReplacementVisitor.getRootsToCorrelate()) {
                        if (subqueryBuilder == null) {
                            subqueryBuilder = (SubqueryBuilderImpl)subqueryInitiator.from(entry.getEntityClass(), entry.getAlias());
                        } else {
                            subqueryBuilder.from(entry.getEntityClass(), entry.getAlias());
                        }
                        additionalPredicates.add(entry.getAdditionalPredicate());
                    }
                    for (ImplicitJoinCorrelationPathReplacementVisitor.CorrelationTransformEntry correlationTransformEntry : this.correlationPathReplacementVisitor.getPathsToCorrelate()) {
                        String alias = correlationTransformEntry.getAlias();
                        String correlationExpression = correlationTransformEntry.getCorrelationExpression();
                        if (correlationTransformEntry.isInConjunction()) {
                            if (subqueryBuilder == null) {
                                subqueryBuilder = (SubqueryBuilderImpl)subqueryInitiator.from(correlationExpression, alias);
                                continue;
                            }
                            subqueryBuilder.from(correlationExpression, alias);
                            continue;
                        }
                        subqueryBuilder.leftJoinDefault(correlationExpression, alias);
                    }
                    ((SubqueryBuilderImpl)subqueryBuilder).whereManager.restrictSetExpression(this.correlationPathReplacementVisitor.rewritePredicate((Predicate)node.getOnPredicate()));
                    for (Predicate additionalPredicate : additionalPredicates) {
                        ((SubqueryBuilderImpl)subqueryBuilder).whereManager.restrictExpression(additionalPredicate);
                    }
                    node.setOnPredicate(new CompoundPredicate(CompoundPredicate.BooleanOperator.AND, new Predicate[]{new ExistsPredicate((Expression)new SubqueryExpression((Subquery)subqueryBuilder), false)}));
                    node.getOnPredicate().accept((Expression.Visitor)this);
                }
            }
            finally {
                this.currentJoinNode = null;
            }
        }
        node.registerDependencies();
        if (node.isFetch()) {
            this.fetchableNodes.add(node);
        }
    }

    public void visit(PathExpression expression) {
        this.visit(expression, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visit(PathExpression expression, boolean idRemovable) {
        Expression aliasedExpression;
        String alias;
        String string = alias = expression.getExpressions().size() == 1 ? expression.toString() : null;
        if (alias != null && !this.currentlyResolvingAliases.contains(alias) && (aliasedExpression = this.joinManager.getJoinableSelectAlias(expression, this.fromClause == ClauseType.SELECT, false)) != null) {
            try {
                this.currentlyResolvingAliases.add(alias);
                aliasedExpression.accept((Expression.Visitor)this);
                if (!(aliasedExpression instanceof PathExpression)) return;
                PathExpression aliasedPathExpression = (PathExpression)aliasedExpression;
                if (aliasedPathExpression.isCollectionQualifiedPath()) {
                    expression.setCollectionQualifiedPath(true);
                }
                if (!aliasedPathExpression.isUsedInCollectionFunction()) return;
                expression.setUsedInCollectionFunction(true);
                return;
            }
            finally {
                this.currentlyResolvingAliases.remove(alias);
            }
        }
        if ("_".equals(alias)) return;
        if (this.relativeExpressionPrefix != null) {
            PathExpression leftMost = ExpressionUtils.getLeftMostPathExpression((PathExpression)expression);
            String leftMostAlias = leftMost.getExpressions().get(0) instanceof ArrayExpression ? ((ArrayExpression)leftMost.getExpressions().get(0)).getBase().toString() : ((PropertyExpression)leftMost.getExpressions().get(0)).getProperty();
            if ("_".equals(leftMostAlias)) {
                return;
            }
            JoinAliasInfo aliasInfo = (JoinAliasInfo)this.joinManager.getAliasManager().getAliasInfo(leftMostAlias);
            if (aliasInfo == null) {
                leftMost.getExpressions().add(0, new PropertyExpression("_"));
                return;
            }
        }
        try {
            JoinNode baseNode;
            AliasManager aliasOwner;
            if (expression.getBaseNode() != null) {
                // empty if block
            }
            this.joinManager.implicitJoin((Expression)expression, this.joinAllowed, true, this.joinWithObjectLeafAllowed, null, this.fromClause, null, this.currentJoinNode, this.currentlyResolvingAliases, false, false, this.joinRequired, idRemovable, false, this.reuseExisting);
            if (this.parentVisitor == null || (aliasOwner = (baseNode = (JoinNode)expression.getBaseNode()).getAliasInfo().getAliasOwner()) == this.joinManager.getAliasManager()) return;
            this.addParentClauseDependencies(baseNode, aliasOwner);
            return;
        }
        catch (ImplicitJoinNotAllowedException ex) {
            if (this.conjunctionPathExpressionFindingVisitor == null) {
                this.conjunctionPathExpressionFindingVisitor = new ConjunctionPathExpressionFindingVisitor();
            }
            this.correlationPathReplacementVisitor.addPathExpression(expression, ex, this.conjunctionPathExpressionFindingVisitor.isInConjunction(this.currentJoinNode.getOnPredicate(), expression));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParentClauseDependencies(JoinNode node, AliasManager aliasOwner) {
        if (this.parentVisitor.getFromClause() == null) {
            try {
                ClauseType parentClause = this.joinManager.getQueryBuilder().queryContext.getParentClause();
                if (parentClause == ClauseType.CTE) {
                    parentClause = ClauseType.JOIN;
                }
                this.parentVisitor.setFromClause(parentClause);
                this.parentVisitor.addClauseDependencies(node, aliasOwner);
            }
            finally {
                this.parentVisitor.setFromClause(null);
            }
        } else {
            this.parentVisitor.addClauseDependencies(node, aliasOwner);
        }
    }

    private void addClauseDependencies(JoinNode node, AliasManager aliasOwner) {
        if (aliasOwner != this.joinManager.getAliasManager()) {
            if (this.parentVisitor == null) {
                throw new IllegalStateException("Couldn't update clause dependencies because implicit joined node does not seem to belong to the query: " + node);
            }
            this.addParentClauseDependencies(node, aliasOwner);
        } else {
            node.getClauseDependencies().add(this.fromClause);
        }
    }

    public void visit(ListIndexExpression expression) {
        boolean allowed = this.joinWithObjectLeafAllowed;
        this.joinWithObjectLeafAllowed = true;
        super.visit(expression);
        this.joinWithObjectLeafAllowed = allowed;
    }

    public void visit(MapKeyExpression expression) {
        boolean allowed = this.joinWithObjectLeafAllowed;
        this.joinWithObjectLeafAllowed = true;
        super.visit(expression);
        this.joinWithObjectLeafAllowed = allowed;
    }

    public void visit(TreatExpression expression) {
        throw new IllegalArgumentException("Treat should not be a root of an expression: " + expression.toString());
    }

    public boolean isJoinRequired() {
        return this.joinRequired;
    }

    public void setJoinRequired(boolean joinRequired) {
        this.joinRequired = joinRequired;
    }

    public void visit(FunctionExpression expression) {
        if (ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this.parentVisitor);
        } else {
            super.visit(expression);
            if (expression.getWindowDefinition() != null) {
                expression.setResolvedWindowDefinition(this.windowManager.resolve(expression.getWindowDefinition()));
            }
        }
    }

    public void visit(SubqueryExpression expression) {
        if (expression.getSubquery() instanceof AbstractCommonQueryBuilder) {
            ((AbstractCommonQueryBuilder)expression.getSubquery()).prepareAndCheck(this);
        }
    }

    public boolean isJoinWithObjectLeafAllowed() {
        return this.joinWithObjectLeafAllowed;
    }

    public void setJoinWithObjectLeafAllowed(boolean joinWithObjectLeafAllowed) {
        this.joinWithObjectLeafAllowed = joinWithObjectLeafAllowed;
    }

    public void visit(EqPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        this.removeAssociationIdIfPossible(predicate.getLeft(), predicate.getRight());
        this.joinRequired = original;
    }

    public void visit(InPredicate predicate) {
        Expression right;
        boolean original = this.joinRequired;
        this.joinRequired = false;
        boolean rewritten = false;
        if (predicate.getRight().size() == 1 && ((right = (Expression)predicate.getRight().get(0)) instanceof PathExpression || right instanceof ParameterExpression)) {
            this.removeAssociationIdIfPossible(predicate.getLeft(), right);
            rewritten = true;
        }
        if (!rewritten) {
            predicate.getLeft().accept((Expression.Visitor)this);
            for (Expression right2 : predicate.getRight()) {
                right2.accept((Expression.Visitor)this);
            }
        }
        this.joinRequired = original;
    }

    private void removeAssociationIdIfPossible(Expression left, Expression right) {
        String naturalIdAttribute;
        if (this.needsSingleValuedAssociationIdRemoval && this.fromClause == ClauseType.JOIN) {
            if (this.removeAssociationIdIfPossible(left)) {
                Type<?> associationType;
                ParameterValueTransformer tranformer;
                if (!this.removeAssociationIdIfPossible(right) && !this.rewriteToAssociationParam(tranformer = this.parameterTransformerFactory.getToEntityTranformer((associationType = this.getAssociationType(left, right)).getJavaType()), right)) {
                    left.accept((Expression.Visitor)this);
                    right.accept((Expression.Visitor)this);
                }
            } else if (this.removeAssociationIdIfPossible(right)) {
                Type<?> associationType = this.getAssociationType(left, right);
                ParameterValueTransformer tranformer = this.parameterTransformerFactory.getToEntityTranformer(associationType.getJavaType());
                if (!this.rewriteToAssociationParam(tranformer, left)) {
                    left.accept((Expression.Visitor)this);
                    right.accept((Expression.Visitor)this);
                }
            } else {
                left.accept((Expression.Visitor)this);
                right.accept((Expression.Visitor)this);
            }
        } else if (this.fromClause == ClauseType.JOIN && left instanceof PathExpression && right instanceof PathExpression && (naturalIdAttribute = this.getNaturalIdAttribute(left, right)) != null) {
            ((PathExpression)left).getExpressions().add(new PropertyExpression(naturalIdAttribute));
            ((PathExpression)right).getExpressions().add(new PropertyExpression(naturalIdAttribute));
            left.accept((Expression.Visitor)this);
            right.accept((Expression.Visitor)this);
        } else {
            left.accept((Expression.Visitor)this);
            right.accept((Expression.Visitor)this);
        }
    }

    private boolean removeAssociationIdIfPossible(Expression expression) {
        if (expression instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression;
            this.visit(pathExpression, true);
            String lastElement = ((PathElementExpression)pathExpression.getExpressions().get(pathExpression.getExpressions().size() - 1)).toString();
            PathReference pathReference = pathExpression.getPathReference();
            if (pathReference == null) {
                return false;
            }
            JoinNode node = (JoinNode)pathReference.getBaseNode();
            String field = pathReference.getField();
            if (field == null) {
                if (node.getParentTreeNode() == null ? !lastElement.equals(node.getAlias()) : !lastElement.equals(node.getParentTreeNode().getRelationName()) && !lastElement.equals(node.getAlias())) {
                    return true;
                }
            } else {
                return !field.endsWith(lastElement) || field.length() != lastElement.length() && field.charAt(field.length() - lastElement.length() - 1) != '.';
            }
        }
        return false;
    }

    private Type<?> getAssociationType(Expression expression1, Expression expression2) {
        if (expression1 instanceof PathExpression) {
            return ((PathExpression)expression1).getPathReference().getType();
        }
        return ((PathExpression)expression2).getPathReference().getType();
    }

    private String getNaturalIdAttribute(Expression expression1, Expression expression2) {
        String naturalIdAttribute = this.getNaturalIdAttribute(expression1);
        if (naturalIdAttribute != null) {
            return naturalIdAttribute;
        }
        return this.getNaturalIdAttribute(expression2);
    }

    private String getNaturalIdAttribute(Expression expression) {
        if (expression instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression;
            this.visit(pathExpression, false);
            PathReference pathReference = pathExpression.getPathReference();
            if (pathReference != null && pathReference.getField() != null && pathReference.getType() instanceof EntityType) {
                JoinNode node = (JoinNode)pathReference.getBaseNode();
                Set identifierOrUniqueKeyEmbeddedPropertyNames = this.metamodel.getJpaProvider().getJoinMappingPropertyNames(node.getEntityType(), null, pathReference.getField()).keySet();
                if (identifierOrUniqueKeyEmbeddedPropertyNames.size() == 1) {
                    String naturalIdAttribute = (String)identifierOrUniqueKeyEmbeddedPropertyNames.iterator().next();
                    ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType)pathReference.getType());
                    if (!extendedManagedType.getIdAttribute().getName().equals(naturalIdAttribute)) {
                        return naturalIdAttribute;
                    }
                }
            }
        }
        return null;
    }

    private boolean rewriteToAssociationParam(ParameterValueTransformer tranformer, Expression expression) {
        if (!(expression instanceof ParameterExpression)) {
            return false;
        }
        ParameterExpression parameterExpression = (ParameterExpression)expression;
        ParameterManager.ParameterImpl<?> param = this.parameterManager.getParameter(parameterExpression.getName());
        param.setTransformer(tranformer);
        return true;
    }

    public void visit(IsNullPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        if (!this.removeAssociationIdIfPossible(predicate.getExpression())) {
            predicate.getExpression().accept((Expression.Visitor)this);
        }
        this.joinRequired = original;
    }

    public void visit(IsEmptyPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getExpression().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(MemberOfPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getLeft().accept((Expression.Visitor)this);
        predicate.getRight().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    @Override
    public void visit(SelectInfo selectInfo) {
        String alias = selectInfo.getAlias();
        try {
            if (alias != null) {
                this.currentlyResolvingAliases.add(alias);
            }
            selectInfo.getExpression().accept((Expression.Visitor)this);
        }
        finally {
            this.currentlyResolvingAliases.remove(alias);
        }
    }
}

