/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.JpqlMacroAdapter;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.spi.JpqlMacro;
import java.util.HashMap;
import java.util.Map;

public final class JpqlMacroStorage {
    private final ExpressionFactory expressionFactory;
    private boolean dirty;
    private Map<String, JpqlMacro> scopedMacros;
    private MacroConfiguration macroConfiguration;

    public JpqlMacroStorage(ExpressionFactory expressionFactory, MacroConfiguration macroConfiguration) {
        this.expressionFactory = expressionFactory;
        this.macroConfiguration = macroConfiguration;
    }

    public MacroConfiguration getMacroConfiguration() {
        if (this.dirty) {
            this.macroConfiguration = this.macroConfiguration.with(JpqlMacroAdapter.createMacros(this.scopedMacros, this.expressionFactory));
            this.scopedMacros.clear();
            this.dirty = false;
        }
        return this.macroConfiguration;
    }

    public void registerMacro(String macroName, JpqlMacro jpqlMacro) {
        if (this.scopedMacros == null) {
            this.scopedMacros = new HashMap<String, JpqlMacro>();
        }
        this.scopedMacros.put(macroName.toUpperCase(), jpqlMacro);
        this.dirty = true;
    }
}

