/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseDeleteCriteriaBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseDeleteCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionDeleteModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DeleteJoinStyle;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractDeleteCollectionCriteriaBuilder<T, X extends BaseDeleteCriteriaBuilder<T, X>, Y>
extends BaseDeleteCriteriaBuilderImpl<T, X, Y> {
    protected final String collectionName;
    protected final Type<?> elementType;
    protected final ExtendedAttribute<?, ?> collectionAttribute;

    public AbstractDeleteCollectionCriteriaBuilder(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, String alias, CTEManager.CTEKey cteKey, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, queryContext, isMainQuery, clazz, alias, cteKey, cteClass, result, listener);
        this.collectionName = collectionName;
        ExtendedManagedType extendedManagedType = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType);
        this.collectionAttribute = extendedManagedType.getAttribute(collectionName);
        JoinNode join = this.joinManager.join(this.entityAlias + "." + collectionName, "_collection", JoinType.LEFT, false, true, null);
        if (this.collectionAttribute.getJoinTable() != null) {
            join.setDeReferenceFunction(mainQuery.jpaProvider.getCustomFunctionInvocation("collection_dml_support", 1));
            join.getParent().setDeReferenceFunction(mainQuery.jpaProvider.getCustomFunctionInvocation("collection_dml_support", 1));
            if (mainQuery.dbmsDialect.getDeleteJoinStyle() == DeleteJoinStyle.NONE || mainQuery.dbmsDialect.getDeleteJoinStyle() == DeleteJoinStyle.MERGE) {
                join.setDisallowedDeReferenceAlias(this.aliasManager.generateRootAlias(join.getAlias()));
                join.getParent().setDisallowedDeReferenceAlias(this.aliasManager.generateRootAlias(join.getParent().getAlias()));
            }
            JoinTable joinTable = this.collectionAttribute.getJoinTable();
            Set idAttributeNames = joinTable.getIdAttributeNames();
            HashSet<String> ownerAttributes = new HashSet<String>(idAttributeNames.size());
            for (String idAttributeName : idAttributeNames) {
                ownerAttributes.add(idAttributeName);
                int dotIdx = -1;
                while ((dotIdx = idAttributeName.indexOf(46, dotIdx + 1)) != -1) {
                    ownerAttributes.add(idAttributeName.substring(0, dotIdx));
                }
            }
            join.getParent().setAllowedDeReferences(ownerAttributes);
            HashSet<String> elementAttributes = new HashSet<String>();
            if (((PluralAttribute)this.collectionAttribute.getAttribute()).getElementType() instanceof ManagedType) {
                String prefix = this.collectionAttribute.getAttributePathString() + ".";
                for (Map.Entry entry : extendedManagedType.getAttributes().entrySet()) {
                    if (!((String)entry.getKey()).startsWith(prefix)) continue;
                    elementAttributes.add(((String)entry.getKey()).substring(prefix.length()));
                }
            }
            join.setAllowedDeReferences(elementAttributes);
        }
        this.elementType = join.getType();
        if (this.collectionAttribute.getJoinTable() == null && "".equals(this.collectionAttribute.getMappedBy())) {
            throw new IllegalArgumentException("Cannot delete from the collection attribute '" + collectionName + "' of entity class '" + clazz.getName() + "' because it doesn't have a join table or a mapped by attribute!");
        }
        if (this.collectionAttribute.getMappedBy() != null) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail(null);
            rootNode.getAliasInfo().setAlias("_collection." + this.collectionAttribute.getMappedBy());
        }
    }

    public AbstractDeleteCollectionCriteriaBuilder(AbstractDeleteCollectionCriteriaBuilder<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.collectionName = builder.collectionName;
        this.collectionAttribute = builder.collectionAttribute;
        this.elementType = builder.elementType;
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode) {
        boolean hasOtherJoinNodes;
        JoinNode rootNode = this.joinManager.getRoots().get(0);
        JoinTreeNode collectionTreeNode = (JoinTreeNode)rootNode.getNodes().get(this.collectionName);
        boolean bl = hasOtherJoinNodes = this.joinManager.getRoots().size() > 1 || rootNode.getNodes().size() > 1 || !rootNode.getTreatedJoinNodes().isEmpty() || !rootNode.getEntityJoinNodes().isEmpty() || collectionTreeNode.getJoinNodes().size() > 1 || collectionTreeNode.getDefaultNode().hasChildNodes();
        if (externalRepresentation) {
            sbSelectFrom.append("DELETE FROM ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append('(').append(this.collectionName).append(") ").append(this.entityAlias);
            if (this.collectionAttribute.getJoinTable() == null) {
                rootNode.getAliasInfo().setAlias(this.entityAlias);
            }
            ((JoinTreeNode)rootNode.getNodes().get(this.collectionName)).getDefaultNode().getAliasInfo().setAlias(this.entityAlias + "." + this.collectionName);
            ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
            ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
            if (hasOtherJoinNodes) {
                sbSelectFrom.append(" USING ");
                this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), rootNode, false);
            }
            this.appendWhereClause(sbSelectFrom, externalRepresentation);
            for (String whereClauseConjunct : whereClauseConjuncts) {
                sbSelectFrom.append(" AND ").append(whereClauseConjunct);
            }
            if (this.collectionAttribute.getJoinTable() == null) {
                rootNode.getAliasInfo().setAlias("_collection." + this.collectionAttribute.getMappedBy());
            }
            ((JoinTreeNode)rootNode.getNodes().get(this.collectionName)).getDefaultNode().getAliasInfo().setAlias("_collection");
        } else if (this.collectionAttribute.getJoinTable() == null) {
            sbSelectFrom.append("DELETE FROM ");
            sbSelectFrom.append(((EntityType)this.elementType).getName());
            sbSelectFrom.append(' ');
            sbSelectFrom.append("_collection");
            this.appendWhereClause(sbSelectFrom, externalRepresentation);
        } else {
            sbSelectFrom.append("SELECT 1");
            StringBuilder tempSb = new StringBuilder();
            this.appendWhereClause(tempSb, externalRepresentation);
            if (hasOtherJoinNodes || rootNode.isDisallowedDeReferenceUsed() || collectionTreeNode.getDefaultNode().isDisallowedDeReferenceUsed()) {
                if (this.mainQuery.dbmsDialect.getDeleteJoinStyle() == DeleteJoinStyle.NONE || this.mainQuery.dbmsDialect.getDeleteJoinStyle() == DeleteJoinStyle.MERGE) {
                    sbSelectFrom.append(" FROM ");
                    sbSelectFrom.append(this.entityType.getName());
                    sbSelectFrom.append(' ');
                    sbSelectFrom.append(this.entityAlias);
                    sbSelectFrom.append(" LEFT JOIN ");
                    sbSelectFrom.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
                    sbSelectFrom.append(" WHERE EXISTS (SELECT 1");
                    ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                    ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                    this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), rootNode, true);
                    sbSelectFrom.append((CharSequence)tempSb);
                    for (String whereClauseConjunct : whereClauseConjuncts) {
                        sbSelectFrom.append(" AND ").append(whereClauseConjunct);
                    }
                    sbSelectFrom.append(')');
                } else {
                    ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                    ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                    this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), rootNode, true);
                    this.appendWhereClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts, lateralJoinNode);
                }
            } else {
                ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), null, true);
                sbSelectFrom.append((CharSequence)tempSb);
                for (String whereClauseConjunct : whereClauseConjuncts) {
                    sbSelectFrom.append(" AND ").append(whereClauseConjunct);
                }
            }
        }
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getQuery(includedModificationStates);
        }
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, objectBuilder);
        }
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        String[] discriminatorColumnCheck;
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        String sql = extendedQuerySupport.getSql(this.em, baseQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, "_collection");
        JoinTable joinTable = this.collectionAttribute.getJoinTable();
        if (joinTable == null) {
            throw new IllegalStateException("Deleting inverse collections is not supported!");
        }
        int joinTableIndex = SqlUtils.indexOfTableName(sql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(sql, joinTableIndex + joinTable.getTableName().length());
        String tableToDelete = joinTable.getTableName();
        String tablePrefix = this.mainQuery.dbmsDialect.getDeleteJoinStyle() == DeleteJoinStyle.FROM ? collectionAlias : tableToDelete;
        HashMap<String, String> columnExpressionRemappings = new HashMap<String, String>(joinTable.getIdColumnMappings().size());
        ArrayList joinTableIdColumns = new ArrayList();
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                joinTableIdColumns.add(entry.getKey());
                columnExpressionRemappings.put("collection_dml_support(" + collectionAlias + "." + (String)entry.getValue() + ")", tablePrefix + "." + (String)entry.getKey());
            }
        }
        if ((discriminatorColumnCheck = this.mainQuery.jpaProvider.getDiscriminatorColumnCheck(this.entityType)) != null) {
            columnExpressionRemappings.put(ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1], "1=1");
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            joinTableIdColumns.add(entry.getKey());
            columnExpressionRemappings.put("collection_dml_support(" + ownerAlias + "." + (String)entry.getValue() + ")", tablePrefix + "." + (String)entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnExpressionRemappings.put("collection_dml_support(" + targetAlias + "." + (String)entry.getValue() + ")", tablePrefix + "." + (String)entry.getKey());
        }
        Set set = JpaMetamodelUtils.getIdAttributes((IdentifiableType)this.entityType);
        if (set.size() == 1 && ((SingularAttribute)set.iterator().next()).getType() instanceof ManagedType) {
            StringBuilder leftSb = new StringBuilder();
            StringBuilder rightSb = new StringBuilder();
            leftSb.append("collection_dml_support").append("((");
            rightSb.append("(");
            for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
                leftSb.append(ownerAlias).append('.').append((String)entry.getValue()).append(", ");
                rightSb.append(tablePrefix).append('.').append((String)entry.getKey()).append(',');
            }
            leftSb.setLength(leftSb.length() - 2);
            leftSb.append("))");
            rightSb.setCharAt(rightSb.length() - 1, ')');
            columnExpressionRemappings.put(leftSb.toString(), rightSb.toString());
        }
        return new CollectionDeleteModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, this.returningAttributeBindingMap, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), tableToDelete, collectionAlias, joinTableIdColumns.toArray(new String[0]), false, this.getDeleteExampleQuery(), columnExpressionRemappings);
    }
}

