/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseInsertCriteriaBuilder;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseInsertCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionInsertModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractInsertCollectionCriteriaBuilder<T, X extends BaseInsertCriteriaBuilder<T, X>, Y>
extends BaseInsertCriteriaBuilderImpl<T, X, Y> {
    private final String collectionName;
    private final String keyFunctionExpression;
    private final Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries;
    private final Map<String, String> collectionColumnBindingMap;
    private final Type<?> elementType;
    private final ExtendedAttribute<?, ?> collectionAttribute;

    public AbstractInsertCollectionCriteriaBuilder(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, CTEManager.CTEKey cteKey, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, queryContext, isMainQuery, clazz, cteKey, cteClass, result, listener);
        this.collectionName = collectionName;
        ExtendedManagedType extendedManagedType = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType);
        this.collectionAttribute = extendedManagedType.getAttribute(collectionName);
        this.elementType = mainQuery.metamodel.type(this.collectionAttribute.getElementClass());
        if (this.collectionAttribute.getJoinTable() == null && "".equals(this.collectionAttribute.getMappedBy())) {
            throw new IllegalArgumentException("Unsupported collection attribute that doesn't have a join table or a mapped by attribute!");
        }
        if (this.collectionAttribute.getMappedBy() != null) {
            throw new IllegalArgumentException("Insert operation on inverse collections is currently not supported!");
        }
        Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries = JpaUtils.getCollectionAttributeEntries(mainQuery.metamodel, this.entityType, this.collectionAttribute);
        this.keyFunctionExpression = this.collectionAttribute.getAttribute() instanceof MapAttribute ? "key(" + collectionName + ")" : (this.collectionAttribute.getAttribute() instanceof ListAttribute && !this.collectionAttribute.isBag() ? "index(" + collectionName + ")" : null);
        this.collectionColumnBindingMap = new LinkedHashMap<String, String>(collectionAttributeEntries.size());
        this.collectionAttributeEntries = collectionAttributeEntries;
    }

    public AbstractInsertCollectionCriteriaBuilder(AbstractInsertCollectionCriteriaBuilder<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.collectionName = builder.collectionName;
        this.keyFunctionExpression = builder.keyFunctionExpression;
        this.collectionColumnBindingMap = builder.collectionColumnBindingMap;
        this.collectionAttributeEntries = builder.collectionAttributeEntries;
        this.collectionAttribute = builder.collectionAttribute;
        this.elementType = builder.elementType;
    }

    @Override
    protected void appendInsertIntoFragment(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        super.appendInsertIntoFragment(sbSelectFrom, externalRepresentation);
        if (externalRepresentation) {
            sbSelectFrom.append('.').append(this.collectionName);
        }
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode) {
        if (externalRepresentation) {
            super.buildBaseQueryString(sbSelectFrom, externalRepresentation, lateralJoinNode);
        } else {
            this.buildSelectBaseQueryString(sbSelectFrom, externalRepresentation);
        }
    }

    @Override
    protected void addBind(String attributeName) {
        if (attributeName.equalsIgnoreCase(this.keyFunctionExpression)) {
            Integer attributeBindIndex = (Integer)this.bindingMap.get(attributeName);
            if (attributeBindIndex != null) {
                throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
            }
            this.bindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
            return;
        }
        ExtendedAttribute<?, ?> attributeEntry = this.collectionAttributeEntries.get(attributeName);
        if (attributeEntry == null) {
            TreeSet<String> set = new TreeSet<String>(this.collectionAttributeEntries.keySet());
            if (this.keyFunctionExpression != null) {
                set.add(this.keyFunctionExpression);
            }
            throw new IllegalArgumentException("The attribute [" + attributeName + "] does not exist or can't be bound! Allowed attributes are: " + set);
        }
        Integer attributeBindIndex = (Integer)this.bindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.bindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
    }

    @Override
    protected void expandBindings() {
        JpaUtils.expandBindings(this.bindingMap, this.collectionColumnBindingMap, this.collectionAttributeEntries, ClauseType.SELECT, this, this.keyFunctionExpression, true);
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases(baseQuery, keyRestrictedLeftJoins, Collections.EMPTY_SET);
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        Query insertExampleQuery = this.getInsertExampleQuery();
        String insertExampleSql = extendedQuerySupport.getSql(this.em, insertExampleQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, insertExampleQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, insertExampleQuery, "_collection");
        JoinTable joinTable = this.mainQuery.jpaProvider.getJoinTable(this.entityType, this.collectionName);
        int joinTableIndex = SqlUtils.indexOfTableName(insertExampleSql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(insertExampleSql, joinTableIndex + joinTable.getTableName().length());
        String[] selectItemExpressions = SqlUtils.getSelectItemExpressions(insertExampleSql, SqlUtils.indexOfSelect(insertExampleSql));
        HashMap columnExpressionRemappings = new HashMap(selectItemExpressions.length);
        String[] discriminatorColumnCheck = this.mainQuery.jpaProvider.getDiscriminatorColumnCheck(this.entityType);
        if (discriminatorColumnCheck != null) {
            columnExpressionRemappings.put(ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1], "1=1");
        }
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                columnExpressionRemappings.put(collectionAlias + "." + (String)entry.getValue(), entry.getKey());
            }
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            columnExpressionRemappings.put(ownerAlias + "." + (String)entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnExpressionRemappings.put(targetAlias + "." + (String)entry.getValue(), entry.getKey());
        }
        int cutoffColumns = 0;
        StringBuilder insertSqlSb = new StringBuilder();
        insertSqlSb.append("insert into ").append(joinTable.getTableName()).append("(");
        for (String selectItemExpression : selectItemExpressions) {
            String columnExpression = (String)columnExpressionRemappings.get(selectItemExpression.trim());
            if (columnExpression == null) {
                ++cutoffColumns;
                continue;
            }
            insertSqlSb.append(columnExpression).append(',');
        }
        insertSqlSb.setCharAt(insertSqlSb.length() - 1, ')');
        return new CollectionInsertModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, this.returningAttributeBindingMap, this.getInsertExecutorQuery(), insertSqlSb.toString(), cutoffColumns, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled());
    }

    protected Query getInsertExampleQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (Map.Entry entry : this.bindingMap.entrySet()) {
            String expression = (String)entry.getKey();
            int collectionIndex = expression.indexOf(this.collectionName);
            if (collectionIndex == -1) {
                sb.append(this.entityAlias).append('.').append(expression);
            } else {
                sb.append(expression, 0, collectionIndex);
                sb.append("_collection");
                sb.append(expression, collectionIndex + this.collectionName.length(), expression.length());
            }
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        sb.append(this.entityType.getName());
        sb.append(' ');
        sb.append(this.entityAlias);
        sb.append(" LEFT JOIN ");
        sb.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
        return this.em.createQuery(sb.toString());
    }

    protected Query getInsertExecutorQuery() {
        String exampleQueryString = "UPDATE " + ValuesEntity.class.getSimpleName() + " SET value = NULL";
        return this.em.createQuery(exampleQueryString);
    }
}

