/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;

public final class CachingJpaProvider
implements JpaProvider {
    private final JpaProvider jpaProvider;
    private final EntityMetamodelImpl entityMetamodel;

    public CachingJpaProvider(EntityMetamodelImpl entityMetamodel) {
        this.jpaProvider = entityMetamodel.getJpaProvider();
        this.entityMetamodel = entityMetamodel;
    }

    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    public String[] getDiscriminatorColumnCheck(EntityType<?> entityType) {
        return this.jpaProvider.getDiscriminatorColumnCheck(entityType);
    }

    public boolean isForeignJoinColumn(EntityType<?> ownerType, String attributeName) {
        ExtendedAttribute attribute = (ExtendedAttribute)this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttributes().get(attributeName);
        return attribute != null && attribute.isForeignJoinColumn();
    }

    public boolean isColumnShared(EntityType<?> ownerType, String attributeName) {
        ExtendedAttribute attribute = (ExtendedAttribute)this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttributes().get(attributeName);
        return attribute != null && attribute.isColumnShared();
    }

    public JpaProvider.ConstraintType requiresTreatFilter(EntityType<?> ownerType, String attributeName, JoinType joinType) {
        ExtendedAttribute attribute = (ExtendedAttribute)this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttributes().get(attributeName);
        return attribute == null ? JpaProvider.ConstraintType.NONE : attribute.getJoinTypeIndexedRequiresTreatFilter(joinType);
    }

    public String getMappedBy(EntityType<?> ownerType, String attributeName) {
        return this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttribute(attributeName).getMappedBy();
    }

    public String[] getColumnNames(EntityType<?> ownerType, String attributeName) {
        return this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttribute(attributeName).getColumnNames();
    }

    public String[] getColumnNames(EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        return this.getColumnNames(ownerType, attributeName);
    }

    public String[] getColumnTypes(EntityType<?> ownerType, String attributeName) {
        return this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttribute(attributeName).getColumnTypes();
    }

    public String[] getColumnTypes(EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        return this.getColumnTypes(ownerType, attributeName);
    }

    public Map<String, String> getWritableMappedByMappings(EntityType<?> inverseType, EntityType<?> ownerType, String attributeName, String inverseAttribute) {
        if (attributeName.isEmpty()) {
            return this.entityMetamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)inverseType).getAttribute(inverseAttribute).getWritableMappedByMappings(ownerType);
        }
        return this.entityMetamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)ownerType).getAttribute(attributeName).getWritableMappedByMappings(inverseType);
    }

    public JoinTable getJoinTable(EntityType<?> ownerType, String attributeName) {
        return this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttribute(attributeName).getJoinTable();
    }

    public boolean isBag(EntityType<?> ownerType, String attributeName) {
        ExtendedAttribute attribute = (ExtendedAttribute)this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType.getName()).getAttributes().get(attributeName);
        return attribute != null && attribute.isBag();
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String attributeName) {
        ExtendedManagedType managedType = this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType);
        ExtendedAttribute attribute = (ExtendedAttribute)managedType.getAttributes().get(attributeName);
        return attribute != null && attribute.isOrphanRemoval();
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        return this.isOrphanRemoval(ownerType, attributeName);
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String attributeName) {
        ExtendedManagedType managedType = this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType);
        ExtendedAttribute attribute = (ExtendedAttribute)managedType.getAttributes().get(attributeName);
        return attribute != null && attribute.isDeleteCascaded();
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        return this.isDeleteCascaded(ownerType, attributeName);
    }

    public boolean hasJoinCondition(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        ExtendedManagedType managedType = this.entityMetamodel.getManagedType(ExtendedManagedType.class, ownerType);
        ExtendedAttribute attribute = (ExtendedAttribute)managedType.getAttributes().get(attributeName);
        return attribute != null && attribute.hasJoinCondition();
    }

    public boolean supportsJpa21() {
        return this.jpaProvider.supportsJpa21();
    }

    public boolean supportsEntityJoin() {
        return this.jpaProvider.supportsEntityJoin();
    }

    public boolean supportsInsertStatement() {
        return this.jpaProvider.supportsInsertStatement();
    }

    public boolean needsBracketsForListParameter() {
        return this.jpaProvider.needsBracketsForListParameter();
    }

    public boolean needsJoinSubqueryRewrite() {
        return this.jpaProvider.needsJoinSubqueryRewrite();
    }

    public String getBooleanExpression(boolean value) {
        return this.jpaProvider.getBooleanExpression(value);
    }

    public String getBooleanConditionalExpression(boolean value) {
        return this.jpaProvider.getBooleanConditionalExpression(value);
    }

    public String getNullExpression() {
        return this.jpaProvider.getNullExpression();
    }

    public String getOnClause() {
        return this.jpaProvider.getOnClause();
    }

    public String getCollectionValueFunction() {
        return this.jpaProvider.getCollectionValueFunction();
    }

    public boolean supportsCollectionValueDereference() {
        return this.jpaProvider.supportsCollectionValueDereference();
    }

    public Class<?> getDefaultQueryResultType() {
        return this.jpaProvider.getDefaultQueryResultType();
    }

    public String getCustomFunctionInvocation(String functionName, int argumentCount) {
        return this.jpaProvider.getCustomFunctionInvocation(functionName, argumentCount);
    }

    public String escapeCharacter(char character) {
        return this.jpaProvider.escapeCharacter(character);
    }

    public boolean supportsNullPrecedenceExpression() {
        return this.jpaProvider.supportsNullPrecedenceExpression();
    }

    public void renderNullPrecedence(StringBuilder sb, String expression, String resolvedExpression, String order, String nulls) {
        this.jpaProvider.renderNullPrecedence(sb, expression, resolvedExpression, order, nulls);
    }

    public boolean supportsRootTreat() {
        return this.jpaProvider.supportsRootTreat();
    }

    public boolean supportsTreatJoin() {
        return this.jpaProvider.supportsTreatJoin();
    }

    public boolean supportsTreatCorrelation() {
        return this.jpaProvider.supportsTreatCorrelation();
    }

    public boolean supportsRootTreatJoin() {
        return this.jpaProvider.supportsRootTreatJoin();
    }

    public boolean supportsRootTreatTreatJoin() {
        return this.jpaProvider.supportsRootTreatTreatJoin();
    }

    public boolean supportsSubtypePropertyResolving() {
        return this.jpaProvider.supportsSubtypePropertyResolving();
    }

    public boolean supportsSubtypeRelationResolving() {
        return this.jpaProvider.supportsSubtypeRelationResolving();
    }

    public boolean supportsCountStar() {
        return this.jpaProvider.supportsCountStar();
    }

    public boolean supportsCustomFunctions() {
        return this.jpaProvider.supportsCustomFunctions();
    }

    public boolean supportsNonScalarSubquery() {
        return this.jpaProvider.supportsNonScalarSubquery();
    }

    public boolean supportsSubqueryInFunction() {
        return this.jpaProvider.supportsSubqueryInFunction();
    }

    public boolean supportsSubqueryAliasShadowing() {
        return this.jpaProvider.supportsSubqueryAliasShadowing();
    }

    public boolean containsEntity(EntityManager em, Class<?> entityClass, Object id) {
        return this.jpaProvider.containsEntity(em, entityClass, id);
    }

    public boolean supportsSingleValuedAssociationIdExpressions() {
        return this.jpaProvider.supportsSingleValuedAssociationIdExpressions();
    }

    public boolean supportsForeignAssociationInOnClause() {
        return this.jpaProvider.supportsForeignAssociationInOnClause();
    }

    public boolean supportsUpdateSetEmbeddable() {
        return this.jpaProvider.supportsUpdateSetEmbeddable();
    }

    public boolean supportsUpdateSetAssociationId() {
        return this.jpaProvider.supportsUpdateSetAssociationId();
    }

    public boolean supportsTransientEntityAsParameter() {
        return this.jpaProvider.supportsTransientEntityAsParameter();
    }

    public boolean needsAssociationToIdRewriteInOnClause() {
        return this.jpaProvider.needsAssociationToIdRewriteInOnClause();
    }

    public boolean needsBrokenAssociationToIdRewriteInOnClause() {
        return this.jpaProvider.needsBrokenAssociationToIdRewriteInOnClause();
    }

    public boolean needsTypeConstraintForColumnSharing() {
        return this.jpaProvider.needsTypeConstraintForColumnSharing();
    }

    public boolean supportsCollectionTableCleanupOnDelete() {
        return this.jpaProvider.supportsCollectionTableCleanupOnDelete();
    }

    public boolean supportsJoinTableCleanupOnDelete() {
        return this.jpaProvider.supportsJoinTableCleanupOnDelete();
    }

    public boolean needsCorrelationPredicateWhenCorrelatingWithWhereClause() {
        return this.jpaProvider.needsCorrelationPredicateWhenCorrelatingWithWhereClause();
    }

    public boolean supportsSingleValuedAssociationNaturalIdExpressions() {
        return this.jpaProvider.supportsSingleValuedAssociationNaturalIdExpressions();
    }

    public boolean supportsGroupByEntityAlias() {
        return this.jpaProvider.supportsGroupByEntityAlias();
    }

    public boolean needsElementCollectionIdCutoff() {
        return this.jpaProvider.needsElementCollectionIdCutoff();
    }

    public boolean needsUnproxyForFieldAccess() {
        return this.jpaProvider.needsUnproxyForFieldAccess();
    }

    public void setCacheable(Query query) {
        this.jpaProvider.setCacheable(query);
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(EntityType<?> owner, String attributeName) {
        return this.jpaProvider.getIdentifierOrUniqueKeyEmbeddedPropertyNames(owner, attributeName);
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(EntityType<?> owner, String elementCollectionPath, String attributeName) {
        return this.jpaProvider.getIdentifierOrUniqueKeyEmbeddedPropertyNames(owner, elementCollectionPath, attributeName);
    }

    public Map<String, String> getJoinMappingPropertyNames(EntityType<?> owner, String elementCollectionPath, String attributeName) {
        return this.jpaProvider.getJoinMappingPropertyNames(owner, elementCollectionPath, attributeName);
    }

    public boolean supportsEnumLiteral(ManagedType<?> ownerType, String attributeName, boolean key) {
        return this.jpaProvider.supportsEnumLiteral(ownerType, attributeName, key);
    }

    public boolean supportsTemporalLiteral() {
        return this.jpaProvider.supportsTemporalLiteral();
    }

    public boolean supportsNonDrivingAliasInOnClause() {
        return this.jpaProvider.supportsNonDrivingAliasInOnClause();
    }

    public boolean supportsSelectCompositeIdEntityInSubquery() {
        return this.jpaProvider.supportsSelectCompositeIdEntityInSubquery();
    }

    public Object getIdentifier(Object entity) {
        return this.jpaProvider.getIdentifier(entity);
    }

    public <T> T unproxy(T entity) {
        return (T)this.jpaProvider.unproxy(entity);
    }

    public JpaMetamodelAccessor getJpaMetamodelAccessor() {
        return this.jpaProvider.getJpaMetamodelAccessor();
    }
}

