/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.CTE;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.AttributeAccessor;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpaProviderFactory;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.BasicType;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class EntityMetamodelImpl
implements EntityMetamodel {
    private final Metamodel delegate;
    private final JpaProvider jpaProvider;
    private final Map<String, EntityType<?>> entityNameMap;
    private final Map<EntityType<?>, Set<EntityType<?>>> entitySubtypes;
    private final Map<String, Class<?>> entityTypes;
    private final Map<String, Class<Enum<?>>> enumTypes;
    private final Map<String, Class<Enum<?>>> enumTypesForLiterals;
    private final Map<Class<?>, Type<?>> classMap;
    private final ConcurrentMap<Class<?>, Type<?>> basicTypeMap = new ConcurrentHashMap();
    private final Map<Class<?>, ManagedType<?>> cteMap;
    private final Map<Object, ExtendedManagedTypeImpl<?>> extendedManagedTypes;
    private final Map<Class<?>, AttributeExample> exampleAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityMetamodelImpl(EntityManagerFactory emf, JpaProviderFactory jpaProviderFactory) {
        this.delegate = emf.getMetamodel();
        Set managedTypes = this.delegate.getManagedTypes();
        Set originalEntityTypes = this.delegate.getEntities();
        HashMap<String, EntityType> nameToType = new HashMap<String, EntityType>(managedTypes.size());
        HashMap<String, Class> entityTypes = new HashMap<String, Class>(managedTypes.size());
        HashMap enumTypes = new HashMap(managedTypes.size());
        HashMap enumTypesForLiterals = new HashMap(managedTypes.size());
        HashMap classToType = new HashMap(managedTypes.size());
        HashMap<Class, EntityType> cteToType = new HashMap<Class, EntityType>(managedTypes.size());
        try (EntityManager em = emf.createEntityManager();){
            this.jpaProvider = jpaProviderFactory.createJpaProvider(em);
        }
        HashSet seenTypesForEnumResolving = new HashSet();
        HashMap<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes = new HashMap<String, TemporaryExtendedManagedType>();
        HashMap entitySubtypes = new HashMap();
        HashMap accessorCache = new HashMap();
        for (EntityType entityType : originalEntityTypes) {
            nameToType.put(entityType.getName(), entityType);
            entityTypes.put(entityType.getName(), entityType.getJavaType());
            TreeSet<EntityType> subtypes = new TreeSet<EntityType>(JpaMetamodelUtils.ENTITY_NAME_COMPARATOR);
            subtypes.add(entityType);
            entitySubtypes.put(entityType, subtypes);
            if (entityType.getJavaType() != null) {
                classToType.put(entityType.getJavaType(), (Type<?>)entityType);
                entityTypes.put(entityType.getJavaType().getName(), entityType.getJavaType());
                seenTypesForEnumResolving.add(entityType.getJavaType());
                if (AnnotationUtils.findAnnotation((Class)entityType.getJavaType(), CTE.class) != null) {
                    cteToType.put(entityType.getJavaType(), entityType);
                }
            }
            TemporaryExtendedManagedType extendedManagedType = this.getTemporaryType((ManagedType<?>)entityType, (Map<String, TemporaryExtendedManagedType>)temporaryExtendedManagedTypes);
            this.collectColumnNames((EntityType<?>)entityType, extendedManagedType.attributes, null, null, null, (ManagedType<?>)entityType, (Map<String, TemporaryExtendedManagedType>)temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
        }
        for (ManagedType managedType : managedTypes) {
            if (!(managedType instanceof EntityType)) {
                this.collectColumnNames(null, null, null, null, null, managedType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
                if (managedType.getJavaType() == null) continue;
                classToType.put(managedType.getJavaType(), (Type<?>)managedType);
                continue;
            }
            if (managedType.getJavaType() == null) continue;
            ArrayList<EntityType> types = new ArrayList<EntityType>();
            types.add((EntityType)managedType);
            EntityType superType = (EntityType)managedType;
            while ((superType = superType.getSupertype()) != null) {
                if (!(superType instanceof EntityType) || superType.getJavaType() == null) continue;
                types.add(superType);
                ((Set)entitySubtypes.get(superType)).addAll(types);
            }
        }
        for (Map.Entry entry : entitySubtypes.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        HashSet cascadingDeleteCycleSet = new HashSet();
        for (Object e : originalEntityTypes) {
            Class targetClass = e.getJavaType();
            TemporaryExtendedManagedType targetManagedType = (TemporaryExtendedManagedType)temporaryExtendedManagedTypes.get(JpaMetamodelUtils.getTypeName((Type)e));
            cascadingDeleteCycleSet.add(targetClass);
            for (Map.Entry entry : targetManagedType.attributes.entrySet()) {
                AttributeEntry attribute = (AttributeEntry)entry.getValue();
                this.detectCascadingDeleteCycles(targetManagedType, temporaryExtendedManagedTypes, cascadingDeleteCycleSet, targetClass, attribute, classToType);
                if (!targetManagedType.done || !targetManagedType.cascadingDeleteCycle) continue;
                entry.setValue(attribute.withCascadingDeleteCycle());
            }
            cascadingDeleteCycleSet.remove(targetClass);
            targetManagedType.done = true;
        }
        HashMap<Object, ExtendedManagedTypeImpl> hashMap = new HashMap<Object, ExtendedManagedTypeImpl>(temporaryExtendedManagedTypes.size());
        for (TemporaryExtendedManagedType value : new HashSet(temporaryExtendedManagedTypes.values())) {
            ExtendedManagedTypeImpl extendedManagedType = new ExtendedManagedTypeImpl(value.managedType, value.singularOwnerType, value.pluralOwnerType, value.cascadingDeleteCycle, this.initAttributes(value.attributes));
            hashMap.put(JpaMetamodelUtils.getTypeName((Type)value.managedType), extendedManagedType);
            if (value.managedType.getJavaType() == null) continue;
            hashMap.put(value.managedType.getJavaType(), extendedManagedType);
        }
        this.entityNameMap = Collections.unmodifiableMap(nameToType);
        this.entityTypes = Collections.unmodifiableMap(entityTypes);
        this.entitySubtypes = Collections.unmodifiableMap(entitySubtypes);
        this.enumTypes = Collections.unmodifiableMap(enumTypes);
        this.enumTypesForLiterals = Collections.unmodifiableMap(enumTypesForLiterals);
        this.classMap = Collections.unmodifiableMap(classToType);
        this.cteMap = Collections.unmodifiableMap(cteToType);
        this.extendedManagedTypes = Collections.unmodifiableMap(hashMap);
        HashMap exampleAttributes = new HashMap();
        for (ExtendedManagedTypeImpl extendedManagedType : hashMap.values()) {
            for (AttributeEntry attributeEntry : extendedManagedType.ownedSingularAttributes.values()) {
                if (!(attributeEntry.ownerType instanceof EntityType) || exampleAttributes.containsKey(attributeEntry.getElementClass()) || this.classMap.get(attributeEntry.getElementClass()) != null) continue;
                exampleAttributes.put(attributeEntry.getElementClass(), new AttributeExample(attributeEntry, "SELECT e." + attributeEntry.attributePathString + " FROM " + JpaMetamodelUtils.getTypeName((Type)attributeEntry.ownerType) + " e WHERE e." + attributeEntry.attributePathString + "="));
            }
        }
        this.exampleAttributes = Collections.unmodifiableMap(exampleAttributes);
    }

    private TemporaryExtendedManagedType getTemporaryType(ManagedType<?> type, Map<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes) {
        TemporaryExtendedManagedType extendedManagedType = temporaryExtendedManagedTypes.get(JpaMetamodelUtils.getTypeName(type));
        if (extendedManagedType == null) {
            extendedManagedType = new TemporaryExtendedManagedType(type, new TreeMap());
            temporaryExtendedManagedTypes.put(JpaMetamodelUtils.getTypeName(type), extendedManagedType);
            if (type.getJavaType() != null) {
                temporaryExtendedManagedTypes.put(type.getJavaType().getName(), extendedManagedType);
            }
        }
        return extendedManagedType;
    }

    private Map<String, AttributeEntry<?, ?>> initAttributes(Map<String, AttributeEntry<?, ?>> attributes) {
        for (AttributeEntry<?, ?> attributeEntry : attributes.values()) {
            attributeEntry.initColumnEquivalentAttributes(attributes.values());
        }
        return Collections.unmodifiableMap(attributes);
    }

    private void detectCascadingDeleteCycles(TemporaryExtendedManagedType ownerManagedType, Map<String, TemporaryExtendedManagedType> extendedManagedTypes, Set<Class<?>> cascadingDeleteCycleSet, Class<?> ownerClass, AttributeEntry<?, ?> attributeEntry, Map<Class<?>, Type<?>> classToType) {
        TemporaryExtendedManagedType targetManagedType;
        Class<?> targetClass = attributeEntry.getElementClass();
        Type<?> type = classToType.get(targetClass);
        TemporaryExtendedManagedType temporaryExtendedManagedType = targetManagedType = type == null ? null : extendedManagedTypes.get(JpaMetamodelUtils.getTypeName(type));
        if (targetManagedType != null) {
            if (cascadingDeleteCycleSet.add(targetClass)) {
                if (targetManagedType.done) {
                    if (targetManagedType.cascadingDeleteCycle) {
                        ownerManagedType.done = true;
                        ownerManagedType.cascadingDeleteCycle = true;
                    }
                } else {
                    for (Map.Entry entry : targetManagedType.attributes.entrySet()) {
                        AttributeEntry attribute = (AttributeEntry)entry.getValue();
                        this.detectCascadingDeleteCycles(targetManagedType, extendedManagedTypes, cascadingDeleteCycleSet, targetClass, attribute, classToType);
                        if (!targetManagedType.done || !targetManagedType.cascadingDeleteCycle) continue;
                        entry.setValue(attribute.withCascadingDeleteCycle());
                    }
                    targetManagedType.done = true;
                }
                cascadingDeleteCycleSet.remove(targetClass);
            } else {
                ownerManagedType.done = true;
                ownerManagedType.cascadingDeleteCycle = true;
                targetManagedType.done = true;
                targetManagedType.cascadingDeleteCycle = true;
            }
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, ManagedType<?> t, String parent) {
        if (!(t instanceof EntityType)) {
            return;
        }
        if (!seenTypesForEnumResolving.add(t.getJavaType())) {
            return;
        }
        for (Attribute attribute : t.getAttributes()) {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, t, parent, attribute);
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, Type<?> type, ManagedType<?> baseType, String parent, Attribute<?, ?> attribute, boolean key) {
        if (type.getPersistenceType() == Type.PersistenceType.BASIC) {
            Class elementType = type.getJavaType();
            if (elementType.isEnum()) {
                enumTypes.put(elementType.getName(), elementType);
                if (this.jpaProvider.supportsEnumLiteral(baseType, parent, key)) {
                    enumTypesForLiterals.put(elementType.getName(), elementType);
                }
            }
        } else {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, (ManagedType)type, null);
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, ManagedType<?> baseType, String parent, Attribute<?, ?> attribute) {
        String newParent = parent == null || attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED ? attribute.getName() : parent + "." + attribute.getName();
        Class fieldType = JpaMetamodelUtils.resolveFieldClass((Class)baseType.getJavaType(), attribute);
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
            if (fieldType.isEnum()) {
                enumTypes.put(fieldType.getName(), fieldType);
                if (this.jpaProvider.supportsEnumLiteral(baseType, newParent, false)) {
                    enumTypesForLiterals.put(fieldType.getName(), fieldType);
                }
            }
        } else if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (pluralAttribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                MapAttribute mapAttribute = (MapAttribute)pluralAttribute;
                this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, (Type<?>)mapAttribute.getKeyType(), baseType, newParent, (Attribute<?, ?>)mapAttribute, true);
            }
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, (Type<?>)pluralAttribute.getElementType(), baseType, newParent, (Attribute<?, ?>)pluralAttribute, false);
        } else if (!seenTypesForEnumResolving.contains(fieldType)) {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, this.delegate.managedType(fieldType), attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? newParent : null);
        }
    }

    private TemporaryExtendedManagedType collectColumnNames(EntityType<?> e, Map<String, AttributeEntry<?, ?>> attributeMap, String parent, List<Attribute<?, ?>> parents, String elementCollectionPath, ManagedType<?> type, Map<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes, Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, Map<AttributeAccessorCacheKey, AttributeAccessor<?, ?>> accessorCache) {
        Set attributes = type.getAttributes();
        TemporaryExtendedManagedType extendedManagedType = this.getTemporaryType(type, temporaryExtendedManagedTypes);
        if (parent != null) {
            Attribute<?, ?> parentAttribute = parents.get(parents.size() - 1);
            if (parentAttribute.isCollection()) {
                if (extendedManagedType.pluralOwnerType == null) {
                    extendedManagedType.pluralOwnerType = new AbstractMap.SimpleEntry(e, parent);
                }
            } else if (elementCollectionPath == null && (extendedManagedType.singularOwnerType == null || this.shouldReplaceOwner(parent, (String)extendedManagedType.singularOwnerType.getValue()))) {
                extendedManagedType.singularOwnerType = new AbstractMap.SimpleEntry(e, parent);
            }
        }
        Map managedTypeAttributes = extendedManagedType.attributes;
        for (Attribute attribute : attributes) {
            List<Attribute<?, ?>> newParents;
            String attributeName;
            Class fieldType = JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)attribute);
            if (e == null) {
                attributeName = attribute.getName();
                newParents = Collections.singletonList(attribute);
            } else {
                AttributeEntry attributeEntry;
                String idPath;
                AttributeEntry value;
                TemporaryExtendedManagedType extendedEmbeddableType;
                EmbeddableType embeddableType;
                if (parent == null) {
                    attributeName = attribute.getName();
                    newParents = Collections.singletonList(attribute);
                } else {
                    attributeName = parent + "." + attribute.getName();
                    newParents = new ArrayList<Attribute>(parents.size() + 1);
                    newParents.addAll(parents);
                    newParents.add((Attribute)attribute);
                }
                if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                    embeddableType = fieldType == Map.class ? (EmbeddableType)((SingularAttribute)attribute).getType() : this.delegate.embeddable(fieldType);
                    extendedEmbeddableType = this.collectColumnNames(e, attributeMap, attributeName, newParents, elementCollectionPath, (ManagedType<?>)embeddableType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
                    if (elementCollectionPath == null && (extendedEmbeddableType.singularOwnerType == null || this.shouldReplaceOwner(attributeName, (String)extendedEmbeddableType.singularOwnerType.getValue()))) {
                        extendedEmbeddableType.singularOwnerType = new AbstractMap.SimpleEntry(e, attributeName);
                    }
                    if (attributeMap != managedTypeAttributes) {
                        for (Map.Entry entry : extendedEmbeddableType.attributes.entrySet()) {
                            value = (AttributeEntry)entry.getValue();
                            idPath = attributeName + "." + (String)entry.getKey();
                            attributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, (ManagedType<?>)value.declaringType, value.attribute, idPath, value.elementClass, new ArrayList(value.attributePath), value.getElementCollectionPath() == null ? elementCollectionPath : value.getElementCollectionPath(), accessorCache);
                            managedTypeAttributes.put(attribute.getName() + "." + (String)entry.getKey(), attributeEntry);
                        }
                    }
                } else if (attribute instanceof PluralAttribute) {
                    if (((PluralAttribute)attribute).getElementType() instanceof EmbeddableType) {
                        embeddableType = fieldType == Map.class ? (EmbeddableType)((SingularAttribute)attribute).getType() : this.delegate.embeddable(fieldType);
                        extendedEmbeddableType = this.collectColumnNames(e, attributeMap, attributeName, newParents, attributeName, (ManagedType<?>)embeddableType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
                        if (extendedEmbeddableType.pluralOwnerType == null) {
                            extendedEmbeddableType.pluralOwnerType = new AbstractMap.SimpleEntry(e, attributeName);
                        }
                        if (attributeMap != managedTypeAttributes) {
                            for (Map.Entry entry : extendedEmbeddableType.attributes.entrySet()) {
                                value = (AttributeEntry)entry.getValue();
                                idPath = attributeName + "." + (String)entry.getKey();
                                attributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, (ManagedType<?>)value.declaringType, value.attribute, idPath, value.elementClass, new ArrayList(value.attributePath), attributeName, accessorCache);
                                managedTypeAttributes.put(attribute.getName() + "." + (String)entry.getKey(), attributeEntry);
                            }
                        }
                    }
                } else if (EntityMetamodelImpl.isAssociation(attribute) && (elementCollectionPath != null || !this.jpaProvider.isForeignJoinColumn(e, attributeName))) {
                    this.collectIdColumns(e, attributeMap, attributeName, newParents, elementCollectionPath, fieldType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
                    if (e != type) {
                        String prefix = attributeName + ".";
                        for (AttributeEntry attributeEntry2 : attributeMap.values()) {
                            if (!attributeEntry2.getAttributePathString().startsWith(prefix)) continue;
                            String idPath2 = attributeEntry2.getAttributePathString().substring(parent.length() + 1);
                            ArrayList idParents = new ArrayList(attributeEntry2.attributePath.subList(0, attributeEntry2.attributePath.size()));
                            AttributeEntry attributeEntry22 = new AttributeEntry(this.jpaProvider, type, attributeEntry2.declaringType, attributeEntry2.attribute, idPath2, attributeEntry2.elementClass, idParents, null, accessorCache);
                            managedTypeAttributes.put(idPath2, attributeEntry22);
                        }
                    }
                }
            }
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, type, parent, attribute);
            AttributeEntry attributeEntry = null;
            if (e == null) {
                if (!managedTypeAttributes.containsKey(attribute.getName())) {
                    attributeEntry = new AttributeEntry(this.jpaProvider, type, type, attribute, attributeName, fieldType, newParents, elementCollectionPath, accessorCache);
                    managedTypeAttributes.put(attribute.getName(), attributeEntry);
                }
            } else {
                attributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, type, attribute, attributeName, fieldType, newParents, elementCollectionPath, accessorCache);
                attributeMap.put(attributeName, attributeEntry);
                managedTypeAttributes.put(attribute.getName(), attributeEntry);
            }
            if (attributeEntry == null || attributeEntry.joinTable == null || attributeEntry.joinTable.getTargetAttributeNames() == null) continue;
            for (String string : attributeEntry.joinTable.getTargetAttributeNames()) {
                String subAttributeName = attributeName;
                Object subType = this.delegate.managedType(attributeEntry.getElementClass());
                ArrayList<Object> subParents = new ArrayList<Object>(newParents.size() + 1);
                subParents.addAll(newParents);
                for (String attributePart : string.split("\\.")) {
                    subAttributeName = subAttributeName + "." + attributePart;
                    Attribute subAttribute = JpaMetamodelUtils.getAttribute((ManagedType)subType, (String)attributePart);
                    fieldType = JpaMetamodelUtils.resolveFieldClass((Class)subType.getJavaType(), (Attribute)subAttribute);
                    subParents.add(subAttribute);
                    AttributeEntry subAttributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, (ManagedType<?>)subType, subAttribute, subAttributeName, fieldType, new ArrayList(subParents), attributeName, accessorCache);
                    if (e != null) {
                        attributeMap.put(subAttributeName, subAttributeEntry);
                    }
                    managedTypeAttributes.put(attribute.getName() + "." + string, subAttributeEntry);
                    subType = subAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC ? null : this.delegate.managedType(fieldType);
                }
            }
        }
        return extendedManagedType;
    }

    private void collectIdColumns(EntityType<?> e, Map<String, AttributeEntry<?, ?>> attributeMap, String attributeName, List<Attribute<?, ?>> newParents, String elementCollectionPath, Class<?> fieldType, Map<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes, Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, Map<AttributeAccessorCacheKey, AttributeAccessor<?, ?>> accessorCache) {
        Set identifierOrUniqueKeyEmbeddedPropertyNames = elementCollectionPath == null ? this.jpaProvider.getJoinMappingPropertyNames(e, elementCollectionPath, attributeName).keySet() : this.jpaProvider.getJoinMappingPropertyNames(e, elementCollectionPath, attributeName).keySet();
        EntityType fieldEntityType = this.delegate.entity(fieldType);
        for (String name : identifierOrUniqueKeyEmbeddedPropertyNames) {
            int dotIndex = name.indexOf(46);
            if (dotIndex != -1) {
                name = name.substring(0, dotIndex);
                if (attributeMap.containsKey(attributeName + "." + name)) continue;
            }
            Attribute idAttribute = JpaMetamodelUtils.getAttribute((ManagedType)fieldEntityType, (String)name);
            Class idType = JpaMetamodelUtils.resolveFieldClass(fieldType, (Attribute)idAttribute);
            String idPath = attributeName + "." + name;
            ArrayList idParents = new ArrayList(newParents.size() + 1);
            idParents.addAll(newParents);
            idParents.add(idAttribute);
            AttributeEntry attributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, (ManagedType<?>)fieldEntityType, idAttribute, idPath, idType, idParents, elementCollectionPath, accessorCache);
            attributeMap.put(idPath, attributeEntry);
            if (EntityMetamodelImpl.isAssociation(idAttribute)) {
                this.collectIdColumns(e, attributeMap, idPath, newParents, elementCollectionPath, idType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
                continue;
            }
            if (idAttribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED) continue;
            ArrayList embeddableParents = new ArrayList(newParents.size() + 1);
            embeddableParents.addAll(newParents);
            embeddableParents.add(idAttribute);
            EmbeddableType embeddableType = idType == Map.class ? (EmbeddableType)((SingularAttribute)idAttribute).getType() : this.delegate.embeddable(idType);
            this.collectColumnNames(e, attributeMap, idPath, embeddableParents, elementCollectionPath, (ManagedType<?>)embeddableType, temporaryExtendedManagedTypes, seenTypesForEnumResolving, enumTypes, enumTypesForLiterals, accessorCache);
        }
    }

    private boolean shouldReplaceOwner(String attributeName, String existingAttributeName) {
        int dotCount = 0;
        for (int i = 0; i < attributeName.length(); ++i) {
            if (attributeName.charAt(i) != '.') continue;
            ++dotCount;
        }
        int existingDotCount = 0;
        for (int i = 0; i < existingAttributeName.length(); ++i) {
            if (existingAttributeName.charAt(i) != '.') continue;
            ++existingDotCount;
        }
        if (dotCount == existingDotCount) {
            return attributeName.length() < existingAttributeName.length();
        }
        return dotCount < existingDotCount;
    }

    private static boolean isAssociation(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        return this.delegate.entity(cls);
    }

    public EntityType<?> entity(String name) {
        EntityType<?> type = this.entityNameMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Invalid entity type: " + name);
        }
        return type;
    }

    public EntityType<?> getEntity(String name) {
        return this.entityNameMap.get(name);
    }

    public Set<EntityType<?>> getEntitySubtypes(EntityType<?> entityType) {
        return this.entitySubtypes.get(entityType);
    }

    public ManagedType<?> getManagedType(String name) {
        return (ManagedType)this.entityNameMap.get(name);
    }

    public Map<String, Class<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public Map<String, Class<Enum<?>>> getEnumTypes() {
        return this.enumTypes;
    }

    public Map<String, Class<Enum<?>>> getEnumTypesForLiterals() {
        return this.enumTypesForLiterals;
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        return this.delegate.managedType(cls);
    }

    public Collection<Type<?>> getBasicTypes() {
        return this.basicTypeMap.values();
    }

    public Map<Class<?>, AttributeExample> getBasicTypeExampleAttributes() {
        return this.exampleAttributes;
    }

    public <X> Type<X> type(Class<X> cls) {
        Object type = this.classMap.get(cls);
        if (type != null) {
            return type;
        }
        type = new BasicTypeImpl<X>(cls);
        Type<?> oldType = this.basicTypeMap.putIfAbsent(cls, (Type<?>)type);
        if (oldType != null) {
            type = oldType;
        }
        return type;
    }

    public ManagedType<?> managedType(String name) {
        ManagedType t = (ManagedType)this.entityNameMap.get(name);
        if (t == null) {
            throw new IllegalStateException("Managed type with name '" + name + "' does not exist!");
        }
        return t;
    }

    public <X> ManagedType<X> getManagedType(Class<X> cls) {
        return (ManagedType)this.classMap.get(cls);
    }

    public <X> EntityType<X> getEntity(Class<X> cls) {
        Type<?> type = this.classMap.get(cls);
        if (type == null || !(type instanceof EntityType)) {
            return null;
        }
        return (EntityType)type;
    }

    public <X> ManagedType<X> getCte(Class<X> cls) {
        return this.cteMap.get(cls);
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        return this.delegate.embeddable(cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return this.delegate.getManagedTypes();
    }

    public Set<EntityType<?>> getEntities() {
        return this.delegate.getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.delegate.getEmbeddables();
    }

    public <T> T getManagedType(Class<T> cls, ManagedType<?> managedType) {
        if (managedType.getJavaType() == null) {
            return this.getManagedType(cls, JpaMetamodelUtils.getTypeName(managedType));
        }
        return this.getManagedType(cls, managedType.getJavaType());
    }

    public <T> T getManagedType(Class<T> cls, Class<?> managedType) {
        ExtendedManagedType<?> extendedManagedType = this.getEntry(managedType);
        if (cls == ExtendedManagedType.class) {
            return (T)extendedManagedType;
        }
        return null;
    }

    public <T> T getManagedType(Class<T> cls, String managedTypeName) {
        ExtendedManagedType<?> extendedManagedType = this.getEntry(managedTypeName);
        if (cls == ExtendedManagedType.class) {
            return (T)extendedManagedType;
        }
        return null;
    }

    private ExtendedManagedType<?> getEntry(Class<?> ownerType) {
        ExtendedManagedType extendedManagedType = this.extendedManagedTypes.get(ownerType);
        if (extendedManagedType == null) {
            throw new IllegalArgumentException("Unknown managed type '" + ownerType.getName() + "'");
        }
        return extendedManagedType;
    }

    private ExtendedManagedType<?> getEntry(String managedTypeName) {
        ExtendedManagedType extendedManagedType = this.extendedManagedTypes.get(managedTypeName);
        if (extendedManagedType == null) {
            throw new IllegalArgumentException("Unknown managed type '" + managedTypeName + "'");
        }
        return extendedManagedType;
    }

    private static final class TemporaryExtendedManagedType {
        private final ManagedType<?> managedType;
        private final Map<String, AttributeEntry<?, ?>> attributes;
        private Map.Entry<EntityType<?>, String> singularOwnerType;
        private Map.Entry<EntityType<?>, String> pluralOwnerType;
        private boolean done;
        private boolean cascadingDeleteCycle;

        private TemporaryExtendedManagedType(ManagedType<?> managedType, Map<String, AttributeEntry<?, ?>> attributes) {
            this.managedType = managedType;
            this.attributes = attributes;
        }
    }

    private static final class AttributeEntry<X, Y>
    implements ExtendedAttribute<X, Y> {
        private static final Map<String, String> NO_MAPPINGS = new HashMap<String, String>();
        private final JpaProvider jpaProvider;
        private final ManagedType<?> ownerType;
        private final ManagedType<?> declaringType;
        private final Attribute<X, Y> attribute;
        private final AttributeAccessor<X, Y> attributeAccessor;
        private final List<Attribute<?, ?>> attributePath;
        private final String attributePathString;
        private final String elementCollectionPath;
        private final Class<Y> elementClass;
        private final boolean hasCascadeDeleteCycle;
        private final boolean hasJoinCondition;
        private final boolean isForeignJoinColumn;
        private final boolean isColumnShared;
        private final boolean isBag;
        private final boolean isOrphanRemoval;
        private final boolean isDeleteCascaded;
        private final JpaProvider.ConstraintType[] joinTypeIndexedRequiresTreatFilter;
        private final String mappedBy;
        private final JoinTable joinTable;
        private final String[] columnNames;
        private final String[] columnTypes;
        private final ConcurrentMap<EntityType<?>, Map<String, String>> inverseAttributeCache = new ConcurrentHashMap();
        private final Set<ExtendedAttribute<X, ?>> columnEquivalentAttributes = new HashSet();

        public AttributeEntry(JpaProvider jpaProvider, ManagedType<X> ownerType, ManagedType<?> declaringType, Attribute<X, Y> attribute, String attributeName, Class<Y> fieldType, List<Attribute<?, ?>> parents, String elementCollectionPath, Map<AttributeAccessorCacheKey, AttributeAccessor<?, ?>> accessorCache) {
            this.jpaProvider = jpaProvider;
            this.ownerType = ownerType;
            this.declaringType = declaringType;
            this.attribute = attribute;
            this.attributeAccessor = AttributeEntry.createAccessor(accessorCache, jpaProvider, declaringType, attribute);
            this.elementCollectionPath = elementCollectionPath;
            this.attributePath = Collections.unmodifiableList(parents);
            this.attributePathString = attributeName;
            this.elementClass = fieldType;
            if (elementCollectionPath == null) {
                this.isOrphanRemoval = jpaProvider.isOrphanRemoval(ownerType, attributeName);
                this.isDeleteCascaded = jpaProvider.isDeleteCascaded(ownerType, attributeName);
            } else {
                this.isOrphanRemoval = jpaProvider.isOrphanRemoval(ownerType, elementCollectionPath, attributeName);
                this.isDeleteCascaded = jpaProvider.isDeleteCascaded(ownerType, elementCollectionPath, attributeName);
            }
            this.hasCascadeDeleteCycle = false;
            this.hasJoinCondition = jpaProvider.hasJoinCondition(ownerType, elementCollectionPath, attributeName);
            JoinType[] joinTypes = JoinType.values();
            JpaProvider.ConstraintType[] requiresTreatFilter = new JpaProvider.ConstraintType[joinTypes.length];
            if (ownerType instanceof EntityType) {
                EntityType entityType = (EntityType)ownerType;
                if (elementCollectionPath == null) {
                    this.isForeignJoinColumn = jpaProvider.isForeignJoinColumn(entityType, attributeName);
                    this.isColumnShared = jpaProvider.isColumnShared(entityType, attributeName);
                    this.isBag = jpaProvider.isBag(entityType, attributeName);
                    this.mappedBy = jpaProvider.getMappedBy(entityType, attributeName);
                    this.joinTable = jpaProvider.getJoinTable(entityType, attributeName);
                    this.columnNames = jpaProvider.getColumnNames(entityType, attributeName);
                    this.columnTypes = jpaProvider.getColumnTypes(entityType, attributeName);
                    for (JoinType joinType : joinTypes) {
                        requiresTreatFilter[joinType.ordinal()] = jpaProvider.requiresTreatFilter(entityType, attributeName, joinType);
                    }
                } else {
                    this.isForeignJoinColumn = false;
                    this.isColumnShared = false;
                    this.isBag = false;
                    this.mappedBy = null;
                    this.joinTable = null;
                    this.columnNames = jpaProvider.getColumnNames(entityType, elementCollectionPath, attributeName);
                    this.columnTypes = jpaProvider.getColumnTypes(entityType, elementCollectionPath, attributeName);
                    for (JoinType joinType : joinTypes) {
                        requiresTreatFilter[joinType.ordinal()] = JpaProvider.ConstraintType.NONE;
                    }
                }
            } else {
                this.isForeignJoinColumn = false;
                this.isColumnShared = false;
                this.isBag = false;
                this.mappedBy = null;
                this.joinTable = null;
                this.columnNames = null;
                this.columnTypes = null;
            }
            this.joinTypeIndexedRequiresTreatFilter = requiresTreatFilter;
        }

        private AttributeEntry(AttributeEntry<X, Y> original, boolean hasCascadeDeleteCycle) {
            this.jpaProvider = original.jpaProvider;
            this.ownerType = original.ownerType;
            this.declaringType = original.declaringType;
            this.attribute = original.attribute;
            this.attributeAccessor = original.attributeAccessor;
            this.elementCollectionPath = original.elementCollectionPath;
            this.attributePath = original.attributePath;
            this.attributePathString = original.attributePathString;
            this.elementClass = original.elementClass;
            this.hasCascadeDeleteCycle = hasCascadeDeleteCycle;
            this.hasJoinCondition = original.hasJoinCondition;
            this.isForeignJoinColumn = original.isForeignJoinColumn;
            this.isColumnShared = original.isColumnShared;
            this.isBag = original.isBag;
            this.isOrphanRemoval = original.isOrphanRemoval;
            this.isDeleteCascaded = original.isDeleteCascaded;
            this.joinTypeIndexedRequiresTreatFilter = original.joinTypeIndexedRequiresTreatFilter;
            this.mappedBy = original.mappedBy;
            this.joinTable = original.joinTable;
            this.columnNames = original.columnNames;
            this.columnTypes = original.columnTypes;
        }

        private static <X, Y> AttributeAccessor<X, Y> createAccessor(Map<AttributeAccessorCacheKey, AttributeAccessor<?, ?>> accessorCache, JpaProvider jpaProvider, ManagedType<?> declaringType, Attribute<X, Y> attribute) {
            AttributeAccessorCacheKey key;
            Object accessor = null;
            if (declaringType.getJavaType() != null && (accessor = accessorCache.get(key = new AttributeAccessorCacheKey(declaringType, attribute))) == null) {
                if (attribute.getJavaMember() instanceof Field) {
                    accessor = jpaProvider.needsUnproxyForFieldAccess() ? new UnproxyingFieldAttributeAccessor(jpaProvider, declaringType.getJavaType(), attribute) : new FieldAttributeAccessor(declaringType.getJavaType(), attribute);
                } else if (attribute.getJavaMember() instanceof Method) {
                    accessor = new MethodAttributeAccessor(declaringType.getJavaType(), attribute);
                }
                accessorCache.put(key, (AttributeAccessor<?, ?>)accessor);
            }
            return accessor;
        }

        public Map<String, String> getWritableMappedByMappings(EntityType<?> inverseType) {
            Map mappings = (Map)this.inverseAttributeCache.get(inverseType);
            if (mappings == null) {
                mappings = this.jpaProvider.getWritableMappedByMappings(inverseType, (EntityType)this.ownerType, this.attributePathString, null);
                if (mappings == null) {
                    this.inverseAttributeCache.putIfAbsent(inverseType, NO_MAPPINGS);
                } else {
                    mappings = Collections.unmodifiableMap(mappings);
                    this.inverseAttributeCache.putIfAbsent(inverseType, mappings);
                }
            } else if (mappings == NO_MAPPINGS) {
                return null;
            }
            return mappings;
        }

        public Attribute<X, Y> getAttribute() {
            return this.attribute;
        }

        public AttributeAccessor<X, Y> getAccessor() {
            return this.attributeAccessor;
        }

        public List<Attribute<?, ?>> getAttributePath() {
            return this.attributePath;
        }

        public String getAttributePathString() {
            return this.attributePathString;
        }

        public String getElementCollectionPath() {
            return this.elementCollectionPath;
        }

        public Class<Y> getElementClass() {
            return this.elementClass;
        }

        public boolean hasJoinCondition() {
            return this.hasJoinCondition;
        }

        public boolean hasCascadingDeleteCycle() {
            return this.hasCascadeDeleteCycle;
        }

        public boolean isForeignJoinColumn() {
            return this.isForeignJoinColumn;
        }

        public boolean isColumnShared() {
            return this.isColumnShared;
        }

        public boolean isBag() {
            return this.isBag;
        }

        public boolean isOrphanRemoval() {
            return this.isOrphanRemoval;
        }

        public boolean isDeleteCascaded() {
            return this.isDeleteCascaded;
        }

        public JpaProvider.ConstraintType getJoinTypeIndexedRequiresTreatFilter(JoinType joinType) {
            return this.joinTypeIndexedRequiresTreatFilter[joinType.ordinal()];
        }

        public String getMappedBy() {
            return this.mappedBy;
        }

        public JoinTable getJoinTable() {
            return this.joinTable;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public String[] getColumnTypes() {
            return this.columnTypes;
        }

        public Set<ExtendedAttribute<X, ?>> getColumnEquivalentAttributes() {
            return this.columnEquivalentAttributes;
        }

        public void initColumnEquivalentAttributes(Collection<AttributeEntry<?, ?>> attributeEntries) {
            for (AttributeEntry<?, ?> attributeEntry : attributeEntries) {
                if (attributeEntry == this || this.columnNames == null || this.columnNames.length == 0 || !Arrays.equals(this.columnNames, attributeEntry.columnNames)) continue;
                this.columnEquivalentAttributes.add(attributeEntry);
            }
        }

        public AttributeEntry<X, Y> withCascadingDeleteCycle() {
            if (this.hasCascadeDeleteCycle) {
                return this;
            }
            return new AttributeEntry<X, Y>(this, true);
        }
    }

    private static final class ExtendedManagedTypeImpl<X>
    implements ExtendedManagedType<X> {
        private final ManagedType<X> managedType;
        private final Map.Entry<EntityType<?>, String> singularOwnerType;
        private final Map.Entry<EntityType<?>, String> pluralOwnerType;
        private final boolean hasCascadingDeleteCycle;
        private final Set<SingularAttribute<X, ?>> idAttributes;
        private final Map<String, AttributeEntry<?, ?>> attributes;
        private final Map<String, AttributeEntry<?, ?>> ownedAttributes;
        private final Map<String, AttributeEntry<?, ?>> ownedSingularAttributes;

        private ExtendedManagedTypeImpl(ManagedType<X> managedType, Map.Entry<EntityType<?>, String> singularOwnerType, Map.Entry<EntityType<?>, String> pluralOwnerType, boolean hasCascadingDeleteCycle, Map<String, AttributeEntry<?, ?>> attributes) {
            this.managedType = managedType;
            this.singularOwnerType = singularOwnerType;
            this.pluralOwnerType = pluralOwnerType;
            this.idAttributes = JpaMetamodelUtils.isIdentifiable(managedType) ? JpaMetamodelUtils.getIdAttributes((IdentifiableType)((IdentifiableType)managedType)) : Collections.emptySet();
            this.hasCascadingDeleteCycle = hasCascadingDeleteCycle;
            this.attributes = attributes;
            HashMap ownedAttributes = new HashMap(attributes.size());
            HashMap ownedSingularAttributes = new HashMap(attributes.size());
            block0: for (Map.Entry<String, AttributeEntry<?, ?>> entry : attributes.entrySet()) {
                List<Attribute<?, ?>> attributePath = entry.getValue().getAttributePath();
                for (int i = 0; i < attributePath.size() - 1; ++i) {
                    Attribute<?, ?> attribute = attributePath.get(i);
                    if (attribute.isCollection()) continue block0;
                }
                ownedAttributes.put(entry.getKey(), entry.getValue());
                if (attributePath.get(attributePath.size() - 1).isCollection()) continue;
                ownedSingularAttributes.put(entry.getKey(), entry.getValue());
            }
            this.ownedAttributes = ownedAttributes;
            this.ownedSingularAttributes = ownedSingularAttributes;
        }

        public ManagedType<X> getType() {
            return this.managedType;
        }

        public Map.Entry<EntityType<?>, String> getEmbeddableSingularOwner() {
            return this.singularOwnerType;
        }

        public Map.Entry<EntityType<?>, String> getEmbeddablePluralOwner() {
            return this.pluralOwnerType;
        }

        public boolean hasCascadingDeleteCycle() {
            return this.hasCascadingDeleteCycle;
        }

        public SingularAttribute<X, ?> getIdAttribute() {
            Iterator<SingularAttribute<X, ?>> iterator = this.idAttributes.iterator();
            if (iterator.hasNext()) {
                SingularAttribute<X, ?> idAttribute = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalStateException("Can't access a single id attribute as the entity has multiple id attributes i.e. uses @IdClass!");
                }
                return idAttribute;
            }
            return null;
        }

        public Set<SingularAttribute<X, ?>> getIdAttributes() {
            return this.idAttributes;
        }

        public Map<String, ExtendedAttribute<X, ?>> getAttributes() {
            return this.attributes;
        }

        public Map<String, ExtendedAttribute<X, ?>> getOwnedAttributes() {
            return this.ownedAttributes;
        }

        public Map<String, ExtendedAttribute<X, ?>> getOwnedSingularAttributes() {
            return this.ownedSingularAttributes;
        }

        public ExtendedAttribute<X, ?> getAttribute(String attributeName) {
            AttributeEntry<?, ?> entry = this.attributes.get(attributeName);
            if (entry == null) {
                throw new IllegalArgumentException("Could not find attribute '" + attributeName + "' on managed type '" + JpaMetamodelUtils.getTypeName(this.managedType) + "'");
            }
            return entry;
        }
    }

    public static final class AttributeExample {
        private final ExtendedAttribute<?, ?> attribute;
        private final String exampleJpql;

        public AttributeExample(ExtendedAttribute<?, ?> attribute, String exampleJpql) {
            this.attribute = attribute;
            this.exampleJpql = exampleJpql;
        }

        public ExtendedAttribute<?, ?> getAttribute() {
            return this.attribute;
        }

        public String getExampleJpql() {
            return this.exampleJpql;
        }
    }

    private static class BasicTypeImpl<T>
    implements BasicType<T> {
        private final Class<T> cls;

        public BasicTypeImpl(Class<T> cls) {
            this.cls = cls;
        }

        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.BASIC;
        }

        public Class<T> getJavaType() {
            return this.cls;
        }
    }

    private static class AttributeAccessorCacheKey {
        private final ManagedType<?> declaringType;
        private final Attribute<?, ?> attribute;

        public AttributeAccessorCacheKey(ManagedType<?> declaringType, Attribute<?, ?> attribute) {
            this.declaringType = declaringType;
            this.attribute = attribute;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AttributeAccessorCacheKey)) {
                return false;
            }
            AttributeAccessorCacheKey that = (AttributeAccessorCacheKey)o;
            if (!this.declaringType.equals(that.declaringType)) {
                return false;
            }
            return this.attribute.equals(that.attribute);
        }

        public int hashCode() {
            int result = this.declaringType.hashCode();
            result = 31 * result + this.attribute.hashCode();
            return result;
        }
    }

    private static final class UnproxyingFieldAttributeAccessor<X, Y>
    implements AttributeAccessor<X, Y> {
        private final JpaProvider jpaProvider;
        private final Field field;

        public UnproxyingFieldAttributeAccessor(JpaProvider jpaProvider, Class<?> owner, Attribute<?, ?> attribute) {
            this.jpaProvider = jpaProvider;
            Field field = ReflectionUtils.getField(owner, (String)attribute.getName());
            field.setAccessible(true);
            this.field = field;
        }

        public Y get(X entity) {
            try {
                return (Y)this.field.get(this.jpaProvider.unproxy(entity));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via field!", e);
            }
        }

        public Y getNullSafe(X entity) {
            if (entity == null) {
                return null;
            }
            try {
                return (Y)this.field.get(this.jpaProvider.unproxy(entity));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via field!", e);
            }
        }

        public void set(X entity, Y value) {
            try {
                this.field.set(this.jpaProvider.unproxy(entity), value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't set the value on the attribute via field!", e);
            }
        }
    }

    private static final class FieldAttributeAccessor<X, Y>
    implements AttributeAccessor<X, Y> {
        private final Field field;

        public FieldAttributeAccessor(Class<?> owner, Attribute<?, ?> attribute) {
            Field field = ReflectionUtils.getField(owner, (String)attribute.getName());
            field.setAccessible(true);
            this.field = field;
        }

        public Y get(X entity) {
            try {
                return (Y)this.field.get(entity);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via field!", e);
            }
        }

        public Y getNullSafe(X entity) {
            if (entity == null) {
                return null;
            }
            try {
                return (Y)this.field.get(entity);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via field!", e);
            }
        }

        public void set(X entity, Y value) {
            try {
                this.field.set(entity, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't set the value on the attribute via field!", e);
            }
        }
    }

    private static final class MethodAttributeAccessor<X, Y>
    implements AttributeAccessor<X, Y> {
        private static final Logger LOG = Logger.getLogger(MethodAttributeAccessor.class.getName());
        private final Method getter;
        private final Method setter;

        public MethodAttributeAccessor(Class<?> owner, Attribute<?, ?> attribute) {
            Method getter = ReflectionUtils.getGetter(owner, (String)attribute.getName());
            Method setter = null;
            if (getter == null) {
                if (attribute.getJavaType() == Boolean.TYPE) {
                    LOG.warning("Can't provide accessor because no getter with name 'is" + Character.toUpperCase(attribute.getName().charAt(0)) + attribute.getName().substring(1) + "' for attribute with name '" + attribute.getName() + "' could be found on type " + owner.getName());
                } else {
                    LOG.warning("Can't provide accessor because no getter with name 'get" + Character.toUpperCase(attribute.getName().charAt(0)) + attribute.getName().substring(1) + "' for attribute with name '" + attribute.getName() + "' could be found on type " + owner.getName());
                }
            } else {
                setter = ReflectionUtils.getSetter(owner, (String)attribute.getName());
                getter.setAccessible(true);
                if (setter != null) {
                    setter.setAccessible(true);
                }
            }
            this.getter = getter;
            this.setter = setter;
        }

        public Y get(X entity) {
            try {
                return (Y)this.getter.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via method!", e);
            }
        }

        public Y getNullSafe(X entity) {
            if (entity == null) {
                return null;
            }
            try {
                return (Y)this.getter.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't access the attribute via method!", e);
            }
        }

        public void set(X entity, Y value) {
            try {
                this.setter.invoke(entity, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't set the value on the attribute via method!", e);
            }
        }
    }
}

