/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.BasicCastTypes;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectManager;
import com.blazebit.persistence.impl.SplittingParameterTransformer;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.QualifiedExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;

public final class JpaUtils {
    private JpaUtils() {
    }

    private static boolean isBasicElementType(Attribute<?, ?> attribute) {
        return attribute instanceof PluralAttribute && ((PluralAttribute)attribute).getElementType().getPersistenceType() == Type.PersistenceType.BASIC;
    }

    public static void expandBindings(Map<String, Integer> bindingMap, Map<String, String> columnBindingMap, Map<String, ExtendedAttribute<?, ?>> attributeEntries, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, String keyFunctionExpression, boolean enableElementCollectionIdCutoff) {
        SelectManager selectManager = queryBuilder.selectManager;
        JoinManager joinManager = queryBuilder.joinManager;
        ParameterManager parameterManager = queryBuilder.parameterManager;
        JpaProvider jpaProvider = queryBuilder.mainQuery.jpaProvider;
        EntityMetamodelImpl metamodel = queryBuilder.mainQuery.metamodel;
        boolean requiresNullCast = queryBuilder.mainQuery.dbmsDialect.requiresNullCast();
        boolean needsCastParameters = queryBuilder.mainQuery.dbmsDialect.needsCastParameters();
        JpaMetamodelAccessor jpaMetamodelAccessor = jpaProvider.getJpaMetamodelAccessor();
        boolean needsElementCollectionIdCutoff = enableElementCollectionIdCutoff && jpaProvider.needsElementCollectionIdCutoff();
        ArrayDeque<String> attributeQueue = new ArrayDeque<String>(bindingMap.keySet());
        while (!attributeQueue.isEmpty()) {
            ArrayList<Object> arguments;
            boolean splitExpression;
            String columnType;
            Class elementType;
            String attributeName = (String)attributeQueue.remove();
            Integer tupleIndex = bindingMap.get(attributeName);
            ExtendedAttribute<?, ?> attributeEntry = attributeEntries.get(attributeName);
            if (attributeEntry == null) {
                if (!attributeName.equalsIgnoreCase(keyFunctionExpression)) continue;
                String realAttributeName = attributeName.substring(attributeName.indexOf(40) + 1, attributeName.length() - 1);
                attributeEntry = attributeEntries.get(realAttributeName);
                if (attributeEntry.getAttribute() instanceof ListAttribute) {
                    elementType = Integer.class;
                    columnType = queryBuilder.mainQuery.dbmsDialect.getSqlType(Integer.class);
                } else {
                    MapAttribute mapAttribute = (MapAttribute)attributeEntry.getAttribute();
                    elementType = mapAttribute.getKeyJavaType();
                    columnType = attributeEntry.getJoinTable() != null && attributeEntry.getJoinTable().getKeyColumnTypes() != null && attributeEntry.getJoinTable().getKeyColumnTypes().size() == 1 ? (String)attributeEntry.getJoinTable().getKeyColumnTypes().values().iterator().next() : null;
                }
                splitExpression = false;
            } else {
                elementType = attributeEntry.getElementClass();
                columnType = attributeEntry.getColumnTypes().length == 0 ? null : attributeEntry.getColumnTypes()[0];
                List attributePath = attributeEntry.getAttributePath();
                Attribute lastAttribute = (Attribute)attributePath.get(attributePath.size() - 1);
                boolean bl = splitExpression = lastAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
                if (!splitExpression && (clause != ClauseType.SET || jpaProvider.supportsUpdateSetAssociationId()) && jpaMetamodelAccessor.isJoinable(lastAttribute) && !JpaUtils.isBasicElementType(lastAttribute)) {
                    splitExpression = true;
                    if (needsElementCollectionIdCutoff) {
                        block1: for (int i = 0; i < attributePath.size() - 1; ++i) {
                            Attribute attribute = (Attribute)attributePath.get(i);
                            if (attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.ELEMENT_COLLECTION) continue;
                            for (int j = i + 1; j < attributePath.size() - 1; ++j) {
                                attribute = (Attribute)attributePath.get(j);
                                if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) break block1;
                            }
                            splitExpression = false;
                            break;
                        }
                    }
                }
            }
            SelectInfo selectInfo = selectManager.getSelectInfos().get(tupleIndex);
            final Expression selectExpression = selectInfo.getExpression();
            if (splitExpression) {
                if (selectExpression instanceof NullExpression) {
                    Map.Entry<String, Integer> entry2;
                    Collection<String> embeddedPropertyNames = JpaUtils.getEmbeddedPropertyPaths(attributeEntries, attributeName, needsElementCollectionIdCutoff, false);
                    if (embeddedPropertyNames.size() <= 0) continue;
                    selectManager.getSelectInfos().remove(tupleIndex);
                    bindingMap.remove(attributeName);
                    int delta = embeddedPropertyNames.size() - 1;
                    if (delta > 0) {
                        for (Map.Entry<String, Integer> entry2 : bindingMap.entrySet()) {
                            if ((Integer)entry2.getValue() <= tupleIndex) continue;
                            entry2.setValue((Integer)entry2.getValue() + delta);
                        }
                    }
                    int offset = 0;
                    entry2 = embeddedPropertyNames.iterator();
                    while (entry2.hasNext()) {
                        String embeddedPropertyName = entry2.next();
                        String nestedAttributePath = attributeName + "." + embeddedPropertyName;
                        ExtendedAttribute<?, ?> nestedAttributeEntry = attributeEntries.get(nestedAttributePath);
                        attributeQueue.add(nestedAttributePath);
                        bindingMap.put(nestedAttributePath, tupleIndex + offset);
                        selectManager.select(offset == 0 ? selectExpression : selectExpression.copy(ExpressionCopyContext.EMPTY), null, tupleIndex + offset);
                        if (columnBindingMap != null) {
                            for (String column : nestedAttributeEntry.getColumnNames()) {
                                columnBindingMap.put(column, nestedAttributePath);
                            }
                        }
                        ++offset;
                    }
                    continue;
                }
                if (selectExpression instanceof PathExpression) {
                    boolean firstBinding = true;
                    Collection<String> embeddedPropertyNames = JpaUtils.getEmbeddedPropertyPaths(attributeEntries, attributeName, needsElementCollectionIdCutoff, false);
                    PathExpression baseExpression = embeddedPropertyNames.size() > 1 ? ((PathExpression)selectExpression).copy(ExpressionCopyContext.EMPTY) : (PathExpression)selectExpression;
                    joinManager.implicitJoin((Expression)baseExpression, true, true, true, null, ClauseType.SELECT, new HashSet<String>(), false, false, false, false);
                    if (elementType != baseExpression.getPathReference().getType().getJavaType()) {
                        throw new IllegalStateException("An association should be bound to its association type and not its identifier type");
                    }
                    if (embeddedPropertyNames.size() <= 0) continue;
                    bindingMap.remove(attributeName);
                    int delta = embeddedPropertyNames.size() - 1;
                    if (delta > 0) {
                        for (Map.Entry<String, Integer> entry : bindingMap.entrySet()) {
                            if (entry.getValue() <= tupleIndex) continue;
                            entry.setValue(entry.getValue() + delta);
                        }
                    }
                    int offset = 0;
                    for (String embeddedPropertyName : embeddedPropertyNames) {
                        PathExpression pathExpression = firstBinding ? (PathExpression)selectExpression : baseExpression.copy(ExpressionCopyContext.EMPTY);
                        for (String propertyNamePart : embeddedPropertyName.split("\\.")) {
                            pathExpression.getExpressions().add(new PropertyExpression(propertyNamePart));
                        }
                        String nestedAttributePath = attributeName + "." + embeddedPropertyName;
                        ExtendedAttribute<?, ?> nestedAttributeEntry = attributeEntries.get(nestedAttributePath);
                        attributeQueue.add(nestedAttributePath);
                        bindingMap.put(nestedAttributePath, firstBinding ? tupleIndex : tupleIndex + offset);
                        if (!firstBinding) {
                            selectManager.select((Expression)pathExpression, null, tupleIndex + offset);
                        } else {
                            firstBinding = false;
                        }
                        if (columnBindingMap != null) {
                            for (String column : nestedAttributeEntry.getColumnNames()) {
                                columnBindingMap.put(column, nestedAttributePath);
                            }
                        }
                        ++offset;
                    }
                    continue;
                }
                if (selectExpression instanceof ParameterExpression) {
                    Collection<String> embeddedPropertyNames = JpaUtils.getEmbeddedPropertyPaths(attributeEntries, attributeName, jpaProvider.needsElementCollectionIdCutoff(), false);
                    if (embeddedPropertyNames.size() <= 0) continue;
                    ParameterExpression parameterExpression = (ParameterExpression)selectExpression;
                    String parameterName = parameterExpression.getName();
                    HashMap<String, List<String>> parameterAccessPaths = new HashMap<String, List<String>>(embeddedPropertyNames.size());
                    ParameterValueTransformer tranformer = parameterManager.getParameter(parameterName).getTranformer();
                    if (tranformer instanceof SplittingParameterTransformer) {
                        for (String name : ((SplittingParameterTransformer)tranformer).getParameterNames()) {
                            parameterManager.unregisterParameterName(name, clause, queryBuilder);
                        }
                    }
                    selectManager.getSelectInfos().remove(tupleIndex);
                    bindingMap.remove(attributeName);
                    int delta = embeddedPropertyNames.size() - 1;
                    if (delta > 0) {
                        for (Map.Entry<String, Integer> entry : bindingMap.entrySet()) {
                            if (entry.getValue() <= tupleIndex) continue;
                            entry.setValue(entry.getValue() + delta);
                        }
                    }
                    int offset = 0;
                    for (String embeddedPropertyName : embeddedPropertyNames) {
                        String subParamName = "_" + parameterName + "_" + embeddedPropertyName.replace('.', '_');
                        parameterManager.registerParameterName(subParamName, false, clause, queryBuilder);
                        parameterAccessPaths.put(subParamName, Arrays.asList(embeddedPropertyName.split("\\.")));
                        String nestedAttributePath = attributeName + "." + embeddedPropertyName;
                        ExtendedAttribute<?, ?> nestedAttributeEntry = attributeEntries.get(nestedAttributePath);
                        attributeQueue.add(nestedAttributePath);
                        bindingMap.put(nestedAttributePath, tupleIndex + offset);
                        selectManager.select((Expression)new ParameterExpression(subParamName), null, tupleIndex + offset);
                        if (columnBindingMap != null) {
                            for (String column : nestedAttributeEntry.getColumnNames()) {
                                columnBindingMap.put(column, nestedAttributePath);
                            }
                        }
                        ++offset;
                    }
                    parameterManager.getParameter(parameterName).setTranformer(new SplittingParameterTransformer(parameterManager, metamodel, elementType, parameterAccessPaths));
                    continue;
                }
                throw new IllegalArgumentException("Illegal expression '" + selectExpression.toString() + "' for binding relation '" + attributeName + "'!");
            }
            if (requiresNullCast && selectExpression instanceof NullExpression) {
                if (BasicCastTypes.TYPES.contains(elementType) && queryBuilder.statementType != DbmsStatementType.INSERT) {
                    ArrayList<Object> arguments2 = new ArrayList<Object>(2);
                    arguments2.add(selectExpression);
                    if (columnType != null) {
                        arguments2.add(new StringLiteral(columnType));
                    }
                    selectInfo.set((Expression)new FunctionExpression("CAST_" + elementType.getSimpleName(), arguments2, selectExpression));
                    continue;
                }
                final EntityMetamodelImpl.AttributeExample attributeExample = metamodel.getBasicTypeExampleAttributes().get(elementType);
                if (attributeExample == null) continue;
                arguments = new ArrayList<Object>(2);
                arguments.add(new SubqueryExpression(new Subquery(){

                    public String getQueryString() {
                        return attributeExample.getExampleJpql() + selectExpression;
                    }
                }));
                if (queryBuilder.statementType != DbmsStatementType.INSERT && needsCastParameters) {
                    arguments.add(new StringLiteral(attributeExample.getAttribute().getColumnTypes()[0]));
                }
                selectInfo.set((Expression)new FunctionExpression("nullfn", arguments, selectExpression));
                continue;
            }
            if (!(selectExpression instanceof ParameterExpression) || clause == ClauseType.SET) continue;
            if (BasicCastTypes.TYPES.contains(elementType) && queryBuilder.statementType != DbmsStatementType.INSERT) {
                ArrayList<Object> arguments3 = new ArrayList<Object>(2);
                arguments3.add(selectExpression);
                if (columnType != null) {
                    arguments3.add(new StringLiteral(columnType));
                }
                selectInfo.set((Expression)new FunctionExpression("CAST_" + elementType.getSimpleName(), arguments3, selectExpression));
                continue;
            }
            final EntityMetamodelImpl.AttributeExample attributeExample = metamodel.getBasicTypeExampleAttributes().get(elementType);
            if (attributeExample == null) continue;
            arguments = new ArrayList(2);
            arguments.add(new SubqueryExpression(new Subquery(){

                public String getQueryString() {
                    return attributeExample.getExampleJpql() + selectExpression;
                }
            }));
            if (queryBuilder.statementType != DbmsStatementType.INSERT && needsCastParameters) {
                arguments.add(new StringLiteral(attributeExample.getAttribute().getColumnTypes()[0]));
            }
            selectInfo.set((Expression)new FunctionExpression("param", arguments, selectExpression));
        }
    }

    public static Collection<String> getEmbeddedPropertyPaths(Map<String, ? extends ExtendedAttribute<?, ?>> attributeEntries, String attributeName, boolean needsElementCollectionIdCutoff, boolean filterCollections) {
        TreeSet<String> embeddedPropertyNames = new TreeSet<String>();
        String prefix = attributeName == null ? "" : attributeName + ".";
        int dotCount = -1;
        int dotIndex = -1;
        do {
            ++dotCount;
        } while ((dotIndex = prefix.indexOf(46, dotIndex + 1)) != -1);
        block1: for (Map.Entry<String, ExtendedAttribute<?, ?>> entry : attributeEntries.entrySet()) {
            String higher;
            String subAttribute;
            String lower;
            if (!entry.getKey().startsWith(prefix)) continue;
            if (filterCollections) {
                List attributePath = entry.getValue().getAttributePath();
                for (int i = dotCount; i < attributePath.size(); ++i) {
                    if (((Attribute)attributePath.get(i)).isCollection()) continue block1;
                }
            }
            if ((lower = embeddedPropertyNames.lower(subAttribute = entry.getKey().substring(prefix.length()))) == null) {
                higher = embeddedPropertyNames.higher(subAttribute);
                if (higher != null && higher.startsWith(subAttribute + ".")) continue;
                embeddedPropertyNames.add(subAttribute);
                continue;
            }
            if (subAttribute.startsWith(lower + ".")) {
                embeddedPropertyNames.remove(lower);
            }
            if (lower.startsWith(subAttribute + ".") || (higher = embeddedPropertyNames.higher(subAttribute)) != null && higher.startsWith(subAttribute + ".")) continue;
            embeddedPropertyNames.add(subAttribute);
        }
        if (attributeName != null) {
            embeddedPropertyNames.remove(attributeName);
            if (needsElementCollectionIdCutoff && attributeEntries.get(attributeName).getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                Iterator iterator = embeddedPropertyNames.iterator();
                ArrayList<String> addProperties = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String property = (String)iterator.next();
                    if (!property.endsWith(".id")) continue;
                    iterator.remove();
                    addProperties.add(property.substring(0, property.length() - ".id".length()));
                }
                embeddedPropertyNames.addAll(addProperties);
            }
        }
        return embeddedPropertyNames;
    }

    public static Map<String, ExtendedAttribute<?, ?>> getCollectionAttributeEntries(EntityMetamodel metamodel, EntityType<?> entityType, ExtendedAttribute<?, ?> attribute) {
        HashMap collectionAttributeEntries = new HashMap();
        JoinTable joinTable = attribute.getJoinTable();
        if (joinTable == null) {
            throw new IllegalArgumentException("Inserting into or updating an inverse collection via DML API is not supported!");
        }
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)metamodel.getManagedType(ExtendedManagedType.class, entityType);
        for (String idAttributeName : joinTable.getIdAttributeNames()) {
            collectionAttributeEntries.put(idAttributeName, extendedManagedType.getAttribute(idAttributeName));
        }
        if (((PluralAttribute)attribute.getAttribute()).getElementType() instanceof ManagedType) {
            String prefix = attribute.getAttributePathString() + ".";
            for (Map.Entry entry : extendedManagedType.getAttributes().entrySet()) {
                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                collectionAttributeEntries.put((String)entry.getKey(), (ExtendedAttribute<?, ?>)entry.getValue());
            }
        }
        collectionAttributeEntries.put(attribute.getAttributePathString(), attribute);
        return collectionAttributeEntries;
    }

    public static AttributeHolder getAttributeForJoining(EntityMetamodel metamodel, PathExpression expression) {
        String baseNodeAlias;
        JoinNode expressionBaseNode = (JoinNode)expression.getPathReference().getBaseNode();
        Expression p = (Expression)expression.getExpressions().get(0);
        while (!(p instanceof PropertyExpression)) {
            if (p instanceof PathExpression) {
                p = (Expression)((PathExpression)p).getExpressions().get(0);
                continue;
            }
            if (p instanceof QualifiedExpression) {
                p = (Expression)((QualifiedExpression)p).getPath().getExpressions().get(0);
                continue;
            }
            if (p instanceof ArrayExpression) {
                p = ((ArrayExpression)p).getBase();
                continue;
            }
            p = ((TreatExpression)p).getExpression();
        }
        String firstElementString = p.toString();
        JoinNode baseNode = expressionBaseNode;
        while (!firstElementString.equals(baseNodeAlias = baseNode.getAlias()) && (baseNode = baseNode.getParent()) != null) {
        }
        if (baseNode == null) {
            baseNodeAlias = null;
            baseNode = expressionBaseNode.getParent() == null ? expressionBaseNode : expressionBaseNode.getParent();
        }
        return JpaUtils.getAttributeForJoining(metamodel, baseNode.getNodeType(), (Expression)expression, baseNodeAlias);
    }

    public static AttributeHolder getAttributeForJoining(EntityMetamodel metamodel, Expression resolvedExpression) {
        return JpaUtils.getAttributeForJoining(metamodel, null, resolvedExpression, null);
    }

    public static AttributeHolder getAttributeForJoining(EntityMetamodel metamodel, Type<?> baseNodeType, Expression joinExpression, String baseNodeAlias) {
        PathTargetResolvingExpressionVisitor visitor = new PathTargetResolvingExpressionVisitor(metamodel, baseNodeType, baseNodeAlias);
        joinExpression.accept((Expression.Visitor)visitor);
        Map possibleTargets = visitor.getPossibleTargets();
        if (possibleTargets.size() > 1) {
            throw new IllegalArgumentException("Multiple possible target types for expression: " + joinExpression);
        }
        Map.Entry entry = possibleTargets.entrySet().iterator().next();
        return new AttributeHolder((Attribute)entry.getKey(), (Type)entry.getValue());
    }
}

