/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.BasicCastTypes;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.EntitySelectResolveVisitor;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeGathererVisitor;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoVisitor;
import com.blazebit.persistence.impl.SelectObjectBuilderEndedListener;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.object.ClassObjectBuilder;
import com.blazebit.persistence.impl.builder.object.ConstructorObjectBuilder;
import com.blazebit.persistence.impl.builder.object.DelegatingTupleObjectBuilder;
import com.blazebit.persistence.impl.builder.object.MultisetTransformingObjectBuilder;
import com.blazebit.persistence.impl.builder.object.PreProcessingObjectBuilder;
import com.blazebit.persistence.impl.builder.object.SelectObjectBuilderImpl;
import com.blazebit.persistence.impl.builder.object.TupleObjectBuilder;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionProcessor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;

public class SelectManager<T>
extends AbstractManager<SelectInfo> {
    private final List<SelectInfo> selectInfos = new ArrayList<SelectInfo>();
    private final Map<Integer, JpqlFunctionProcessor<?>> jpqlFunctionProcessors = new HashMap();
    private boolean distinct = false;
    private boolean hasDefaultSelect;
    private Set<JoinNode> defaultSelectNodes;
    private boolean hasSizeSelect;
    private SelectObjectBuilderImpl<?> selectObjectBuilder;
    private ObjectBuilder<T> objectBuilder;
    private SubqueryBuilderListenerImpl<?> subqueryBuilderListener;
    private final Map<String, Integer> selectAliasToPositionMap = new HashMap<String, Integer>();
    private final SelectObjectBuilderEndedListenerImpl selectObjectBuilderEndedListener = new SelectObjectBuilderEndedListenerImpl();
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    private final AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder;
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;
    private final JoinManager joinManager;
    private final AliasManager aliasManager;
    private final ExpressionFactory expressionFactory;
    private final JpaProvider jpaProvider;
    private final MainQuery mainQuery;
    private final Class<?> resultClazz;

    public SelectManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, JoinManager joinManager, AliasManager aliasManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, JpaProvider jpaProvider, MainQuery mainQuery, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor, Class<?> resultClazz) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.queryBuilder = queryBuilder;
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
        this.joinManager = joinManager;
        this.aliasManager = aliasManager;
        this.expressionFactory = expressionFactory;
        this.jpaProvider = jpaProvider;
        this.mainQuery = mainQuery;
        this.resultClazz = resultClazz;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.SELECT;
    }

    void verifyBuilderEnded() {
        if (this.subqueryBuilderListener != null) {
            this.subqueryBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
        this.selectObjectBuilderEndedListener.verifyBuilderEnded();
    }

    ObjectBuilder<T> getSelectObjectBuilder() {
        ObjectBuilder<T> builder = this.objectBuilder;
        if (builder == null) {
            if (this.resultClazz.equals(Tuple.class)) {
                if (this.jpqlFunctionProcessors.isEmpty()) {
                    return new TupleObjectBuilder(this.selectInfos, this.selectAliasToPositionMap);
                }
                return new DelegatingTupleObjectBuilder(new MultisetTransformingObjectBuilder(this.jpqlFunctionProcessors, this.selectInfos), this.selectInfos, this.selectAliasToPositionMap);
            }
        } else if (!this.jpqlFunctionProcessors.isEmpty()) {
            builder = new PreProcessingObjectBuilder<T>(new MultisetTransformingObjectBuilder(this.jpqlFunctionProcessors, this.selectInfos), builder);
        }
        return builder;
    }

    public List<SelectInfo> getSelectInfos() {
        return this.selectInfos;
    }

    public Map<Integer, JpqlFunctionProcessor<?>> getJpqlFunctionProcessors() {
        return this.jpqlFunctionProcessors;
    }

    public boolean containsSizeSelect() {
        return this.hasSizeSelect;
    }

    public Set<JoinNode> collectFetchOwners() {
        HashSet<JoinNode> fetchOwners = new HashSet<JoinNode>();
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            Expression expression = selectInfo.getExpression();
            if (expression instanceof MapValueExpression) {
                expression = ((MapValueExpression)expression).getPath();
            } else if (expression instanceof MapKeyExpression) {
                expression = ((MapKeyExpression)expression).getPath();
            }
            if (!(expression instanceof PathExpression)) continue;
            PathExpression pathExpression = (PathExpression)expression;
            JoinNode node = (JoinNode)pathExpression.getBaseNode();
            if (pathExpression.getField() != null) continue;
            fetchOwners.add(node);
        }
        if (size == 0) {
            fetchOwners.add(this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!"));
        }
        return fetchOwners;
    }

    void acceptVisitor(Expression.Visitor v) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            selectInfo.getExpression().accept(v);
        }
    }

    void acceptVisitor(SelectInfoVisitor v) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            selectInfo.accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            if (!stopValue.equals(selectInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    void buildGroupByClauses(EntityMetamodel m, GroupByManager groupByManager, boolean hasGroupBy, JoinVisitor joinVisitor) {
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<PathExpression> componentPaths = new LinkedHashSet<PathExpression>();
        EntitySelectResolveVisitor resolveVisitor = new EntitySelectResolveVisitor(m, this.jpaProvider, componentPaths);
        if (this.selectInfos.isEmpty()) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!");
            String rootAlias = rootNode.getAliasInfo().getAlias();
            ArrayList<PropertyExpression> path = new ArrayList<PropertyExpression>();
            path.add(new PropertyExpression(rootAlias));
            PathExpression pathExpression = new PathExpression(path, (PathReference)new SimplePathReference(rootNode, null, rootNode.getNodeType()), false, false);
            if (this.jpaProvider.supportsGroupByEntityAlias()) {
                Set<Expression> extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions((Expression)pathExpression);
                if (!extractedGroupByExpressions.isEmpty()) {
                    this.collectGroupBys(sb, joinVisitor, groupByManager, hasGroupBy, extractedGroupByExpressions, null);
                }
            } else {
                resolveVisitor.visit(pathExpression);
                this.collectGroupBys(sb, joinVisitor, groupByManager, hasGroupBy, componentPaths, resolveVisitor.getRootNode());
            }
        } else {
            List<SelectInfo> infos = this.selectInfos;
            int size = this.selectInfos.size();
            for (int i = 0; i < size; ++i) {
                Set<Expression> extractedGroupByExpressions;
                SelectInfo selectInfo = infos.get(i);
                if (this.jpaProvider.supportsGroupByEntityAlias()) {
                    extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(selectInfo.getExpression());
                    if (extractedGroupByExpressions.isEmpty()) continue;
                    this.collectGroupBys(sb, joinVisitor, groupByManager, hasGroupBy, extractedGroupByExpressions, null);
                    continue;
                }
                componentPaths.clear();
                selectInfo.getExpression().accept((Expression.Visitor)resolveVisitor);
                if (componentPaths.size() > 0) {
                    this.collectGroupBys(sb, joinVisitor, groupByManager, hasGroupBy, componentPaths, resolveVisitor.getRootNode());
                    continue;
                }
                extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(selectInfo.getExpression());
                if (extractedGroupByExpressions.isEmpty()) continue;
                this.collectGroupBys(sb, joinVisitor, groupByManager, hasGroupBy, extractedGroupByExpressions, null);
            }
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.groupByExpressionGatheringVisitor.clear();
    }

    private void collectGroupBys(StringBuilder sb, JoinVisitor joinVisitor, GroupByManager groupByManager, boolean hasGroupBy, Set<? extends Expression> componentPaths, JoinNode rootNode) {
        this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
        this.queryGenerator.setQueryBuffer(sb);
        if (joinVisitor == null) {
            for (Expression expression : componentPaths) {
                sb.setLength(0);
                this.queryGenerator.generate(expression);
                groupByManager.collect(new ResolvedExpression(sb.toString(), expression), ClauseType.SELECT, hasGroupBy, joinVisitor);
            }
        } else {
            joinVisitor.setFromClause(ClauseType.SELECT);
            boolean old = joinVisitor.setReuseExisting(rootNode != null);
            for (Expression expression : componentPaths) {
                expression.accept((Expression.Visitor)joinVisitor);
                sb.setLength(0);
                this.queryGenerator.generate(expression);
                if (expression instanceof PathExpression && rootNode != ((PathExpression)expression).getBaseNode()) {
                    PathExpression pathExpression = (PathExpression)expression;
                    PathExpression associationIdAccess = pathExpression.copy(ExpressionCopyContext.EMPTY);
                    associationIdAccess.setPathReference(pathExpression.getPathReference());
                    groupByManager.collect(new ResolvedExpression(sb.toString(), (Expression)associationIdAccess), ClauseType.SELECT, hasGroupBy, joinVisitor);
                    joinVisitor.setReuseExisting(false);
                    expression.accept((Expression.Visitor)joinVisitor);
                    sb.setLength(0);
                    this.queryGenerator.generate(expression);
                    groupByManager.collect(new ResolvedExpression(sb.toString(), expression), ClauseType.SELECT, hasGroupBy, joinVisitor);
                    joinVisitor.setReuseExisting(true);
                    continue;
                }
                groupByManager.collect(new ResolvedExpression(sb.toString(), expression), ClauseType.SELECT, hasGroupBy, joinVisitor);
            }
            joinVisitor.setReuseExisting(old);
        }
        this.queryGenerator.setClauseType(null);
    }

    void buildSelect(StringBuilder sb, boolean isInsertInto, boolean externalRepresentation) {
        sb.append("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        this.buildSelectItems(sb, isInsertInto, externalRepresentation, true);
    }

    void buildSelectItems(StringBuilder sb, boolean isInsertInto, boolean externalRepresentation, boolean renderAlias) {
        List<SelectInfo> infos = this.selectInfos;
        int size = infos.size();
        if (size == 0) {
            ExtendedManagedType managedType;
            JoinNode rootNode = this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!");
            if (!externalRepresentation && this.queryBuilder instanceof SubqueryBuilder && rootNode.getType() instanceof IdentifiableType && !this.mainQuery.jpaProvider.supportsSelectCompositeIdEntityInSubquery() && this.hasCompositeId(managedType = this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, rootNode.getManagedType()))) {
                this.emulateSelectCompositeId(sb, rootNode, managedType);
            } else {
                rootNode.appendAlias(sb, externalRepresentation);
            }
        } else {
            ExtendedManagedType managedType;
            PathExpression pathExpression;
            this.queryGenerator.setClauseType(ClauseType.SELECT);
            this.queryGenerator.setQueryBuffer(sb);
            SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
            SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = !this.mainQuery.getQueryConfiguration().isParameterAsLiteralRenderingEnabled() || isInsertInto ? this.queryGenerator.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER) : this.queryGenerator.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.LITERAL);
            if (!externalRepresentation && this.queryBuilder instanceof SubqueryBuilder && size == 1 && !this.mainQuery.jpaProvider.supportsSelectCompositeIdEntityInSubquery() && infos.get(0).getExpression() instanceof PathExpression && (pathExpression = (PathExpression)infos.get(0).getExpression()).getPathReference().getType() instanceof IdentifiableType && this.hasCompositeId(managedType = this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType)pathExpression.getPathReference().getType()))) {
                this.emulateSelectCompositeId(sb, (JoinNode)pathExpression.getBaseNode(), managedType);
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    this.applySelect(this.queryGenerator, sb, infos.get(i), renderAlias);
                }
            }
            this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
            this.queryGenerator.setParameterRenderingMode(oldParameterRenderingMode);
            this.queryGenerator.setClauseType(null);
        }
    }

    private void emulateSelectCompositeId(StringBuilder sb, JoinNode rootNode, ExtendedManagedType<?> managedType) {
        boolean comma = false;
        for (SingularAttribute idAttribute : managedType.getIdAttributes()) {
            for (String propertyPath : JpaUtils.getEmbeddedPropertyPaths(managedType.getOwnedSingularAttributes(), idAttribute.getName(), false, false)) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                rootNode.appendDeReference(sb, idAttribute.getName() + "." + propertyPath, false);
            }
        }
    }

    private boolean hasCompositeId(ExtendedManagedType<?> extendedManagedType) {
        return extendedManagedType.getIdAttributes().size() > 1 || extendedManagedType.getIdAttribute().getType() instanceof EmbeddableType;
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super SelectInfo> visitor) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            visitor.visit(selectInfo, ClauseType.SELECT);
        }
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SelectSubqueryBuilderListener(selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener, false, ClauseType.SELECT);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String subqueryAlias, Expression expression, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SuperExpressionSelectSubqueryBuilderListener(subqueryAlias, expression, selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener, false, ClauseType.SELECT);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> MultipleSubqueryInitiator<X> selectSubqueries(X builder, Expression expression, final String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(builder, expression, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                SelectManager.this.select(builder.getExpression(), selectAlias);
            }
        }, this.subqueryInitFactory, ClauseType.SELECT);
        return initiator;
    }

    <X> SubqueryBuilder<X> selectSubquery(X builder, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SelectSubqueryBuilderListener(selectAlias);
        SubqueryBuilderImpl<X> subqueryBuilder = this.subqueryInitFactory.createSubqueryBuilder(builder, this.subqueryBuilderListener, false, criteriaBuilder, ClauseType.SELECT);
        this.subqueryBuilderListener.onBuilderStarted(subqueryBuilder);
        return subqueryBuilder;
    }

    <X> SubqueryBuilder<X> selectSubquery(X builder, String subqueryAlias, Expression expression, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SuperExpressionSelectSubqueryBuilderListener(subqueryAlias, expression, selectAlias);
        SubqueryBuilderImpl<X> subqueryBuilder = this.subqueryInitFactory.createSubqueryBuilder(builder, this.subqueryBuilderListener, false, criteriaBuilder, ClauseType.SELECT);
        this.subqueryBuilderListener.onBuilderStarted(subqueryBuilder);
        return subqueryBuilder;
    }

    <X> CaseWhenStarterBuilder<X> selectCase(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, ClauseType.SELECT));
    }

    <X> SimpleCaseWhenStarterBuilder<X> selectSimpleCase(X builder, String selectAlias, Expression caseOperandExpression) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperandExpression, this.subqueryInitFactory, this.parameterManager, ClauseType.SELECT));
    }

    Class<?> getExpectedQueryResultType() {
        if (this.selectInfos.size() > 1) {
            return Object[].class;
        }
        return this.jpaProvider.getDefaultQueryResultType();
    }

    void select(Expression expr, String selectAlias) {
        this.select(expr, selectAlias, -1);
    }

    void select(Expression expr, String selectAlias, int index) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.selectInternal(expr, selectAlias, index);
    }

    private void selectInternal(Expression expr, String selectAlias) {
        this.selectInternal(expr, selectAlias, -1);
    }

    private void selectInternal(Expression expr, String selectAlias, int index) {
        SelectInfo selectInfo = new SelectInfo(expr, selectAlias, this.aliasManager);
        if (selectAlias != null) {
            this.aliasManager.registerAliasInfo(selectInfo);
            this.selectAliasToPositionMap.put(selectAlias, this.selectAliasToPositionMap.size());
        }
        if (index == -1) {
            this.addJpqlFunctionProcessor(expr, this.selectInfos.size());
            this.selectInfos.add(selectInfo);
        } else {
            this.addJpqlFunctionProcessor(expr, index);
            this.selectInfos.add(index, selectInfo);
        }
        this.hasSizeSelect = this.hasSizeSelect || ExpressionUtils.containsSizeExpression(selectInfo.getExpression());
        this.registerParameterExpressions(expr);
    }

    private void addJpqlFunctionProcessor(Expression expr, int index) {
        SubqueryInternalBuilder subqueryInternalBuilder;
        Subquery subquery;
        if (expr instanceof FunctionExpression) {
            String functionName = ((FunctionExpression)expr).getFunctionName().toLowerCase();
            JpqlFunction jpqlFunction = this.mainQuery.cbf.getRegisteredFunctions().get(functionName);
            if (jpqlFunction instanceof JpqlFunctionProcessor) {
                Subquery subquery2;
                this.jpqlFunctionProcessors.put(index, (JpqlFunctionProcessor)jpqlFunction);
                if ("to_multiset".equals(functionName) && (subquery2 = ((SubqueryExpression)((FunctionExpression)expr).getExpressions().get(0)).getSubquery()) instanceof SubqueryInternalBuilder) {
                    SubqueryInternalBuilder subqueryInternalBuilder2 = (SubqueryInternalBuilder)subquery2;
                    this.jpqlFunctionProcessors.put(index, new NestedToMultisetJpqlFunctionProcessor((JpqlFunctionProcessor)jpqlFunction, subqueryInternalBuilder2.getJpqlFunctionProcessors(), subqueryInternalBuilder2.getSelectExpressions()));
                }
            }
        } else if (expr instanceof SubqueryExpression && (subquery = ((SubqueryExpression)expr).getSubquery()) instanceof SubqueryInternalBuilder && !(subqueryInternalBuilder = (SubqueryInternalBuilder)subquery).getJpqlFunctionProcessors().isEmpty()) {
            this.jpqlFunctionProcessors.put(index, subqueryInternalBuilder.getJpqlFunctionProcessors().get(0));
        }
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Class<Y> clazz) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ClassObjectBuilder<Y>(clazz);
        return this.selectObjectBuilder;
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Constructor<Y> constructor) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ConstructorObjectBuilder<Y>(constructor);
        return this.selectObjectBuilder;
    }

    <X extends FullQueryBuilder<?, X>> void selectNew(X builder, ObjectBuilder<?> objectBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        objectBuilder.applySelects(builder);
        this.objectBuilder = objectBuilder;
    }

    void setDefaultSelect(Map<JoinNode, JoinNode> nodeMapping, List<SelectInfo> selectInfos, ExpressionCopyContext copyContext) {
        if (!this.selectInfos.isEmpty()) {
            throw new IllegalStateException("Can't set default select when explicit select items are already set!");
        }
        this.hasDefaultSelect = true;
        HashSet<JoinNode> nodes = null;
        JoinNodeGathererVisitor visitor = null;
        if (nodeMapping != null) {
            nodes = new HashSet<JoinNode>();
            visitor = new JoinNodeGathererVisitor(nodes);
        }
        for (int i = 0; i < selectInfos.size(); ++i) {
            SelectInfo selectInfo = selectInfos.get(i);
            String selectAlias = selectInfo.getAlias();
            Expression expr = this.subqueryInitFactory.reattachSubqueries(selectInfo.getExpression().copy(copyContext), ClauseType.SELECT);
            if (nodeMapping != null) {
                selectInfo.getExpression().accept((Expression.Visitor)visitor);
            }
            this.selectInternal(expr, selectAlias);
        }
        if (nodeMapping != null) {
            this.defaultSelectNodes = new HashSet<JoinNode>();
            for (JoinNode node : nodes) {
                this.defaultSelectNodes.add(nodeMapping.get(node));
            }
        }
    }

    void distinct() {
        this.distinct = true;
    }

    boolean isDistinct() {
        return this.distinct;
    }

    void setDefaultSelect() {
        this.hasDefaultSelect = true;
    }

    void unsetDefaultSelect() {
        this.hasDefaultSelect = false;
    }

    void removeDefaultSelectNode(JoinNode node) {
        if (this.defaultSelectNodes != null) {
            this.defaultSelectNodes.remove(node);
            this.defaultSelectNodes.removeAll(node.getDependencies());
        }
    }

    private void clearDefaultSelects() {
        if (!this.hasDefaultSelect) {
            return;
        }
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            if (selectInfo.getAlias() != null) {
                this.queryBuilder.inlineSelectAlias(selectInfo.getAlias(), selectInfo.getExpression());
            }
            this.aliasManager.unregisterAliasInfoForBottomLevel(selectInfo);
            this.unregisterParameterExpressions(selectInfo.getExpression());
        }
        this.selectAliasToPositionMap.clear();
        this.selectInfos.clear();
        this.jpqlFunctionProcessors.clear();
        this.hasDefaultSelect = false;
        this.hasSizeSelect = false;
        if (this.defaultSelectNodes != null) {
            this.joinManager.removeSelectOnlyNodes(this.defaultSelectNodes);
        }
        this.defaultSelectNodes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySelect(ResolvingQueryGenerator queryGenerator, StringBuilder sb, SelectInfo select, boolean renderAlias) {
        try {
            queryGenerator.addAlias(select.alias);
            queryGenerator.generate(select.getExpression());
            if (renderAlias && select.alias != null) {
                sb.append(" AS ").append(select.alias);
            }
        }
        finally {
            queryGenerator.removeAlias(select.alias);
        }
    }

    public String getSubquerySelectAlias(SelectInfo s) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            if (s != this.selectInfos.get(i)) continue;
            return "synth_alias_" + i;
        }
        return null;
    }

    public String getSubquerySelectAlias(String alias) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            if (!alias.equals(this.selectInfos.get((int)i).alias)) continue;
            return "synth_alias_" + i;
        }
        return null;
    }

    public void wrapPlainParameters() {
        boolean needsCastParameters = this.queryBuilder.mainQuery.dbmsDialect.needsCastParameters();
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            Class<?> elementType;
            SelectInfo selectInfo = this.selectInfos.get(i);
            final Expression expression = selectInfo.getExpression();
            if (!(expression instanceof ParameterExpression)) continue;
            String parameterName = ((ParameterExpression)expression).getName();
            ParameterManager.ParameterImpl<?> parameter = this.parameterManager.getParameter(parameterName);
            Object boundValue = parameter.getValue();
            if (parameter.getParameterType() == null) {
                if (boundValue == null) {
                    throw new IllegalArgumentException("Can't use the parameter with name '" + parameterName + "' as plain SELECT item with a null value!");
                }
                ParameterManager.ParameterValue parameterValue = parameter.getParameterValue();
                elementType = parameterValue == null ? boundValue.getClass() : parameterValue.getValueType();
            } else {
                elementType = parameter.getParameterType();
            }
            if (BasicCastTypes.TYPES.contains(elementType) && needsCastParameters) {
                ArrayList<Object> arguments = new ArrayList<Object>(2);
                arguments.add(expression);
                arguments.add(new StringLiteral(this.mainQuery.dbmsDialect.getSqlType(elementType)));
                selectInfo.set((Expression)new FunctionExpression("CAST_" + elementType.getSimpleName(), arguments, expression));
                continue;
            }
            final EntityMetamodelImpl.AttributeExample attributeExample = this.mainQuery.metamodel.getBasicTypeExampleAttributes().get(elementType);
            if (attributeExample == null) {
                throw new IllegalArgumentException("Can't use the parameter with name '" + parameterName + "', type '" + elementType.getName() + "' and value '" + boundValue + "' as plain SELECT item because there is no example attribute with that type in the JPA model providing the SQL type!");
            }
            ArrayList<Object> arguments = new ArrayList<Object>(2);
            arguments.add(new SubqueryExpression(new Subquery(){

                public String getQueryString() {
                    return attributeExample.getExampleJpql() + expression;
                }
            }));
            if (needsCastParameters && attributeExample.getAttribute().getColumnTypes().length != 0) {
                arguments.add(new StringLiteral(attributeExample.getAttribute().getColumnTypes()[0]));
            }
            selectInfo.set((Expression)new FunctionExpression("param", arguments, expression));
        }
    }

    private class SelectObjectBuilderEndedListenerImpl
    implements SelectObjectBuilderEndedListener {
        private SelectObjectBuilder<?> currentBuilder;

        private SelectObjectBuilderEndedListenerImpl() {
        }

        protected void verifyBuilderEnded() {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("A builder was not ended properly.");
            }
        }

        protected <X extends SelectObjectBuilder<?>> X startBuilder(X builder) {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("There was an attempt to start a builder but a previous builder was not ended.");
            }
            this.currentBuilder = builder;
            return builder;
        }

        @Override
        public void onBuilderEnded(Collection<Map.Entry<Expression, String>> expressions) {
            if (this.currentBuilder == null) {
                throw new IllegalStateException("There was an attempt to end a builder that was not started or already closed.");
            }
            this.currentBuilder = null;
            for (Map.Entry<Expression, String> e : expressions) {
                SelectManager.this.select(e.getKey(), e.getValue());
            }
        }
    }

    private class CaseExpressionBuilderListener
    extends ExpressionBuilderEndedListenerImpl {
        private final String selectAlias;

        public CaseExpressionBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(ExpressionBuilder builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(builder.getExpression(), this.selectAlias);
        }
    }

    private class SelectSubqueryBuilderListener<X>
    extends SubqueryBuilderListenerImpl<X> {
        private final String selectAlias;

        public SelectSubqueryBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select((Expression)new SubqueryExpression(builder), this.selectAlias);
        }
    }

    private class SuperExpressionSelectSubqueryBuilderListener<X>
    extends SuperExpressionSubqueryBuilderListener<X> {
        private final String selectAlias;

        public SuperExpressionSelectSubqueryBuilderListener(String subqueryAlias, Expression superExpression, String selectAlias) {
            super(subqueryAlias, superExpression);
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(this.superExpression, this.selectAlias);
        }
    }

    private static class NestedToMultisetJpqlFunctionProcessor
    implements JpqlFunctionProcessor<Object> {
        private final MultisetTransformingObjectBuilder objectBuilder;
        private final JpqlFunctionProcessor<Object> preProcessor;

        public NestedToMultisetJpqlFunctionProcessor(JpqlFunctionProcessor<?> preProcessor, Map<Integer, JpqlFunctionProcessor<?>> jpqlFunctionProcessorMap, List<Expression> expressions) {
            this.objectBuilder = new MultisetTransformingObjectBuilder(expressions, jpqlFunctionProcessorMap);
            this.preProcessor = preProcessor;
        }

        public Object process(Object result, List<Object> arguments) {
            List newResult = (List)this.preProcessor.process(result, arguments);
            if (newResult != null) {
                for (int i = 0; i < newResult.size(); ++i) {
                    this.objectBuilder.build((Object[])newResult.get(i));
                }
            }
            return newResult;
        }
    }
}

