/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.AbstractDbmsLimitHandler;
import com.blazebit.persistence.impl.function.CyclicUnsignedCounter;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySQLDbmsLimitHandler
extends AbstractDbmsLimitHandler {
    private static final ThreadLocal<CyclicUnsignedCounter> threadLocalCounter = new ThreadLocal<CyclicUnsignedCounter>(){

        @Override
        protected CyclicUnsignedCounter initialValue() {
            return new CyclicUnsignedCounter(-1);
        }
    };

    public MySQLDbmsLimitHandler() {
        super(20);
    }

    public MySQLDbmsLimitHandler(int length) {
        super(length);
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    public void applySql(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        if (limit != null) {
            if (offset != null) {
                sqlSb.append(" limit ").append(offset).append(',').append(limit);
            } else {
                sqlSb.append(" limit ").append(limit);
            }
        } else if (offset != null) {
            sqlSb.append(" limit ").append(offset).append(",18446744073709551610");
        }
    }

    public int bindLimitParametersAtEndOfQuery(Integer limit, Integer offset, PreparedStatement statement, int index) throws SQLException {
        if (limit != null) {
            if (offset != null) {
                statement.setInt(index, offset);
                statement.setInt(index + 1, limit);
                return 2;
            }
            statement.setInt(index, limit);
            return 1;
        }
        if (offset != null) {
            statement.setInt(index, offset);
            return 1;
        }
        return 0;
    }
}

