/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.dialect.PostgreSQLDbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.DeleteJoinStyle;
import com.blazebit.persistence.spi.SetOperationType;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PostgreSQLDbmsDialect
extends DefaultDbmsDialect {
    public PostgreSQLDbmsDialect() {
    }

    public PostgreSQLDbmsDialect(Map<Class<?>, String> childSqlTypes) {
        super(childSqlTypes);
    }

    @Override
    public DeleteJoinStyle getDeleteJoinStyle() {
        return DeleteJoinStyle.USING;
    }

    @Override
    public UpdateJoinStyle getUpdateJoinStyle() {
        return UpdateJoinStyle.FROM;
    }

    @Override
    public boolean supportsModificationQueryInWithClause() {
        return true;
    }

    @Override
    public boolean supportsReturningColumns() {
        return true;
    }

    @Override
    public boolean supportsIntersect(boolean all) {
        return true;
    }

    @Override
    public boolean supportsExcept(boolean all) {
        return true;
    }

    @Override
    protected boolean supportsPartitionInRowNumberOver() {
        return true;
    }

    @Override
    public boolean supportsCountTuple() {
        return true;
    }

    @Override
    public boolean supportsFilterClause() {
        return false;
    }

    @Override
    public boolean supportsWindowNullPrecedence() {
        return true;
    }

    @Override
    protected boolean needsSetOperationWrapper() {
        return false;
    }

    @Override
    public int getPrepareFlags() {
        return 2;
    }

    @Override
    public DbmsLimitHandler createLimitHandler() {
        return new PostgreSQLDbmsLimitHandler();
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String dmlAffectedTable, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean addParenthesis;
        boolean requiresNew = includedModificationStates != null && includedModificationStates.containsKey(DbmsModificationState.NEW);
        boolean bl = addParenthesis = isSubquery && sqlSb.length() > 0 && sqlSb.charAt(0) != '(';
        if (requiresNew) {
            StringBuilder newStateSb = new StringBuilder(sqlSb.length() + returningColumns.length * 30);
            if (statementType == DbmsStatementType.DELETE) {
                int i;
                String deletedEntitiesCte = includedModificationStates.get(DbmsModificationState.NEW) + "_del";
                StringBuilder deleteSb = new StringBuilder(sqlSb.length() + returningColumns.length * 30);
                deleteSb.append((CharSequence)sqlSb);
                deleteSb.append(" returning *");
                sqlSb.setLength(0);
                PostgreSQLDbmsDialect.appendSelectColumnsFromTable(sqlSb, returningColumns, deletedEntitiesCte);
                if (addParenthesis) {
                    newStateSb.append('(');
                }
                PostgreSQLDbmsDialect.appendSelectColumnsFromTable(newStateSb, new String[]{"*"}, PostgreSQLDbmsDialect.extractSingleTableName(statementType, deleteSb));
                newStateSb.append(" new_tmp_ where not exists (");
                PostgreSQLDbmsDialect.appendSelectColumnsFromTable(newStateSb, new String[]{"1"}, deletedEntitiesCte);
                newStateSb.append(" sub_tmp_ where (");
                for (i = 0; i < returningColumns.length; ++i) {
                    newStateSb.append("new_tmp_.").append(returningColumns[i]);
                    newStateSb.append(',');
                }
                newStateSb.setCharAt(newStateSb.length() - 1, ')');
                newStateSb.append("=(");
                for (i = 0; i < returningColumns.length; ++i) {
                    newStateSb.append("sub_tmp_.").append(returningColumns[i]);
                    newStateSb.append(',');
                }
                newStateSb.setCharAt(newStateSb.length() - 1, ')');
                newStateSb.append(')');
                if (addParenthesis) {
                    newStateSb.append(')');
                }
                LinkedHashMap<String, String> addedCtes = new LinkedHashMap<String, String>();
                addedCtes.put(deletedEntitiesCte, deleteSb.toString());
                addedCtes.put(includedModificationStates.get(DbmsModificationState.NEW), newStateSb.toString());
                return addedCtes;
            }
            newStateSb.append((CharSequence)sqlSb);
            newStateSb.append(" returning *");
            sqlSb.setLength(0);
            if (addParenthesis) {
                sqlSb.append('(');
            }
            PostgreSQLDbmsDialect.appendSelectColumnsFromTable(sqlSb, returningColumns, includedModificationStates.get(DbmsModificationState.NEW));
            sqlSb.append(" union ");
            PostgreSQLDbmsDialect.appendSelectColumnsFromTable(sqlSb, returningColumns, PostgreSQLDbmsDialect.extractSingleTableName(statementType, newStateSb));
            if (addParenthesis) {
                sqlSb.append(')');
            }
            return Collections.singletonMap(includedModificationStates.get(DbmsModificationState.NEW), newStateSb.toString());
        }
        if (addParenthesis) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(0, withClause);
        }
        if (limit != null || offset != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (returningColumns != null) {
            sqlSb.append(" returning ");
            for (int i = 0; i < returningColumns.length; ++i) {
                if (i != 0) {
                    sqlSb.append(",");
                }
                sqlSb.append(dmlAffectedTable).append('.');
                sqlSb.append(returningColumns[i]);
            }
        }
        if (addParenthesis) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    protected String[] appendSetOperands(StringBuilder sqlSb, SetOperationType setType, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        boolean first = true;
        for (String operand : operands) {
            if (first) {
                first = false;
            } else {
                sqlSb.append(' ');
                sqlSb.append(operator);
                sqlSb.append(' ');
            }
            if (hasOuterClause && !operand.startsWith("(")) {
                sqlSb.append('(');
                sqlSb.append(operand);
                sqlSb.append(')');
                continue;
            }
            sqlSb.append(operand);
        }
        return null;
    }

    private static void appendSelectColumnsFromTable(StringBuilder sqlSb, String[] returningColumns, String table) {
        sqlSb.append(" select ");
        for (int i = 0; i < returningColumns.length; ++i) {
            if (i != 0) {
                sqlSb.append(",");
            }
            sqlSb.append(returningColumns[i]);
        }
        sqlSb.append(" from ");
        sqlSb.append(table);
    }

    private static String extractSingleTableName(DbmsStatementType statementType, StringBuilder sb) {
        if (statementType == DbmsStatementType.DELETE) {
            String needle = "from";
            int startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            int endIndex = sb.indexOf(" ", startIndex);
            return sb.substring(startIndex, endIndex);
        }
        if (statementType == DbmsStatementType.UPDATE) {
            String needle = "update";
            int startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            int endIndex = sb.indexOf(" ", startIndex);
            return sb.substring(startIndex, endIndex);
        }
        if (statementType == DbmsStatementType.INSERT) {
            String needle = "into";
            int startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            int endIndex = sb.indexOf(" ", startIndex);
            endIndex = PostgreSQLDbmsDialect.indexOfOrEnd(sb, '(', startIndex, endIndex);
            return sb.substring(startIndex, endIndex);
        }
        throw new IllegalArgumentException("Unsupported statement type: " + statementType);
    }

    private static int indexOfOrEnd(StringBuilder sb, char needle, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (sb.charAt(startIndex) == needle) {
                return startIndex;
            }
            ++startIndex;
        }
        return endIndex;
    }

    @Override
    public boolean supportsBooleanAggregation() {
        return true;
    }

    @Override
    public boolean supportsArbitraryLengthMultiset() {
        return true;
    }
}

