/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.jsonget;

import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractJsonGetFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "json_get";

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() < 2) {
            throw new RuntimeException("The json_get function requires at least two arguments <jsonField>, <key1|arrayIndex1>, ..., <keyN|arrayIndexN>! args=" + context);
        }
        this.render0(context);
    }

    protected abstract void render0(FunctionRenderContext var1);

    public static String toJsonPath(List<Object> pathElements, int to, boolean quotePathElements) {
        StringBuilder jsonPathBuilder = new StringBuilder("$");
        for (int i = 0; i < to; ++i) {
            Object currentPathElement = pathElements.get(i);
            if (currentPathElement instanceof Integer) {
                jsonPathBuilder.append('[');
                jsonPathBuilder.append((Integer)currentPathElement);
                jsonPathBuilder.append(']');
                continue;
            }
            jsonPathBuilder.append('.');
            if (quotePathElements) {
                jsonPathBuilder.append("\"");
            }
            jsonPathBuilder.append((String)currentPathElement);
            if (!quotePathElements) continue;
            jsonPathBuilder.append("\"");
        }
        return jsonPathBuilder.toString();
    }

    public static List<Object> retrieveJsonPathElements(FunctionRenderContext context, int pathStartOffset) {
        ArrayList<Object> jsonPathElements = new ArrayList<Object>(context.getArgumentsSize() - pathStartOffset);
        for (int i = pathStartOffset; i < context.getArgumentsSize(); ++i) {
            try {
                jsonPathElements.add(Integer.parseInt(JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(i))));
                continue;
            }
            catch (NumberFormatException e) {
                jsonPathElements.add(JpqlFunctionUtil.unquoteDoubleQuotes(JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(i))));
            }
        }
        return jsonPathElements;
    }
}

