/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseModificationCriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningModificationCriteriaBuilderFactory;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.SimpleReturningBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.builder.object.ReturningTupleObjectBuilder;
import com.blazebit.persistence.impl.dialect.DB2DbmsDialect;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.ModificationQuerySpecification;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.AttributePath;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractModificationCriteriaBuilder<T, X extends BaseModificationCriteriaBuilder<X>, Y>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, BaseFinalSetOperationBuilderImpl<T, ?, ?>>
implements BaseModificationCriteriaBuilder<X>,
CTEInfoBuilder,
SimpleReturningBuilder {
    protected final EntityType<T> entityType;
    protected final String entityAlias;
    protected final EntityType<?> cteType;
    protected final CTEManager.CTEKey cteKey;
    protected final Y result;
    protected final CTEBuilderListener listener;
    protected final boolean isReturningEntityAliasAllowed;
    protected final Map<String, List<Attribute<?, ?>>> returningAttributes;
    protected final Map<String, String> returningAttributeBindingMap;
    protected final Map<String, ExtendedAttribute<?, ?>> attributeEntries;
    protected final Map<String, String> columnBindingMap;

    public AbstractModificationCriteriaBuilder(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, DbmsStatementType statementType, Class<T> clazz, String alias, CTEManager.CTEKey cteKey, Class<?> cteClass, Y result, CTEBuilderListener listener) {
        super(mainQuery, queryContext, isMainQuery, statementType, Tuple.class, null);
        if (alias != null) {
            this.fromClassExplicitlySet = true;
        }
        this.entityType = mainQuery.metamodel.entity(clazz);
        this.entityAlias = this.joinManager.addRoot(this.entityType, alias, false);
        this.result = result;
        this.listener = listener;
        if (cteClass == null) {
            this.cteType = null;
            this.cteKey = null;
            this.isReturningEntityAliasAllowed = false;
            this.returningAttributes = new LinkedHashMap(0);
            this.returningAttributeBindingMap = new LinkedHashMap<String, String>(0);
            this.attributeEntries = null;
            this.columnBindingMap = null;
        } else {
            this.cteType = mainQuery.metamodel.entity(cteClass);
            this.cteKey = cteKey;
            this.isReturningEntityAliasAllowed = true;
            this.returningAttributes = null;
            this.attributeEntries = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, cteClass).getOwnedSingularAttributes();
            this.returningAttributeBindingMap = new LinkedHashMap<String, String>(this.attributeEntries.size());
            this.columnBindingMap = new LinkedHashMap<String, String>(this.attributeEntries.size());
        }
    }

    public AbstractModificationCriteriaBuilder(AbstractModificationCriteriaBuilder<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.entityType = builder.entityType;
        this.entityAlias = builder.entityAlias;
        this.result = null;
        this.listener = null;
        this.cteType = builder.cteType;
        this.cteKey = builder.cteKey;
        this.isReturningEntityAliasAllowed = builder.isReturningEntityAliasAllowed;
        this.returningAttributes = builder.returningAttributes == null ? null : new LinkedHashMap(builder.returningAttributes);
        this.returningAttributeBindingMap = new LinkedHashMap<String, String>(builder.returningAttributeBindingMap);
        this.attributeEntries = builder.attributeEntries;
        this.columnBindingMap = builder.columnBindingMap == null ? null : new LinkedHashMap<String, String>(builder.columnBindingMap);
    }

    @Override
    public FullSelectCTECriteriaBuilder<X> with(Class<?> cteClass) {
        if (!this.mainQuery.dbmsDialect.supportsWithClauseInModificationQuery()) {
            return super.with(cteClass, true);
        }
        return super.with(cteClass);
    }

    @Override
    public FullSelectCTECriteriaBuilder<X> with(Class<?> cteClass, CriteriaBuilder<?> criteriaBuilder) {
        if (!this.mainQuery.dbmsDialect.supportsWithClauseInModificationQuery()) {
            return super.with(cteClass, criteriaBuilder, true);
        }
        return super.with(cteClass, criteriaBuilder);
    }

    @Override
    public SelectRecursiveCTECriteriaBuilder<X> withRecursive(Class<?> cteClass) {
        if (!this.mainQuery.dbmsDialect.supportsWithClauseInModificationQuery()) {
            throw new UnsupportedOperationException("The database does not support a with clause in modification queries!");
        }
        return super.withRecursive(cteClass);
    }

    @Override
    public ReturningModificationCriteriaBuilderFactory<X> withReturning(Class<?> cteClass) {
        if (!this.mainQuery.dbmsDialect.supportsWithClauseInModificationQuery()) {
            throw new UnsupportedOperationException("The database does not support a with clause in modification queries!");
        }
        return super.withReturning(cteClass);
    }

    protected void applyJpaReturning(StringBuilder sbSelectFrom) {
        sbSelectFrom.append(" RETURNING ");
        boolean first = true;
        for (String attribute : this.returningAttributeBindingMap.values()) {
            if (first) {
                first = false;
            } else {
                sbSelectFrom.append(", ");
            }
            sbSelectFrom.append(attribute);
        }
    }

    @Override
    public Query getQuery() {
        return this.getQuery(null);
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query query;
        if (this.hasLimit() || this.mainQuery.cteManager.hasCtes() || this.returningAttributeBindingMap.size() > 0) {
            query = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
            Set<String> parameterListNames = this.parameterManager.getParameterListNames(query);
            boolean isEmbedded = this instanceof ReturningBuilder;
            String[] returningColumns = this.getReturningColumns();
            boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
            List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(isEmbedded) : Collections.EMPTY_LIST;
            ModificationQuerySpecification querySpecification = new ModificationQuerySpecification(this, query, this.getCountExampleQuery(), this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, null, includedModificationStates, this.returningAttributeBindingMap, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled());
            query = new CustomSQLQuery(querySpecification, query, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        } else {
            query = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        }
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    public int executeUpdate() {
        return this.getQuery().executeUpdate();
    }

    @Override
    protected Map<DbmsModificationState, String> getModificationStates(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        boolean defaultOld;
        Map<String, DbmsModificationState> versionEntities = explicitVersionEntities.get(this.entityType.getJavaType());
        if (versionEntities == null) {
            return null;
        }
        HashMap<DbmsModificationState, String> includedModificationStates = new HashMap<DbmsModificationState, String>();
        boolean bl = defaultOld = !(this.mainQuery.dbmsDialect instanceof DB2DbmsDialect);
        if (defaultOld) {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.NEW) continue;
                includedModificationStates.put(DbmsModificationState.NEW, this.entityType.getName() + "_new");
                if (this.getStatementType() != DbmsStatementType.DELETE) break;
                includedModificationStates.put(DbmsModificationState.OLD, this.cteKey.getName());
                break;
            }
        } else {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.OLD) continue;
                includedModificationStates.put(DbmsModificationState.OLD, this.entityType.getName() + "_old");
                break;
            }
        }
        return includedModificationStates;
    }

    @Override
    protected Map<String, String> getModificationStateRelatedTableNameRemappings(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        boolean defaultOld;
        Map<String, DbmsModificationState> versionEntities = explicitVersionEntities.get(this.entityType.getJavaType());
        if (versionEntities == null) {
            return null;
        }
        HashMap<String, String> tableNameRemappings = new HashMap<String, String>();
        boolean bl = defaultOld = !(this.mainQuery.dbmsDialect instanceof DB2DbmsDialect);
        if (defaultOld) {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.NEW) continue;
                tableNameRemappings.put(entry.getKey(), this.entityType.getName() + "_new");
            }
        } else {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.OLD) continue;
                tableNameRemappings.put(entry.getKey(), this.entityType.getName() + "_old");
            }
        }
        return tableNameRemappings;
    }

    public ReturningResult<Tuple> executeWithReturning(String ... attributes) {
        return (ReturningResult)this.getWithReturningQuery(attributes).getSingleResult();
    }

    public TypedQuery<ReturningResult<Tuple>> getWithReturningQuery(String ... attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        if (attributes.length == 0) {
            throw new IllegalArgumentException("Invalid empty attributes");
        }
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        List<List<Attribute<?, ?>>> attributeList = this.getAndCheckAttributes(attributes);
        TypedQuery<Object[]> exampleQuery = this.getExampleQuery(attributeList);
        String[] returningColumns = this.getReturningColumns(attributeList);
        return this.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, new ReturningTupleObjectBuilder());
    }

    public <Z> ReturningResult<Z> executeWithReturning(String attribute, Class<Z> type) {
        return (ReturningResult)this.getWithReturningQuery(attribute, type).getSingleResult();
    }

    public <Z> TypedQuery<ReturningResult<Z>> getWithReturningQuery(String attribute, Class<Z> type) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (attribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty attribute");
        }
        JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
        AttributePath attrPath = jpaMetamodelAccessor.getBasicAttributePath((Metamodel)this.getMetamodel(), this.entityType, attribute);
        if (!type.isAssignableFrom(attrPath.getAttributeClass())) {
            throw new IllegalArgumentException("The given expected field type is not of the expected type: " + attrPath.getAttributeClass().getName());
        }
        ArrayList attributes = new ArrayList();
        attributes.add(attrPath.getAttributes());
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        TypedQuery<Object[]> exampleQuery = this.getExampleQuery(attributes);
        String[] returningColumns = this.getReturningColumns(attributes);
        return this.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, null);
    }

    public <Z> ReturningResult<Z> executeWithReturning(ReturningObjectBuilder<Z> objectBuilder) {
        return (ReturningResult)this.getWithReturningQuery(objectBuilder).getSingleResult();
    }

    public <Z> TypedQuery<ReturningResult<Z>> getWithReturningQuery(ReturningObjectBuilder<Z> objectBuilder) {
        this.returningAttributes.clear();
        objectBuilder.applyReturning((SimpleReturningBuilder)this);
        List<List<Attribute<?, ?>>> attributes = this.getAndCheckReturningAttributes();
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        TypedQuery<Object[]> exampleQuery = this.getExampleQuery(attributes);
        String[] returningColumns = this.getReturningColumns(attributes);
        return this.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, objectBuilder);
    }

    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        ModificationQuerySpecification querySpecification = new ModificationQuerySpecification(this, baseQuery, (Query)exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, false, returningColumns, objectBuilder, null, this.returningAttributeBindingMap, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled());
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        query.setFirstResult(this.firstResult);
        query.setMaxResults(this.maxResults);
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private List<List<Attribute<?, ?>>> getAndCheckReturningAttributes() {
        int attributeCount = this.returningAttributes.size();
        if (attributeCount == 0) {
            throw new IllegalArgumentException("Invalid empty attributes");
        }
        return new ArrayList(this.returningAttributes.values());
    }

    private void validateReturningAttributes() {
        Set availableAttributes;
        int attributeCount = this.returningAttributeBindingMap.size();
        if (attributeCount == 0) {
            throw new IllegalArgumentException("Invalid empty attributes");
        }
        if (this.cteType == null || (availableAttributes = this.cteType.getAttributes()).size() == this.returningAttributeBindingMap.size()) {
            return;
        }
        TreeSet<String> attributeNames = new TreeSet<String>();
        for (Attribute attr : availableAttributes) {
            String attributeName = attr.getName();
            if (this.returningAttributeBindingMap.containsKey(attributeName)) continue;
            attributeNames.add(attributeName);
        }
        throw new IllegalArgumentException("The following required CTE attributes are not bound: " + attributeNames);
    }

    public SimpleReturningBuilder returning(String modificationQueryAttribute) {
        JpaMetamodelAccessor jpaMetamodelAccessor;
        List attributePath;
        if (modificationQueryAttribute == null) {
            throw new NullPointerException("modificationQueryAttribute");
        }
        if (modificationQueryAttribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty modificationQueryAttribute");
        }
        if (this.isReturningEntityAliasAllowed && modificationQueryAttribute.equals(this.entityAlias)) {
            SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute(this.entityType);
            modificationQueryAttribute = idAttribute.getName();
        }
        if (this.returningAttributes.put(modificationQueryAttribute, attributePath = (jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor()).getBasicAttributePath((Metamodel)this.getMetamodel(), this.entityType, modificationQueryAttribute).getAttributes()) != null) {
            throw new IllegalArgumentException("The entity attribute [" + modificationQueryAttribute + "] has already been returned!");
        }
        return this;
    }

    public X returning(String cteAttribute, String modificationQueryAttribute) {
        Class queryAttrType;
        if (cteAttribute == null) {
            throw new NullPointerException("cteAttribute");
        }
        if (modificationQueryAttribute == null) {
            throw new NullPointerException("modificationQueryAttribute");
        }
        if (cteAttribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty cteAttribute");
        }
        if (modificationQueryAttribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty modificationQueryAttribute");
        }
        ExtendedAttribute<?, ?> attributeEntry = this.attributeEntries.get(cteAttribute);
        if (attributeEntry == null) {
            if (this.cteType.getAttribute(cteAttribute) != null) {
                throw new IllegalArgumentException("Can't bind the embeddable cte attribute [" + cteAttribute + "] directly! Please bind the respective sub attributes.");
            }
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] does not exist!");
        }
        if (this.isReturningEntityAliasAllowed && modificationQueryAttribute.equals(this.entityAlias)) {
            queryAttrType = this.entityType.getJavaType();
            SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute(this.entityType);
            modificationQueryAttribute = idAttribute.getName();
        } else {
            JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
            AttributePath queryAttributePath = jpaMetamodelAccessor.getBasicAttributePath((Metamodel)this.getMetamodel(), this.entityType, modificationQueryAttribute);
            queryAttrType = queryAttributePath.getAttributeClass();
        }
        Class cteAttrType = attributeEntry.getElementClass();
        if (!cteAttrType.isAssignableFrom(queryAttrType)) {
            throw new IllegalArgumentException("The given cte attribute '" + cteAttribute + "' with the type '" + cteAttrType.getName() + "' can not be assigned with a value of the type '" + queryAttrType.getName() + "' of the query attribute '" + modificationQueryAttribute + "'!");
        }
        if (this.returningAttributeBindingMap.put(cteAttribute, modificationQueryAttribute) != null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] has already been bound!");
        }
        for (String column : attributeEntry.getColumnNames()) {
            if (this.columnBindingMap.put(column, cteAttribute) == null) continue;
            throw new IllegalArgumentException("The cte column [" + column + "] has already been bound!");
        }
        return (X)this;
    }

    public Y end() {
        this.validateReturningAttributes();
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public CTEInfo createCTEInfo() {
        List<String> attributes = this.prepareAndGetAttributes();
        List<String> columns = this.prepareAndGetColumnNames();
        CTEInfo info = new CTEInfo(this.cteKey.getName(), this.cteKey.getOwner(), false, this.cteType, attributes, columns, false, false, this, null);
        return info;
    }

    private List<List<Attribute<?, ?>>> getAndCheckAttributes(String[] attributes) {
        ArrayList attrs = new ArrayList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] == null) {
                throw new NullPointerException("attribute at position " + i);
            }
            if (attributes[i].isEmpty()) {
                throw new IllegalArgumentException("empty attribute at position " + i);
            }
            JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
            attrs.add(jpaMetamodelAccessor.getBasicAttributePath((Metamodel)this.getMetamodel(), this.entityType, attributes[i]).getAttributes());
        }
        return attrs;
    }

    private String[] getReturningColumns(List<List<Attribute<?, ?>>> attributes) {
        ArrayList<String> columns = new ArrayList<String>(attributes.size());
        StringBuilder sb = new StringBuilder();
        for (List<Attribute<?, ?>> returningAttribute : attributes) {
            JoinTable joinTable = null;
            for (int i = 0; i < returningAttribute.size(); ++i) {
                sb.append(returningAttribute.get(i).getName()).append('.');
                if (!returningAttribute.get(i).isCollection()) continue;
                sb.setLength(sb.length() - 1);
                joinTable = this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType).getAttribute(sb.toString()).getJoinTable();
                sb.setLength(0);
            }
            sb.setLength(sb.length() - 1);
            if (joinTable == null) {
                for (String column : this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType).getAttribute(sb.toString()).getColumnNames()) {
                    columns.add(column);
                }
            } else {
                for (String column : joinTable.getTargetColumnMappings().keySet()) {
                    columns.add(column);
                }
            }
            sb.setLength(0);
        }
        return columns.toArray(new String[columns.size()]);
    }

    protected String[] getReturningColumns() {
        if (this.returningAttributeBindingMap.isEmpty()) {
            return null;
        }
        Collection<String> returningAttributeNames = this.returningAttributeBindingMap.values();
        ArrayList<String> columns = new ArrayList<String>(returningAttributeNames.size());
        for (String returningAttributeName : this.returningAttributeBindingMap.values()) {
            for (String column : this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType).getAttribute(returningAttributeName).getColumnNames()) {
                columns.add(column);
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    protected Query getCountExampleQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(e) FROM ");
        sb.append(this.entityType.getName());
        sb.append(" e");
        String exampleQueryString = sb.toString();
        return this.em.createQuery(exampleQueryString);
    }

    private TypedQuery<Object[]> getExampleQuery(List<List<Attribute<?, ?>>> attributes) {
        StringBuilder sb = new StringBuilder();
        StringBuilder joinSb = new StringBuilder();
        sb.append("SELECT ");
        boolean first = true;
        for (List<Attribute<?, ?>> attrPath : attributes) {
            int i;
            Attribute<?, ?> lastPathElem = attrPath.get(attrPath.size() - 1);
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (!this.mainQuery.dbmsDialect.supportsReturningColumns() && !JpaMetamodelUtils.getSingleIdAttribute(this.entityType).equals(lastPathElem)) {
                throw new IllegalArgumentException("Returning the query attribute [" + lastPathElem.getName() + "] is not supported by the dbms, only generated keys can be returned!");
            }
            JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
            if (jpaMetamodelAccessor.isJoinable(lastPathElem)) {
                sb.append(this.entityAlias).append('.');
                EntityType type = this.mainQuery.metamodel.entity(JpaMetamodelUtils.resolveFieldClass((Class)this.entityType.getJavaType(), lastPathElem));
                SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute(type);
                sb.append(lastPathElem.getName()).append('.').append(idAttribute.getName());
                continue;
            }
            String startAlias = this.entityAlias;
            int startIndex = 0;
            for (i = 0; i < attrPath.size(); ++i) {
                if (!attrPath.get(i).isCollection()) continue;
                startAlias = attrPath.get(i).getName();
                startIndex = i + 1;
                joinSb.append(" JOIN ").append(this.entityAlias).append(".").append(startAlias).append(" ").append(startAlias);
                break;
            }
            sb.append(startAlias).append('.');
            sb.append(attrPath.get(startIndex).getName());
            for (i = startIndex + 1; i < attrPath.size(); ++i) {
                sb.append('.').append(attrPath.get(i).getName());
            }
        }
        sb.append(" FROM ");
        sb.append(this.entityType.getName()).append(' ').append(this.entityAlias);
        sb.append((CharSequence)joinSb);
        String exampleQueryString = sb.toString();
        return this.em.createQuery(exampleQueryString, Object[].class);
    }

    protected List<String> prepareAndGetAttributes() {
        return new ArrayList<String>(this.returningAttributeBindingMap.keySet());
    }

    protected List<String> prepareAndGetColumnNames() {
        StringBuilder sb = null;
        for (ExtendedAttribute<?, ?> entry : this.attributeEntries.values()) {
            for (String column : entry.getColumnNames()) {
                if (this.columnBindingMap.containsKey(column)) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append("[");
                } else {
                    sb.append(", ");
                }
                sb.append(column);
            }
        }
        if (sb != null) {
            sb.insert(0, "The following column names have not been bound: ");
            sb.append("]");
            throw new IllegalStateException(sb.toString());
        }
        return new ArrayList<String>(this.columnBindingMap.keySet());
    }

    protected String[] getIdColumns(ExtendedManagedType<?> extendedManagedType) {
        if (this.mainQuery.dbmsDialect.getPhysicalRowId() != null) {
            return new String[]{this.mainQuery.dbmsDialect.getPhysicalRowId()};
        }
        Map attributes = extendedManagedType.getAttributes();
        TreeSet idColumns = new TreeSet();
        for (SingularAttribute idAttribute : extendedManagedType.getIdAttributes()) {
            Collections.addAll(idColumns, ((ExtendedAttribute)attributes.get(idAttribute.getName())).getColumnNames());
        }
        return idColumns.toArray(new String[0]);
    }
}

