/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExtendedParameter;
import com.blazebit.persistence.impl.ParameterRegistrationVisitor;
import com.blazebit.persistence.impl.ParameterUnregistrationVisitor;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.util.LiteralFunctionTypeConverter;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.AttributeAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class ParameterManager {
    private static final String PREFIX = "param_";
    private static final Map<TypeConverter<?>, String> TEMPORAL_CONVERTER_LITERAL_FUNCTIONS;
    private int counter;
    private final JpaProvider jpaProvider;
    private final EntityMetamodel entityMetamodel;
    private final Map<String, ParameterImpl<?>> parameters = new TreeMap();
    private final Map<String, String> valuesParameters = new TreeMap<String, String>();
    private final ParameterRegistrationVisitor parameterRegistrationVisitor;
    private final ParameterUnregistrationVisitor parameterUnregistrationVisitor;
    private int positionalOffset = -1;

    public ParameterManager(JpaProvider jpaProvider, EntityMetamodel entityMetamodel) {
        this.jpaProvider = jpaProvider;
        this.entityMetamodel = entityMetamodel;
        this.parameterRegistrationVisitor = new ParameterRegistrationVisitor(this);
        this.parameterUnregistrationVisitor = new ParameterUnregistrationVisitor(this);
    }

    public ParameterRegistrationVisitor getParameterRegistrationVisitor() {
        return this.parameterRegistrationVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectParameterRegistrations(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, ClauseType clauseType) {
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> oldQueryBuilder = this.parameterRegistrationVisitor.getQueryBuilder();
        ClauseType oldClauseType = this.parameterRegistrationVisitor.getClauseType();
        try {
            this.parameterRegistrationVisitor.setClauseType(clauseType);
            this.parameterRegistrationVisitor.setQueryBuilder(queryBuilder);
            queryBuilder.applyVisitor((Expression.Visitor)this.parameterRegistrationVisitor);
        }
        finally {
            this.parameterRegistrationVisitor.setClauseType(oldClauseType);
            this.parameterRegistrationVisitor.setQueryBuilder(oldQueryBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectParameterRegistrations(Expression expression, ClauseType clauseType, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> oldQueryBuilder = this.parameterRegistrationVisitor.getQueryBuilder();
        ClauseType oldClauseType = this.parameterRegistrationVisitor.getClauseType();
        try {
            this.parameterRegistrationVisitor.setClauseType(clauseType);
            this.parameterRegistrationVisitor.setQueryBuilder(queryBuilder);
            expression.accept((Expression.Visitor)this.parameterRegistrationVisitor);
        }
        finally {
            this.parameterRegistrationVisitor.setClauseType(oldClauseType);
            this.parameterRegistrationVisitor.setQueryBuilder(oldQueryBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectParameterUnregistrations(Expression expression, ClauseType clauseType, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> oldQueryBuilder = this.parameterUnregistrationVisitor.getQueryBuilder();
        ClauseType oldClauseType = this.parameterUnregistrationVisitor.getClauseType();
        try {
            this.parameterUnregistrationVisitor.setClauseType(clauseType);
            this.parameterUnregistrationVisitor.setQueryBuilder(queryBuilder);
            expression.accept((Expression.Visitor)this.parameterUnregistrationVisitor);
        }
        finally {
            this.parameterUnregistrationVisitor.setClauseType(oldClauseType);
            this.parameterUnregistrationVisitor.setQueryBuilder(oldQueryBuilder);
        }
    }

    Map<String, String> copyFrom(ParameterManager parameterManager) {
        HashMap<String, String> parameterMapping = new HashMap<String, String>(parameterManager.parameters.size());
        for (Map.Entry<String, ParameterImpl<?>> entry : parameterManager.parameters.entrySet()) {
            String newParameterName;
            String oldParameterName;
            ParameterImpl<?> param = entry.getValue();
            ParameterValue paramValue = null;
            if (param.isValueSet()) {
                paramValue = param.getParameterValue() == null ? (ParameterValue)param.getValue() : param.getParameterValue().copy();
            }
            if (Character.isDigit((oldParameterName = entry.getKey()).charAt(0))) {
                ++this.positionalOffset;
                newParameterName = Integer.toString(this.positionalOffset);
            } else if (param.isImplicit() && !(paramValue instanceof ValuesParameterWrapper)) {
                newParameterName = PREFIX + this.counter++;
            } else {
                ParameterImpl<?> existingParameter = this.parameters.get(oldParameterName);
                newParameterName = oldParameterName;
                if (existingParameter != null) {
                    if (existingParameter.getParameterType() != param.getParameterType()) {
                        throw new IllegalStateException("Can't apply parameters! Parameter '" + oldParameterName + "' with type '" + param.getParameterType() + "' is incompatible with existing type: " + existingParameter.getParameterType());
                    }
                    if (existingParameter.isCollectionValued() != param.isCollectionValued()) {
                        throw new IllegalStateException("Can't apply parameters! Parameter '" + oldParameterName + "' is collection valued in one query, but not the other!");
                    }
                    if (existingParameter.getTransformer() != param.getTransformer()) {
                        throw new IllegalStateException("Can't apply parameters! Parameter '" + oldParameterName + "' has a tranfsformer in one query, but not the other!");
                    }
                    if (!param.isValueSet()) continue;
                    existingParameter.setValue(paramValue);
                    continue;
                }
            }
            parameterMapping.put(oldParameterName, newParameterName);
            this.addParameterMapping(newParameterName, paramValue, param.isImplicit());
        }
        for (Map.Entry<String, Object> entry : parameterManager.valuesParameters.entrySet()) {
            if (this.valuesParameters.put(entry.getKey(), (String)entry.getValue()) == null) continue;
            throw new IllegalArgumentException("Can't copy value parameters because of a name clash for value parameter with name: " + entry.getKey());
        }
        return parameterMapping;
    }

    Set<String> getParameterListNames(Query q) {
        return this.getParameterListNames(q, null);
    }

    Set<String> getParameterListNames(Query q, String skippedParameterPrefix) {
        HashSet<String> parameterListNames = new HashSet<String>();
        this.collectParameterListNames(q, parameterListNames, skippedParameterPrefix);
        return parameterListNames;
    }

    void collectParameterListNames(Query q, Set<String> parameterListNames) {
        this.collectParameterListNames(q, parameterListNames, null);
    }

    void collectParameterListNames(Query q, Set<String> parameterListNames, String skippedParameterPrefix) {
        for (Parameter p : q.getParameters()) {
            ParameterImpl<?> parameter;
            String name = p.getName();
            if (name == null) {
                name = p.getPosition().toString();
            } else if (skippedParameterPrefix != null && name.startsWith(skippedParameterPrefix)) continue;
            if ((parameter = this.getParameter(name)) == null || !parameter.isCollectionValued()) continue;
            parameterListNames.add(name);
        }
    }

    void parameterizeQuery(Query q) {
        this.parameterizeQuery(q, null);
    }

    void parameterizeQuery(Query q, String skippedParameterPrefix) {
        HashSet<String> requestedValueParameters = new HashSet<String>();
        for (Parameter p : q.getParameters()) {
            String parameterName = p.getName();
            if (parameterName == null) {
                parameterName = p.getPosition().toString();
            } else if (skippedParameterPrefix != null && parameterName.startsWith(skippedParameterPrefix)) continue;
            ParameterImpl<?> parameter = this.parameters.get(parameterName);
            if (parameter == null) {
                String valuesParameter = this.valuesParameters.get(parameterName);
                if (valuesParameter == null) {
                    throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
                }
                requestedValueParameters.add(valuesParameter);
                continue;
            }
            if (parameter.getParameterValue() instanceof ValuesParameterWrapper) {
                if (parameter.getValue() == null) continue;
                q.setParameter(parameterName, parameter.getValue());
                continue;
            }
            parameter.bind(q);
        }
        for (String parameterName : requestedValueParameters) {
            ParameterImpl<?> parameter = this.parameters.get(parameterName);
            parameter.bind(q);
        }
    }

    public ParameterImpl<?> getParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        return parameter;
    }

    public Set<Parameter<?>> getParameters() {
        return new HashSet(this.parameters.values());
    }

    public Map<String, String> getValuesParameters() {
        return Collections.unmodifiableMap(this.valuesParameters);
    }

    public Map<String, ParameterValueTransformer> getTransformers() {
        HashMap<String, ParameterValueTransformer> transformers = new HashMap<String, ParameterValueTransformer>();
        for (Map.Entry<String, ParameterImpl<?>> entry : this.parameters.entrySet()) {
            ParameterValueTransformer transformer = entry.getValue().getTransformer();
            if (transformer == null) continue;
            transformers.put(entry.getKey(), transformer);
        }
        return transformers;
    }

    public Map<String, ValuesParameterBinder> getValuesBinders() {
        HashMap<String, ValuesParameterBinder> binders = new HashMap<String, ValuesParameterBinder>();
        for (Map.Entry<String, ParameterImpl<?>> entry : this.parameters.entrySet()) {
            ParameterValue value = entry.getValue().getParameterValue();
            if (!(value instanceof ValuesParameterWrapper)) continue;
            binders.put(entry.getKey(), ((ValuesParameterWrapper)value).getBinder());
        }
        return binders;
    }

    public boolean containsParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        return this.parameters.containsKey(parameterName);
    }

    public boolean isParameterSet(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        return parameter != null && parameter.getValue() != null;
    }

    public Object getParameterValue(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        return parameter.getValue();
    }

    public String getLiteralParameterValue(ParameterExpression expression, boolean renderEnumAsLiteral) {
        Object value = expression.getValue();
        if (value == null) {
            value = this.getParameterValue(expression.getName());
        }
        return this.getLiteralParameterValue(value, renderEnumAsLiteral);
    }

    public String getLiteralParameterValue(Object value, boolean renderEnumAsLiteral) {
        TypeConverter converter;
        if (value != null && (converter = TypeUtils.getConverter(value.getClass(), this.entityMetamodel.getEnumTypes().keySet())) != null) {
            if (value instanceof Enum) {
                if (renderEnumAsLiteral) {
                    return converter.toString(value);
                }
            } else {
                if (converter instanceof LiteralFunctionTypeConverter) {
                    if (TypeUtils.isTemporalConverter((TypeConverter)converter) && this.jpaProvider.supportsTemporalLiteral()) {
                        return converter.toString(value);
                    }
                    String functionInvocation = this.jpaProvider.getCustomFunctionInvocation(((LiteralFunctionTypeConverter)converter).getLiteralFunctionName(), 1);
                    String literalValue = converter.toString(value);
                    StringBuilder sb = new StringBuilder(functionInvocation.length() + literalValue.length() + 5);
                    sb.append(functionInvocation);
                    TypeUtils.STRING_CONVERTER.appendTo((Object)literalValue, sb);
                    sb.append(')');
                    return sb.toString();
                }
                return converter.toString(value);
            }
        }
        return null;
    }

    public ParameterExpression addParameterExpression(Object o, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        String name = this.addParameter(o, o instanceof Collection, clause, queryBuilder);
        return new ParameterExpression(name, o, o instanceof Collection);
    }

    private String addParameter(Object o, boolean collectionValued, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (o == null) {
            throw new NullPointerException();
        }
        String name = PREFIX + this.counter++;
        this.parameters.put(name, new ParameterImpl<Object>(name, collectionValued, clause, queryBuilder, o));
        return name;
    }

    public void addParameterMapping(String parameterName, Object o, boolean implicit) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        Integer position = this.determinePositionalOffset(parameterName);
        if (position == null) {
            this.parameters.put(parameterName, new ParameterImpl<Object>(parameterName, o instanceof Collection, implicit, o));
        } else {
            this.parameters.put(parameterName, new ParameterImpl<Object>(position, o instanceof Collection, implicit, o));
        }
    }

    public void addParameterMapping(String parameterName, Object o, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        Integer position = this.determinePositionalOffset(parameterName);
        if (position == null) {
            this.parameters.put(parameterName, new ParameterImpl<Object>(parameterName, o instanceof Collection, clause, queryBuilder, o));
        } else {
            this.parameters.put(parameterName, new ParameterImpl<Object>((int)position, o instanceof Collection, clause, queryBuilder, o));
        }
    }

    public void registerParameterName(String parameterName, boolean collectionValued, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            Integer position = this.determinePositionalOffset(parameterName);
            if (position == null) {
                this.parameters.put(parameterName, new ParameterImpl(parameterName, collectionValued, false, clause, queryBuilder));
            } else {
                this.parameters.put(parameterName, new ParameterImpl((int)position, collectionValued, false, clause, queryBuilder));
            }
        } else {
            Set<AbstractCommonQueryBuilder<Object, Object, Object, Object, Object>> builders = parameter.getClauseTypes().get((Object)clause);
            if (builders == null) {
                builders = Collections.newSetFromMap(new IdentityHashMap());
                parameter.getClauseTypes().put(clause, builders);
            }
            builders.add(queryBuilder);
        }
    }

    private Integer determinePositionalOffset(String parameterName) {
        if (Character.isDigit(parameterName.charAt(0))) {
            int value = Integer.parseInt(parameterName);
            this.positionalOffset = Math.max(value, this.positionalOffset);
            return value;
        }
        return null;
    }

    public void unregisterParameterName(String parameterName, ClauseType clauseType, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        Set<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> builders;
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter != null && (builders = parameter.getClauseTypes().get((Object)clauseType)) != null) {
            builders.remove(queryBuilder);
            if (builders.isEmpty()) {
                parameter.getClauseTypes().remove((Object)clauseType);
                if (parameter.getClauseTypes().isEmpty()) {
                    this.parameters.remove(parameterName);
                }
            }
        }
    }

    public void registerValuesParameter(String parameterName, Class<?> type, String[][] parameterNames, AttributeAccessor<Object, Object>[] pathExpressions, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException("Can't register parameter for VALUES clause because there already exists a parameter with the name: " + parameterName);
        }
        this.parameters.put(parameterName, new ParameterImpl<ValuesParameterWrapper>(parameterName, false, ClauseType.JOIN, queryBuilder, new ValuesParameterWrapper(type, parameterNames, pathExpressions)));
        for (int i = 0; i < parameterNames.length; ++i) {
            for (int j = 0; j < parameterNames[i].length; ++j) {
                this.valuesParameters.put(parameterNames[i][j], parameterName);
            }
        }
    }

    public void satisfyParameter(String parameterName, Object parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(parameterValue);
    }

    public void satisfyParameter(String parameterName, Calendar value, TemporalType temporalType) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(new TemporalCalendarParameterWrapper(temporalType, value));
    }

    public void satisfyParameter(String parameterName, Date value, TemporalType temporalType) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(new TemporalDateParameterWrapper(temporalType, value));
    }

    public void setParameterType(String parameterName, Class<?> type) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setParameterType(type);
    }

    public int getPositionalOffset() {
        if (this.positionalOffset == -1) {
            return -1;
        }
        return this.positionalOffset + 1;
    }

    static {
        HashMap literalFunctions = new HashMap();
        literalFunctions.put(TypeUtils.TIME_CONVERTER, "literal_time");
        literalFunctions.put(TypeUtils.DATE_CONVERTER, "literal_date");
        literalFunctions.put(TypeUtils.TIMESTAMP_CONVERTER, "literal_timestamp");
        literalFunctions.put(TypeUtils.DATE_TIMESTAMP_CONVERTER, "literal_util_date");
        literalFunctions.put(TypeUtils.CALENDAR_CONVERTER, "literal_calendar");
        TEMPORAL_CONVERTER_LITERAL_FUNCTIONS = literalFunctions;
    }

    public static final class ParameterImpl<T>
    implements ExtendedParameter<T> {
        private final String name;
        private final Integer position;
        private final boolean collectionValued;
        private final boolean implicit;
        private final Map<ClauseType, Set<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>>> clauseTypes;
        private boolean usedInImplicitGroupBy;
        private Class<T> parameterType;
        private T value;
        private boolean valueSet;
        private ParameterValueTransformer transformer;

        public ParameterImpl(String name, boolean collectionValued, boolean implicit, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
            this.name = name;
            this.position = null;
            this.collectionValued = collectionValued;
            this.implicit = implicit;
            this.clauseTypes = new EnumMap(ClauseType.class);
            if (clause != null) {
                Set builders = Collections.newSetFromMap(new IdentityHashMap());
                builders.add(queryBuilder);
                this.clauseTypes.put(clause, builders);
            }
        }

        public ParameterImpl(String name, boolean collectionValued, boolean implicit, T value) {
            this(name, collectionValued, implicit, null, null);
            this.setValue(value);
        }

        public ParameterImpl(String name, boolean collectionValued, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, T value) {
            this(name, collectionValued, true, clause, queryBuilder);
            this.setValue(value);
        }

        public ParameterImpl(int position, boolean collectionValued, boolean implicit, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
            this.name = null;
            this.position = position;
            this.collectionValued = collectionValued;
            this.implicit = implicit;
            this.clauseTypes = new EnumMap(ClauseType.class);
            if (clause != null) {
                Set builders = Collections.newSetFromMap(new IdentityHashMap());
                builders.add(queryBuilder);
                this.clauseTypes.put(clause, builders);
            }
        }

        public ParameterImpl(int position, boolean collectionValued, boolean implicit, T value) {
            this(position, collectionValued, implicit, null, null);
            this.setValue(value);
        }

        public ParameterImpl(int position, boolean collectionValued, ClauseType clause, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, T value) {
            this(position, collectionValued, true, clause, queryBuilder);
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        @Override
        public boolean isCollectionValued() {
            return this.collectionValued;
        }

        public Map<ClauseType, Set<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>>> getClauseTypes() {
            return this.clauseTypes;
        }

        public Class<T> getParameterType() {
            return this.parameterType;
        }

        public void setParameterType(Class<T> parameterType) {
            this.parameterType = parameterType;
        }

        public boolean isUsedInGroupBy() {
            return this.usedInImplicitGroupBy || this.clauseTypes.containsKey((Object)ClauseType.GROUP_BY);
        }

        public boolean isUsedInImplicitGroupBy() {
            return this.usedInImplicitGroupBy;
        }

        public void setUsedInImplicitGroupBy(boolean usedInImplicitGroupBy) {
            this.usedInImplicitGroupBy = usedInImplicitGroupBy;
        }

        public ParameterValue getParameterValue() {
            if (this.value instanceof ParameterValue) {
                return (ParameterValue)this.value;
            }
            return null;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public boolean isValueSet() {
            return this.valueSet;
        }

        public T getValue() {
            if (this.value instanceof ParameterValue) {
                return (T)((ParameterValue)this.value).getValue();
            }
            return this.value;
        }

        public void setValue(T value) {
            this.valueSet = true;
            if (this.transformer != null) {
                value = this.transform(value);
            }
            if (this.value instanceof ParameterValue) {
                this.value = ((ParameterValue)this.value).withValue(value);
            } else {
                this.value = value;
                if (value != null) {
                    this.parameterType = value instanceof ParameterValue ? ((ParameterValue)value).getValueType() : value.getClass();
                }
            }
        }

        private T transform(T value) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                ArrayList<Object> list = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    list.add(this.transformer.transform(o));
                }
                return (T)list;
            }
            return (T)this.transformer.transform(value);
        }

        public ParameterValueTransformer getTransformer() {
            return this.transformer;
        }

        public void setTransformer(ParameterValueTransformer transformer) {
            if (this.transformer == null) {
                this.transformer = transformer;
                if (this.valueSet) {
                    this.value = this.transform(this.value);
                }
            } else if (!this.transformer.equals(transformer)) {
                throw new IllegalStateException("Tried to set parameter value transformer [" + transformer + "] although a transformer [" + this.transformer + "] is already set for parameter: " + this.name);
            }
        }

        public void bind(Query q) {
            if (this.valueSet) {
                if (this.value instanceof ParameterValue) {
                    if (this.name == null) {
                        ((ParameterValue)this.value).bind(q, this.position);
                    } else {
                        ((ParameterValue)this.value).bind(q, this.name);
                    }
                } else if (this.name == null) {
                    q.setParameter(this.position.intValue(), this.value);
                } else {
                    q.setParameter(this.name, this.value);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (this.name != null ? !this.name.equals(parameter.getName()) : parameter.getName() != null) {
                return false;
            }
            return this.position != null ? this.position.equals(parameter.getPosition()) : parameter.getPosition() == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
            return result;
        }
    }

    static interface ParameterValue {
        public ParameterValue copy();

        public Class<?> getValueType();

        public Object getValue();

        public ParameterValue withValue(Object var1);

        public void bind(Query var1, String var2);

        public void bind(Query var1, int var2);
    }

    static final class ValuesParameterWrapper
    implements ParameterValue {
        private final Class<?> type;
        private final ValuesParameterBinder binder;
        private Collection<Object> value;

        public ValuesParameterWrapper(Class<?> type, String[][] parameterNames, AttributeAccessor<Object, Object>[] pathExpressions) {
            this.type = type;
            this.binder = new ValuesParameterBinder(parameterNames, pathExpressions);
        }

        private ValuesParameterWrapper(Class<?> type, ValuesParameterBinder binder) {
            this.type = type;
            this.binder = binder;
        }

        @Override
        public ParameterValue copy() {
            ArrayList<Object> newValue = null;
            if (this.value != null) {
                newValue = new ArrayList<Object>(this.value);
            }
            return new ValuesParameterWrapper(this.type, this.binder).withValue(newValue);
        }

        public ValuesParameterBinder getBinder() {
            return this.binder;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Class<?> getValueType() {
            return Collection.class;
        }

        @Override
        public ParameterValue withValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("null not allowed for VALUES parameter!");
            }
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value for VALUES parameter must be a collection! Unsupported type: " + value.getClass());
            }
            Collection collection = (Collection)value;
            if (collection.size() > this.binder.size()) {
                throw new IllegalArgumentException("The size of the collection must be lower or equal to the specified size for the VALUES clause.");
            }
            this.value = collection;
            return this;
        }

        @Override
        public void bind(Query query, String name) {
            if (this.value == null) {
                throw new IllegalArgumentException("No values are bound for parameter with name: " + name);
            }
            this.binder.bind(query, this.value);
        }

        @Override
        public void bind(Query query, int position) {
            if (this.value == null) {
                throw new IllegalArgumentException("No values are bound for parameter with position: " + position);
            }
            this.binder.bind(query, this.value);
        }
    }

    static final class TemporalCalendarParameterWrapper
    implements ParameterValue {
        private final TemporalType type;
        private Calendar value;

        public TemporalCalendarParameterWrapper(TemporalType type, Calendar value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public ParameterValue copy() {
            Calendar newValue = null;
            if (this.value != null) {
                newValue = (Calendar)this.value.clone();
            }
            return new TemporalCalendarParameterWrapper(this.type, newValue);
        }

        @Override
        public Calendar getValue() {
            return this.value;
        }

        @Override
        public ParameterValue withValue(Object value) {
            this.value = (Calendar)value;
            return this;
        }

        @Override
        public Class<?> getValueType() {
            return Calendar.class;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.type);
        }

        @Override
        public void bind(Query query, int position) {
            query.setParameter(position, this.value, this.type);
        }
    }

    static final class TemporalDateParameterWrapper
    implements ParameterValue {
        private final TemporalType type;
        private Date value;

        public TemporalDateParameterWrapper(TemporalType type, Date value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public ParameterValue copy() {
            Date newValue = null;
            if (this.value != null) {
                newValue = (Date)this.value.clone();
            }
            return new TemporalDateParameterWrapper(this.type, newValue);
        }

        @Override
        public Date getValue() {
            return this.value;
        }

        @Override
        public ParameterValue withValue(Object value) {
            this.value = (Date)value;
            return this;
        }

        @Override
        public Class<?> getValueType() {
            return Date.class;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.type);
        }

        @Override
        public void bind(Query query, int position) {
            query.setParameter(position, this.value, this.type);
        }
    }
}

