/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.entity;

import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public class EntityFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "entity_function";
    public static final String MARKER_PREDICATE = "999=999";
    private static final String AND_MARKER = " and 999=999";

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return firstArgumentType;
    }

    public void render(FunctionRenderContext functionRenderContext) {
        int aliasStartIndex;
        if (functionRenderContext.getArgumentsSize() == 0) {
            throw new RuntimeException("The ENTITY_FUNCTION function needs at least one argument <sub_query>! args=" + functionRenderContext);
        }
        String subquery = functionRenderContext.getArgument(0);
        StringBuilder sb = new StringBuilder();
        int subqueryEndIndex = subquery.lastIndexOf(AND_MARKER);
        int aliasEndIndex = subquery.indexOf(46, subqueryEndIndex);
        for (aliasStartIndex = aliasEndIndex - 1; aliasStartIndex > subqueryEndIndex; --aliasStartIndex) {
            if (SqlUtils.isIdentifier(subquery.charAt(aliasStartIndex))) continue;
            ++aliasStartIndex;
            break;
        }
        String entityName = JpqlFunctionUtil.unquoteSingleQuotes(functionRenderContext.getArgument(1));
        String valuesClause = JpqlFunctionUtil.unquoteSingleQuotes(functionRenderContext.getArgument(2));
        String valuesAliases = JpqlFunctionUtil.unquoteSingleQuotes(functionRenderContext.getArgument(3));
        String syntheticPredicate = JpqlFunctionUtil.unquoteSingleQuotes(functionRenderContext.getArgument(4));
        String valuesTableSqlAlias = subquery.substring(aliasStartIndex, aliasEndIndex);
        EntityFunction.appendSubqueryPart(sb, subquery, 1, subqueryEndIndex, subquery.length() - 1);
        if (!syntheticPredicate.isEmpty()) {
            String exampleQuerySqlAlias = syntheticPredicate.substring(0, syntheticPredicate.indexOf(46));
            syntheticPredicate = syntheticPredicate.replace(exampleQuerySqlAlias, valuesTableSqlAlias);
            String subselect = "( select * from " + entityName + " )";
            String subselectTableExpr = subselect + " " + valuesTableSqlAlias;
            int subselectIndex = sb.indexOf(subselectTableExpr, 0);
            String andSeparator = " and ";
            if (subselectIndex == -1) {
                int syntheticPredicateStart = sb.indexOf(syntheticPredicate, sb.indexOf(" " + valuesTableSqlAlias + " "));
                int end = syntheticPredicateStart + syntheticPredicate.length();
                if (sb.indexOf(" and ", end) == end) {
                    sb.replace(syntheticPredicateStart, end + " and ".length(), "");
                } else {
                    sb.replace(syntheticPredicateStart, end, "1=1");
                }
            } else {
                while ((subselectIndex = sb.indexOf(subselectTableExpr, subselectIndex)) > -1) {
                    int endIndex = subselectIndex + subselect.length();
                    int syntheticPredicateStart = sb.indexOf(syntheticPredicate, endIndex);
                    int end = syntheticPredicateStart + syntheticPredicate.length();
                    if (sb.indexOf(" and ", end) == end) {
                        sb.replace(syntheticPredicateStart, end + " and ".length(), "");
                    } else {
                        sb.replace(syntheticPredicateStart, end, "1=1");
                    }
                    sb.replace(subselectIndex, endIndex, entityName);
                }
            }
        }
        SqlUtils.applyTableNameRemapping(sb, valuesTableSqlAlias, valuesClause, valuesAliases, null, false);
        functionRenderContext.addChunk("(");
        functionRenderContext.addChunk(sb.toString());
        functionRenderContext.addChunk(")");
    }

    public static void appendSubqueryPart(StringBuilder sb, String sqlQuery) {
        int subqueryEndIndex = sqlQuery.lastIndexOf(AND_MARKER);
        if (subqueryEndIndex == -1) {
            sb.append(sqlQuery);
        } else {
            EntityFunction.appendSubqueryPart(sb, sqlQuery, 0, subqueryEndIndex, sqlQuery.length());
        }
    }

    private static void appendSubqueryPart(StringBuilder sb, String sqlQuery, int start, int subqueryEndIndex, int end) {
        sb.append(sqlQuery, start, subqueryEndIndex);
        int[] range = EntityFunction.removeSyntheticPredicate(sqlQuery, subqueryEndIndex, end);
        sb.append(sqlQuery, range[0], range[1]);
    }

    public static void removeSyntheticPredicate(StringBuilder sb, String sqlQuery, int end) {
        int subqueryEndIndex = sb.lastIndexOf(AND_MARKER);
        int[] range = EntityFunction.removeSyntheticPredicate(sqlQuery, subqueryEndIndex, end);
        sb.replace(subqueryEndIndex, range[0], "");
    }

    private static int[] removeSyntheticPredicate(String sqlQuery, int subqueryEndIndex, int end) {
        int idPredicateIndex = sqlQuery.indexOf(" and ", subqueryEndIndex + AND_MARKER.length());
        if (idPredicateIndex == -1) {
            return new int[]{subqueryEndIndex + AND_MARKER.length(), end};
        }
        int isNullPredicateIndex = sqlQuery.indexOf(" is null", idPredicateIndex + 1);
        int newSubqueryPartStart = isNullPredicateIndex + " is null".length();
        for (int i = idPredicateIndex + 1; i < isNullPredicateIndex; ++i) {
            if (sqlQuery.charAt(i) != '(') continue;
            ++newSubqueryPartStart;
        }
        return new int[]{newSubqueryPartStart, end};
    }
}

