/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public class ObjectBuilderTypedQuery<X>
extends TypedQueryWrapper<X> {
    private final ObjectBuilder<X> builder;

    public ObjectBuilderTypedQuery(TypedQuery<?> delegate, ObjectBuilder<X> builder) {
        super(delegate);
        this.builder = builder;
    }

    @Override
    public X getSingleResult() {
        List<X> list = this.getResultList();
        switch (list.size()) {
            case 0: {
                throw new NoResultException("No results for query: " + this.delegate);
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new NonUniqueResultException("Expected a single result for query: " + this.delegate);
    }

    @Override
    public List<X> getResultList() {
        List list = super.getResultList();
        int size = list.size();
        ArrayList<Object> newList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object tuple = list.get(i);
            if (tuple instanceof Object[]) {
                newList.add(this.builder.build((Object[])tuple));
                continue;
            }
            newList.add(this.builder.build(new Object[]{tuple}));
        }
        return this.builder.buildList(newList);
    }
}

