/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.plan.CustomSelectQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class SetOperationQuerySpecification<T>
extends CustomQuerySpecification<T> {
    private final Query leftMostQuery;
    private final List<Query> setOperands;
    private final SetOperationType operator;
    private final List<? extends OrderByElement> orderByElements;
    private final boolean nested;

    public SetOperationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query leftMostQuery, Query baseQuery, List<Query> setOperands, SetOperationType operator, List<? extends OrderByElement> orderByElements, boolean nested, Set<Parameter<?>> parameters, Set<String> parameterListNames, String limit, String offset, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean queryPlanCacheEnabled) {
        super(commonQueryBuilder, baseQuery, parameters, parameterListNames, limit, offset, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes, queryPlanCacheEnabled, null);
        this.leftMostQuery = leftMostQuery;
        this.setOperands = setOperands;
        this.operator = operator;
        this.orderByElements = orderByElements;
        this.nested = nested;
    }

    @Override
    public Query getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    protected void initialize() {
        String sqlQuery;
        ArrayList<Object> participatingQueries = new ArrayList<Object>();
        ArrayList<Query> cteQueries = new ArrayList<Query>();
        this.bindListParameters(this.baseQuery);
        TypedQuery q = this.leftMostQuery;
        if (q instanceof TypedQueryWrapper) {
            q = ((TypedQueryWrapper)q).getDelegate();
        }
        if (q instanceof AbstractCustomQuery) {
            AbstractCustomQuery customQuery = (AbstractCustomQuery)q;
            this.bindListParameters((Query)q);
            List<Query> customQueryParticipants = customQuery.getParticipatingQueries();
            participatingQueries.addAll(customQueryParticipants);
            sqlQuery = customQuery.getSql();
        } else {
            participatingQueries.add(this.baseQuery);
            sqlQuery = this.extendedQuerySupport.getSql(this.em, this.baseQuery);
        }
        int size = sqlQuery.length() + 10;
        ArrayList<String> setOperands = new ArrayList<String>();
        setOperands.add(sqlQuery);
        for (TypedQuery typedQuery : this.setOperands) {
            String setOperandSql;
            this.bindListParameters((Query)typedQuery);
            q = typedQuery;
            if (q instanceof TypedQueryWrapper) {
                q = ((TypedQueryWrapper)q).getDelegate();
            }
            if (q instanceof AbstractCustomQuery) {
                AbstractCustomQuery customQuery = (AbstractCustomQuery)q;
                List<Query> customQueryParticipants = customQuery.getParticipatingQueries();
                participatingQueries.addAll(customQueryParticipants);
                setOperandSql = customQuery.getSql();
            } else {
                setOperandSql = this.extendedQuerySupport.getSql(this.em, q);
                participatingQueries.add(q);
            }
            setOperands.add(setOperandSql);
            size += setOperandSql.length() + 30;
        }
        StringBuilder sqlSb = new StringBuilder(size);
        this.dbmsDialect.appendSet(sqlSb, this.operator, this.nested, setOperands, this.orderByElements, this.limit, this.offset);
        StringBuilder stringBuilder = this.applyCtes(sqlSb, this.baseQuery, cteQueries);
        Map addedCtes = this.dbmsDialect.appendExtendedSql(sqlSb, this.statementType, false, false, stringBuilder, null, null, null, null, null);
        cteQueries.addAll(participatingQueries);
        participatingQueries = cteQueries;
        this.sql = sqlSb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }

    @Override
    public SelectQueryPlan<T> createSelectPlan(int firstResult, int maxResults) {
        String sql = this.getSql();
        return new CustomSelectQueryPlan(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.baseQuery, this.participatingQueries, sql, firstResult, maxResults, this.queryPlanCacheEnabled);
    }

    private void bindListParameters(Query q) {
        for (Parameter parameter : q.getParameters()) {
            Collection value = (Collection)this.listParameters.get(parameter.getName());
            if (value == null) continue;
            q.setParameter(parameter, (Object)value);
        }
    }
}

