/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateAndExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenAndThenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.CaseWhenOrThenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.util.ArrayList;
import java.util.List;

public class CaseWhenBuilderImpl<T>
extends PredicateAndExpressionBuilderEndedListener
implements CaseWhenBuilder<T>,
CaseWhenThenBuilder<CaseWhenBuilder<T>>,
ExpressionBuilder {
    private final T result;
    private final List<WhenClauseExpression> whenClauses;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private Predicate whenExpression;
    private GeneralCaseExpression expression;
    private Expression thenExpression;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>>();
    private final ExpressionBuilderEndedListener listener;

    public CaseWhenBuilderImpl(T result, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clauseType) {
        this.result = result;
        this.whenClauses = new ArrayList<WhenClauseExpression>();
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
        this.clauseType = clauseType;
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> when(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery() {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, this.clauseType);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery(String subqueryAlias, String expression) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false, this.clauseType);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clauseType);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubqueries(String expression) {
        return this.startMultipleSubqueryInitiator(this.expressionFactory.createSimpleExpression(expression));
    }

    private MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> startMultipleSubqueryInitiator(Expression expression) {
        this.verifyBuilderEnded();
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> initiator = new MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>>(restrictionBuilder, expression, null, this.subqueryInitFactory, this.clauseType);
        return initiator;
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenExists() {
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightHandside, true, this.clauseType);
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenNotExists() {
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightHandside, true, this.clauseType);
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightHandside, true, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightHandside, true, criteriaBuilder, this.clauseType);
    }

    public CaseWhenBuilder<T> thenExpression(String expression) {
        if (this.thenExpression != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.thenExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.whenClauses.add(new WhenClauseExpression((Expression)this.whenExpression, this.thenExpression));
        return this;
    }

    public CaseWhenBuilder<T> thenLiteral(Object value) {
        if (this.thenExpression != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        String literal = TypeUtils.asLiteral((Object)value, (EntityMetamodel)this.subqueryInitFactory.getQueryBuilder().getMetamodel());
        if (literal == null) {
            return this.then(value);
        }
        this.thenExpression = this.expressionFactory.createInItemExpression(literal);
        this.whenClauses.add(new WhenClauseExpression((Expression)this.whenExpression, this.thenExpression));
        return this;
    }

    public CaseWhenBuilder<T> then(Object value) {
        if (this.thenExpression != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.thenExpression = this.parameterManager.addParameterExpression(value, this.clauseType, this.subqueryInitFactory.getQueryBuilder());
        this.whenClauses.add(new WhenClauseExpression((Expression)this.whenExpression, this.thenExpression));
        return this;
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<T>> whenAnd() {
        return this.startBuilder(new CaseWhenAndThenBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<T>> whenOr() {
        return this.startBuilder(new CaseWhenOrThenBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public T otherwiseExpression(String elseExpression) {
        this.verifyBuilderEnded();
        if (this.whenClauses.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        if (this.expression != null) {
            throw new IllegalStateException("Method otherwise/otherwiseExpression called multiple times");
        }
        this.expression = new GeneralCaseExpression(this.whenClauses, this.expressionFactory.createSimpleExpression(elseExpression, false));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T otherwiseLiteral(Object value) {
        this.verifyBuilderEnded();
        if (this.whenClauses.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        if (this.expression != null) {
            throw new IllegalStateException("Method otherwise/otherwiseExpression called multiple times");
        }
        String literal = TypeUtils.asLiteral((Object)value, (EntityMetamodel)this.subqueryInitFactory.getQueryBuilder().getMetamodel());
        if (literal == null) {
            return this.otherwise(value);
        }
        this.expression = new GeneralCaseExpression(this.whenClauses, this.expressionFactory.createInItemExpression(literal));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T otherwise(Object value) {
        this.verifyBuilderEnded();
        if (this.whenClauses.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        if (this.expression != null) {
            throw new IllegalStateException("Method otherwise/otherwiseExpression called multiple times");
        }
        this.expression = new GeneralCaseExpression(this.whenClauses, (Expression)this.parameterManager.addParameterExpression(value, this.clauseType, this.subqueryInitFactory.getQueryBuilder()));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder o) {
        super.onBuilderEnded(o);
        this.whenExpression = o.getPredicate();
        this.thenExpression = null;
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        super.onBuilderEnded(builder);
        this.whenClauses.add((WhenClauseExpression)builder.getExpression());
    }

    @Override
    public void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.leftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }
}

