/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.impl.util.AbstractPatternFinder;

public class BoyerMooreCaseInsensitiveAsciiLastPatternFinder
extends AbstractPatternFinder {
    private static final int RADIX = 256;
    private final int[] left;
    private final char[] pattern;

    public BoyerMooreCaseInsensitiveAsciiLastPatternFinder(String pattern) {
        int i;
        int length = pattern.length();
        this.pattern = new char[length];
        this.left = new int[256];
        for (i = 0; i < 256; ++i) {
            this.left[i] = length - 1;
        }
        i = length - 1;
        while (i >= 0) {
            char c;
            this.pattern[i] = c = Character.toLowerCase(pattern.charAt(i));
            this.left[c] = i--;
        }
    }

    @Override
    public int indexIn(char[] text, int start, int end) {
        int skip;
        int m = this.pattern.length;
        for (int i = end - m; i >= start; i -= skip) {
            skip = 0;
            for (int j = 0; j < m; ++j) {
                char c = Character.toLowerCase(text[i + j]);
                if (this.pattern[j] == c) continue;
                skip = Math.max(1, this.left[c] - j);
                break;
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexIn(CharSequence text, int start, int end) {
        int skip;
        int m = this.pattern.length;
        for (int i = end - m; i >= start; i -= skip) {
            skip = 0;
            for (int j = 0; j < m; ++j) {
                char c = Character.toLowerCase(text.charAt(i + j));
                if (this.pattern[j] == c) continue;
                skip = Math.max(1, this.left[c] - j);
                break;
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }
}

