/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.PredicateBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.WhereOrBuilder;
import com.blazebit.persistence.WindowBuilder;
import com.blazebit.persistence.WindowFrameBetweenBuilder;
import com.blazebit.persistence.WindowFrameBuilder;
import com.blazebit.persistence.WindowFrameExclusionBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.WindowManager;
import com.blazebit.persistence.impl.builder.predicate.WhereOrBuilderImpl;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFrameMode;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.List;

public class WindowBuilderImpl<T>
extends PredicateManager<WindowBuilderImpl<T>>
implements WindowBuilder<T>,
WhereBuilder<WindowBuilderImpl<T>>,
WindowFrameBuilder<T>,
WindowFrameExclusionBuilder<T>,
WindowFrameBetweenBuilder<T> {
    private final WindowManager<T> windowManager;
    private final T result;
    private final String name;
    private final List<Expression> partitionExpressions = new ArrayList<Expression>();
    private final List<OrderByItem> orderByExpressions = new ArrayList<OrderByItem>();
    private String baseWindowName;
    private WindowFrameMode frameMode;
    private WindowFramePositionType frameStartType;
    private Expression frameStartExpression;
    private WindowFramePositionType frameEndType;
    private Expression frameEndExpression;
    private WindowFrameExclusionType frameExclusionType;

    public WindowBuilderImpl(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, WindowManager<T> windowManager, T result, String name) {
        super(queryGenerator, parameterManager, subqueryInitFactory, expressionFactory);
        this.windowManager = windowManager;
        this.result = result;
        this.name = name;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.WINDOW;
    }

    @Override
    protected String getClauseName() {
        return "WINDOW";
    }

    public <X extends WhereBuilder<X> & WindowBuilder<X>> X filter() {
        return (X)this;
    }

    public WindowBuilder<T> partitionBy(String ... partitionExpressions) {
        for (String partitionExpression : partitionExpressions) {
            Expression expr = this.expressionFactory.createSimpleExpression(partitionExpression, false);
            this.parameterManager.collectParameterRegistrations(expr, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            this.partitionExpressions.add(expr);
        }
        return this;
    }

    public WindowBuilder<T> partitionBy(String partitionExpression) {
        Expression expr = this.expressionFactory.createSimpleExpression(partitionExpression, false);
        this.parameterManager.collectParameterRegistrations(expr, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.partitionExpressions.add(expr);
        return this;
    }

    public WindowFrameBuilder<T> rows() {
        this.frameMode = WindowFrameMode.ROWS;
        return this;
    }

    public WindowFrameBuilder<T> range() {
        this.frameMode = WindowFrameMode.RANGE;
        return this;
    }

    public WindowFrameBuilder<T> groups() {
        this.frameMode = WindowFrameMode.GROUPS;
        return this;
    }

    public WindowBuilder<T> orderBy(String expression, boolean ascending) {
        return this.orderBy(expression, ascending, false);
    }

    public WindowBuilder<T> orderBy(String expression, boolean ascending, boolean nullFirst) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(expr, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.orderByExpressions.add(new OrderByItem(ascending, nullFirst, expr));
        return this;
    }

    public WindowBuilder<T> orderByAsc(String expression) {
        return this.orderBy(expression, true, false);
    }

    public WindowBuilder<T> orderByAsc(String expression, boolean nullFirst) {
        return this.orderBy(expression, true, nullFirst);
    }

    public WindowBuilder<T> orderByDesc(String expression) {
        return this.orderBy(expression, false, false);
    }

    public WindowBuilder<T> orderByDesc(String expression, boolean nullFirst) {
        return this.orderBy(expression, false, nullFirst);
    }

    public WindowFrameBetweenBuilder<T> betweenUnboundedPreceding() {
        this.frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
        return this;
    }

    public WindowFrameBetweenBuilder<T> betweenPreceding(String expression) {
        this.frameStartExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(this.frameStartExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.frameStartType = WindowFramePositionType.BOUNDED_PRECEDING;
        return this;
    }

    public WindowFrameBetweenBuilder<T> betweenFollowing(String expression) {
        this.frameStartExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(this.frameStartExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.frameStartType = WindowFramePositionType.BOUNDED_FOLLOWING;
        return this;
    }

    public WindowFrameBetweenBuilder<T> betweenCurrentRow() {
        this.frameStartType = WindowFramePositionType.CURRENT_ROW;
        return this;
    }

    public WindowFrameExclusionBuilder<T> unboundedPreceding() {
        this.frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
        return this;
    }

    public WindowFrameExclusionBuilder<T> preceding(String expression) {
        this.frameStartExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(this.frameStartExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.frameStartType = WindowFramePositionType.BOUNDED_PRECEDING;
        return this;
    }

    public WindowFrameExclusionBuilder<T> currentRow() {
        this.frameStartType = WindowFramePositionType.CURRENT_ROW;
        return this;
    }

    public WindowFrameExclusionBuilder<T> andUnboundedFollowing() {
        this.frameEndType = WindowFramePositionType.UNBOUNDED_FOLLOWING;
        return this;
    }

    public WindowFrameExclusionBuilder<T> andPreceding(String expression) {
        this.frameEndExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(this.frameEndExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.frameEndType = WindowFramePositionType.BOUNDED_PRECEDING;
        return this;
    }

    public WindowFrameExclusionBuilder<T> andFollowing(String expression) {
        this.frameEndExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(this.frameEndExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
        this.frameEndType = WindowFramePositionType.BOUNDED_FOLLOWING;
        return this;
    }

    public WindowFrameExclusionBuilder<T> andCurrentRow() {
        this.frameEndType = WindowFramePositionType.CURRENT_ROW;
        return this;
    }

    public T excludeNoOthers() {
        return this.end();
    }

    public T excludeCurrentRow() {
        this.frameExclusionType = WindowFrameExclusionType.EXCLUDE_CURRENT_ROW;
        return this.end();
    }

    public T excludeGroup() {
        this.frameExclusionType = WindowFrameExclusionType.EXCLUDE_GROUP;
        return this.end();
    }

    public T excludeTies() {
        this.frameExclusionType = WindowFrameExclusionType.EXCLUDE_TIES;
        return this.end();
    }

    public T end() {
        WindowFrameMode frameMode = this.frameMode;
        WindowFramePositionType frameStartType = this.frameStartType;
        WindowFramePositionType frameEndType = this.frameEndType;
        if (frameMode == WindowFrameMode.RANGE && this.frameEndExpression == null && frameEndType == WindowFramePositionType.CURRENT_ROW) {
            frameEndType = null;
        }
        if (frameMode == WindowFrameMode.RANGE && frameEndType == null && this.frameStartExpression == null && frameStartType == WindowFramePositionType.UNBOUNDED_PRECEDING) {
            frameStartType = null;
        }
        if (frameMode == WindowFrameMode.RANGE && frameStartType == null && frameEndType == null) {
            frameMode = null;
        }
        this.windowManager.onBuilderEnded(this.name, new WindowDefinition(this.baseWindowName, this.partitionExpressions, this.orderByExpressions, (Predicate)this.rootPredicate.getPredicate(), frameMode, frameStartType, this.frameStartExpression, frameEndType, this.frameEndExpression, this.frameExclusionType));
        return this.result;
    }

    @Override
    public RestrictionBuilder<WindowBuilderImpl<T>> where(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return this.restrict(this, expr);
    }

    @Override
    public CaseWhenStarterBuilder<RestrictionBuilder<WindowBuilderImpl<T>>> whereCase() {
        return this.restrictCase(this);
    }

    @Override
    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<WindowBuilderImpl<T>>> whereSimpleCase(String expression) {
        return this.restrictSimpleCase(this, this.expressionFactory.createSimpleExpression(expression, false));
    }

    @Override
    public WhereOrBuilder<WindowBuilderImpl<T>> whereOr() {
        return this.rootPredicate.startBuilder(new WhereOrBuilderImpl<WindowBuilderImpl>(this, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    @Override
    public SubqueryInitiator<WindowBuilderImpl<T>> whereExists() {
        return this.restrictExists(this);
    }

    @Override
    public SubqueryInitiator<WindowBuilderImpl<T>> whereNotExists() {
        return this.restrictNotExists(this);
    }

    @Override
    public SubqueryBuilder<WindowBuilderImpl<T>> whereExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrictExists(this, criteriaBuilder);
    }

    @Override
    public SubqueryBuilder<WindowBuilderImpl<T>> whereNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrictNotExists(this, criteriaBuilder);
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<WindowBuilderImpl<T>>> whereSubquery() {
        return this.restrict(this);
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<WindowBuilderImpl<T>>> whereSubquery(String subqueryAlias, String expression) {
        return this.restrict(this, subqueryAlias, expression);
    }

    @Override
    public MultipleSubqueryInitiator<RestrictionBuilder<WindowBuilderImpl<T>>> whereSubqueries(String expression) {
        return this.restrictSubqueries(this, expression);
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<WindowBuilderImpl<T>>> whereSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrict(this, criteriaBuilder);
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<WindowBuilderImpl<T>>> whereSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrict(this, subqueryAlias, expression, criteriaBuilder);
    }

    @Override
    public WindowBuilderImpl<T> whereExpression(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        this.restrictExpression(predicate);
        return this;
    }

    @Override
    public MultipleSubqueryInitiator<WindowBuilderImpl<T>> whereExpressionSubqueries(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, true);
        return this.restrictExpressionSubqueries(this, predicate);
    }

    @Override
    public WindowBuilderImpl<T> setWhereExpression(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        this.restrictSetExpression(predicate);
        return this;
    }

    @Override
    public MultipleSubqueryInitiator<WindowBuilderImpl<T>> setWhereExpressionSubqueries(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, true);
        return this.restrictSetExpressionSubqueries(this, predicate, null);
    }

    @Override
    public PredicateBuilder where() {
        return this;
    }
}

