/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.jsonset;

import com.blazebit.persistence.impl.function.concat.ConcatFunction;
import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractJsonFunction
implements JpqlFunction {
    private static final String PARAMETER_PLACEHOLDER = "??";
    private final ConcatFunction concatFunction;

    protected AbstractJsonFunction(ConcatFunction concatFunction) {
        this.concatFunction = concatFunction;
    }

    protected static boolean isJsonPathTemplate(String argument) {
        return argument.startsWith("$");
    }

    protected static String toJsonPathTemplate(List<Object> pathElements, int to, boolean quotePathElements) {
        Object firstArgument = pathElements.get(0);
        if (firstArgument instanceof String && AbstractJsonFunction.isJsonPathTemplate((String)firstArgument)) {
            return (String)firstArgument;
        }
        StringBuilder jsonPathBuilder = new StringBuilder("$");
        for (int i = 0; i < to; ++i) {
            Object currentPathElement = pathElements.get(i);
            if (currentPathElement instanceof Integer) {
                jsonPathBuilder.append('[');
                jsonPathBuilder.append((Integer)currentPathElement);
                jsonPathBuilder.append(']');
                continue;
            }
            jsonPathBuilder.append('.');
            if (quotePathElements) {
                jsonPathBuilder.append("\"");
            }
            jsonPathBuilder.append((String)currentPathElement);
            if (!quotePathElements) continue;
            jsonPathBuilder.append("\"");
        }
        return jsonPathBuilder.toString();
    }

    protected void renderJsonPathTemplate(FunctionRenderContext context, String jsonPathTemplate, int templateParameterOffset) {
        List<String> concatenationParts = AbstractJsonFunction.splitByParameterPlaceholder(jsonPathTemplate);
        if (concatenationParts.size() == 1) {
            context.addChunk(JpqlFunctionUtil.quoteSingle(jsonPathTemplate));
        } else {
            context.addChunk(this.concatFunction.startConcat());
            context.addChunk(JpqlFunctionUtil.quoteSingle(concatenationParts.get(0)));
            for (int i = 1; i < concatenationParts.size(); ++i) {
                context.addChunk(this.concatFunction.concatSeparator());
                this.renderJsonPathTemplateParameter(context, templateParameterOffset++);
                context.addChunk(this.concatFunction.concatSeparator());
                context.addChunk(JpqlFunctionUtil.quoteSingle(concatenationParts.get(i)));
            }
            context.addChunk(this.concatFunction.endConcat());
        }
    }

    protected void renderJsonPathTemplateParameter(FunctionRenderContext context, int parameterIdx) {
        context.addArgument(parameterIdx);
    }

    private static List<String> splitByParameterPlaceholder(String str) {
        int currentIdx;
        ArrayList<String> parts = new ArrayList<String>();
        int previousIdx = 0;
        while ((currentIdx = str.indexOf(PARAMETER_PLACEHOLDER, previousIdx)) != -1) {
            parts.add(str.substring(previousIdx, currentIdx));
            previousIdx = currentIdx + PARAMETER_PLACEHOLDER.length();
        }
        parts.add(str.substring(previousIdx));
        return parts;
    }

    protected static List<Object> retrieveJsonPathElements(FunctionRenderContext context, int pathStartOffset) {
        String firstArgument = context.getArgument(pathStartOffset);
        if (AbstractJsonFunction.isJsonPathTemplate(JpqlFunctionUtil.unquoteSingleQuotes(firstArgument))) {
            return Collections.singletonList(JpqlFunctionUtil.unquoteDoubleQuotes(JpqlFunctionUtil.unquoteSingleQuotes(firstArgument)));
        }
        ArrayList<Object> jsonPathElements = new ArrayList<Object>(context.getArgumentsSize() - pathStartOffset);
        for (int i = pathStartOffset; i < context.getArgumentsSize(); ++i) {
            try {
                jsonPathElements.add(Integer.parseInt(JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(i))));
                continue;
            }
            catch (NumberFormatException e) {
                jsonPathElements.add(JpqlFunctionUtil.unquoteDoubleQuotes(JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(i))));
            }
        }
        return jsonPathElements;
    }
}

