/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Blazebit
 */

package com.blazebit.persistence.impl.function.literal;

/**
 *
 * @author Christian Beikov
 * @since 1.6.0
 */
public class LiteralOffsetDateTimeFunction extends LiteralFunction {

    public static final String FUNCTION_NAME = "LITERAL_OFFSETDATETIME";
    private static final Class<?> CLAZZ = loadClass("java.time.OffsetDateTime");

    @Override
    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return CLAZZ;
    }

    @Override
    protected String getFunctionName() {
        return FUNCTION_NAME;
    }

}
