/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;

public class ClauseAndJoinAwareVisitor
extends VisitorAdapter {
    protected ClauseType fromClause;
    protected boolean joinRequired = true;

    public void visit(ClauseType clauseType, Expression expression) {
        this.fromClause = clauseType;
        try {
            expression.accept((Expression.Visitor)this);
        }
        finally {
            this.fromClause = null;
        }
    }

    public void visit(EqPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        super.visit(predicate);
        this.joinRequired = original;
    }

    public void visit(InPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        super.visit(predicate);
        this.joinRequired = original;
    }

    public void visit(MemberOfPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        super.visit(predicate);
        this.joinRequired = original;
    }

    public void visit(IsEmptyPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        super.visit(predicate);
        this.joinRequired = original;
    }

    public void visit(IsNullPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        super.visit(predicate);
        this.joinRequired = original;
    }
}

