/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseUpdateCriteriaBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseUpdateCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionUpdateModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractUpdateCollectionCriteriaBuilder<T, X extends BaseUpdateCriteriaBuilder<T, X>, Y>
extends BaseUpdateCriteriaBuilderImpl<T, X, Y> {
    private final String collectionName;
    private final String keyFunctionExpression;
    private final Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries;
    private final Map<String, String> collectionColumnBindingMap;
    private final Type<?> elementType;
    private final ExtendedAttribute<?, ?> collectionAttribute;

    public AbstractUpdateCollectionCriteriaBuilder(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, String alias, CTEManager.CTEKey cteName, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, queryContext, isMainQuery, clazz, alias, cteName, cteClass, result, listener);
        this.collectionName = collectionName;
        ExtendedManagedType extendedManagedType = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType);
        this.collectionAttribute = extendedManagedType.getAttribute(collectionName);
        JoinNode join = this.joinManager.join(this.entityAlias + "." + collectionName, "_collection", JoinType.LEFT, false, true, null);
        join.setDeReferenceFunction(mainQuery.jpaProvider.getCustomFunctionInvocation("collection_dml_support", 1));
        join.getParent().setDeReferenceFunction(mainQuery.jpaProvider.getCustomFunctionInvocation("collection_dml_support", 1));
        if (mainQuery.dbmsDialect.getUpdateJoinStyle() == UpdateJoinStyle.NONE) {
            join.setDisallowedDeReferenceAlias(this.aliasManager.generateRootAlias(join.getAlias()));
            join.getParent().setDisallowedDeReferenceAlias(this.aliasManager.generateRootAlias(join.getParent().getAlias()));
        }
        this.elementType = join.getType();
        if (this.collectionAttribute.getJoinTable() == null && "".equals(this.collectionAttribute.getMappedBy())) {
            throw new IllegalArgumentException("Cannot update the collection attribute '" + collectionName + "' of entity class '" + clazz.getName() + "' because it doesn't have a join table or a mapped by attribute!");
        }
        if (this.collectionAttribute.getMappedBy() != null) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail(null);
            rootNode.getAliasInfo().setAlias("_collection." + this.collectionAttribute.getMappedBy());
        } else {
            JoinTable joinTable = this.collectionAttribute.getJoinTable();
            Set idAttributeNames = joinTable.getIdAttributeNames();
            HashSet<String> ownerAttributes = new HashSet<String>(idAttributeNames.size());
            for (String idAttributeName : idAttributeNames) {
                ownerAttributes.add(idAttributeName);
                int dotIdx = -1;
                while ((dotIdx = idAttributeName.indexOf(46, dotIdx + 1)) != -1) {
                    ownerAttributes.add(idAttributeName.substring(0, dotIdx));
                }
            }
            join.getParent().setAllowedDeReferences(ownerAttributes);
            HashSet<String> elementAttributes = new HashSet<String>();
            if (((PluralAttribute)this.collectionAttribute.getAttribute()).getElementType() instanceof ManagedType) {
                String prefix = this.collectionAttribute.getAttributePathString() + ".";
                for (Map.Entry entry : extendedManagedType.getAttributes().entrySet()) {
                    if (!((String)entry.getKey()).startsWith(prefix)) continue;
                    elementAttributes.add(((String)entry.getKey()).substring(prefix.length()));
                }
            }
            join.setAllowedDeReferences(elementAttributes);
        }
        Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries = JpaUtils.getCollectionAttributeEntries(mainQuery.metamodel, this.entityType, this.collectionAttribute);
        this.keyFunctionExpression = this.collectionAttribute.getAttribute() instanceof MapAttribute ? "key(" + collectionName + ")" : (this.collectionAttribute.getAttribute() instanceof ListAttribute && !mainQuery.jpaProvider.isBag(this.entityType, collectionName) ? "index(" + collectionName + ")" : null);
        this.collectionColumnBindingMap = new LinkedHashMap<String, String>(collectionAttributeEntries.size());
        this.collectionAttributeEntries = collectionAttributeEntries;
    }

    public AbstractUpdateCollectionCriteriaBuilder(AbstractUpdateCollectionCriteriaBuilder<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.collectionName = builder.collectionName;
        this.keyFunctionExpression = builder.keyFunctionExpression;
        this.collectionColumnBindingMap = builder.collectionColumnBindingMap;
        this.collectionAttributeEntries = builder.collectionAttributeEntries;
        this.collectionAttribute = builder.collectionAttribute;
        this.elementType = builder.elementType;
    }

    @Override
    protected void addAttribute(String attributeName) {
        if (attributeName.equalsIgnoreCase(this.keyFunctionExpression)) {
            Integer attributeBindIndex = (Integer)this.setAttributeBindingMap.get(attributeName);
            if (attributeBindIndex != null) {
                throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
            }
            this.setAttributeBindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
            return;
        }
        ExtendedAttribute<?, ?> attributeEntry = this.collectionAttributeEntries.get(attributeName);
        if (attributeEntry == null) {
            TreeSet<String> set = new TreeSet<String>(this.collectionAttributeEntries.keySet());
            if (this.keyFunctionExpression != null) {
                set.add(this.keyFunctionExpression);
            }
            throw new IllegalArgumentException("The attribute [" + attributeName + "] does not exist or can't be bound! Allowed attributes are: " + set);
        }
        Integer attributeBindIndex = (Integer)this.setAttributeBindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.setAttributeBindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode, boolean countWrapped) {
        block16: {
            boolean hasOtherJoinNodes;
            JoinNode rootNode = this.joinManager.getRoots().get(0);
            JoinTreeNode collectionTreeNode = (JoinTreeNode)rootNode.getNodes().get(this.collectionName);
            boolean bl = hasOtherJoinNodes = this.joinManager.getRoots().size() > 1 || rootNode.getNodes().size() > 1 || !rootNode.getTreatedJoinNodes().isEmpty() || !rootNode.getEntityJoinNodes().isEmpty() || collectionTreeNode.getJoinNodes().size() > 1 || collectionTreeNode.getDefaultNode().hasChildNodes();
            if (externalRepresentation) {
                sbSelectFrom.append("UPDATE ");
                sbSelectFrom.append(this.entityType.getName());
                sbSelectFrom.append('(').append(this.collectionName).append(") ");
                sbSelectFrom.append(this.entityAlias);
                if (this.collectionAttribute.getJoinTable() == null) {
                    rootNode.getAliasInfo().setAlias(this.entityAlias);
                }
                collectionTreeNode.getDefaultNode().getAliasInfo().setAlias(this.entityAlias + "." + this.collectionName);
                this.appendSetClause(sbSelectFrom, externalRepresentation);
                if (hasOtherJoinNodes) {
                    ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                    ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                    this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), rootNode, true);
                }
                this.appendWhereClause(sbSelectFrom, externalRepresentation);
                if (this.collectionAttribute.getJoinTable() == null) {
                    rootNode.getAliasInfo().setAlias("_collection." + this.collectionAttribute.getMappedBy());
                }
                collectionTreeNode.getDefaultNode().getAliasInfo().setAlias("_collection");
            } else if (this.collectionAttribute.getJoinTable() == null) {
                sbSelectFrom.append("UPDATE ");
                sbSelectFrom.append(((EntityType)this.elementType).getName());
                sbSelectFrom.append(' ');
                sbSelectFrom.append("_collection");
                this.appendSetClause(sbSelectFrom, externalRepresentation);
                this.appendWhereClause(sbSelectFrom, externalRepresentation);
            } else {
                boolean originalExternalRepresentation = this.queryGenerator.isExternalRepresentation();
                this.queryGenerator.setExternalRepresentation(externalRepresentation);
                try {
                    if (this.mainQuery.dbmsDialect.getUpdateJoinStyle() == UpdateJoinStyle.NONE) {
                        StringBuilder tempSb = new StringBuilder();
                        this.appendWhereClause(tempSb, Collections.emptyList(), Collections.emptyList(), null);
                        if (hasOtherJoinNodes || rootNode.needsDisallowedDeReferenceAlias(externalRepresentation) || collectionTreeNode.getDefaultNode().needsDisallowedDeReferenceAlias(externalRepresentation)) {
                            throw new IllegalStateException("The DBMS does not support joins in UPDATE statements!");
                        }
                        this.appendSelectClause(sbSelectFrom, externalRepresentation);
                        sbSelectFrom.append(" FROM ");
                        sbSelectFrom.append(this.entityType.getName());
                        sbSelectFrom.append(' ');
                        sbSelectFrom.append(this.entityAlias);
                        sbSelectFrom.append(" LEFT JOIN ");
                        sbSelectFrom.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
                        sbSelectFrom.append(" WHERE EXISTS (SELECT 1");
                        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                        ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                        this.joinManager.buildClause(sbSelectFrom, Collections.emptySet(), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), rootNode, true);
                        sbSelectFrom.append((CharSequence)tempSb);
                        for (String whereClauseConjunct : whereClauseConjuncts) {
                            sbSelectFrom.append(" AND ").append(whereClauseConjunct);
                        }
                        sbSelectFrom.append(')');
                        break block16;
                    }
                    String rootNodeDeReferenceFunction = rootNode.getDeReferenceFunction();
                    String collectionNodeDeReferenceFunction = collectionTreeNode.getDefaultNode().getDeReferenceFunction();
                    try {
                        rootNode.setDeReferenceFunction(null);
                        collectionTreeNode.getDefaultNode().setDeReferenceFunction(null);
                        sbSelectFrom.append("SELECT ");
                        this.appendSetElementsAsCaseExpressions(sbSelectFrom);
                        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
                        ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
                        this.joinManager.buildClause(sbSelectFrom, EnumSet.noneOf(ClauseType.class), null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), null, true);
                        this.appendWhereClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts, lateralJoinNode);
                    }
                    finally {
                        rootNode.setDeReferenceFunction(rootNodeDeReferenceFunction);
                        collectionTreeNode.getDefaultNode().setDeReferenceFunction(collectionNodeDeReferenceFunction);
                    }
                }
                finally {
                    this.queryGenerator.setExternalRepresentation(originalExternalRepresentation);
                }
            }
        }
    }

    @Override
    protected void appendSetElementAsSelectItem(StringBuilder sbSelectFrom, String attribute) {
        int collectionIndex = attribute.indexOf(this.collectionName);
        if (collectionIndex == -1) {
            sbSelectFrom.append(this.entityAlias).append('.').append(attribute);
        } else {
            sbSelectFrom.append(attribute, 0, collectionIndex);
            sbSelectFrom.append("_collection");
            sbSelectFrom.append(attribute, collectionIndex + this.collectionName.length(), attribute.length());
        }
    }

    @Override
    protected boolean appendSetElementEntityPrefix(String trimmedPath) {
        return !trimmedPath.startsWith("_collection") && super.appendSetElementEntityPrefix(trimmedPath);
    }

    @Override
    protected void prepareAndCheck(JoinVisitor parentVisitor) {
        if (!this.needsCheck) {
            return;
        }
        boolean enableElementCollectionIdCutoff = this.collectionAttribute.getJoinTable() != null && !this.mainQuery.jpaProvider.needsAssociationToIdRewriteInOnClause();
        JpaUtils.expandBindings(this.setAttributeBindingMap, this.collectionColumnBindingMap, this.collectionAttributeEntries, ClauseType.SET, this, this.keyFunctionExpression, enableElementCollectionIdCutoff);
        super.prepareAndCheck(parentVisitor);
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getQuery(includedModificationStates);
        }
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, objectBuilder);
        }
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        String sourceExpression;
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases(baseQuery, keyRestrictedLeftJoins, Collections.emptySet());
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(baseQuery, 0);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        String sql = extendedQuerySupport.getSql(this.em, baseQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, this.entityAlias, 0);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, "_collection", 0);
        JoinTable joinTable = this.collectionAttribute.getJoinTable();
        int joinTableIndex = SqlUtils.indexOfTableName(sql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(sql, joinTableIndex + joinTable.getTableName().length());
        String tableToUpdate = joinTable.getTableName();
        Object tablePrefix = this.mainQuery.dbmsDialect.getUpdateJoinStyle() == UpdateJoinStyle.FROM_ALIAS ? collectionAlias : (this.mainQuery.dbmsDialect.getUpdateJoinStyle() == UpdateJoinStyle.FROM ? null : tableToUpdate);
        List<String> setColumns = this.getSetColumns();
        HashMap<String, String> columnExpressionRemappings = new HashMap<String, String>();
        ArrayList<Object> joinTableIdColumns = new ArrayList<Object>();
        String[] discriminatorColumnCheck = this.mainQuery.jpaProvider.getDiscriminatorColumnCheck(this.entityType);
        String discriminatorPredicate = "";
        if (discriminatorColumnCheck != null) {
            discriminatorPredicate = ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1] + " and";
            columnExpressionRemappings.put(ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1], "1=1");
        }
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                joinTableIdColumns.add(entry.getKey());
                sourceExpression = "collection_dml_support(" + collectionAlias + "." + (String)entry.getValue() + ")";
                if (tablePrefix == null) {
                    columnExpressionRemappings.put(sourceExpression, collectionAlias + "." + (String)entry.getValue());
                    continue;
                }
                columnExpressionRemappings.put(sourceExpression, (String)tablePrefix + "." + (String)entry.getKey());
            }
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            joinTableIdColumns.add(entry.getKey());
            sourceExpression = "collection_dml_support(" + ownerAlias + "." + (String)entry.getValue() + ")";
            if (tablePrefix == null) {
                columnExpressionRemappings.put(sourceExpression, ownerAlias + "." + (String)entry.getValue());
                continue;
            }
            columnExpressionRemappings.put(sourceExpression, (String)tablePrefix + "." + (String)entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            sourceExpression = "collection_dml_support(" + targetAlias + "." + (String)entry.getValue() + ")";
            if (tablePrefix == null) {
                columnExpressionRemappings.put(sourceExpression, targetAlias + "." + (String)entry.getValue());
            } else {
                columnExpressionRemappings.put(sourceExpression, (String)tablePrefix + "." + (String)entry.getKey());
            }
            if (tablePrefix == null) {
                columnExpressionRemappings.put("collection_dml_support(" + targetAlias + "." + (String)entry.getValue() + ")", targetAlias + "." + (String)entry.getValue());
                continue;
            }
            columnExpressionRemappings.put("collection_dml_support(" + targetAlias + "." + (String)entry.getKey() + ")", (String)tablePrefix + "." + (String)entry.getKey());
        }
        Set idAttributes = JpaMetamodelUtils.getIdAttributes((IdentifiableType)this.entityType);
        if (idAttributes.size() == 1 && ((SingularAttribute)idAttributes.iterator().next()).getType() instanceof ManagedType) {
            StringBuilder leftSb = new StringBuilder();
            StringBuilder rightSb = new StringBuilder();
            leftSb.append("collection_dml_support").append("((");
            rightSb.append("(");
            for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
                leftSb.append(ownerAlias).append('.').append((String)entry.getValue()).append(", ");
                if (tablePrefix == null) {
                    rightSb.append(ownerAlias).append('.').append((String)entry.getValue()).append(',');
                    continue;
                }
                rightSb.append((String)tablePrefix).append('.').append((String)entry.getKey()).append(',');
            }
            leftSb.setLength(leftSb.length() - 2);
            leftSb.append("))");
            rightSb.setCharAt(rightSb.length() - 1, ')');
            columnExpressionRemappings.put(leftSb.toString(), rightSb.toString());
        }
        TreeMap<String, String> aliasMapping = new TreeMap<String, String>();
        if (this.mainQuery.dbmsDialect.getPhysicalRowId() != null) {
            joinTableIdColumns.clear();
            joinTableIdColumns.add(this.mainQuery.dbmsDialect.getPhysicalRowId());
        }
        for (String string : joinTableIdColumns) {
            aliasMapping.put(collectionAlias + "." + string, "tmp.c" + aliasMapping.size());
        }
        SqlUtils.buildAliasMappingForTopLevelSelects(extendedQuerySupport.getSql(this.em, baseQuery), "tmp", aliasMapping);
        return new CollectionUpdateModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameterImpls(), parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, this.returningAttributeBindingMap, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), tableToUpdate, collectionAlias, joinTableIdColumns.toArray(new String[0]), setColumns, this.getForeignKeyParticipatingQueries(), aliasMapping, this.getUpdateExampleQuery(), columnExpressionRemappings);
    }

    @Override
    protected List<String> getSetColumns() {
        ArrayList<String> setColumns = new ArrayList<String>(this.setAttributeBindingMap.size());
        for (String attribute : this.setAttributeBindingMap.keySet()) {
            if (attribute.equalsIgnoreCase(this.keyFunctionExpression)) {
                setColumns.addAll(this.collectionAttribute.getJoinTable().getKeyColumnMappings().keySet());
                continue;
            }
            Collections.addAll(setColumns, this.collectionAttributeEntries.get(attribute).getColumnNames());
        }
        return setColumns;
    }

    @Override
    protected Collection<Query> getForeignKeyParticipatingQueries() {
        HashMap<String, Query> map = null;
        block0: for (String attributeName : this.setAttributeBindingMap.keySet()) {
            ExtendedAttribute<?, ?> attribute = this.collectionAttributeEntries.get(attributeName);
            if (attribute == null) continue;
            for (Attribute attributePart : attribute.getAttributePath()) {
                if (!(attributePart instanceof SingularAttribute)) continue;
                SingularAttribute singularAttribute = (SingularAttribute)attributePart;
                if (map == null) {
                    map = new HashMap<String, Query>();
                }
                if (!(singularAttribute.getType() instanceof EntityType)) continue;
                String entityName = ((EntityType)singularAttribute.getType()).getName();
                if (map.containsKey(entityName)) continue block0;
                map.put(entityName, this.em.createQuery("select e from " + entityName + " e"));
                continue block0;
            }
        }
        return map == null ? Collections.emptyList() : map.values();
    }
}

