/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiFirstPatternFinder;
import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiLastPatternFinder;
import com.blazebit.persistence.impl.util.PatternFinder;
import com.blazebit.persistence.impl.util.QuoteMode;
import com.blazebit.persistence.impl.util.QuotedIdentifierAwarePatternFinder;
import com.blazebit.persistence.parser.SQLParser;
import com.blazebit.persistence.parser.SQLParserBaseVisitor;
import com.blazebit.persistence.parser.SqlParserUtils;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlUtils {
    public static final String SELECT = "select ";
    public static final String UPDATE = "update ";
    public static final String SET = " set ";
    public static final String FROM = " from ";
    public static final String JOIN = " join ";
    public static final String ON = " on ";
    public static final String WITH = "with ";
    public static final String WHERE = " where ";
    public static final String GROUP_BY = " group by ";
    public static final String HAVING = " having ";
    public static final String ORDER_BY = " order by ";
    public static final String LIMIT = " limit ";
    public static final String FETCH_FIRST = " fetch first ";
    public static final String AS = " as ";
    public static final String FROM_FINAL_TABLE = " from final table (";
    public static final String NEXT_VALUE_FOR = "next value for ";
    public static final String INTO = "into ";
    public static final PatternFinder SELECT_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("select "));
    public static final PatternFinder UPDATE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("update "));
    public static final PatternFinder SET_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" set "));
    public static final PatternFinder FROM_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from "));
    public static final PatternFinder JOIN_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" join "));
    public static final PatternFinder ON_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" on "));
    public static final PatternFinder WITH_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("with "));
    public static final PatternFinder WHERE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" where "));
    public static final PatternFinder GROUP_BY_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" group by "));
    public static final PatternFinder HAVING_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" having "));
    public static final PatternFinder ORDER_BY_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" order by "));
    public static final PatternFinder LIMIT_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" limit "));
    public static final PatternFinder FETCH_FIRST_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" fetch first "));
    public static final PatternFinder AS_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiLastPatternFinder(" as "));
    public static final PatternFinder FROM_FINAL_TABLE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from final table ("));
    public static final PatternFinder NEXT_VALUE_FOR_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("next value for "));
    public static final PatternFinder INTO_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("into "));
    private static final SelectItemExtractor ALIAS_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractAlias(sb);
        }
    };
    private static final SelectItemExtractor EXPRESSION_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractExpression(sb);
        }
    };
    private static final SelectItemExtractor COLUMN_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractColumn(sb);
        }
    };

    private SqlUtils() {
    }

    public static void applyTableNameRemapping(StringBuilder sb, ExtendedQuerySupport.SqlFromInfo sqlFromInfo, String newCteName, String aliasExtension, String newSqlAlias, boolean useApply) {
        String sqlAlias = sqlFromInfo.getAlias();
        String searchAs = " as";
        String searchAlias = " " + sqlAlias;
        int searchIndex = 0;
        while ((searchIndex = sb.indexOf(searchAlias, searchIndex)) > -1) {
            int idx = searchIndex + searchAlias.length();
            if ((idx >= sb.length() || sb.charAt(idx) != '.') && SqlUtils.isInMainQuery(sb, searchIndex)) {
                int[] tableNameIndexRange = " as".equalsIgnoreCase(sb.substring(searchIndex - " as".length(), searchIndex)) ? SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex - " as".length()) : SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex);
                if (sb.charAt(tableNameIndexRange[1] - 1) == ')') {
                    int parenthesis = 1;
                    QuoteMode mode = QuoteMode.NONE;
                    for (int i = tableNameIndexRange[1] - 2; i >= 0; --i) {
                        char c = sb.charAt(i);
                        if ((mode = mode.onCharBackwards(c)) != QuoteMode.NONE) continue;
                        if (c == '(') {
                            if (--parenthesis != 0) continue;
                            tableNameIndexRange[0] = i;
                            break;
                        }
                        if (c != ')') continue;
                        ++parenthesis;
                    }
                }
                if (newSqlAlias != null) {
                    sb.replace(tableNameIndexRange[1] + 1, tableNameIndexRange[1] + 1 + sqlAlias.length(), newSqlAlias);
                    searchIndex += newSqlAlias.length() - sqlAlias.length();
                    sqlAlias = newSqlAlias;
                }
                int oldTableNameLength = tableNameIndexRange[1] - tableNameIndexRange[0];
                if (useApply) {
                    int whereIndex = SqlUtils.indexOfWhere(sb, tableNameIndexRange[1]);
                    if (whereIndex == -1) {
                        whereIndex = sb.length();
                    }
                    int[] indexRange = SqlUtils.indexOfFullJoin(sb, sqlAlias, tableNameIndexRange[1] + 1, whereIndex);
                    oldTableNameLength += tableNameIndexRange[0] - indexRange[0];
                    sb.replace(indexRange[0], indexRange[1], newCteName + sb.substring(tableNameIndexRange[1], tableNameIndexRange[1] + searchAlias.length()));
                } else {
                    sb.replace(tableNameIndexRange[0], tableNameIndexRange[1], newCteName);
                }
                if (aliasExtension != null) {
                    sb.insert(searchIndex + searchAlias.length() + (newCteName.length() - oldTableNameLength), aliasExtension);
                    searchIndex += aliasExtension.length();
                }
                searchIndex += newCteName.length() - oldTableNameLength;
            }
            ++searchIndex;
        }
    }

    public static void applyTableNameRemapping(StringBuilder sb, String sqlAlias, String newCteName, String aliasExtension, String newSqlAlias, boolean useApply) {
        String searchAs = " as";
        String searchAlias = " " + sqlAlias;
        int searchIndex = 0;
        while ((searchIndex = sb.indexOf(searchAlias, searchIndex)) > -1) {
            int idx = searchIndex + searchAlias.length();
            if ((idx >= sb.length() || sb.charAt(idx) != '.') && SqlUtils.isInMainQuery(sb, searchIndex)) {
                int[] tableNameIndexRange = " as".equalsIgnoreCase(sb.substring(searchIndex - " as".length(), searchIndex)) ? SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex - " as".length()) : SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex);
                if (sb.charAt(tableNameIndexRange[0]) == ')') {
                    int parenthesis = 1;
                    QuoteMode mode = QuoteMode.NONE;
                    for (int i = tableNameIndexRange[0] - 1; i >= 0; --i) {
                        char c = sb.charAt(i);
                        if ((mode = mode.onCharBackwards(c)) != QuoteMode.NONE) continue;
                        if (c == '(') {
                            if (--parenthesis != 0) continue;
                            tableNameIndexRange[0] = i;
                            break;
                        }
                        if (c != ')') continue;
                        ++parenthesis;
                    }
                }
                if (newSqlAlias != null) {
                    sb.replace(tableNameIndexRange[1] + 1, tableNameIndexRange[1] + 1 + sqlAlias.length(), newSqlAlias);
                    searchIndex += newSqlAlias.length() - sqlAlias.length();
                    sqlAlias = newSqlAlias;
                }
                int oldTableNameLength = tableNameIndexRange[1] - tableNameIndexRange[0];
                if (useApply) {
                    int whereIndex = SqlUtils.indexOfWhere(sb, tableNameIndexRange[1]);
                    if (whereIndex == -1) {
                        whereIndex = sb.length();
                    }
                    int[] indexRange = SqlUtils.indexOfFullJoin(sb, sqlAlias, tableNameIndexRange[1] + 1, whereIndex);
                    oldTableNameLength += tableNameIndexRange[0] - indexRange[0];
                    sb.replace(indexRange[0], indexRange[1], newCteName + sb.substring(tableNameIndexRange[1], tableNameIndexRange[1] + searchAlias.length()));
                } else {
                    sb.replace(tableNameIndexRange[0], tableNameIndexRange[1], newCteName);
                }
                if (aliasExtension != null) {
                    sb.insert(searchIndex + searchAlias.length() + (newCteName.length() - oldTableNameLength), aliasExtension);
                    searchIndex += aliasExtension.length();
                }
                searchIndex += newCteName.length() - oldTableNameLength;
            }
            ++searchIndex;
        }
    }

    public static void remapColumnExpressions(StringBuilder sqlSb, Map<String, String> columnExpressionRemappings) {
        SqlUtils.remapColumnExpressions(sqlSb, columnExpressionRemappings, 0, sqlSb.length());
    }

    public static int remapColumnExpressions(StringBuilder sqlSb, Map<String, String> columnExpressionRemappings, int startIndex, int endIndex) {
        for (Map.Entry<String, String> entry : columnExpressionRemappings.entrySet()) {
            String targetExpression;
            String sourceExpression = entry.getKey();
            if (sourceExpression.equals(targetExpression = entry.getValue())) continue;
            int index = startIndex;
            while ((index = sqlSb.indexOf(sourceExpression, index)) != -1 && index < endIndex) {
                if (index != 0 && Character.isJavaIdentifierPart(sqlSb.charAt(index - 1))) {
                    ++index;
                    continue;
                }
                int sourceEndIndex = index + sourceExpression.length();
                if (sourceEndIndex < endIndex && Character.isJavaIdentifierPart(sqlSb.charAt(sourceEndIndex))) {
                    ++index;
                    continue;
                }
                sqlSb.replace(index, sourceEndIndex, targetExpression);
                int delta = targetExpression.length() - sourceExpression.length();
                index += delta;
                endIndex += delta;
            }
        }
        return endIndex;
    }

    private static boolean isInMainQuery(StringBuilder sb, int tableNameIndex) {
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        for (int i = 0; i < tableNameIndex; ++i) {
            char c = sb.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                ++parenthesis;
                continue;
            }
            if (c != ')') continue;
            --parenthesis;
        }
        return parenthesis == 0;
    }

    public static int[] rtrimBackwardsToFirstWhitespace(CharSequence sb, int startIndex) {
        int tableNameStartIndex;
        int tableNameEndIndex = startIndex;
        boolean text = false;
        for (tableNameStartIndex = tableNameEndIndex; tableNameStartIndex >= 0; --tableNameStartIndex) {
            if (text) {
                char c = sb.charAt(tableNameStartIndex);
                if (!Character.isWhitespace(c) && c != ',') continue;
                break;
            }
            if (Character.isWhitespace(sb.charAt(tableNameStartIndex))) {
                --tableNameEndIndex;
                continue;
            }
            text = true;
            ++tableNameEndIndex;
        }
        return new int[]{++tableNameStartIndex, tableNameEndIndex};
    }

    public static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static String[] getSelectItemAliases(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, ALIAS_EXTRACTOR);
    }

    public static String[] getSelectItemExpressions(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, EXPRESSION_EXTRACTOR);
    }

    public static String[] getSelectItemColumns(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, COLUMN_EXTRACTOR);
    }

    public static String[] getSelectItems(CharSequence sql, int start, SelectItemExtractor extractor) {
        int selectIndex = SELECT_FINDER.indexIn(sql, start);
        int fromIndex = SqlUtils.indexOfFrom(sql, selectIndex);
        if (fromIndex == -1) {
            fromIndex = sql.length();
        }
        List<String> selectItems = SqlUtils.getExpressionItems(sql, selectIndex + SELECT.length(), fromIndex, extractor);
        return selectItems.toArray(new String[selectItems.size()]);
    }

    public static List<String> getExpressionItems(CharSequence sql) {
        return SqlUtils.getExpressionItems(sql, 0, sql.length(), EXPRESSION_EXTRACTOR);
    }

    public static List<String> getExpressionItems(CharSequence sql, int i, int end) {
        return SqlUtils.getExpressionItems(sql, i, end, EXPRESSION_EXTRACTOR);
    }

    public static List<String> getExpressionItems(CharSequence sql, int i, int end, SelectItemExtractor extractor) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        while (i < end) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) == QuoteMode.NONE) {
                if (parenthesis == 0 && c == ',') {
                    selectItems.add(extractor.extract(sb, selectItems.size(), i));
                    sb.setLength(0);
                    ++i;
                    continue;
                }
                if (c == '(') {
                    ++parenthesis;
                } else if (c == ')') {
                    --parenthesis;
                }
                if (sb.length() != 0 || !Character.isWhitespace(c)) {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        String lastAlias = extractor.extract(sb, selectItems.size(), i);
        if (!lastAlias.isEmpty()) {
            selectItems.add(lastAlias);
        }
        return selectItems;
    }

    public static void buildAliasMappingForTopLevelSelects(CharSequence sql, String alias, Map<String, String> aliasMapping) {
        final HashSet definedTableAliases = new HashSet();
        final HashMap usedColumns = new HashMap();
        try {
            SqlParserUtils.visitSelectStatement((CharSequence)sql, (SQLParserBaseVisitor)new SQLParserBaseVisitor<Void>(){
                Boolean inTopLevelSelect;
                boolean inSubquery;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void visitSelect_list(SQLParser.Select_listContext ctx) {
                    Boolean select = this.inTopLevelSelect;
                    if (this.inTopLevelSelect == null) {
                        this.inTopLevelSelect = true;
                    } else if (this.inTopLevelSelect == Boolean.FALSE) {
                        return null;
                    }
                    try {
                        Void void_ = (Void)super.visitSelect_list(ctx);
                        return void_;
                    }
                    finally {
                        if (select == null) {
                            this.inTopLevelSelect = Boolean.FALSE;
                        }
                    }
                }

                public Void visitFull_column_name(SQLParser.Full_column_nameContext ctx) {
                    SQLParser.Table_nameContext tableNameContext = ctx.table_name();
                    SQLParser.IdContext idContext = ctx.id();
                    this.columnUsage(tableNameContext, idContext);
                    return (Void)super.visitFull_column_name(ctx);
                }

                public Void visitColumn_elem(SQLParser.Column_elemContext ctx) {
                    SQLParser.Table_nameContext tableNameContext = ctx.table_name();
                    SQLParser.IdContext idContext = ctx.id();
                    this.columnUsage(tableNameContext, idContext);
                    return (Void)super.visitColumn_elem(ctx);
                }

                private void columnUsage(SQLParser.Table_nameContext tableNameContext, SQLParser.IdContext idContext) {
                    if (tableNameContext == null || idContext == null || !this.inTopLevelSelect.booleanValue()) {
                        return;
                    }
                    String tableName = tableNameContext.getText();
                    HashSet<String> columns = (HashSet<String>)usedColumns.get(tableName);
                    if (columns == null) {
                        columns = new HashSet<String>();
                        usedColumns.put(tableName, columns);
                    }
                    columns.add(idContext.getText());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void visitSubquery(SQLParser.SubqueryContext ctx) {
                    boolean subquery = !this.inSubquery;
                    this.inSubquery = true;
                    try {
                        Void void_ = (Void)super.visitSubquery(ctx);
                        return void_;
                    }
                    finally {
                        if (subquery) {
                            this.inSubquery = false;
                        }
                    }
                }

                public Void visitTable_source_item(SQLParser.Table_source_itemContext ctx) {
                    SQLParser.As_table_aliasContext aliasContext;
                    if (!this.inSubquery && (aliasContext = ctx.as_table_alias()) != null) {
                        definedTableAliases.add(aliasContext.table_alias().getText());
                    }
                    return (Void)super.visitTable_source_item(ctx);
                }
            });
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Couldn't parse SQL fragment: " + sql, ex);
        }
        for (Map.Entry entry : usedColumns.entrySet()) {
            if (!definedTableAliases.contains(entry.getKey())) continue;
            for (String column : (Set)entry.getValue()) {
                if (aliasMapping.containsKey((String)entry.getKey() + "." + column)) continue;
                aliasMapping.put((String)entry.getKey() + "." + column, alias + ".c" + aliasMapping.size());
            }
        }
    }

    public static int indexOfSelect(CharSequence sql) {
        int selectIndex = SELECT_FINDER.indexIn(sql);
        int withIndex = WITH_FINDER.indexIn(sql, 0, selectIndex);
        if (withIndex == -1 && selectIndex == 0) {
            return selectIndex;
        }
        return SqlUtils.indexOf(SELECT_FINDER, sql, 0, Math.max(withIndex, 0));
    }

    public static int indexOfSet(CharSequence sql, int start) {
        return SqlUtils.indexOf(SET_FINDER, sql, start, 0);
    }

    public static int indexOfFrom(CharSequence sql) {
        return SqlUtils.indexOf(FROM_FINDER, sql, 0, 0);
    }

    public static int indexOfFrom(CharSequence sql, int start) {
        return SqlUtils.indexOf(FROM_FINDER, sql, start, start);
    }

    public static int indexOfWhere(CharSequence sql) {
        return SqlUtils.indexOfWhere(sql, 0);
    }

    public static int indexOfWhere(CharSequence sql, int start) {
        return SqlUtils.indexOf(WHERE_FINDER, sql, start, 0);
    }

    public static int indexOfGroupBy(CharSequence sql, int start) {
        return SqlUtils.indexOf(GROUP_BY_FINDER, sql, start, 0);
    }

    public static int indexOfHaving(CharSequence sql, int start) {
        return SqlUtils.indexOf(HAVING_FINDER, sql, start, 0);
    }

    public static int indexOfOrderBy(CharSequence sql) {
        return SqlUtils.indexOf(ORDER_BY_FINDER, sql, 0, 0);
    }

    public static int indexOfOrderBy(CharSequence sql, int start) {
        return SqlUtils.indexOf(ORDER_BY_FINDER, sql, start, start);
    }

    public static int indexOfLimit(CharSequence sql) {
        return SqlUtils.indexOf(LIMIT_FINDER, sql, 0, 0);
    }

    public static int indexOfLimit(CharSequence sql, int start) {
        return SqlUtils.indexOf(LIMIT_FINDER, sql, start, start);
    }

    public static int indexOfFetchFirst(CharSequence sql, int start) {
        return SqlUtils.indexOf(FETCH_FIRST_FINDER, sql, start, start);
    }

    public static int indexOfOn(CharSequence sql, int start) {
        return SqlUtils.indexOf(ON_FINDER, sql, start, start);
    }

    private static int indexOf(PatternFinder patternFinder, CharSequence sql, int start, int checkStart) {
        int patternIndex = patternFinder.indexIn(sql, start);
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = patternIndex;
        for (int i = checkStart; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < patternIndex ? patternIndex : (patternIndex = patternFinder.indexIn(sql, i));
        }
        return patternIndex;
    }

    public static int[] indexOfFinalTableSubquery(CharSequence sql, int selectIndex) {
        int fromFinalTableIndex = FROM_FINAL_TABLE_FINDER.indexIn(sql, selectIndex);
        if (fromFinalTableIndex == -1) {
            return new int[]{0, sql.length()};
        }
        int brackets = 1;
        QuoteMode mode = QuoteMode.NONE;
        int end = sql.length();
        for (int i = fromFinalTableIndex + FROM_FINAL_TABLE.length(); i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            return new int[]{fromFinalTableIndex + FROM_FINAL_TABLE.length(), i};
        }
        return new int[]{0, sql.length()};
    }

    public static int indexOfTableName(CharSequence sql, String tableName) {
        QuotedIdentifierAwarePatternFinder finder;
        int index;
        int startIndex = FROM_FINDER.indexIn(sql, 0);
        if (startIndex == -1) {
            return -1;
        }
        startIndex += FROM.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        if ((index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" " + tableName + " "))).indexIn(sql, startIndex, whereIndex)) == -1 && (index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("(" + tableName + " "))).indexIn(sql, startIndex, whereIndex)) == -1) {
            return -1;
        }
        return index + 1;
    }

    public static int indexOfJoinTableAlias(CharSequence sql, String tableAlias) {
        QuotedIdentifierAwarePatternFinder finder;
        int index;
        int startIndex = FROM_FINDER.indexIn(sql, 0);
        if (startIndex == -1) {
            return -1;
        }
        startIndex += FROM.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        if ((index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(tableAlias + ON))).indexIn(sql, startIndex, whereIndex)) == -1) {
            finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(tableAlias + JOIN));
            index = finder.indexIn(sql, startIndex, whereIndex);
        }
        return index;
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias) {
        int whereIndex = SqlUtils.indexOfWhere(sql);
        return SqlUtils.indexOfFullJoin(sql, tableAlias, whereIndex);
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias, int whereIndex) {
        int aliasIndex = SqlUtils.indexOfJoinTableAlias(sql, tableAlias);
        return SqlUtils.indexOfFullJoin(sql, tableAlias, aliasIndex, whereIndex);
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias, int aliasIndex, int whereIndex) {
        String aliasOnPart = " " + tableAlias + ON;
        if (aliasIndex > -1 && aliasIndex < whereIndex) {
            int onClauseStart = --aliasIndex + aliasOnPart.length();
            int onClauseEnd = SqlUtils.findEndOfOnClause(sql, onClauseStart, whereIndex);
            int joinStartIndex = SqlUtils.findJoinStartIndex(sql, aliasIndex);
            return new int[]{joinStartIndex, onClauseEnd};
        }
        return null;
    }

    public static int findJoinStartIndex(CharSequence sqlSb, int aliasIndex) {
        int[] tokenRange = SqlUtils.rtrimBackwardsToFirstWhitespace(sqlSb, aliasIndex);
        return SqlUtils.findJoinStartIndex(sqlSb, tokenRange[0] - 1, EnumSet.of(JoinToken.JOIN));
    }

    public static int findJoinStartIndex(CharSequence sqlSb, int tokenEnd, Set<JoinToken> allowedTokens) {
        int[] tokenRange;
        do {
            String token;
            JoinToken joinToken;
            if ((joinToken = JoinToken.of(token = sqlSb.subSequence((tokenRange = SqlUtils.rtrimBackwardsToFirstWhitespace(sqlSb, tokenEnd))[0], tokenRange[1]).toString().trim().toUpperCase())) == null) {
                return tokenEnd;
            }
            if (!allowedTokens.contains((Object)joinToken)) {
                return tokenRange[1];
            }
            allowedTokens = joinToken.previous();
            tokenEnd = tokenRange[0] - 1;
        } while (!allowedTokens.isEmpty());
        return tokenRange[0];
    }

    public static int findEndOfOnClause(CharSequence sqlSb, int predicateStartIndex, int whereIndex) {
        int joinIndex = JOIN_FINDER.indexIn(sqlSb, predicateStartIndex);
        int end = joinIndex == -1 || joinIndex > whereIndex ? whereIndex : SqlUtils.findJoinStartIndex(sqlSb, joinIndex, JoinToken.JOIN.previous());
        int potentialEndIndex = end;
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        for (int i = predicateStartIndex; i < end; ++i) {
            char c = sqlSb.charAt(i);
            if ((mode = mode.onCharBackwards(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = whereIndex;
                ++parenthesis;
                continue;
            }
            if (c == ')') {
                --parenthesis;
                if (i < potentialEndIndex) {
                    end = potentialEndIndex;
                    continue;
                }
                joinIndex = JOIN_FINDER.indexIn(sqlSb, i);
                if (joinIndex == -1) {
                    return whereIndex;
                }
                end = potentialEndIndex = SqlUtils.findJoinStartIndex(sqlSb, joinIndex, JoinToken.JOIN.previous());
                continue;
            }
            if (c != ',' || parenthesis != 0) continue;
            return i;
        }
        return end;
    }

    public static String extractAlias(StringBuilder sb) {
        int aliasEndCharIndex = SqlUtils.findLastNonWhitespace(sb);
        QuoteMode mode = QuoteMode.NONE.onCharBackwards(sb.charAt(aliasEndCharIndex));
        int endIndex = aliasEndCharIndex;
        if (mode != QuoteMode.NONE) {
            while ((mode = mode.onCharBackwards(sb.charAt(--endIndex))) != QuoteMode.NONE || endIndex > 0 && sb.charAt(endIndex) == sb.charAt(endIndex - 1)) {
            }
        }
        int aliasBeforeIndex = SqlUtils.findLastWhitespace(sb, endIndex);
        int dotIndex = sb.lastIndexOf(".", endIndex);
        aliasBeforeIndex = Math.max(aliasBeforeIndex, dotIndex);
        if (NEXT_VALUE_FOR_FINDER.indexIn(sb) != -1) {
            return sb.toString();
        }
        return sb.substring(aliasBeforeIndex + 1, aliasEndCharIndex + 1);
    }

    public static String extractAlias(CharSequence sb, int index) {
        char c;
        int i;
        int aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, index);
        if (sb.length() > aliasBeginCharIndex + 3 && Character.toLowerCase(sb.charAt(aliasBeginCharIndex)) == 'a' && Character.toLowerCase(sb.charAt(aliasBeginCharIndex + 1)) == 's' && Character.isWhitespace(sb.charAt(aliasBeginCharIndex + 2))) {
            aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, aliasBeginCharIndex + 2);
        }
        QuoteMode mode = QuoteMode.NONE;
        int end = sb.length();
        for (i = aliasBeginCharIndex; !(i >= end || (mode = mode.onChar(c = sb.charAt(i))) == QuoteMode.NONE && Character.isWhitespace(c)); ++i) {
        }
        return sb.subSequence(aliasBeginCharIndex, i).toString();
    }

    private static int skipWhitespaces(CharSequence charSequence, int index) {
        while (Character.isWhitespace(charSequence.charAt(index))) {
            int nextIndex = index + 1;
            if (nextIndex == charSequence.length()) {
                return nextIndex;
            }
            index = nextIndex;
        }
        return index;
    }

    public static String extractExpression(StringBuilder sb) {
        int i;
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.toString();
        }
        int lastNonWhitespaceIndex = sb.length();
        for (i = sb.length() - 1; i > 0; --i) {
            if (Character.isWhitespace(sb.charAt(i))) continue;
            lastNonWhitespaceIndex = i + 1;
            break;
        }
        for (i = asIndex + 4; i < lastNonWhitespaceIndex; ++i) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            return sb.toString();
        }
        return sb.substring(0, asIndex);
    }

    private static String extractColumn(StringBuilder sb) {
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.substring(SqlUtils.findLastDot(sb, sb.length()) + 1);
        }
        return sb.substring(SqlUtils.findLastDot(sb, asIndex) + 1, asIndex);
    }

    private static int findLastDot(StringBuilder sb, int end) {
        int i = end - 1;
        QuoteMode mode = QuoteMode.NONE;
        while (i >= 0) {
            char c = sb.charAt(i);
            if ((mode = mode.onCharBackwards(sb.charAt(i))) == QuoteMode.NONE) {
                if (c == '.') break;
                --i;
                continue;
            }
            --i;
        }
        return i;
    }

    private static int findLastNonWhitespace(StringBuilder sb) {
        return SqlUtils.findLastNonWhitespace(sb, sb.length() - 1);
    }

    private static int findLastNonWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    private static int findLastWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && !Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    public static interface SelectItemExtractor {
        public String extract(StringBuilder var1, int var2, int var3);
    }

    static enum JoinToken {
        COMMA,
        LEFT,
        INNER,
        RIGHT,
        CROSS,
        OUTER{

            @Override
            Set<JoinToken> previous() {
                return EnumSet.of(LEFT, RIGHT);
            }
        }
        ,
        JOIN{

            @Override
            Set<JoinToken> previous() {
                return EnumSet.of(LEFT, INNER, RIGHT, OUTER, CROSS);
            }
        };

        private static final Map<String, JoinToken> TOKEN_MAP;

        Set<JoinToken> previous() {
            return EnumSet.noneOf(JoinToken.class);
        }

        static JoinToken of(String text) {
            switch (text) {
                case ",": {
                    return COMMA;
                }
            }
            return TOKEN_MAP.get(text);
        }

        static {
            HashMap<String, JoinToken> tokenMap = new HashMap<String, JoinToken>();
            for (JoinToken value : JoinToken.values()) {
                tokenMap.put(value.name(), value);
            }
            TOKEN_MAP = tokenMap;
        }
    }
}

