/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsLimitHandler;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.DeleteJoinStyle;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import com.blazebit.persistence.spi.ValuesStrategy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultDbmsDialect
implements DbmsDialect {
    private final Map<Class<?>, String> sqlTypes;

    public DefaultDbmsDialect() {
        this(Collections.EMPTY_MAP);
    }

    public DefaultDbmsDialect(Map<Class<?>, String> childSqlTypes) {
        HashMap types = new HashMap();
        types.put(Boolean.class, "number(1,0)");
        types.put(Boolean.TYPE, "number(1,0)");
        types.put(Byte.class, "tinyint");
        types.put(Byte.TYPE, "tinyint");
        types.put(Short.class, "smallint");
        types.put(Short.TYPE, "smallint");
        types.put(Integer.class, "integer");
        types.put(Integer.TYPE, "integer");
        types.put(Long.class, "bigint");
        types.put(Long.TYPE, "bigint");
        types.put(Float.class, "float");
        types.put(Float.TYPE, "float");
        types.put(Double.class, "double precision");
        types.put(Double.TYPE, "double precision");
        types.put(Character.class, "char");
        types.put(Character.TYPE, "char");
        types.put(String.class, "varchar");
        types.put(BigInteger.class, "bigint");
        types.put(BigDecimal.class, "decimal");
        types.put(Time.class, "time");
        types.put(Date.class, "date");
        types.put(Timestamp.class, "timestamp");
        types.put(java.util.Date.class, "timestamp");
        types.put(Calendar.class, "timestamp");
        types.putAll(childSqlTypes);
        this.sqlTypes = Collections.unmodifiableMap(types);
    }

    public boolean supportsWithClause() {
        return true;
    }

    public boolean supportsNonRecursiveWithClause() {
        return true;
    }

    public boolean supportsWithClauseHead() {
        return this.supportsWithClause();
    }

    public boolean supportsJoinsInRecursiveCte() {
        return true;
    }

    public boolean supportsAnsiRowValueConstructor() {
        return this.supportsRowValueConstructor();
    }

    public boolean supportsRowValueConstructor() {
        return true;
    }

    public boolean supportsFullRowValueComparison() {
        return true;
    }

    public boolean supportsCountTuple() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsFilterClause() {
        return false;
    }

    public boolean supportsNullPrecedence() {
        return true;
    }

    public boolean supportsWindowNullPrecedence() {
        return false;
    }

    public boolean supportsBooleanAggregation() {
        return false;
    }

    public boolean isNullSmallest() {
        return false;
    }

    public boolean requiresNullCast() {
        return true;
    }

    public String getPhysicalRowId() {
        return null;
    }

    public LateralStyle getLateralStyle() {
        return LateralStyle.LATERAL;
    }

    public DeleteJoinStyle getDeleteJoinStyle() {
        return DeleteJoinStyle.NONE;
    }

    public UpdateJoinStyle getUpdateJoinStyle() {
        return UpdateJoinStyle.NONE;
    }

    public boolean supportsArbitraryLengthMultiset() {
        return false;
    }

    public String getSqlType(Class<?> castType) {
        return this.sqlTypes.get(castType);
    }

    public String getWithClause(boolean recursive) {
        if (recursive) {
            return "with recursive";
        }
        return "with";
    }

    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        return this.appendExtendedSql(sqlSb, statementType, isSubquery, isEmbedded, withClause, limit, offset, null, returningColumns, includedModificationStates);
    }

    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String dmlAffectedTable, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean addParenthesis;
        boolean bl = addParenthesis = isSubquery && sqlSb.length() > 0 && sqlSb.charAt(0) != '(';
        if (addParenthesis) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(0, withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isSubquery && !this.supportsModificationQueryInWithClause() && returningColumns != null) {
            throw new IllegalArgumentException("Returning columns in a subquery is not possible for this dbms!");
        }
        if (addParenthesis) {
            sqlSb.append(')');
        }
        return null;
    }

    public void appendSet(StringBuilder sqlSb, SetOperationType setType, boolean isSubquery, List<String> operands, List<? extends OrderByElement> orderByElements, String limit, String offset) {
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (operands.size() > 0) {
            boolean needsWrapper;
            String operator = this.getOperator(setType);
            boolean hasLimit = limit != null;
            boolean hasOrderBy = orderByElements.size() > 0;
            boolean hasOuterClause = hasLimit || hasOrderBy;
            boolean bl = needsWrapper = hasOuterClause && this.needsSetOperationWrapper() && operands.size() > 1;
            if (needsWrapper) {
                sqlSb.append("select * from (");
            }
            String[] aliases = this.appendSetOperands(sqlSb, setType, operator, isSubquery, operands, hasOuterClause);
            if (needsWrapper) {
                this.closeFromClause(sqlSb);
            }
            this.appendOrderBy(sqlSb, orderByElements, aliases);
            if (limit != null) {
                this.appendLimit(sqlSb, isSubquery, limit, offset);
            }
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
    }

    public DbmsLimitHandler createLimitHandler() {
        return new DefaultDbmsLimitHandler();
    }

    public boolean supportsLimitWithoutOrderBy() {
        return true;
    }

    public boolean supportsLimitInQuantifiedPredicateSubquery() {
        return true;
    }

    public boolean supportsNestedCorrelations() {
        return true;
    }

    protected String getWindowFunctionDummyOrderBy() {
        return null;
    }

    protected boolean needsAliasInSetOrderBy() {
        return false;
    }

    protected boolean supportsPartitionInRowNumberOver() {
        return false;
    }

    protected boolean needsAliasForFromClause() {
        return false;
    }

    protected boolean needsSetOperationWrapper() {
        return true;
    }

    protected String[] appendSetOperands(StringBuilder sqlSb, SetOperationType setType, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        boolean first = true;
        boolean emulate = setType == SetOperationType.EXCEPT_ALL && !this.supportsExcept(true) || setType == SetOperationType.INTERSECT_ALL && !this.supportsIntersect(true);
        String select = "select ";
        String windowFunctionDummyOrderBy = this.getWindowFunctionDummyOrderBy();
        String[] aliases = null;
        if (this.needsAliasInSetOrderBy()) {
            aliases = SqlUtils.getSelectItemAliases(operands.get(0), SqlUtils.SELECT_FINDER.indexIn(operands.get(0)));
        }
        for (String operand : operands) {
            boolean addWrapper;
            boolean wasFirst = false;
            if (first) {
                first = false;
                wasFirst = true;
                if (emulate) {
                    if (aliases == null) {
                        aliases = SqlUtils.getSelectItemAliases(operand, SqlUtils.indexOfSelect(operand));
                    }
                    sqlSb.append("select ");
                    for (int i = 0; i < aliases.length; ++i) {
                        if (i != 0) {
                            sqlSb.append(", ");
                        }
                        sqlSb.append(aliases[i]);
                    }
                    sqlSb.append(" from (");
                }
            } else {
                sqlSb.append(' ');
                sqlSb.append(operator);
                sqlSb.append(' ');
            }
            if (emulate) {
                int selectIndex = SqlUtils.indexOfSelect(operand);
                String[] expressions = SqlUtils.getSelectItemExpressions(operand, selectIndex);
                sqlSb.append("select ");
                sqlSb.append("row_number() over (partition by ");
                for (int i = 0; i < expressions.length; ++i) {
                    if (i != 0) {
                        sqlSb.append(", ");
                    }
                    sqlSb.append(expressions[i]);
                }
                if (windowFunctionDummyOrderBy != null) {
                    sqlSb.append(windowFunctionDummyOrderBy);
                }
                sqlSb.append(") as set_op_row_num_, ");
                sqlSb.append(operand, "select ".length(), operand.length());
                continue;
            }
            boolean bl = addWrapper = SqlUtils.indexOfOrderBy(operand) != -1;
            if (addWrapper) {
                sqlSb.append("select * from (");
            }
            if ((addWrapper || wasFirst) && operand.charAt(0) == '(') {
                sqlSb.append(operand, 1, operand.length() - 1);
            } else {
                sqlSb.append(operand);
            }
            if (!addWrapper) continue;
            this.closeFromClause(sqlSb);
        }
        if (emulate) {
            this.closeFromClause(sqlSb);
        }
        return aliases;
    }

    private void closeFromClause(StringBuilder sqlSb) {
        sqlSb.append(')');
        if (this.needsAliasForFromClause()) {
            sqlSb.append(" set_op");
        }
    }

    protected void appendOrderBy(StringBuilder sqlSb, List<? extends OrderByElement> orderByElements, String[] aliases) {
        if (orderByElements.isEmpty()) {
            return;
        }
        sqlSb.append(" order by ");
        boolean first = true;
        for (OrderByElement orderByElement : orderByElements) {
            if (first) {
                first = false;
            } else {
                sqlSb.append(',');
            }
            this.appendOrderByElement(sqlSb, orderByElement, aliases);
        }
    }

    public void appendOrderByElement(StringBuilder sqlSb, OrderByElement element, String[] aliases) {
        if (aliases != null) {
            sqlSb.append(aliases[element.getPosition() - 1]);
        } else {
            sqlSb.append(element.getPosition());
        }
        if (element.isAscending()) {
            sqlSb.append(" asc");
        } else {
            sqlSb.append(" desc");
        }
        if (element.isNullable()) {
            if (element.isNullsFirst()) {
                sqlSb.append(" nulls first");
            } else {
                sqlSb.append(" nulls last");
            }
        }
    }

    protected void appendEmulatedOrderByElementWithNulls(StringBuilder sqlSb, OrderByElement element, String[] aliases) {
        sqlSb.append("case when ");
        if (aliases != null) {
            sqlSb.append(aliases[element.getPosition() - 1]);
        } else {
            sqlSb.append(element.getPosition());
        }
        sqlSb.append(" is null then ");
        sqlSb.append(element.isNullsFirst() ? 0 : 1);
        sqlSb.append(" else ");
        sqlSb.append(element.isNullsFirst() ? 1 : 0);
        sqlSb.append(" end, ");
        sqlSb.append(element.getPosition());
        sqlSb.append(element.isAscending() ? " asc" : " desc");
    }

    protected String getOperator(SetOperationType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + type);
    }

    public boolean supportsUnion(boolean all) {
        return true;
    }

    public boolean supportsIntersect(boolean all) {
        return !all;
    }

    public boolean supportsExcept(boolean all) {
        return !all;
    }

    public boolean supportsWithClauseInModificationQuery() {
        return true;
    }

    public boolean supportsModificationQueryInWithClause() {
        return false;
    }

    public boolean usesExecuteUpdateWhenWithClauseInModificationQuery() {
        return true;
    }

    public boolean supportsReturningGeneratedKeys() {
        return true;
    }

    public boolean supportsReturningAllGeneratedKeys() {
        return true;
    }

    public boolean supportsReturningColumns() {
        return false;
    }

    public boolean supportsGroupByExpressionInHavingMatching() {
        return true;
    }

    public boolean supportsComplexJoinOn() {
        return true;
    }

    public ValuesStrategy getValuesStrategy() {
        return ValuesStrategy.VALUES;
    }

    public boolean needsCastParameters() {
        return true;
    }

    public String getDummyTable() {
        return null;
    }

    public String cast(String expression, String sqlType) {
        return "cast(" + expression + " as " + sqlType + ")";
    }

    public Character getDefaultEscapeCharacter() {
        return null;
    }

    public boolean needsReturningSqlTypes() {
        return false;
    }

    public int getPrepareFlags() {
        return 1;
    }

    public PreparedStatement prepare(PreparedStatement ps, int[] returningSqlTypes) throws SQLException {
        return ps;
    }

    public ResultSet extractReturningResult(PreparedStatement ps) throws SQLException {
        return ps.getGeneratedKeys();
    }

    public void appendLimit(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        this.createLimitHandler().applySql(sqlSb, isSubquery, limit, offset);
    }

    protected static int indexOfIgnoreCase(StringBuilder haystack, String needle) {
        int endLimit = haystack.length() - needle.length() + 1;
        for (int i = 0; i < endLimit; ++i) {
            if (!DefaultDbmsDialect.regionMatchesIgnoreCase(haystack, i, needle, 0, needle.length())) continue;
            return i;
        }
        return -1;
    }

    protected static boolean regionMatchesIgnoreCase(StringBuilder haystack, int thisStart, String substring, int start, int length) {
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = haystack.charAt(index1++)) == (c2 = substring.charAt(index2++)) || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

