/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.LeafOngoingFinalSetOperationCriteriaBuilder;
import com.blazebit.persistence.LeafOngoingSetOperationCriteriaBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCriteriaBuilder;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.BuilderListener;
import com.blazebit.persistence.impl.BuilderListenerImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.FinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.StartOngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.spi.SetOperationType;
import javax.persistence.TypedQuery;

public class CriteriaBuilderImpl<T>
extends AbstractFullQueryBuilder<T, CriteriaBuilder<T>, LeafOngoingSetOperationCriteriaBuilder<T>, StartOngoingSetOperationCriteriaBuilder<T, LeafOngoingFinalSetOperationCriteriaBuilder<T>>, BaseFinalSetOperationCriteriaBuilderImpl<T, ?>>
implements CriteriaBuilder<T> {
    protected long cachedQueryRootMaximumCount;
    protected String cachedQueryRootCountQueryString;
    protected String cachedExternalQueryRootCountQueryString;

    public CriteriaBuilderImpl(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias) {
        super(mainQuery, isMainQuery, clazz, alias, null);
    }

    @Override
    protected void prepareForModification(ClauseType changedClause) {
        super.prepareForModification(changedClause);
        this.cachedQueryRootMaximumCount = Long.MAX_VALUE;
        this.cachedQueryRootCountQueryString = null;
        this.cachedExternalQueryRootCountQueryString = null;
    }

    public TypedQuery<Long> getQueryRootCountQuery() {
        this.prepareAndCheck();
        return this.getCountQuery(this.getCountQueryRootQueryStringWithoutCheck(Long.MAX_VALUE), this.isComplexCountQuery());
    }

    public TypedQuery<Long> getQueryRootCountQuery(long maximumCount) {
        this.prepareAndCheck();
        return this.getCountQuery(this.getCountQueryRootQueryStringWithoutCheck(maximumCount), this.isComplexCountQuery());
    }

    public String getQueryRootCountQueryString() {
        this.prepareAndCheck();
        return this.getExternalQueryRootCountQueryString(Long.MAX_VALUE);
    }

    public String getQueryRootCountQueryString(long maximumCount) {
        this.prepareAndCheck();
        return this.getExternalQueryRootCountQueryString(maximumCount);
    }

    private String getCountQueryRootQueryStringWithoutCheck(long maximumCount) {
        if (this.cachedQueryRootMaximumCount != maximumCount) {
            this.cachedQueryRootMaximumCount = maximumCount;
            this.cachedQueryRootCountQueryString = null;
            this.cachedExternalQueryRootCountQueryString = null;
        }
        if (this.cachedQueryRootCountQueryString == null) {
            this.cachedQueryRootCountQueryString = this.buildPageCountQueryString(false, false, this.cachedQueryRootMaximumCount);
        }
        return this.cachedQueryRootCountQueryString;
    }

    private String getExternalQueryRootCountQueryString(long maximumCount) {
        if (this.cachedQueryRootMaximumCount != maximumCount) {
            this.cachedQueryRootMaximumCount = maximumCount;
            this.cachedQueryRootCountQueryString = null;
            this.cachedExternalQueryRootCountQueryString = null;
        }
        if (this.cachedExternalQueryRootCountQueryString == null) {
            this.cachedExternalQueryRootCountQueryString = this.buildPageCountQueryString(true, false, this.cachedQueryRootMaximumCount);
        }
        return this.cachedExternalQueryRootCountQueryString;
    }

    public <Y> CriteriaBuilder<Y> copy(Class<Y> resultClass) {
        return (CriteriaBuilder)super.copy(resultClass);
    }

    @Override
    public <Y> SelectObjectBuilder<CriteriaBuilder<Y>> selectNew(Class<Y> clazz) {
        return super.selectNew(clazz);
    }

    public <Y> CriteriaBuilder<Y> selectNew(ObjectBuilder<Y> builder) {
        return (CriteriaBuilder)super.selectNew(builder);
    }

    @Override
    protected void verifySetBuilderEnded() {
        super.verifySetBuilderEnded();
        if (this.finalSetOperationBuilder != null) {
            throw new IllegalStateException("The original criteria builder should not be accessed anymore after connecting it with a set operation. Use the result of the set operation instead!");
        }
    }

    @Override
    protected BaseFinalSetOperationCriteriaBuilderImpl<T, ?> createFinalSetOperationBuilder(SetOperationType operator, boolean nested) {
        BuilderListenerImpl<Object> newListener;
        boolean wasMainQuery = this.isMainQuery;
        this.isMainQuery = false;
        BuilderListenerImpl<Object> builderListenerImpl = newListener = this.finalSetOperationBuilder == null ? null : ((BaseFinalSetOperationCriteriaBuilderImpl)this.finalSetOperationBuilder).getSubListener();
        if (nested) {
            return new OngoingFinalSetOperationCriteriaBuilderImpl(this.mainQuery, this.queryContext, wasMainQuery, this.resultType, operator, nested, (BuilderListener<Object>)newListener);
        }
        return new FinalSetOperationCriteriaBuilderImpl(this.mainQuery, this.queryContext, wasMainQuery, this.resultType, operator, nested, (BuilderListener<Object>)newListener);
    }

    @Override
    protected LeafOngoingSetOperationCriteriaBuilder<T> createSetOperand(BaseFinalSetOperationCriteriaBuilderImpl<T, ?> finalSetOperationBuilder) {
        return this.createLeaf(finalSetOperationBuilder);
    }

    @Override
    protected StartOngoingSetOperationCriteriaBuilder<T, LeafOngoingFinalSetOperationCriteriaBuilder<T>> createSubquerySetOperand(BaseFinalSetOperationCriteriaBuilderImpl<T, ?> finalSetOperationBuilder, BaseFinalSetOperationCriteriaBuilderImpl<T, ?> resultFinalSetOperationBuilder) {
        LeafOngoingSetOperationCriteriaBuilderImpl<T> leafCb = this.createLeaf(resultFinalSetOperationBuilder);
        return this.createOngoing(finalSetOperationBuilder, leafCb);
    }

    private LeafOngoingSetOperationCriteriaBuilderImpl<T> createLeaf(BaseFinalSetOperationCriteriaBuilderImpl<T, ?> finalSetOperationBuilder) {
        BuilderListenerImpl<Object> newListener = finalSetOperationBuilder.getSubListener();
        LeafOngoingSetOperationCriteriaBuilderImpl next = new LeafOngoingSetOperationCriteriaBuilderImpl(this.mainQuery, this.queryContext, false, this.resultType, newListener, (FinalSetOperationCriteriaBuilderImpl)finalSetOperationBuilder);
        newListener.onBuilderStarted(next);
        return next;
    }

    private <Y> StartOngoingSetOperationCriteriaBuilderImpl<T, Y> createOngoing(BaseFinalSetOperationCriteriaBuilderImpl<T, ?> finalSetOperationBuilder, Y endSetResult) {
        finalSetOperationBuilder.setEndSetResult(endSetResult);
        BuilderListenerImpl<Object> newListener = finalSetOperationBuilder.getSubListener();
        StartOngoingSetOperationCriteriaBuilderImpl next = new StartOngoingSetOperationCriteriaBuilderImpl(this.mainQuery, this.queryContext, false, this.resultType, newListener, (OngoingFinalSetOperationCriteriaBuilderImpl)finalSetOperationBuilder, endSetResult);
        newListener.onBuilderStarted(next);
        return next;
    }
}

