/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.From;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.AbortableResultJoinNodeVisitor;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ConstantifiedJoinNodeAttributeCollector;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.TreatedJoinAliasInfo;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.expression.BaseNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;

public class JoinNode
implements From,
ExpressionModifier,
BaseNode {
    private JoinType joinType = JoinType.LEFT;
    private boolean fetch = false;
    private final EnumSet<ClauseType> clauseDependencies = EnumSet.noneOf(ClauseType.class);
    private final JoinNode parent;
    private final JoinTreeNode parentTreeNode;
    private final JoinNode correlationParent;
    private final String correlationPath;
    private final Type<?> nodeType;
    private final EntityType<?> treatType;
    private final String valuesTypeName;
    private final int valueCount;
    private final EntityType<?> valueType;
    private final Set<String> valuesIdNames;
    private final String valuesLikeClause;
    private final boolean valueClazzAttributeSingular;
    private final boolean valueClazzSimpleValue;
    private final String valuesLikeAttribute;
    private final String valuesCastedParameter;
    private final String[] valuesAttributes;
    private final String qualificationExpression;
    private final JoinAliasInfo aliasInfo;
    private final List<JoinNode> joinNodesForTreatConstraint;
    private final boolean lateral;
    private final NavigableMap<String, JoinTreeNode> nodes = new TreeMap<String, JoinTreeNode>();
    private final NavigableMap<String, JoinNode> treatedJoinNodes = new TreeMap<String, JoinNode>();
    private final Set<JoinNode> entityJoinNodes = new LinkedHashSet<JoinNode>();
    private final Set<JoinNode> dependencies = new HashSet<JoinNode>();
    private CTEInfo inlineCte;
    private CompoundPredicate onPredicate;
    private List<JoinNode> joinNodesNeedingTreatConjunct;
    private String deReferenceFunction;
    private Set<String> allowedAttributes;
    private String disallowedDeReferenceAlias;
    private boolean disallowedDeReferenceUsed;
    private boolean crossJoin;
    private boolean dirty = true;
    private boolean cardinalityMandatory;

    private JoinNode(TreatedJoinAliasInfo treatedJoinAliasInfo) {
        List<JoinNode> joinNodesForTreatConstraint;
        JoinNode treatedJoinNode;
        this.parent = treatedJoinNode = treatedJoinAliasInfo.getTreatedJoinNode();
        this.parentTreeNode = null;
        this.joinType = JoinType.LEFT;
        this.correlationParent = null;
        this.correlationPath = null;
        this.nodeType = treatedJoinNode.nodeType;
        this.treatType = treatedJoinAliasInfo.getTreatType();
        this.qualificationExpression = null;
        this.valuesTypeName = treatedJoinNode.valuesTypeName;
        this.valueCount = treatedJoinNode.valueCount;
        this.valueType = treatedJoinNode.valueType;
        this.valuesIdNames = treatedJoinNode.valuesIdNames;
        this.valuesLikeClause = treatedJoinNode.valuesLikeClause;
        this.valueClazzAttributeSingular = treatedJoinNode.valueClazzAttributeSingular;
        this.valueClazzSimpleValue = treatedJoinNode.valueClazzSimpleValue;
        this.valuesLikeAttribute = treatedJoinNode.valuesLikeAttribute;
        this.valuesCastedParameter = treatedJoinNode.valuesCastedParameter;
        this.valuesAttributes = treatedJoinNode.valuesAttributes;
        this.aliasInfo = treatedJoinAliasInfo;
        this.lateral = treatedJoinNode.lateral;
        if (treatedJoinNode.joinNodesForTreatConstraint.isEmpty()) {
            joinNodesForTreatConstraint = Collections.singletonList(this);
        } else {
            joinNodesForTreatConstraint = new ArrayList<JoinNode>(treatedJoinNode.joinNodesForTreatConstraint.size() + 1);
            for (JoinNode joinNodeForTreatConstraint : treatedJoinNode.joinNodesForTreatConstraint) {
                if (joinNodeForTreatConstraint != this.parent || this.isJoinOnTreatSubtypeAssociation()) continue;
                joinNodesForTreatConstraint.add(joinNodeForTreatConstraint);
            }
            joinNodesForTreatConstraint.add(this);
        }
        this.joinNodesForTreatConstraint = Collections.unmodifiableList(joinNodesForTreatConstraint);
    }

    private JoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinType joinType, JoinNode correlationParent, String correlationPath, Type<?> nodeType, EntityType<?> treatType, String qualificationExpression, JoinAliasInfo aliasInfo, boolean lateral) {
        this.parent = parent;
        this.parentTreeNode = parentTreeNode;
        this.joinType = joinType;
        this.correlationParent = correlationParent;
        this.correlationPath = correlationPath;
        this.nodeType = nodeType;
        this.treatType = treatType;
        this.lateral = lateral;
        this.valuesTypeName = null;
        this.valueCount = 0;
        this.valueType = null;
        this.valuesIdNames = null;
        this.valuesLikeClause = null;
        this.valueClazzAttributeSingular = false;
        this.valueClazzSimpleValue = false;
        this.valuesLikeAttribute = null;
        this.valuesCastedParameter = null;
        this.valuesAttributes = null;
        this.qualificationExpression = qualificationExpression;
        this.aliasInfo = aliasInfo;
        this.joinNodesForTreatConstraint = treatType != null ? Collections.singletonList(this) : (parent != null ? parent.joinNodesForTreatConstraint : Collections.emptyList());
        this.onUpdate(null);
    }

    private JoinNode(Type<?> nodeType, EntityType<?> valueType, String valuesTypeName, int valueCount, Set<String> valuesIdNames, String valuesLikeClause, String valueClazzAttributeQualificationExpression, boolean valueClazzAttributeSingular, boolean valueClazzSimpleValue, String valuesLikeAttribute, String valuesCastedParameter, String[] valuesAttributes, JoinAliasInfo aliasInfo) {
        this.parent = null;
        this.parentTreeNode = null;
        this.joinType = null;
        this.correlationParent = null;
        this.correlationPath = null;
        this.nodeType = nodeType;
        this.treatType = null;
        this.valuesTypeName = valuesTypeName;
        this.valueCount = valueCount;
        this.valueType = valueType;
        this.valuesIdNames = valuesIdNames;
        this.valuesLikeClause = valuesLikeClause;
        this.valueClazzAttributeSingular = valueClazzAttributeSingular;
        this.valueClazzSimpleValue = valueClazzSimpleValue;
        this.valuesLikeAttribute = valuesLikeAttribute;
        this.valuesCastedParameter = valuesCastedParameter;
        this.valuesAttributes = valuesAttributes;
        this.qualificationExpression = valueClazzAttributeQualificationExpression;
        this.aliasInfo = aliasInfo;
        this.joinNodesForTreatConstraint = Collections.emptyList();
        this.lateral = false;
        this.onUpdate(null);
    }

    public static JoinNode createRootNode(EntityType<?> nodeType, JoinAliasInfo aliasInfo) {
        return new JoinNode(null, null, null, null, null, (Type<?>)nodeType, null, null, aliasInfo, false);
    }

    public static JoinNode createSimpleValuesRootNode(MainQuery mainQuery, Class<?> nodeType, int valueCount, JoinAliasInfo aliasInfo) {
        String sqlType = mainQuery.dbmsDialect.getSqlType(Long.class);
        String valuesTypeName = mainQuery.cbf.getNamedTypes().get(Long.class);
        String valuesCastedParameter = mainQuery.dbmsDialect.cast("?", sqlType);
        return new JoinNode(mainQuery.metamodel.type(nodeType), mainQuery.metamodel.entity(ValuesEntity.class), valuesTypeName, valueCount, null, null, null, true, true, "value", valuesCastedParameter, new String[]{"value"}, aliasInfo);
    }

    public static JoinNode createValuesRootNode(Type<?> nodeType, EntityType<?> valueType, String valuesTypeName, int valueCount, Set<String> valuesIdName, String valuesLikeClause, String qualificationExpression, boolean valueClazzAttributeSingular, boolean valueClazzSimpleValue, String valuesLikeAttribute, String valuesCastedParameter, String[] valuesAttributes, JoinAliasInfo aliasInfo) {
        return new JoinNode(nodeType, valueType, valuesTypeName, valueCount, valuesIdName, valuesLikeClause, qualificationExpression, valueClazzAttributeSingular, valueClazzSimpleValue, valuesLikeAttribute, valuesCastedParameter, valuesAttributes, aliasInfo);
    }

    public static JoinNode createCorrelationRootNode(JoinNode correlationParent, String correlationPath, Attribute<?, ?> correlatedAttribute, Type<?> nodeType, EntityType<?> treatType, JoinAliasInfo aliasInfo, boolean lateral) {
        return new JoinNode(lateral ? correlationParent : null, new JoinTreeNode(correlationPath, correlatedAttribute), null, correlationParent, correlationPath, nodeType, treatType, null, aliasInfo, lateral);
    }

    public static JoinNode createEntityJoinNode(JoinNode parent, JoinType joinType, EntityType<?> nodeType, JoinAliasInfo aliasInfo, boolean lateral) {
        return new JoinNode(parent, null, joinType, null, null, (Type<?>)nodeType, null, null, aliasInfo, lateral);
    }

    public static JoinNode createAssociationJoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinType joinType, Type<?> nodeType, EntityType<?> treatType, String qualificationExpression, JoinAliasInfo aliasInfo) {
        return new JoinNode(parent, parentTreeNode, joinType, null, null, nodeType, treatType, qualificationExpression, aliasInfo, false);
    }

    public JoinNode cloneRootNode(JoinAliasInfo aliasInfo) {
        JoinNode newNode;
        if (this.valueCount > 0) {
            newNode = JoinNode.createValuesRootNode(this.nodeType, this.valueType, this.valuesTypeName, this.valueCount, this.valuesIdNames, this.valuesLikeClause, this.qualificationExpression, this.valueClazzAttributeSingular, this.valueClazzSimpleValue, this.valuesLikeAttribute, this.valuesCastedParameter, this.valuesAttributes, aliasInfo);
        } else if (this.correlationParent == null) {
            newNode = JoinNode.createRootNode((EntityType)this.nodeType, aliasInfo);
        } else {
            JoinAliasInfo parentAliasInfo = (JoinAliasInfo)aliasInfo.getAliasOwner().getAliasInfo(this.correlationParent.getAlias());
            newNode = JoinNode.createCorrelationRootNode(parentAliasInfo.getJoinNode(), this.correlationPath, this.parentTreeNode.getAttribute(), this.nodeType, this.treatType, aliasInfo, false);
        }
        newNode.getClauseDependencies().addAll(this.clauseDependencies);
        return newNode;
    }

    public JoinNode cloneJoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinAliasInfo aliasInfo) {
        JoinNode newNode = parentTreeNode == null && this.treatType == null ? JoinNode.createEntityJoinNode(parent, this.joinType, (EntityType)this.nodeType, aliasInfo, this.lateral) : JoinNode.createAssociationJoinNode(parent, parentTreeNode, this.joinType, this.nodeType, this.treatType, this.qualificationExpression, aliasInfo);
        newNode.fetch = this.fetch;
        newNode.getClauseDependencies().addAll(this.clauseDependencies);
        return newNode;
    }

    private boolean isJoinOnTreatSubtypeAssociation() {
        if (this.parentTreeNode == null) {
            return false;
        }
        ManagedType declaringType = this.parentTreeNode.getAttribute().getDeclaringType();
        Type<?> baseType = this.parent.getBaseType();
        for (IdentifiableType treatType = this.parent.getTreatType(); treatType != baseType; treatType = treatType.getSupertype()) {
            if (declaringType != treatType) continue;
            return true;
        }
        return false;
    }

    private void onUpdate(StateChange stateChange) {
        if (this.cardinalityMandatory && stateChange != StateChange.JOIN_TYPE) {
            return;
        }
        this.dirty = true;
        if (this.parent != null) {
            this.parent.onUpdate(StateChange.CHILD);
        }
    }

    public boolean isCardinalityMandatory() {
        if (this.dirty) {
            this.updateCardinalityMandatory();
            this.dirty = false;
        }
        return this.cardinalityMandatory;
    }

    private void updateCardinalityMandatory() {
        boolean computedMandatory = false;
        if (this.joinType == JoinType.INNER) {
            if (this.parentTreeNode == null || this.parentTreeNode.isOptional() || !this.isEmptyCondition()) {
                computedMandatory = true;
            }
        } else if (this.joinType == JoinType.LEFT) {
            if (!this.isEmptyCondition() && !this.isArrayExpressionCondition()) {
                computedMandatory = true;
            }
            block0: for (Map.Entry nodeEntry : this.nodes.entrySet()) {
                JoinTreeNode treeNode = (JoinTreeNode)nodeEntry.getValue();
                for (JoinNode childNode : treeNode.getJoinNodes().values()) {
                    if (!childNode.isCardinalityMandatory()) continue;
                    computedMandatory = true;
                    break block0;
                }
            }
        }
        if (computedMandatory != this.cardinalityMandatory) {
            this.cardinalityMandatory = computedMandatory;
        }
    }

    public boolean containsNode(JoinNode n, String joinRelationName) {
        if (this.parent == n && this.parentTreeNode != null && joinRelationName.equals(this.parentTreeNode.getRelationName())) {
            return this.onPredicate == null;
        }
        return this.parent != null && this.parent.containsNode(n, joinRelationName);
    }

    private boolean isEmptyCondition() {
        return this.onPredicate == null || this.onPredicate.getChildren().isEmpty();
    }

    private boolean isArrayExpressionCondition() {
        if (this.onPredicate == null || this.onPredicate.getChildren().size() != 1) {
            return false;
        }
        Predicate predicate = (Predicate)this.onPredicate.getChildren().get(0);
        if (!(predicate instanceof EqPredicate)) {
            return false;
        }
        EqPredicate eqPredicate = (EqPredicate)predicate;
        Expression left = eqPredicate.getLeft();
        if (left instanceof MapKeyExpression) {
            return this.equals(((MapKeyExpression)left).getPath().getBaseNode());
        }
        if (left instanceof ListIndexExpression) {
            return this.equals(((ListIndexExpression)left).getPath().getBaseNode());
        }
        return false;
    }

    public void registerDependencies() {
        if (this.onPredicate != null) {
            this.onPredicate.accept((Expression.Visitor)new VisitorAdapter(){

                public void visit(SubqueryExpression expression) {
                    ((AbstractCommonQueryBuilder)expression.getSubquery()).applyVisitor((Expression.Visitor)this);
                }

                public void visit(PathExpression pathExpr) {
                    JoinNode baseNode = (JoinNode)pathExpr.getBaseNode();
                    if (baseNode != null && baseNode != JoinNode.this && baseNode.aliasInfo.getAliasOwner() == JoinNode.this.aliasInfo.getAliasOwner() && (baseNode.getQualificationExpression() == null || baseNode.parent != JoinNode.this)) {
                        JoinNode.this.dependencies.add(baseNode);
                    }
                }
            });
        }
    }

    public void set(Expression expression) {
        if (!(expression instanceof CompoundPredicate)) {
            throw new IllegalArgumentException("Expected compound predicate but was given: " + expression);
        }
        this.onPredicate = (CompoundPredicate)expression;
    }

    public Expression get() {
        return this.onPredicate;
    }

    public void accept(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        if (this.onPredicate != null) {
            visitor.visit(this, ClauseType.JOIN);
        }
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                joinNode.accept(visitor);
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            joinNode.accept(visitor);
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            joinNode.accept(visitor);
        }
    }

    public void accept(JoinNodeVisitor visitor) {
        visitor.visit(this);
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                joinNode.accept(visitor);
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            joinNode.accept(visitor);
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            joinNode.accept(visitor);
        }
    }

    public <T> T accept(AbortableResultJoinNodeVisitor<T> visitor) {
        Object result;
        T stopValue = visitor.getStopValue();
        if (stopValue.equals(result = visitor.visit(this))) {
            return result;
        }
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                result = joinNode.accept(visitor);
                if (!stopValue.equals(result)) continue;
                return result;
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            result = joinNode.accept(visitor);
            if (!stopValue.equals(result)) continue;
            return result;
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            result = joinNode.accept(visitor);
            if (!stopValue.equals(result)) continue;
            return result;
        }
        return result;
    }

    public JoinNode getTreatedJoinNode(EntityType<?> type) {
        if (type.getJavaType().isAssignableFrom(this.getJavaType())) {
            return this;
        }
        String typeName = type.getJavaType().getName();
        JoinNode treatedNode = (JoinNode)this.treatedJoinNodes.get(typeName);
        if (treatedNode != null) {
            return treatedNode;
        }
        String alias = this.aliasInfo.getAliasOwner().generateRootAlias(this.aliasInfo.getAlias());
        TreatedJoinAliasInfo treatedJoinAliasInfo = new TreatedJoinAliasInfo(this, type, alias);
        this.aliasInfo.getAliasOwner().registerAliasInfo(treatedJoinAliasInfo);
        treatedNode = new JoinNode(treatedJoinAliasInfo);
        ArrayList<EqPredicate> predicates = new ArrayList<EqPredicate>(1);
        predicates.add(new EqPredicate(this.createExpression(null), treatedNode.createExpression(null)));
        treatedNode.onPredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND, predicates);
        treatedJoinAliasInfo.setJoinNode(treatedNode);
        this.treatedJoinNodes.put(typeName, treatedNode);
        return treatedNode;
    }

    public EnumSet<ClauseType> getClauseDependencies() {
        return this.clauseDependencies;
    }

    public boolean updateClauseDependencies(ClauseType clauseDependency, Set<JoinNode> seenNodes) {
        return this.updateClauseDependencies(clauseDependency, false, false, seenNodes);
    }

    private boolean updateClauseDependencies(ClauseType clauseDependency, boolean forceAdd, boolean forceAddAll, Set<JoinNode> seenNodes) {
        boolean add;
        if (seenNodes != null && !seenNodes.add(this)) {
            StringBuilder errorSb = new StringBuilder();
            errorSb.append("Cyclic join dependency between nodes: ");
            for (JoinNode seenNode : seenNodes) {
                errorSb.append(seenNode.getAliasInfo().getAlias());
                if (seenNode.getAliasInfo().isImplicit()) {
                    errorSb.append('(').append(seenNode.getAliasInfo().getAbsolutePath()).append(')');
                }
                errorSb.append(" -> ");
            }
            errorSb.setLength(errorSb.length() - 4);
            throw new IllegalStateException(errorSb.toString());
        }
        if (this.clauseDependencies.contains((Object)clauseDependency)) {
            if (seenNodes != null) {
                seenNodes.remove(this);
            }
            return true;
        }
        if (clauseDependency != ClauseType.JOIN || forceAddAll) {
            add = true;
        } else if (this.joinType == JoinType.INNER) {
            forceAddAll = this.parentTreeNode == null || this.parentTreeNode.isOptional() || !this.isEmptyCondition();
            add = forceAddAll;
        } else {
            add = false;
        }
        for (JoinNode dependency : this.dependencies) {
            dependency.updateClauseDependencies(clauseDependency, add, forceAddAll, seenNodes);
        }
        if (this.parent != null && !this.dependencies.contains(this.parent)) {
            add = this.parent.updateClauseDependencies(clauseDependency, add, forceAddAll, seenNodes);
        }
        boolean bl = add = add || forceAdd;
        if (add) {
            this.clauseDependencies.add(clauseDependency);
        }
        if (seenNodes != null) {
            seenNodes.remove(this);
        }
        return add;
    }

    public JoinTreeNode getParentTreeNode() {
        return this.parentTreeNode;
    }

    public JoinNode getParent() {
        return this.parent;
    }

    public JoinAliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
        this.onUpdate(StateChange.JOIN_TYPE);
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public boolean hasChildNodes() {
        return !this.nodes.isEmpty() || !this.treatedJoinNodes.isEmpty() || !this.entityJoinNodes.isEmpty();
    }

    public NavigableMap<String, JoinTreeNode> getNodes() {
        return this.nodes;
    }

    public NavigableMap<String, JoinNode> getTreatedJoinNodes() {
        return this.treatedJoinNodes;
    }

    public JoinNode getKeyJoinNode() {
        JoinTreeNode treeNode = this.getOrCreateTreeNode("KEY(" + this.getParentTreeNode().getRelationName() + ")", this.getParentTreeNode().getAttribute());
        return treeNode.getDefaultNode();
    }

    public JoinTreeNode getOrCreateTreeNode(String joinRelationName, Attribute<?, ?> attribute) {
        JoinTreeNode node = (JoinTreeNode)this.nodes.get(joinRelationName);
        if (node == null) {
            node = new JoinTreeNode(joinRelationName, attribute);
            this.nodes.put(joinRelationName, node);
        }
        return node;
    }

    public JoinNode getDefaultJoin(List<PathElementExpression> pathElements, int start, int end) {
        PathElementExpression pathElementExpression = pathElements.get(start);
        JoinTreeNode node = (JoinTreeNode)this.nodes.get(pathElementExpression.toString());
        if (node != null) {
            return node.getDefaultNode();
        }
        return null;
    }

    public boolean hasDefaultJoin(String joinRelationName) {
        JoinTreeNode node = (JoinTreeNode)this.nodes.get(joinRelationName);
        return node != null && node.getDefaultNode() != null;
    }

    public Set<JoinNode> getEntityJoinNodes() {
        return this.entityJoinNodes;
    }

    public void addEntityJoin(JoinNode entityJoinNode) {
        this.entityJoinNodes.add(entityJoinNode);
    }

    public Type<?> getNodeType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        return this.nodeType;
    }

    public EntityType<?> getEntityType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        if (this.nodeType instanceof EntityType) {
            return (EntityType)this.nodeType;
        }
        throw new IllegalArgumentException("Expected type of join node to be an entity but isn't: " + JpaMetamodelUtils.getTypeName(this.nodeType));
    }

    public EntityType<?> getInternalEntityType() {
        if (this.valueType != null) {
            return this.valueType;
        }
        return this.getEntityType();
    }

    public ManagedType<?> getManagedType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        if (this.nodeType instanceof ManagedType) {
            return (ManagedType)this.nodeType;
        }
        throw new IllegalArgumentException("Expected type of join node to be a managed type but isn't: " + JpaMetamodelUtils.getTypeName(this.nodeType));
    }

    public Type<?> getBaseType() {
        return this.nodeType;
    }

    public EntityType<?> getTreatType() {
        return this.treatType;
    }

    public boolean isTreatJoinNode() {
        return this.treatType != null && !(this.aliasInfo instanceof TreatedJoinAliasInfo);
    }

    public boolean isTreatedJoinNode() {
        return this.treatType != null && this.aliasInfo instanceof TreatedJoinAliasInfo;
    }

    public boolean isEntityJoinNode() {
        return this.parentTreeNode == null;
    }

    public boolean isRootJoinNode() {
        return this.parent == null && (this.parentTreeNode == null || this.correlationParent != null);
    }

    public boolean isDefaultJoinNode() {
        return this.aliasInfo.isImplicit();
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public EntityType<?> getValueType() {
        return this.valueType;
    }

    public boolean isValueClazzAttributeSingular() {
        return this.valueClazzAttributeSingular;
    }

    public boolean isValueClazzSimpleValue() {
        return this.valueClazzSimpleValue;
    }

    public String getValuesLikeAttribute() {
        return this.valuesLikeAttribute;
    }

    public String getValueClazzAlias(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.appendValueClazzAlias(sb, prefix);
        return sb.toString();
    }

    public void appendValueClazzAlias(StringBuilder sb, String prefix) {
        if (this.qualificationExpression == null) {
            sb.append(prefix).append(this.valuesLikeAttribute.replace('.', '_'));
        } else {
            sb.append(prefix).append(this.valuesAttributes[0].replace('.', '_')).append('_').append(this.qualificationExpression.toLowerCase());
        }
    }

    public Set<String> getValuesIdNames() {
        return this.valuesIdNames;
    }

    public String getValuesLikeClause() {
        return this.valuesLikeClause;
    }

    String getValuesTypeName() {
        return this.valuesTypeName;
    }

    public String getValuesCastedParameter() {
        return this.valuesCastedParameter;
    }

    public String[] getValuesAttributes() {
        return this.valuesAttributes;
    }

    public JoinNode getCorrelationParent() {
        return this.correlationParent;
    }

    public String getCorrelationPath() {
        return this.correlationPath;
    }

    public CompoundPredicate getOnPredicate() {
        return this.onPredicate;
    }

    public void setOnPredicate(CompoundPredicate onPredicate) {
        this.onPredicate = onPredicate;
        this.onUpdate(StateChange.ON_PREDICATE);
    }

    public Set<JoinNode> getDependencies() {
        return this.dependencies;
    }

    public boolean dependsOn(JoinNode tableReference) {
        if (this.dependencies.contains(tableReference)) {
            return true;
        }
        JoinNode joinNode = this.parent;
        while (joinNode != null) {
            if (tableReference == joinNode || joinNode.getDependencies().contains(tableReference)) {
                return true;
            }
            joinNode = joinNode.parent;
        }
        return false;
    }

    public boolean isCollection(ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector) {
        return this.parentTreeNode != null && this.parentTreeNode.isCollection() && !constantifiedJoinNodeAttributeCollector.isConstantified(this) || this.parentTreeNode == null && !constantifiedJoinNodeAttributeCollector.isConstantified(this);
    }

    List<JoinNode> getJoinNodesNeedingTreatConjunct() {
        return this.joinNodesNeedingTreatConjunct;
    }

    void setJoinNodesNeedingTreatConjunct(List<JoinNode> joinNodesNeedingTreatConjunct) {
        this.joinNodesNeedingTreatConjunct = joinNodesNeedingTreatConjunct;
    }

    List<JoinNode> getJoinNodesForTreatConstraint() {
        return this.joinNodesForTreatConstraint;
    }

    public String getQualificationExpression() {
        return this.qualificationExpression;
    }

    public boolean isQualifiedJoin() {
        return this.qualificationExpression != null;
    }

    public boolean isLateral() {
        return this.lateral;
    }

    public void setInlineCte(CTEInfo inlineCte) {
        this.inlineCte = inlineCte;
    }

    public CTEInfo getInlineCte() {
        return this.inlineCte;
    }

    public boolean isInlineCte() {
        return this.inlineCte != null;
    }

    public void setAllowedDeReferences(Set<String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    public void setDisallowedDeReferenceAlias(String disallowedDeReferenceAlias) {
        this.disallowedDeReferenceAlias = disallowedDeReferenceAlias;
    }

    public String getDisallowedDeReferenceAlias() {
        return this.disallowedDeReferenceAlias;
    }

    public boolean isDisallowedDeReferenceUsed() {
        return this.disallowedDeReferenceUsed;
    }

    public boolean isParent(JoinNode parent) {
        if (this.parent != null) {
            return this.parent == parent || this.parent.isParent(parent);
        }
        return false;
    }

    public Expression createExpression(String field) {
        return this.createExpression(field, false);
    }

    public PathExpression createPathExpression(String field) {
        return (PathExpression)this.createExpression(field, true);
    }

    public Expression createExpression(String field, boolean asPath) {
        ArrayList<Object> pathElements = new ArrayList<Object>();
        if (this.qualificationExpression != null) {
            ArrayList<PropertyExpression> pathElementExpressions = new ArrayList<PropertyExpression>(1);
            pathElementExpressions.add(new PropertyExpression(this.parent.getAlias()));
            PathExpression path = new PathExpression(pathElementExpressions);
            if ("KEY".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new MapKeyExpression(path));
            } else if ("INDEX".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new ListIndexExpression(path));
            } else if ("ENTRY".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new MapEntryExpression(path));
            }
        } else {
            pathElements.add(new PropertyExpression(this.aliasInfo.getAlias()));
        }
        if (field != null) {
            for (String fieldPart : field.split("\\.")) {
                pathElements.add(new PropertyExpression(fieldPart));
            }
        }
        if (!asPath && this.valuesTypeName != null) {
            return new FunctionExpression("FUNCTION", Arrays.asList(new StringLiteral("TREAT_" + this.valuesTypeName.toUpperCase()), new PathExpression(pathElements)));
        }
        return new PathExpression(pathElements);
    }

    public void appendDeReference(StringBuilder sb, String property, boolean externalRepresentation) {
        this.appendDeReference(sb, property, false, externalRepresentation, false);
    }

    public void appendDeReference(StringBuilder sb, String property, boolean renderTreat, boolean externalRepresentation, boolean requiresElementCollectionIdCutoff) {
        boolean wrapperFunction = false;
        if (externalRepresentation || this.allowedAttributes == null || this.allowedAttributes.contains(property)) {
            if (!externalRepresentation && this.deReferenceFunction != null) {
                wrapperFunction = true;
                sb.append(this.deReferenceFunction);
            }
            this.appendAlias(sb, renderTreat, externalRepresentation);
        } else {
            if (this.disallowedDeReferenceAlias == null) {
                this.appendAlias(sb, renderTreat, externalRepresentation);
            } else {
                sb.append(this.disallowedDeReferenceAlias);
            }
            this.disallowedDeReferenceUsed = true;
        }
        if (property != null && this.valuesTypeName == null) {
            if (requiresElementCollectionIdCutoff && this.parentTreeNode != null && this.parentTreeNode.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION && property.endsWith(".id")) {
                sb.append('.').append(property, 0, property.length() - ".id".length());
            } else {
                sb.append('.').append(property);
            }
        }
        if (wrapperFunction) {
            sb.append(')');
        }
    }

    public void appendAlias(StringBuilder sb, boolean externalRepresentation) {
        this.appendAlias(sb, false, externalRepresentation);
    }

    public void appendAlias(StringBuilder sb, boolean renderTreat, boolean externalRepresentation) {
        if (this.valuesTypeName != null) {
            if (externalRepresentation) {
                sb.append(this.aliasInfo.getAlias());
            } else {
                sb.append("TREAT_");
                sb.append(this.valuesTypeName.toUpperCase()).append('(');
                sb.append(this.aliasInfo.getAlias());
                sb.append(".value");
                sb.append(')');
            }
        } else if (this.valuesLikeAttribute != null) {
            if (externalRepresentation) {
                sb.append(this.aliasInfo.getAlias());
            } else if (this.valueClazzAttributeSingular) {
                sb.append(this.aliasInfo.getAlias()).append('.').append(this.valuesLikeAttribute.replace('.', '_'));
            } else if (this.qualificationExpression != null) {
                sb.append(this.qualificationExpression);
                sb.append('(');
                sb.append(this.aliasInfo.getAlias()).append('_').append(this.valuesLikeAttribute.replace('.', '_'));
                sb.append('_').append(this.qualificationExpression.toLowerCase());
                sb.append(')');
            } else {
                sb.append(this.aliasInfo.getAlias()).append('_').append(this.valuesLikeAttribute.replace('.', '_'));
            }
        } else if (this.qualificationExpression != null) {
            boolean hasTreat;
            boolean bl = hasTreat = renderTreat && this.treatType != null;
            if (hasTreat) {
                sb.append("TREAT(");
            }
            sb.append(this.qualificationExpression);
            sb.append('(');
            this.parent.appendAlias(sb, false, externalRepresentation);
            sb.append(')');
            if (hasTreat) {
                sb.append(" AS ");
                sb.append(this.treatType.getName());
                sb.append(')');
            }
        } else if (this.aliasInfo instanceof TreatedJoinAliasInfo) {
            if (renderTreat) {
                sb.append("TREAT(");
            }
            this.parent.appendAlias(sb, false, externalRepresentation);
            if (renderTreat) {
                sb.append(" AS ");
                sb.append(this.treatType.getName());
                sb.append(')');
            }
        } else if (renderTreat) {
            this.aliasInfo.render(sb);
        } else {
            sb.append(this.aliasInfo.getAlias());
        }
    }

    boolean needsDisallowedDeReferenceAlias(boolean externalRepresentation) {
        if (externalRepresentation || this.disallowedDeReferenceAlias == null) {
            return false;
        }
        if (this.disallowedDeReferenceUsed) {
            return true;
        }
        if (this.parent == null) {
            return this.nodes.size() > 1 || !this.treatedJoinNodes.isEmpty() || !this.entityJoinNodes.isEmpty() || this.nodes.firstEntry().getValue().getJoinNodes().size() > 1 || this.nodes.firstEntry().getValue().getDefaultNode().needsDisallowedDeReferenceAlias(externalRepresentation);
        }
        return this.parent.disallowedDeReferenceAlias != null && this.parent.disallowedDeReferenceUsed || this.hasChildNodes();
    }

    public String getDeReferenceFunction() {
        return this.deReferenceFunction;
    }

    public void setDeReferenceFunction(String deReferenceFunction) {
        this.deReferenceFunction = deReferenceFunction;
    }

    public boolean isCrossJoin() {
        return this.crossJoin;
    }

    public void setCrossJoin() {
        this.crossJoin = true;
    }

    public boolean isCollectionDmlNode(boolean externalRepresentation) {
        return externalRepresentation && this.getAlias().indexOf(46) != -1;
    }

    public String getAlias() {
        return this.aliasInfo.getAlias();
    }

    public String getAliasExpression() {
        StringBuilder sb = new StringBuilder();
        this.appendAlias(sb, true, false);
        return sb.toString();
    }

    public Type<?> getType() {
        return this.getNodeType();
    }

    public Class<?> getJavaType() {
        if (this.treatType != null) {
            return this.treatType.getJavaType();
        }
        return this.nodeType.getJavaType();
    }

    public int getJoinDepth() {
        int i = 0;
        JoinNode joinNode = this;
        while ((joinNode = joinNode.getParent()) != null) {
            ++i;
        }
        return i;
    }

    private static enum StateChange {
        JOIN_TYPE,
        ON_PREDICATE,
        CHILD;

    }
}

