/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SplittingParameterTransformer;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.QualifiedExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.parser.util.LiteralFunctionTypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;

public class ResolvingQueryGenerator
extends SimpleQueryGenerator {
    private static final Set<String> BUILT_IN_FUNCTIONS;
    protected String aliasPrefix;
    private boolean resolveSelectAliases = true;
    private boolean externalRepresentation;
    private boolean quantifiedPredicate;
    private Set<JoinNode> renderedJoinNodes;
    private ClauseType clauseType;
    private final EntityMetamodel entityMetamodel;
    private final Set<String> currentlyResolvingAliases;
    private final AliasManager aliasManager;
    private final ParameterManager parameterManager;
    private final AssociationParameterTransformerFactory parameterTransformerFactory;
    private final JpaProvider jpaProvider;
    private final DbmsDialect dbmsDialect;
    private final Map<String, JpqlFunction> registeredFunctions;
    private final Map<String, String> registeredFunctionNames;

    public ResolvingQueryGenerator(EntityMetamodel entityMetamodel, AliasManager aliasManager, ParameterManager parameterManager, AssociationParameterTransformerFactory parameterTransformerFactory, JpaProvider jpaProvider, DbmsDialect dbmsDialect, Map<String, JpqlFunction> registeredFunctions, Map<String, String> registeredFunctionNames) {
        this.entityMetamodel = entityMetamodel;
        this.aliasManager = aliasManager;
        this.parameterManager = parameterManager;
        this.parameterTransformerFactory = parameterTransformerFactory;
        this.jpaProvider = jpaProvider;
        this.dbmsDialect = dbmsDialect;
        this.registeredFunctions = registeredFunctions;
        this.currentlyResolvingAliases = new HashSet<String>();
        this.registeredFunctionNames = registeredFunctionNames;
    }

    public void generate(Expression expression) {
        if (expression instanceof NullExpression && this.clauseType != ClauseType.SET) {
            if (this.externalRepresentation) {
                this.sb.append("NULL");
            } else {
                this.sb.append(this.jpaProvider.getNullExpression());
            }
            return;
        }
        expression.accept((Expression.Visitor)this);
    }

    public void visit(ListIndexExpression expression) {
        PathExpression path = expression.getPath();
        String deReferenceFunction = null;
        if (!this.externalRepresentation && path.getPathReference() != null && (deReferenceFunction = ((JoinNode)path.getPathReference().getBaseNode()).getDeReferenceFunction()) != null) {
            this.sb.append(deReferenceFunction);
        }
        this.sb.append("INDEX(");
        path.accept((Expression.Visitor)this);
        this.sb.append(')');
        if (deReferenceFunction != null) {
            this.sb.append(')');
        }
    }

    public void visit(MapKeyExpression expression) {
        PathExpression path = expression.getPath();
        String deReferenceFunction = null;
        if (!this.externalRepresentation && path.getPathReference() != null && (deReferenceFunction = ((JoinNode)path.getPathReference().getBaseNode()).getDeReferenceFunction()) != null) {
            this.sb.append(deReferenceFunction);
        }
        this.sb.append("KEY(");
        path.accept((Expression.Visitor)this);
        this.sb.append(')');
        if (deReferenceFunction != null) {
            this.sb.append(')');
        }
    }

    public void visit(MapValueExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
    }

    public void visit(FunctionExpression expression) {
        if (this.externalRepresentation && expression.getRealArgument() != null) {
            expression.getRealArgument().accept((Expression.Visitor)this);
            return;
        }
        if (com.blazebit.persistence.parser.util.ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this);
        } else if (ExpressionUtils.isFunctionFunctionExpression(expression)) {
            List arguments = expression.getExpressions();
            String literalFunctionName = ExpressionUtils.unwrapStringLiteral(((Expression)arguments.get(0)).toString());
            String resolvedFunctionName = this.resolveRenderedFunctionName(literalFunctionName);
            List<Object> argumentsWithoutFunctionName = arguments.size() > 1 ? arguments.subList(1, arguments.size()) : Collections.emptyList();
            this.renderFunctionFunction(resolvedFunctionName, false, argumentsWithoutFunctionName, expression.getWithinGroup(), expression.getResolvedWindowDefinition());
        } else if (this.isCountStarFunction(expression)) {
            this.renderCountStar(expression.getResolvedWindowDefinition());
        } else if (BUILT_IN_FUNCTIONS.contains(expression.getFunctionName().toLowerCase()) && expression.getResolvedWindowDefinition() == null) {
            super.visit(expression);
        } else {
            boolean distinct = false;
            if (expression instanceof AggregateExpression) {
                distinct = ((AggregateExpression)expression).isDistinct();
            }
            this.renderFunctionFunction(this.resolveRenderedFunctionName(expression.getFunctionName()), distinct, expression.getExpressions(), expression.getWithinGroup(), expression.getResolvedWindowDefinition());
        }
    }

    private String resolveRenderedFunctionName(String literalFunctionName) {
        String registeredFunctionName = this.registeredFunctionNames.get(literalFunctionName.toLowerCase());
        return registeredFunctionName == null ? literalFunctionName : registeredFunctionName;
    }

    protected void renderCountStar(WindowDefinition windowDefinition) {
        if (this.jpaProvider.supportsCustomFunctions()) {
            if (this.jpaProvider.supportsCountStar() && windowDefinition == null) {
                this.sb.append("COUNT(*)");
            } else if (windowDefinition != null) {
                this.renderFunctionFunction(this.resolveRenderedFunctionName("WINDOW_COUNT"), false, Collections.emptyList(), null, windowDefinition);
            } else {
                this.renderFunctionFunction(this.resolveRenderedFunctionName("COUNT_STAR"), false, Collections.emptyList(), null, null);
            }
        } else {
            if (windowDefinition != null) {
                throw new IllegalArgumentException("JPA provider does not support custom function invocation!");
            }
            this.sb.append("COUNT(1)");
        }
    }

    public void visit(SubqueryExpression expression) {
        if (!this.externalRepresentation && expression.getSubquery() instanceof SubqueryInternalBuilder) {
            boolean isSimple;
            AbstractCommonQueryBuilder subquery = (AbstractCommonQueryBuilder)expression.getSubquery();
            subquery.prepareAndCheck();
            boolean hasFirstResult = subquery.getFirstResult() != 0;
            boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
            boolean hasLimit = hasFirstResult || hasMaxResults;
            boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
            boolean hasEntityFunctions = subquery.joinManager.hasEntityFunctions();
            boolean bl = isSimple = !hasLimit && !hasSetOperations && !hasEntityFunctions;
            if (isSimple) {
                this.sb.append('(');
                subquery.buildBaseQueryString(this.sb, this.externalRepresentation, null, false);
                this.sb.append(')');
            } else {
                if (!this.externalRepresentation) {
                    this.sb.append('(');
                }
                Expression subqueryExpression = subquery.asExpression(this.externalRepresentation, this.quantifiedPredicate);
                if (!this.externalRepresentation && subqueryExpression instanceof SubqueryExpression) {
                    this.sb.append(((SubqueryExpression)subqueryExpression).getSubquery().getQueryString());
                } else {
                    subqueryExpression.accept((Expression.Visitor)this);
                }
                if (!this.externalRepresentation) {
                    this.sb.append(')');
                }
            }
        } else {
            this.sb.append('(');
            this.sb.append(expression.getSubquery().getQueryString());
            this.sb.append(')');
        }
    }

    protected boolean isSimpleSubquery(SubqueryExpression expression) {
        if (!this.externalRepresentation && expression.getSubquery() instanceof SubqueryInternalBuilder) {
            AbstractCommonQueryBuilder subquery = (AbstractCommonQueryBuilder)expression.getSubquery();
            boolean hasFirstResult = subquery.getFirstResult() != 0;
            boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
            boolean hasLimit = hasFirstResult || hasMaxResults;
            boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
            boolean hasEntityFunctions = subquery.joinManager.hasEntityFunctions();
            return !hasLimit && !hasSetOperations && !hasEntityFunctions && !subquery.joinManager.hasLateInlineNodes();
        }
        return super.isSimpleSubquery(expression);
    }

    protected void renderFunctionFunction(String functionName, boolean distinct, List<Expression> arguments, List<OrderByItem> withinGroup, WindowDefinition windowDefinition) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        int size = arguments.size();
        if (this.registeredFunctions.containsKey(functionName)) {
            this.sb.append(this.jpaProvider.getCustomFunctionInvocation(functionName, windowDefinition == null || windowDefinition.isEmpty() ? size : size + 1));
            if (size == 0) {
                if (withinGroup != null && !withinGroup.isEmpty()) {
                    this.visitWithinGroup(withinGroup);
                    if (windowDefinition != null && !windowDefinition.isEmpty()) {
                        this.sb.append(",");
                        this.visitWindowDefinition(windowDefinition);
                    }
                } else {
                    this.visitWindowDefinition(windowDefinition);
                }
            } else {
                if (distinct) {
                    this.sb.append("'DISTINCT',");
                }
                arguments.get(0).accept((Expression.Visitor)this);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    arguments.get(i).accept((Expression.Visitor)this);
                }
                if (withinGroup != null && !withinGroup.isEmpty()) {
                    this.sb.append(",");
                    this.visitWithinGroup(withinGroup);
                }
                if (windowDefinition != null && !windowDefinition.isEmpty()) {
                    this.sb.append(",");
                    this.visitWindowDefinition(windowDefinition);
                }
            }
            this.sb.append(')');
        } else if (this.jpaProvider.supportsJpa21()) {
            this.sb.append("FUNCTION('");
            this.sb.append(functionName);
            this.sb.append('\'');
            if (distinct) {
                this.sb.append(",'DISTINCT'");
            }
            for (int i = 0; i < size; ++i) {
                this.sb.append(',');
                arguments.get(i).accept((Expression.Visitor)this);
            }
            if (withinGroup != null && !withinGroup.isEmpty()) {
                this.sb.append(",");
                this.visitWithinGroup(withinGroup);
            }
            if (windowDefinition != null && !windowDefinition.isEmpty()) {
                this.sb.append(",");
                this.visitWindowDefinition(windowDefinition);
            }
            this.sb.append(')');
        } else {
            throw new IllegalArgumentException("Unknown function [" + functionName + "] is used!");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    protected void visitWithinGroup(List<OrderByItem> withinGroup) {
        int size = withinGroup.size();
        if (size != 0) {
            this.sb.append("'WITHIN GROUP',");
            this.visit(withinGroup.get(0));
            for (int i = 1; i < size; ++i) {
                this.sb.append(",");
                this.visit(withinGroup.get(i));
            }
        }
    }

    protected void visitWindowDefinition(WindowDefinition windowDefinition) {
        if (windowDefinition != null) {
            List orderByExpressions;
            List partitionExpressions;
            int size;
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null) {
                this.sb.append("'FILTER',CASE WHEN ");
                filterPredicate.accept((Expression.Visitor)this);
                this.sb.append(" THEN 1 ELSE 0 END");
            }
            if ((size = (partitionExpressions = windowDefinition.getPartitionExpressions()).size()) != 0) {
                if (filterPredicate != null) {
                    this.sb.append(",");
                }
                this.sb.append("'PARTITION BY',");
                ((Expression)partitionExpressions.get(0)).accept((Expression.Visitor)this);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    ((Expression)partitionExpressions.get(i)).accept((Expression.Visitor)this);
                }
            }
            if ((size = (orderByExpressions = windowDefinition.getOrderByExpressions()).size()) != 0) {
                if (filterPredicate != null || partitionExpressions.size() != 0) {
                    this.sb.append(",");
                }
                this.sb.append("'ORDER BY',");
                this.visit((OrderByItem)orderByExpressions.get(0));
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    this.visit((OrderByItem)orderByExpressions.get(i));
                }
            }
            if (windowDefinition.getFrameMode() != null) {
                if (filterPredicate != null || partitionExpressions.size() != 0 || orderByExpressions.size() != 0) {
                    this.sb.append(",");
                }
                this.sb.append('\'');
                this.sb.append(windowDefinition.getFrameMode().name());
                this.sb.append("'");
                if (windowDefinition.getFrameEndType() != null) {
                    this.sb.append(",'BETWEEN'");
                }
                if (windowDefinition.getFrameStartExpression() != null) {
                    this.sb.append(",");
                    windowDefinition.getFrameStartExpression().accept((Expression.Visitor)this);
                }
                this.sb.append(",'");
                this.sb.append(this.getFrameType(windowDefinition.getFrameStartType()));
                this.sb.append("'");
                if (windowDefinition.getFrameEndType() != null) {
                    this.sb.append(",'AND'");
                    if (windowDefinition.getFrameEndExpression() != null) {
                        this.sb.append(",");
                        windowDefinition.getFrameEndExpression().accept((Expression.Visitor)this);
                    }
                    this.sb.append(",'");
                    this.sb.append(this.getFrameType(windowDefinition.getFrameEndType()));
                    this.sb.append("'");
                }
                if (windowDefinition.getFrameExclusionType() != null) {
                    this.sb.append(",'");
                    this.sb.append(this.getFrameExclusionType(windowDefinition.getFrameExclusionType()));
                    this.sb.append("'");
                }
            }
        }
    }

    private void visit(OrderByItem orderByItem) {
        orderByItem.getExpression().accept((Expression.Visitor)this);
        this.sb.append(",'");
        this.sb.append(orderByItem.isAscending() ? "ASC" : "DESC");
        this.sb.append(orderByItem.isNullFirst() ? " NULLS FIRST" : " NULLS LAST");
        this.sb.append("'");
    }

    private boolean isCountStarFunction(FunctionExpression expression) {
        return expression instanceof AggregateExpression && expression.getExpressions().isEmpty() && "COUNT".equalsIgnoreCase(expression.getFunctionName());
    }

    public void visit(TreatExpression expression) {
        if (this.jpaProvider.supportsRootTreat()) {
            super.visit(expression);
        } else if (this.jpaProvider.supportsSubtypePropertyResolving()) {
            expression.getExpression().accept((Expression.Visitor)this);
        } else {
            throw new IllegalArgumentException("Can not render treat expression[" + expression.toString() + "] as the JPA provider does not support it!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(PathExpression expression) {
        JoinNode baseNode;
        if (this.resolveSelectAliases && expression.getExpressions().size() == 1) {
            String potentialAlias = ((PathElementExpression)expression.getExpressions().get(0)).toString();
            try {
                AliasInfo aliasInfo;
                if (this.currentlyResolvingAliases.add(potentialAlias) && (aliasInfo = this.aliasManager.getAliasInfo(potentialAlias)) != null && aliasInfo instanceof SelectInfo) {
                    SelectInfo selectAliasInfo = (SelectInfo)aliasInfo;
                    if (selectAliasInfo.getExpression() instanceof PathExpression) {
                        PathExpression aliasedExpression = (PathExpression)selectAliasInfo.getExpression();
                        boolean collectionKeyPath = aliasedExpression.isCollectionQualifiedPath();
                        boolean usedInCollectionFunction = aliasedExpression.isUsedInCollectionFunction();
                        aliasedExpression.setCollectionQualifiedPath(expression.isCollectionQualifiedPath());
                        aliasedExpression.setUsedInCollectionFunction(expression.isUsedInCollectionFunction());
                        try {
                            selectAliasInfo.getExpression().accept((Expression.Visitor)this);
                        }
                        finally {
                            aliasedExpression.setCollectionQualifiedPath(collectionKeyPath);
                            aliasedExpression.setUsedInCollectionFunction(usedInCollectionFunction);
                        }
                    } else {
                        selectAliasInfo.getExpression().accept((Expression.Visitor)this);
                    }
                    return;
                }
            }
            finally {
                this.currentlyResolvingAliases.remove(potentialAlias);
            }
        }
        if ((baseNode = (JoinNode)expression.getBaseNode()) == null) {
            super.visit(expression);
        } else {
            String collectionValueFunction = this.jpaProvider.getCollectionValueFunction();
            String field = expression.getField();
            if (field == null) {
                if (expression.isUsedInCollectionFunction() || this.renderAbsolutePath(expression)) {
                    super.visit(expression);
                } else {
                    boolean valueFunction;
                    boolean bl = valueFunction = collectionValueFunction != null && this.needsValueFunction(expression, baseNode, field);
                    if (valueFunction) {
                        this.sb.append(collectionValueFunction);
                        this.sb.append('(');
                    }
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb, this.externalRepresentation);
                    if (valueFunction) {
                        this.sb.append(')');
                    }
                }
            } else {
                List<JoinNode> treatedJoinNodes = baseNode.getJoinNodesForTreatConstraint();
                Type<?> baseNodeType = baseNode.getBaseType();
                boolean addTypeCaseWhen = false;
                if (!treatedJoinNodes.isEmpty() && baseNodeType instanceof EntityType && baseNode.getTreatType() != null && (this.jpaProvider.supportsSubtypePropertyResolving() || !this.jpaProvider.supportsRootTreat())) {
                    ExtendedManagedType extendedManagedType = (ExtendedManagedType)this.entityMetamodel.getManagedType(ExtendedManagedType.class, baseNode.getTreatType().getName());
                    ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedManagedType.getAttributes().get(field);
                    if (extendedAttribute.isColumnShared()) {
                        addTypeCaseWhen = this.jpaProvider.needsTypeConstraintForColumnSharing();
                    } else {
                        ExtendedAttribute baseTypeAttribute = (ExtendedAttribute)((ExtendedManagedType)this.entityMetamodel.getManagedType(ExtendedManagedType.class, ((EntityType)baseNode.getBaseType()).getName())).getAttributes().get(field);
                        boolean bl = addTypeCaseWhen = baseTypeAttribute != null && !baseNode.getTreatType().getJavaType().isAssignableFrom(((Attribute)baseTypeAttribute.getAttributePath().get(0)).getDeclaringType().getJavaType());
                    }
                }
                if (addTypeCaseWhen) {
                    this.sb.append("CASE WHEN ");
                    boolean first = true;
                    for (int i = 0; i < treatedJoinNodes.size(); ++i) {
                        JoinNode treatedJoinNode = treatedJoinNodes.get(i);
                        if (this.jpaProvider.supportsTreatJoin() && treatedJoinNode.isTreatJoinNode()) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.sb.append(" AND ");
                        }
                        this.sb.append("TYPE(");
                        treatedJoinNode.appendAlias(this.sb, this.externalRepresentation);
                        this.sb.append(") IN (");
                        for (EntityType entitySubtype : this.entityMetamodel.getEntitySubtypes(treatedJoinNode.getTreatType())) {
                            this.sb.append(entitySubtype.getName());
                            this.sb.append(", ");
                        }
                        this.sb.setLength(this.sb.length() - 2);
                        this.sb.append(')');
                    }
                    if (first) {
                        this.sb.setLength(this.sb.length() - "CASE WHEN ".length());
                        addTypeCaseWhen = false;
                    } else {
                        this.sb.append(" THEN ");
                    }
                }
                boolean valueFunction = collectionValueFunction != null && this.needsValueFunction(expression, baseNode, field);
                boolean renderTreat = this.jpaProvider.supportsRootTreat();
                if (valueFunction) {
                    this.sb.append(collectionValueFunction);
                    this.sb.append('(');
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb, renderTreat, this.externalRepresentation);
                    this.sb.append(')');
                    this.sb.append(".").append(field);
                } else {
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendDeReference(this.sb, field, renderTreat, this.externalRepresentation, this.jpaProvider.needsElementCollectionIdCutoff());
                }
                if (addTypeCaseWhen) {
                    if (this.jpaProvider.needsCaseWhenElseBranch()) {
                        this.sb.append(" ELSE NULL");
                    }
                    this.sb.append(" END");
                }
            }
        }
    }

    private boolean needsValueFunction(PathExpression expression, JoinNode baseNode, String field) {
        return !expression.isCollectionQualifiedPath() && baseNode.getParentTreeNode() != null && baseNode.getParentTreeNode().isMap() && (field == null || this.jpaProvider.supportsCollectionValueDereference());
    }

    private boolean renderAbsolutePath(PathExpression expression) {
        JoinNode baseNode = (JoinNode)expression.getBaseNode();
        return this.renderedJoinNodes != null && !this.renderedJoinNodes.contains(baseNode);
    }

    protected boolean needsParenthesisForCaseResult(Expression expression) {
        return expression instanceof ArithmeticExpression;
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return this.jpaProvider.getBooleanConditionalExpression(value);
    }

    protected String getBooleanExpression(boolean value) {
        return this.jpaProvider.getBooleanExpression(value);
    }

    protected String escapeCharacter(char character) {
        return this.jpaProvider.escapeCharacter(character);
    }

    protected void renderLikePattern(LikePredicate predicate) {
        Character defaultEscapeCharacter;
        if (!this.externalRepresentation && !this.jpaProvider.supportsLikePatternEscape() && predicate.getEscapeCharacter() == null && (defaultEscapeCharacter = this.dbmsDialect.getDefaultEscapeCharacter()) != null) {
            if (predicate.getRight() instanceof StringLiteral) {
                TypeUtils.STRING_CONVERTER.appendTo((Object)((StringLiteral)predicate.getRight()).getValue().replace(defaultEscapeCharacter.toString(), defaultEscapeCharacter.toString() + defaultEscapeCharacter), this.sb);
            } else {
                this.sb.append(this.jpaProvider.getCustomFunctionInvocation("REPLACE", 1));
                predicate.getRight().accept((Expression.Visitor)this);
                this.sb.append(", ").append("'").append(defaultEscapeCharacter).append(defaultEscapeCharacter).append("'");
                this.sb.append(", ").append("'").append(defaultEscapeCharacter).append(defaultEscapeCharacter).append(defaultEscapeCharacter).append(defaultEscapeCharacter).append("'");
                this.sb.append(")");
            }
        } else {
            predicate.getRight().accept((Expression.Visitor)this);
        }
    }

    public void visit(ParameterExpression expression) {
        ParameterManager.ParameterImpl<?> parameter;
        boolean needsBrackets;
        boolean bl = needsBrackets = this.jpaProvider.needsBracketsForListParameter() && expression.isCollectionValued();
        if (needsBrackets) {
            this.sb.append('(');
        }
        if ((parameter = this.parameterManager.getParameter(expression.getName())).isUsedInGroupBy()) {
            SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.LITERAL);
            super.visit(expression);
            this.setParameterRenderingMode(oldParameterRenderingMode);
        } else {
            super.visit(expression);
        }
        if (needsBrackets) {
            this.sb.append(')');
        }
    }

    public void visit(DateLiteral expression) {
        if (this.jpaProvider.supportsTemporalLiteral()) {
            super.visit(expression);
        } else {
            java.util.Date value = expression.getValue();
            if (value instanceof Date) {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.DATE_CONVERTER, (Date)value);
            } else {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.DATE_AS_DATE_CONVERTER, value);
            }
        }
    }

    public void visit(TimeLiteral expression) {
        if (this.jpaProvider.supportsTemporalLiteral()) {
            super.visit(expression);
        } else {
            java.util.Date value = expression.getValue();
            if (value instanceof Time) {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.TIME_CONVERTER, (Time)value);
            } else {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.DATE_AS_TIME_CONVERTER, value);
            }
        }
    }

    public void visit(TimestampLiteral expression) {
        if (this.jpaProvider.supportsTemporalLiteral()) {
            super.visit(expression);
        } else {
            java.util.Date value = expression.getValue();
            if (value instanceof Timestamp) {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.TIMESTAMP_CONVERTER, (Timestamp)value);
            } else {
                this.appendTemporalLiteralEmulation((LiteralFunctionTypeConverter)TypeUtils.DATE_TIMESTAMP_CONVERTER, value);
            }
        }
    }

    private <T> void appendTemporalLiteralEmulation(LiteralFunctionTypeConverter<? super T> converter, T value) {
        String functionInvocation = this.jpaProvider.getCustomFunctionInvocation(converter.getLiteralFunctionName(), 1);
        String literalValue = converter.toString(value);
        this.sb.append(functionInvocation);
        TypeUtils.STRING_CONVERTER.appendTo((Object)literalValue, this.sb);
        this.sb.append(')');
    }

    protected Set<String> getSupportedEnumTypes() {
        return this.entityMetamodel.getEnumTypes().keySet();
    }

    protected String getLiteralParameterValue(ParameterExpression expression) {
        boolean renderEnumAsLiteral = this.getBooleanLiteralRenderingContext() == SimpleQueryGenerator.BooleanLiteralRenderingContext.PLAIN;
        return this.parameterManager.getLiteralParameterValue(expression, renderEnumAsLiteral);
    }

    public void setResolveSelectAliases(boolean replaceSelectAliases) {
        this.resolveSelectAliases = replaceSelectAliases;
    }

    public boolean isResolveSelectAliases() {
        return this.resolveSelectAliases;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public void addAlias(String alias) {
        this.currentlyResolvingAliases.add(alias);
    }

    public void removeAlias(String alias) {
        this.currentlyResolvingAliases.remove(alias);
    }

    public void setRenderedJoinNodes(Set<JoinNode> renderedJoinNodes) {
        this.renderedJoinNodes = renderedJoinNodes;
    }

    public ClauseType getClauseType() {
        return this.clauseType;
    }

    public void setClauseType(ClauseType clauseType) {
        this.clauseType = clauseType;
    }

    public boolean isExternalRepresentation() {
        return this.externalRepresentation;
    }

    public void setExternalRepresentation(boolean externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public void visit(ArrayExpression expression) {
    }

    public void visit(InPredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = true;
        if (predicate.getRight().size() == 1 && this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            Expression right = (Expression)predicate.getRight().get(0);
            if (right instanceof ParameterExpression) {
                ParameterExpression parameterExpression = (ParameterExpression)right;
                Type<?> associationType = this.getAssociationType(predicate.getLeft(), right);
                if (associationType instanceof EntityType) {
                    this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
                } else {
                    super.visit(predicate);
                }
            } else if (right instanceof PathExpression) {
                this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
            } else {
                super.visit(predicate);
            }
        } else {
            super.visit(predicate);
        }
        this.quantifiedPredicate = quantifiedPredicate;
    }

    private Type<?> getAssociationType(Expression expression1, Expression expression2) {
        if (expression1 instanceof PathExpression) {
            return ((PathExpression)expression1).getPathReference().getType();
        }
        return ((PathExpression)expression2).getPathReference().getType();
    }

    public void visit(EqPredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = predicate.getQuantifier() != PredicateQuantifier.ONE;
        this.renderEquality(predicate.getLeft(), predicate.getRight(), predicate.isNegated(), predicate.getQuantifier());
        this.quantifiedPredicate = quantifiedPredicate;
    }

    private void renderEquality(Expression left, Expression right, boolean negated, PredicateQuantifier quantifier) {
        String operator = negated ? " <> " : " = ";
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PLAIN);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        Expression expressionToSplit = this.needsEmbeddableSplitting(left, right);
        if (this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            boolean rewritten = this.renderAssociationIdIfPossible(left);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            if (rewritten |= this.renderAssociationIdIfPossible(right)) {
                this.rewriteToIdParam(left);
                this.rewriteToIdParam(right);
            }
        } else if (expressionToSplit == null || this.dbmsDialect.supportsAnsiRowValueConstructor() || !(left instanceof ParameterExpression) && !(right instanceof ParameterExpression)) {
            left.accept((Expression.Visitor)this);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            right.accept((Expression.Visitor)this);
        } else {
            PathExpression pathExpression = (PathExpression)expressionToSplit;
            ParameterExpression parameterExpression = left instanceof ParameterExpression ? (ParameterExpression)left : (ParameterExpression)right;
            PathReference pathReference = pathExpression.getPathReference();
            EmbeddableType embeddableType = (EmbeddableType)pathReference.getType();
            String parameterName = parameterExpression.getName();
            HashMap<String, List<String>> parameterAccessPaths = new HashMap<String, List<String>>();
            ParameterManager.ParameterImpl<?> parameter = this.parameterManager.getParameter(parameterName);
            this.sb.append('(');
            for (Attribute attribute : embeddableType.getAttributes()) {
                ((JoinNode)pathReference.getBaseNode()).appendDeReference(this.sb, pathReference.getField() + "." + attribute.getName(), this.externalRepresentation);
                String embeddedPropertyName = attribute.getName();
                String subParamName = "_" + parameterName + "_" + embeddedPropertyName.replace('.', '_');
                this.sb.append(operator);
                this.sb.append(":").append(subParamName);
                if (parameter.getTransformer() == null) {
                    this.parameterManager.registerParameterName(subParamName, false, null, null);
                }
                parameterAccessPaths.put(subParamName, Arrays.asList(embeddedPropertyName.split("\\.")));
                this.sb.append(" AND ");
            }
            this.sb.setLength(this.sb.length() - " AND ".length());
            this.sb.append(')');
            if (parameter.getTransformer() == null) {
                parameter.setTransformer(new SplittingParameterTransformer(this.parameterManager, this.entityMetamodel, embeddableType.getJavaType(), parameterAccessPaths));
            }
        }
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private Expression needsEmbeddableSplitting(Expression left, Expression right) {
        Expression l = this.needsEmbeddableSplitting(left);
        if (l != null) {
            return l;
        }
        return this.needsEmbeddableSplitting(right);
    }

    private Expression needsEmbeddableSplitting(Expression expr) {
        JoinNode joinNode;
        PathReference pathReference;
        if (expr instanceof MapKeyExpression ? (pathReference = ((QualifiedExpression)expr).getPath().getPathReference()) != null && (joinNode = (JoinNode)pathReference.getBaseNode()).getDeReferenceFunction() != null && ((MapAttribute)joinNode.getParentTreeNode().getAttribute()).getKeyType() instanceof EmbeddableType : expr instanceof PathExpression && (pathReference = ((PathExpression)expr).getPathReference()) != null && (joinNode = (JoinNode)pathReference.getBaseNode()).getDeReferenceFunction() != null && pathReference.getType() instanceof EmbeddableType) {
            return expr;
        }
        return null;
    }

    private boolean renderAssociationIdIfPossible(Expression expression) {
        expression.accept((Expression.Visitor)this);
        if (expression instanceof PathExpression) {
            Type pathType;
            PathExpression pathExpression = (PathExpression)expression;
            if ((!this.jpaProvider.needsBrokenAssociationToIdRewriteInOnClause() || pathExpression.getBaseNode() != null && pathExpression.getField() != null) && (pathType = pathExpression.getPathReference().getType()) instanceof ManagedType && JpaMetamodelUtils.isIdentifiable((ManagedType)((ManagedType)pathType))) {
                String idName = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((IdentifiableType)pathType)).getName();
                this.sb.append('.');
                this.sb.append(idName);
                return true;
            }
        }
        return false;
    }

    private void rewriteToIdParam(Expression expression) {
        if (!(expression instanceof ParameterExpression)) {
            return;
        }
        ParameterExpression parameterExpression = (ParameterExpression)expression;
        ParameterManager.ParameterImpl<?> param = this.parameterManager.getParameter(parameterExpression.getName());
        param.setTransformer(this.parameterTransformerFactory.getToIdTransformer());
    }

    public void visit(IsNullPredicate predicate) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        predicate.getExpression().accept((Expression.Visitor)this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT NULL");
        } else {
            this.sb.append(" IS NULL");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    public void visit(ExistsPredicate predicate) {
        SubqueryExpression subqueryExpression;
        if (predicate.getExpression() instanceof SubqueryExpression && !this.isSimpleSubquery(subqueryExpression = (SubqueryExpression)predicate.getExpression())) {
            if (this.externalRepresentation) {
                if (predicate.isNegated()) {
                    this.sb.append("NOT EXISTS ");
                } else {
                    this.sb.append("EXISTS ");
                }
                this.sb.append('(');
                predicate.getExpression().accept((Expression.Visitor)this);
                this.sb.append(')');
            } else {
                this.sb.append("1 = ");
                this.sb.append(this.jpaProvider.getCustomFunctionInvocation("exist", 1));
                subqueryExpression.accept((Expression.Visitor)this);
                if (predicate.isNegated()) {
                    this.sb.append(",1");
                }
                this.sb.append(")");
            }
        } else {
            super.visit(predicate);
        }
    }

    public void visit(GtPredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = predicate.getQuantifier() != PredicateQuantifier.ONE;
        super.visit(predicate);
        this.quantifiedPredicate = quantifiedPredicate;
    }

    public void visit(GePredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = predicate.getQuantifier() != PredicateQuantifier.ONE;
        super.visit(predicate);
        this.quantifiedPredicate = quantifiedPredicate;
    }

    public void visit(LtPredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = predicate.getQuantifier() != PredicateQuantifier.ONE;
        super.visit(predicate);
        this.quantifiedPredicate = quantifiedPredicate;
    }

    public void visit(LePredicate predicate) {
        boolean quantifiedPredicate = this.quantifiedPredicate;
        this.quantifiedPredicate = predicate.getQuantifier() != PredicateQuantifier.ONE;
        super.visit(predicate);
        this.quantifiedPredicate = quantifiedPredicate;
    }

    public void visit(CompoundPredicate predicate) {
        boolean parenthesisRequired;
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldConditionalContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        boolean bl = parenthesisRequired = predicate.getChildren().size() > 1;
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
            if (parenthesisRequired) {
                this.sb.append('(');
            }
        }
        if (predicate.getChildren().size() == 1) {
            ((Predicate)predicate.getChildren().get(0)).accept((Expression.Visitor)this);
            return;
        }
        int startLen = this.sb.length();
        String operator = " " + predicate.getOperator().toString() + " ";
        List children = predicate.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Predicate child = (Predicate)children.get(i);
            if (child instanceof CompoundPredicate && ((CompoundPredicate)child).getOperator() != predicate.getOperator() && !child.isNegated()) {
                this.sb.append("(");
                int len = this.sb.length();
                child.accept((Expression.Visitor)this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    continue;
                }
                this.sb.append(")");
                this.sb.append(operator);
                continue;
            }
            child.accept((Expression.Visitor)this);
            this.sb.append(operator);
        }
        if (startLen < this.sb.length()) {
            this.sb.delete(this.sb.length() - operator.length(), this.sb.length());
        }
        if (predicate.isNegated() && parenthesisRequired) {
            this.sb.append(')');
        }
        this.setBooleanLiteralRenderingContext(oldConditionalContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    static {
        HashSet<String> functions = new HashSet<String>();
        functions.add("concat");
        functions.add("substring");
        functions.add("lower");
        functions.add("upper");
        functions.add("length");
        functions.add("locate");
        functions.add("abs");
        functions.add("sqrt");
        functions.add("mod");
        functions.add("coalesce");
        functions.add("nullif");
        functions.add("size");
        functions.add("type");
        functions.add("avg");
        functions.add("max");
        functions.add("min");
        functions.add("sum");
        functions.add("count");
        functions.add("current_date");
        functions.add("current_time");
        functions.add("current_timestamp");
        BUILT_IN_FUNCTIONS = functions;
    }
}

