/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.util.ArrayList;
import java.util.List;

public class SimpleCaseWhenBuilderImpl<T>
implements SimpleCaseWhenBuilder<T>,
ExpressionBuilder {
    private final T result;
    private final Expression caseOperandExpression;
    private final List<WhenClauseExpression> whenExpressions;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private final ExpressionBuilderEndedListener listener;
    private SimpleCaseExpression expression;

    public SimpleCaseWhenBuilderImpl(T result, ExpressionBuilderEndedListener listener, ExpressionFactory expressionFactory, Expression caseOperandExpression, SubqueryInitiatorFactory subqueryInitFactory, ParameterManager parameterManager, ClauseType clauseType) {
        this.result = result;
        this.caseOperandExpression = caseOperandExpression;
        this.subqueryInitFactory = subqueryInitFactory;
        this.parameterManager = parameterManager;
        this.clauseType = clauseType;
        this.whenExpressions = new ArrayList<WhenClauseExpression>();
        this.expressionFactory = expressionFactory;
        this.listener = listener;
    }

    public SimpleCaseWhenBuilder<T> when(String condition, String thenExpression) {
        this.whenExpressions.add(new WhenClauseExpression(this.expressionFactory.createSimpleExpression(condition, false), this.expressionFactory.createSimpleExpression(thenExpression, false)));
        return this;
    }

    public T otherwiseLiteral(Object elseValue) {
        if (this.whenExpressions.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        String literal = TypeUtils.asLiteral((Object)elseValue, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.otherwiseValue(elseValue);
        }
        this.expression = new SimpleCaseExpression(this.caseOperandExpression, this.whenExpressions, this.expressionFactory.createInItemExpression(literal));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T otherwiseValue(Object value) {
        if (this.whenExpressions.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        this.expression = new SimpleCaseExpression(this.caseOperandExpression, this.whenExpressions, (Expression)this.parameterManager.addParameterExpression(value, this.clauseType, this.subqueryInitFactory.getQueryBuilder()));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T otherwise(String elseExpression) {
        if (this.whenExpressions.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        this.expression = new SimpleCaseExpression(this.caseOperandExpression, this.whenExpressions, this.expressionFactory.createSimpleExpression(elseExpression, false));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }
}

