/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateManager;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.predicate.HavingOrBuilderImpl;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import java.util.Set;

public class HavingManager<T>
extends PredicateManager<T> {
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;

    HavingManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor) {
        super(queryGenerator, parameterManager, subqueryInitFactory, expressionFactory);
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
    }

    @Override
    protected String getClauseName() {
        return "HAVING";
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.HAVING;
    }

    HavingOrBuilderImpl<T> havingOr(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        return this.rootPredicate.startBuilder(new HavingOrBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    void buildImplicitGroupByClauses(GroupByManager groupByManager, boolean hasGroupBy, JoinVisitor joinVisitor) {
        if (this.rootPredicate.getPredicate().getChildren().isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.queryGenerator.setQueryBuffer(sb);
        this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        Set<Expression> extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions((Expression)this.rootPredicate.getPredicate(), this.getClauseType());
        if (!extractedGroupByExpressions.isEmpty()) {
            for (Expression expr : extractedGroupByExpressions) {
                this.queryGenerator.generate(expr);
                groupByManager.collect(new ResolvedExpression(sb.toString(), expr), ClauseType.HAVING, hasGroupBy, joinVisitor);
                sb.setLength(0);
            }
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
        this.groupByExpressionGatheringVisitor.clear();
    }

    public boolean isEmpty() {
        return this.rootPredicate.getPredicate().getChildren().isEmpty();
    }
}

