/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.CaseWhenAndBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenAndBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.util.TypeUtils;

public class CaseWhenOrThenBuilderImpl<T extends CaseWhenBuilder<?>>
extends PredicateBuilderEndedListenerImpl
implements CaseWhenOrThenBuilder<T>,
ExpressionBuilder {
    private final T result;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private final CompoundPredicate predicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.OR);
    private final ExpressionBuilderEndedListener listener;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<CaseWhenOrThenBuilder<T>>>();
    private WhenClauseExpression whenClause;

    public CaseWhenOrThenBuilderImpl(T result, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clauseType) {
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
        this.clauseType = clauseType;
    }

    public RestrictionBuilder<CaseWhenOrThenBuilder<T>> or(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery() {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, this.clauseType);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery(String subqueryAlias, String expression) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false, this.clauseType);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clauseType);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubqueries(String expression) {
        return this.startMultipleSubqueryInitiator(this.expressionFactory.createSimpleExpression(expression));
    }

    private MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> startMultipleSubqueryInitiator(Expression expression) {
        this.verifyBuilderEnded();
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> initiator = new MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenOrThenBuilder<T>>>(restrictionBuilder, expression, null, this.subqueryInitFactory, this.clauseType);
        return initiator;
    }

    public SubqueryInitiator<CaseWhenOrThenBuilder<T>> orExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener, true, this.clauseType);
    }

    public SubqueryInitiator<CaseWhenOrThenBuilder<T>> orNotExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener, true, this.clauseType);
    }

    public SubqueryBuilder<CaseWhenOrThenBuilder<T>> orExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightSubqueryPredicateBuilderListener, true, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<CaseWhenOrThenBuilder<T>> orNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightSubqueryPredicateBuilderListener, true, criteriaBuilder, this.clauseType);
    }

    public CaseWhenAndBuilder<CaseWhenOrThenBuilder<T>> and() {
        return this.startBuilder(new CaseWhenAndBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public T thenExpression(String expression) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No or clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, this.expressionFactory.createSimpleExpression(expression, false));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T thenLiteral(Object value) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No and clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.then(value);
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, this.expressionFactory.createInItemExpression(literal));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T then(Object value) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No or clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, (Expression)this.parameterManager.addParameterExpression(value, this.clauseType, this.subqueryInitFactory.getQueryBuilder()));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        this.predicate.getChildren().add(builder.getPredicate());
    }

    @Override
    public Expression getExpression() {
        return this.whenClause;
    }
}

