/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.dialect.MySQLDbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DeleteJoinStyle;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import com.blazebit.persistence.spi.ValuesStrategy;
import java.util.HashMap;
import java.util.Map;

public class MySQLDbmsDialect
extends DefaultDbmsDialect {
    public MySQLDbmsDialect() {
        super(MySQLDbmsDialect.getSqlTypes());
    }

    public MySQLDbmsDialect(Map<Class<?>, String> childSqlTypes) {
        super(childSqlTypes);
    }

    protected static Map<Class<?>, String> getSqlTypes() {
        HashMap types = new HashMap();
        types.put(Character.class, "char");
        types.put(String.class, "char");
        types.put(Short.class, "signed");
        types.put(Integer.class, "signed");
        types.put(Long.class, "signed");
        types.put(Boolean.class, "unsigned");
        return types;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return false;
    }

    @Override
    public boolean supportsWithClause() {
        return false;
    }

    @Override
    public boolean supportsNonRecursiveWithClause() {
        return false;
    }

    @Override
    public boolean isNullSmallest() {
        return true;
    }

    @Override
    public boolean requiresNullCast() {
        return false;
    }

    @Override
    public LateralStyle getLateralStyle() {
        return LateralStyle.NONE;
    }

    @Override
    public DeleteJoinStyle getDeleteJoinStyle() {
        return DeleteJoinStyle.FROM;
    }

    @Override
    public UpdateJoinStyle getUpdateJoinStyle() {
        return UpdateJoinStyle.REFERENCE;
    }

    @Override
    public boolean supportsArbitraryLengthMultiset() {
        return true;
    }

    @Override
    public String getDummyTable() {
        return "dual";
    }

    @Override
    public String getWithClause(boolean recursive) {
        throw new UnsupportedOperationException("With clause is not supported!");
    }

    @Override
    public boolean supportsUnion(boolean all) {
        return true;
    }

    @Override
    public boolean supportsIntersect(boolean all) {
        return false;
    }

    @Override
    public boolean supportsExcept(boolean all) {
        return false;
    }

    @Override
    public boolean supportsGroupByExpressionInHavingMatching() {
        return false;
    }

    @Override
    public boolean supportsFullRowValueComparison() {
        return true;
    }

    @Override
    public boolean supportsCountTuple() {
        return true;
    }

    @Override
    public DbmsLimitHandler createLimitHandler() {
        return new MySQLDbmsLimitHandler();
    }

    @Override
    public boolean supportsLimitInQuantifiedPredicateSubquery() {
        return false;
    }

    @Override
    public boolean supportsNestedCorrelations() {
        return false;
    }

    @Override
    public void appendOrderByElement(StringBuilder sqlSb, OrderByElement element, String[] aliases) {
        if (!element.isNullable()) {
            super.appendOrderByElement(sqlSb, element, aliases);
        } else {
            this.appendEmulatedOrderByElementWithNulls(sqlSb, element, aliases);
        }
    }

    @Override
    public ValuesStrategy getValuesStrategy() {
        return ValuesStrategy.SELECT_UNION;
    }

    @Override
    public boolean needsUniqueSelectItemNamesAlsoWhenTableColumnAliasing() {
        return false;
    }

    @Override
    public boolean needsCastParameters() {
        return false;
    }

    @Override
    protected boolean needsAliasForFromClause() {
        return true;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }
}

