/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.plan.CustomModificationQueryPlan;
import com.blazebit.persistence.impl.plan.CustomReturningModificationQueryPlan;
import com.blazebit.persistence.impl.plan.ModificationQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class ModificationQuerySpecification<T>
extends CustomQuerySpecification<T> {
    protected final Query exampleQuery;
    protected final boolean isEmbedded;
    protected final String[] returningColumns;
    protected final Map<DbmsModificationState, String> includedModificationStates;
    protected final Map<String, String> returningAttributeBindingMap;
    protected final ReturningObjectBuilder<T> objectBuilder;
    protected Query query;

    public ModificationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Query exampleQuery, Collection<? extends Parameter<?>> parameters, Set<String> parameterListNames, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean isEmbedded, String[] returningColumns, ReturningObjectBuilder<T> objectBuilder, Map<DbmsModificationState, String> includedModificationStates, Map<String, String> returningAttributeBindingMap, boolean queryPlanCacheEnabled) {
        this(commonQueryBuilder, baseQuery, exampleQuery, parameters, parameterListNames, Collections.emptyList(), Collections.emptyList(), recursive, ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, returningAttributeBindingMap, queryPlanCacheEnabled);
    }

    public ModificationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Query exampleQuery, Collection<? extends Parameter<?>> parameters, Set<String> parameterListNames, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean isEmbedded, String[] returningColumns, ReturningObjectBuilder<T> objectBuilder, Map<DbmsModificationState, String> includedModificationStates, Map<String, String> returningAttributeBindingMap, boolean queryPlanCacheEnabled) {
        super(commonQueryBuilder, baseQuery, parameters, parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes, queryPlanCacheEnabled, null);
        this.exampleQuery = exampleQuery;
        this.isEmbedded = isEmbedded;
        this.returningColumns = returningColumns;
        this.objectBuilder = objectBuilder;
        this.includedModificationStates = includedModificationStates;
        this.returningAttributeBindingMap = new HashMap<String, String>(returningAttributeBindingMap);
    }

    @Override
    public ModificationQueryPlan createModificationPlan(int firstResult, int maxResults) {
        String finalSql;
        this.dirty |= this.extendedQuerySupport.applyFirstResultMaxResults(this.baseQuery, firstResult, maxResults);
        String sql = this.getSql();
        if (!(this.extendedQuerySupport.getSqlContainsLimit() || firstResult == 0 && maxResults == Integer.MAX_VALUE)) {
            DbmsLimitHandler limitHandler = this.dbmsDialect.createLimitHandler();
            finalSql = limitHandler.applySqlInlined(sql, false, Integer.valueOf(maxResults), Integer.valueOf(firstResult));
        } else {
            finalSql = sql;
        }
        if (this.returningColumns == null) {
            return new CustomModificationQueryPlan(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.query, this.participatingQueries, finalSql, this.queryPlanCacheEnabled);
        }
        return new CustomReturningModificationQueryPlan<T>(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.exampleQuery, this.objectBuilder, this.participatingQueries, finalSql, firstResult, maxResults, this.returningColumns.length == 1 && this.objectBuilder != null, this.queryPlanCacheEnabled);
    }

    @Override
    public SelectQueryPlan<T> createSelectPlan(int firstResult, int maxResults) {
        if (this.returningColumns == null) {
            throw new UnsupportedOperationException();
        }
        this.dirty |= this.extendedQuerySupport.applyFirstResultMaxResults(this.baseQuery, firstResult, maxResults);
        this.extendedQuerySupport.applyFirstResultMaxResults(this.exampleQuery, firstResult, maxResults);
        String sql = this.getSql();
        return new CustomReturningModificationQueryPlan<T>(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.exampleQuery, this.objectBuilder, this.participatingQueries, sql, firstResult, maxResults, this.returningColumns.length == 1 && this.objectBuilder != null, this.queryPlanCacheEnabled);
    }

    @Override
    public Query getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    protected void initialize() {
        String affectedDmlTable;
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        for (Map.Entry entry : this.listParameters.entrySet()) {
            this.baseQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        String sqlQuery = this.extendedQuerySupport.getSql(this.em, this.baseQuery);
        if (this.statementType == DbmsStatementType.UPDATE) {
            affectedDmlTable = sqlQuery.substring(sqlQuery.indexOf(32) + 1, sqlQuery.indexOf(32, sqlQuery.indexOf(32) + 1));
        } else if (this.statementType == DbmsStatementType.DELETE) {
            int fromIndex = SqlUtils.indexOfFrom(sqlQuery);
            int endIndex = sqlQuery.indexOf(32, fromIndex + " from ".length() + 1);
            affectedDmlTable = sqlQuery.substring(fromIndex + " from ".length(), endIndex == -1 ? sqlQuery.length() : endIndex);
        } else if (this.statementType == DbmsStatementType.INSERT) {
            int intoIndex = sqlQuery.indexOf(" into ");
            affectedDmlTable = sqlQuery.substring(intoIndex + " into ".length(), sqlQuery.indexOf(40, intoIndex + " into ".length() + 1));
        } else {
            throw new UnsupportedOperationException("Unsupported statement type: " + this.statementType);
        }
        StringBuilder sqlSb = this.applySqlTransformations(sqlQuery);
        StringBuilder withClause = this.applyCtes(sqlSb, this.baseQuery, participatingQueries);
        Map<String, String> addedCtes = this.applyExtendedSql(sqlSb, false, this.isEmbedded, withClause, affectedDmlTable, this.returningColumns, this.includedModificationStates);
        participatingQueries.add(this.baseQuery);
        participatingQueries.add(this.exampleQuery);
        boolean hasCtes = withClause != null && withClause.length() != 0 || addedCtes != null && !addedCtes.isEmpty();
        this.query = hasCtes && this.returningAttributeBindingMap.isEmpty() && !this.dbmsDialect.usesExecuteUpdateWhenWithClauseInModificationQuery() ? this.exampleQuery : this.baseQuery;
        this.sql = sqlSb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }
}

