/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.ConstantifiedJoinNodeAttributeCollector;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.parser.AliasReplacementVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TemporalLiteral;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedManagedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class ExpressionUtils {
    private static final AbortableVisitorAdapter SUBQUERY_EXPRESSION_DETECTOR = new AbortableVisitorAdapter(){

        public Boolean visit(SubqueryExpression expression) {
            return true;
        }
    };
    private static final AbortableVisitorAdapter SIZE_EXPRESSION_DETECTOR = new AbortableVisitorAdapter(){

        public Boolean visit(FunctionExpression expression) {
            if (com.blazebit.persistence.parser.util.ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
                return true;
            }
            return super.visit(expression);
        }
    };

    private ExpressionUtils() {
    }

    public static String unwrapStringLiteral(String stringLiteral) {
        if (stringLiteral.length() >= 2 && stringLiteral.startsWith("'") && stringLiteral.endsWith("'")) {
            return stringLiteral.substring(1, stringLiteral.length() - 1);
        }
        return stringLiteral;
    }

    public static boolean isFunctionFunctionExpression(FunctionExpression func) {
        return "FUNCTION".equalsIgnoreCase(func.getFunctionName());
    }

    public static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Expression expr) {
        return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, null, expr);
    }

    public static boolean isNullable(EntityMetamodel metamodel, Map<String, Type<?>> rootTypes, Expression expr) {
        return ExpressionUtils.isNullable(metamodel, null, rootTypes, expr);
    }

    private static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Map<String, Type<?>> rootTypes, Expression expr) {
        if (expr instanceof FunctionExpression) {
            return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (FunctionExpression)expr);
        }
        if (expr instanceof PathExpression) {
            return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (PathExpression)expr);
        }
        if (expr instanceof SubqueryExpression) {
            AbstractCommonQueryBuilder subquery = (AbstractCommonQueryBuilder)((SubqueryExpression)expr).getSubquery();
            for (SelectInfo selectInfo : subquery.selectManager.getSelectInfos()) {
                if (com.blazebit.persistence.parser.util.ExpressionUtils.isCountFunction((Expression)selectInfo.get())) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof ParameterExpression) {
            return true;
        }
        if (expr instanceof GeneralCaseExpression) {
            return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (GeneralCaseExpression)expr);
        }
        if (expr instanceof ListIndexExpression) {
            return false;
        }
        if (expr instanceof MapKeyExpression) {
            return false;
        }
        if (expr instanceof MapEntryExpression) {
            return false;
        }
        if (expr instanceof MapValueExpression) {
            return false;
        }
        if (expr instanceof EntityLiteral) {
            return false;
        }
        if (expr instanceof EnumLiteral) {
            return false;
        }
        if (expr instanceof NullExpression) {
            return true;
        }
        if (expr instanceof NumericLiteral) {
            return false;
        }
        if (expr instanceof BooleanLiteral) {
            return false;
        }
        if (expr instanceof StringLiteral) {
            return false;
        }
        if (expr instanceof TemporalLiteral) {
            return false;
        }
        if (expr instanceof ArithmeticFactor) {
            return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, ((ArithmeticFactor)expr).getExpression());
        }
        if (expr instanceof ArithmeticExpression) {
            return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (ArithmeticExpression)expr);
        }
        throw new IllegalArgumentException("The expression of type '" + expr.getClass().getName() + "' can not be analyzed for nullability!");
    }

    private static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Map<String, Type<?>> rootTypes, ArithmeticExpression arithmeticExpression) {
        return ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, arithmeticExpression.getLeft()) || ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, arithmeticExpression.getRight());
    }

    private static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Map<String, Type<?>> rootTypes, GeneralCaseExpression expr) {
        if (expr.getDefaultExpr() != null && ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, expr.getDefaultExpr())) {
            return true;
        }
        List expressions = expr.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, ((WhenClauseExpression)expressions.get(i)).getResult())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Map<String, Type<?>> rootTypes, FunctionExpression expr) {
        if ("NULLIF".equalsIgnoreCase(expr.getFunctionName())) {
            return true;
        }
        if (com.blazebit.persistence.parser.util.ExpressionUtils.isCountFunction((FunctionExpression)expr)) {
            return false;
        }
        if ("COALESCE".equalsIgnoreCase(expr.getFunctionName())) {
            List expressions = expr.getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                boolean nullable = ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (Expression)expressions.get(i));
                if (nullable) continue;
                return false;
            }
            return true;
        }
        List expressions = expr.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            boolean nullable = ExpressionUtils.isNullable(metamodel, constantifiedJoinNodeAttributeCollector, rootTypes, (Expression)expressions.get(i));
            if (!nullable) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(EntityMetamodel metamodel, ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector, Map<String, Type<?>> rootTypes, PathExpression expr) {
        JoinNode baseNode = (JoinNode)expr.getBaseNode();
        if (baseNode == null) {
            List expressions = expr.getExpressions();
            PathElementExpression expression = (PathElementExpression)expressions.get(0);
            if (!(expression instanceof PropertyExpression)) {
                return true;
            }
            int size = expressions.size();
            Type baseType = rootTypes.get(((PropertyExpression)expression).getProperty());
            int i = 0;
            if (baseType != null) {
                if (size == 1) {
                    return true;
                }
                i = 1;
            } else {
                baseType = rootTypes.get("this");
            }
            while (i < size) {
                expression = (PathElementExpression)expressions.get(i);
                if (!(expression instanceof PropertyExpression)) {
                    return true;
                }
                ManagedType managedType = (ManagedType)baseType;
                Attribute attribute = managedType.getAttribute(((PropertyExpression)expression).getProperty());
                if (JpaMetamodelUtils.isNullable((Attribute)attribute)) {
                    return true;
                }
                baseType = ((SingularAttribute)attribute).getType();
                ++i;
            }
            return false;
        }
        if (expr.getField() != null) {
            JoinTreeNode associationNode;
            String associationName;
            Attribute associationAttribute;
            if (constantifiedJoinNodeAttributeCollector != null && constantifiedJoinNodeAttributeCollector.isConstantifiedNonOptional(baseNode, expr.getField())) {
                return false;
            }
            ManagedType<?> managedType = baseNode.getManagedType();
            ExtendedManagedType extendedManagedType = (ExtendedManagedType)metamodel.getManagedType(ExtendedManagedType.class, JpaMetamodelUtils.getTypeName(managedType));
            Attribute attr = extendedManagedType.getAttribute(expr.getField()).getAttribute();
            if (JpaMetamodelUtils.isNullable((Attribute)attr)) {
                return true;
            }
            int dotIndex = expr.getField().lastIndexOf(46);
            if (dotIndex != -1 && JpaMetamodelUtils.isNullable((Attribute)(associationAttribute = extendedManagedType.getAttribute(associationName = expr.getField().substring(0, dotIndex)).getAttribute())) && ((associationNode = (JoinTreeNode)baseNode.getNodes().get(associationName)) == null || associationNode.getDefaultNode().getJoinType() != JoinType.INNER)) {
                return true;
            }
        }
        return baseNode.getValueCount() > 0 && baseNode.getValuesCastedParameter() == null || baseNode.getJoinType() == JoinType.LEFT || baseNode.getJoinType() == JoinType.FULL;
    }

    public static FetchType getFetchType(Attribute<?, ?> attr) {
        Class<Basic> annotationType;
        HashSet annotations;
        Member m = attr.getJavaMember();
        if (m instanceof Method) {
            annotations = AnnotationUtils.getAllAnnotations((Method)((Method)m));
        } else if (m instanceof Field) {
            annotations = new HashSet();
            Collections.addAll(annotations, ((Field)m).getAnnotations());
        } else {
            throw new IllegalStateException("Attribute member [" + attr.getName() + "] is neither field nor method");
        }
        switch (attr.getPersistentAttributeType()) {
            case BASIC: {
                annotationType = Basic.class;
                break;
            }
            case ELEMENT_COLLECTION: {
                annotationType = ElementCollection.class;
                break;
            }
            case EMBEDDED: {
                return FetchType.EAGER;
            }
            case MANY_TO_MANY: {
                annotationType = ManyToMany.class;
                break;
            }
            case MANY_TO_ONE: {
                annotationType = ManyToOne.class;
                break;
            }
            case ONE_TO_MANY: {
                annotationType = OneToMany.class;
                break;
            }
            case ONE_TO_ONE: {
                annotationType = OneToOne.class;
                break;
            }
            default: {
                return FetchType.EAGER;
            }
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(annotationType)) continue;
            try {
                return (FetchType)annotation.annotationType().getMethod("fetch", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return FetchType.EAGER;
    }

    public static boolean containsSubqueryExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)SUBQUERY_EXPRESSION_DETECTOR);
    }

    public static boolean containsSizeExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)SIZE_EXPRESSION_DETECTOR);
    }

    public static Expression replaceSubexpression(Expression superExpression, String placeholder, Expression substitute) {
        return (Expression)superExpression.accept((Expression.ResultVisitor)new AliasReplacementVisitor(substitute, placeholder));
    }
}

