/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.HavingOrBuilder;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.IllegalSubqueryDetector;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.PaginatedTypedQueryImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.impl.builder.object.CountExtractionObjectBuilder;
import com.blazebit.persistence.impl.builder.object.DelegatingKeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.builder.object.KeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.keyset.SimpleKeysetLink;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.ObjectBuilderTypedQuery;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.spi.AttributeAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class PaginatedCriteriaBuilderImpl<T>
extends AbstractFullQueryBuilder<T, PaginatedCriteriaBuilder<T>, PaginatedCriteriaBuilderImpl<T>, PaginatedCriteriaBuilderImpl<T>, BaseFinalSetOperationBuilderImpl<T, ?, ?>>
implements PaginatedCriteriaBuilder<T> {
    private static final String ENTITY_PAGE_POSITION_PARAMETER_NAME = "_entityPagePositionParameter";
    private static final String PAGE_POSITION_ID_QUERY_ALIAS_PREFIX = "_page_position_";
    private static final Set<ClauseType> OBJECT_QUERY_CLAUSE_EXCLUSIONS = EnumSet.complementOf(EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT));
    private boolean keysetExtraction;
    private boolean withExtractAllKeysets = false;
    private boolean withCountQuery = true;
    private boolean withForceIdQuery = false;
    private Boolean withInlineIdQuery;
    private boolean withInlineCountQuery;
    private long maximumCount = Long.MAX_VALUE;
    private int highestOffset = 0;
    private final KeysetPage keysetPage;
    private final ResolvedExpression[] identifierExpressions;
    private final Object entityId;
    private boolean needsNewIdList;
    private int[] keysetToSelectIndexMapping;
    private String[] identifierToUseSelectAliases;
    private KeysetMode keysetMode;
    private boolean forceFirstResult;
    private String cachedIdQueryString;
    private String cachedExternalIdQueryString;

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, Object entityId, int pageSize, ResolvedExpression[] identifierExpressions) {
        super(baseBuilder);
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = null;
        this.entityId = entityId;
        this.maxResults = pageSize;
        this.identifierExpressions = identifierExpressions;
        this.withInlineCountQuery = this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled() == null ? entityId == null && this.mainQuery.jpaProvider.supportsSubqueryAliasShadowing() : this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled();
        this.updateKeysetMode();
    }

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, KeysetPage keysetPage, int firstRow, int pageSize, ResolvedExpression[] identifierExpressions) {
        super(baseBuilder);
        if (firstRow < 0) {
            throw new IllegalArgumentException("firstRow may not be negative");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = keysetPage;
        this.firstResult = firstRow;
        this.entityId = null;
        this.maxResults = pageSize;
        this.identifierExpressions = identifierExpressions;
        this.withInlineCountQuery = this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled() == null ? this.mainQuery.jpaProvider.supportsSubqueryAliasShadowing() : this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled().booleanValue();
        this.updateKeysetMode();
    }

    public <Y> PaginatedCriteriaBuilder<Y> copy(Class<Y> resultClass) {
        FullQueryBuilder<Y, ?> criteriaBuilder = super.copy(resultClass);
        PaginatedCriteriaBuilder builder = this.entityId != null ? criteriaBuilder.pageAndNavigate(this.entityId, this.maxResults) : (this.keysetPage != null ? criteriaBuilder.page(this.keysetPage, this.firstResult, this.maxResults) : criteriaBuilder.page(this.firstResult, this.maxResults));
        builder.withKeysetExtraction(this.keysetExtraction);
        builder.withExtractAllKeysets(this.withExtractAllKeysets);
        builder.withCountQuery(this.withCountQuery);
        builder.withForceIdQuery(this.withForceIdQuery);
        builder.withHighestKeysetOffset(this.highestOffset);
        return builder;
    }

    @Override
    public <Y> CriteriaBuilderImpl<Y> copyCriteriaBuilder(Class<Y> resultClass, boolean copyOrderBy) {
        InPredicate p;
        CriteriaBuilder criteriaBuilder = super.copyCriteriaBuilder((Class)resultClass, copyOrderBy);
        criteriaBuilder.setFirstResult(0);
        criteriaBuilder.setMaxResults(Integer.MAX_VALUE);
        ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
        ResolvedExpression[] resultUniqueExpressions = this.getUniqueIdentifierExpressions();
        if (resultUniqueExpressions != null) {
            identifierExpressions = resultUniqueExpressions;
        }
        SubqueryBuilderImpl<Object> subqueryBuilder = new SubqueryBuilderImpl<Object>(criteriaBuilder.mainQuery, new QueryContext((AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)criteriaBuilder, ClauseType.WHERE), criteriaBuilder.aliasManager, criteriaBuilder.joinManager, criteriaBuilder.mainQuery.subqueryExpressionFactory, null, false, null);
        this.applyPageIdQueryInto(subqueryBuilder, this.keysetPage, this.firstResult, this.maxResults, identifierExpressions, true);
        subqueryBuilder.collectParameters();
        SubqueryExpression expression = new SubqueryExpression(subqueryBuilder);
        if (this.needsNewIdList) {
            ArrayList<Object> subArgs = new ArrayList<Object>(2);
            subArgs.add(expression);
            subArgs.add(new NumericLiteral(Integer.toString(identifierExpressions.length), NumericType.INTEGER));
            expression = new FunctionExpression("column_trunc", subArgs);
        }
        if (identifierExpressions.length == 1) {
            p = new InPredicate(identifierExpressions[0].getExpression(), new Expression[]{expression});
        } else {
            ArrayList<Object> args = new ArrayList<Object>(identifierExpressions.length + 2);
            args.add(new StringLiteral("IN"));
            for (int j = 0; j < identifierExpressions.length; ++j) {
                args.add(identifierExpressions[j].getExpression());
            }
            args.add(expression);
            expression = new FunctionExpression("compare_row_value_subquery", args);
            p = new EqPredicate((Expression)expression, (Expression)new NumericLiteral("0", NumericType.INTEGER));
        }
        CompoundPredicate predicate = criteriaBuilder.whereManager.rootPredicate.getPredicate();
        predicate.getChildren().clear();
        predicate.getChildren().add(p);
        return criteriaBuilder;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        this.updateKeysetMode();
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        this.updateKeysetMode();
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> afterKeyset(Keyset keyset) {
        super.afterKeyset(keyset);
        this.keysetMode = KeysetMode.NEXT;
        this.forceFirstResult = true;
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> beforeKeyset(Keyset keyset) {
        super.beforeKeyset(keyset);
        this.keysetMode = KeysetMode.PREVIOUS;
        this.forceFirstResult = true;
        return this;
    }

    private void updateKeysetMode() {
        KeysetMode oldMode = this.keysetMode;
        this.keysetMode = KeysetPaginationHelper.getKeysetMode(this.keysetPage, this.entityId, this.firstResult, this.maxResults);
        if (this.keysetMode == KeysetMode.NONE) {
            this.keysetManager.setKeysetLink(null);
        } else if (this.keysetMode == KeysetMode.NEXT) {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(this.keysetPage.getHighest(), this.keysetMode));
        } else {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(this.keysetPage.getLowest(), this.keysetMode));
        }
        if (this.keysetMode != oldMode) {
            this.prepareForModification(ClauseType.WHERE);
        }
    }

    public PaginatedCriteriaBuilder<T> withKeysetExtraction(boolean keysetExtraction) {
        this.keysetExtraction = keysetExtraction;
        if (!keysetExtraction) {
            this.withExtractAllKeysets = false;
        }
        return this;
    }

    public boolean isKeysetExtraction() {
        return this.keysetExtraction;
    }

    public PaginatedCriteriaBuilder<T> withExtractAllKeysets(boolean withExtractAllKeysets) {
        this.withExtractAllKeysets = withExtractAllKeysets;
        if (withExtractAllKeysets) {
            this.keysetExtraction = true;
        }
        return this;
    }

    public boolean isWithExtractAllKeysets() {
        return this.withExtractAllKeysets;
    }

    public PaginatedCriteriaBuilder<T> withCountQuery(boolean withCountQuery) {
        this.withCountQuery = withCountQuery;
        return this;
    }

    public boolean isWithCountQuery() {
        return this.withCountQuery;
    }

    public PaginatedCriteriaBuilder<T> withBoundedCount(long maximumCount) {
        if (this.maximumCount != maximumCount) {
            this.maximumCount = maximumCount;
            this.prepareForModification(ClauseType.SELECT);
        }
        return this;
    }

    public long getBoundedCount() {
        return this.maximumCount;
    }

    public PaginatedCriteriaBuilder<T> withForceIdQuery(boolean withForceIdQuery) {
        this.withForceIdQuery = withForceIdQuery;
        return this;
    }

    public boolean isWithForceIdQuery() {
        return this.withForceIdQuery;
    }

    public PaginatedCriteriaBuilder<T> withHighestKeysetOffset(int offset) {
        this.highestOffset = offset;
        return this;
    }

    public int getHighestKeysetOffset() {
        return this.highestOffset;
    }

    public PaginatedCriteriaBuilder<T> withInlineIdQuery(boolean withInlineIdQuery) {
        if (withInlineIdQuery) {
            if (!this.mainQuery.jpaProvider.supportsSubqueryInFunction()) {
                throw new IllegalStateException("Can't inline the id query because the JPA provider does not support subqueries in functions");
            }
            if (!this.mainQuery.jpaProvider.supportsSubqueryAliasShadowing()) {
                throw new IllegalStateException("Can't inline the id query because the JPA provider does not support subquery alias shadowing!");
            }
            if (!(this.mainQuery.dbmsDialect.supportsRowValueConstructor() && this.mainQuery.jpaProvider.supportsNonScalarSubquery() || this.getIdentifierExpressionsToUse().length == 1)) {
                if (!this.mainQuery.jpaProvider.supportsNonScalarSubquery()) {
                    throw new IllegalStateException("Can't inline the id query because pagination is based on multiple identifier expressions but the JPA provider does not support non-scalar subqueries!");
                }
                throw new IllegalStateException("Can't inline the id query because pagination is based on multiple identifier expressions but the database does not support the row value constructor syntax!");
            }
        }
        if (this.withInlineIdQuery != null && this.withInlineIdQuery != withInlineIdQuery) {
            this.prepareForModification(ClauseType.SELECT);
        }
        this.withInlineIdQuery = withInlineIdQuery;
        return this;
    }

    public boolean isWithInlineIdQuery() {
        if (this.withInlineIdQuery == null) {
            this.withInlineIdQuery = this.mainQuery.getQueryConfiguration().getInlineIdQueryEnabled() == null ? Boolean.valueOf(this.mainQuery.jpaProvider.supportsSubqueryInFunction() && this.mainQuery.jpaProvider.supportsSubqueryAliasShadowing() && (this.getIdentifierExpressionsToUse().length == 1 || this.mainQuery.dbmsDialect.supportsRowValueConstructor() && this.mainQuery.jpaProvider.supportsNonScalarSubquery())) : this.mainQuery.getQueryConfiguration().getInlineIdQueryEnabled();
        }
        return this.withInlineIdQuery;
    }

    public boolean isWithInlineCountQuery() {
        return this.withInlineCountQuery;
    }

    public PaginatedCriteriaBuilder<T> withInlineCountQuery(boolean withInlineCountQuery) {
        if (withInlineCountQuery) {
            if (this.entityId != null) {
                throw new IllegalStateException("Can't inline the count query when paginating to a page by entity id!");
            }
            if (!this.mainQuery.jpaProvider.supportsSubqueryAliasShadowing()) {
                throw new IllegalStateException("Can't inline the count query because the JPA provider does not support subquery alias shadowing!");
            }
        }
        if (this.withInlineCountQuery != withInlineCountQuery) {
            this.prepareForModification(ClauseType.SELECT);
        }
        this.withInlineCountQuery = withInlineCountQuery;
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setProperty(String propertyName, String propertyValue) {
        super.setProperty(propertyName, propertyValue);
        switch (propertyName) {
            case "com.blazebit.persistence.inline_id_query": {
                Boolean enabled = this.mainQuery.getQueryConfiguration().getInlineIdQueryEnabled();
                if (enabled == null) break;
                this.withInlineIdQuery(enabled);
                break;
            }
            case "com.blazebit.persistence.inline_count_query": {
                Boolean enabled = this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled();
                if (enabled == null) break;
                this.withInlineCountQuery(enabled);
                break;
            }
        }
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setProperties(Map<String, String> properties) {
        Boolean enabled;
        super.setProperties(properties);
        if (properties.containsKey("com.blazebit.persistence.inline_id_query") && (enabled = this.mainQuery.getQueryConfiguration().getInlineIdQueryEnabled()) != null) {
            this.withInlineIdQuery(enabled);
        }
        if (properties.containsKey("com.blazebit.persistence.inline_count_query") && (enabled = this.mainQuery.getQueryConfiguration().getInlineCountQueryEnabled()) != null) {
            this.withInlineCountQuery(enabled);
        }
        return this;
    }

    @Override
    protected ResolvedExpression[] getIdentifierExpressions() {
        if (this.identifierExpressions != null) {
            return this.identifierExpressions;
        }
        if (this.hasGroupBy) {
            return this.getGroupByIdentifierExpressions();
        }
        return this.getQueryRootEntityIdentifierExpressions();
    }

    public CriteriaBuilder<Object[]> createPageIdQuery() {
        return this.createPageIdQuery(this.keysetPage, this.firstResult, this.maxResults, this.getIdentifierExpressionsToUse());
    }

    private <X> TypedQuery<X> getCountQuery(String countQueryString, Class<X> resultType, boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins, List<JoinNode> entityFunctions, JoinNode dualNode) {
        Collection<ParameterManager.ParameterImpl<?>> parameters;
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, COUNT_QUERY_CLAUSE_EXCLUSIONS)) {
            TypedQuery countQuery = this.em.createQuery(countQueryString, resultType);
            if (this.isCacheable()) {
                this.mainQuery.jpaProvider.setCacheable((Query)countQuery);
            }
            this.parameterManager.parameterizeQuery((Query)countQuery);
            return this.parameterManager.getCriteriaNameMapping() == null ? countQuery : new TypedQueryWrapper(countQuery, this.parameterManager.getCriteriaNameMapping());
        }
        TypedQuery baseQuery = this.em.createQuery(countQueryString, resultType);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, COUNT_QUERY_CLAUSE_EXCLUSIONS);
        ArrayList<EntityFunctionNode> entityFunctionNodes = new ArrayList<EntityFunctionNode>();
        if (dualNode == null) {
            this.collectEntityFunctionNodes(entityFunctionNodes, (Query)baseQuery, entityFunctions);
        } else {
            this.collectEntityFunctionNodes(entityFunctionNodes, (Query)baseQuery, entityFunctions, Collections.emptyList(), false, 0);
        }
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        Map<String, String> valuesParameters = this.parameterManager.getValuesParameters();
        Map<String, ValuesParameterBinder> valuesBinders = this.parameterManager.getValuesBinders();
        if (dualNode == null) {
            parameters = this.parameterManager.getParameterImpls();
        } else {
            parameters = new ArrayList(this.parameterManager.getParameters());
            String valueParameterName = dualNode.getAlias() + "_value_0";
            String[][] parameterNames = new String[1][1];
            parameterNames[0][0] = valueParameterName;
            ParameterManager.ValuesParameterWrapper valuesParameterWrapper = new ParameterManager.ValuesParameterWrapper(dualNode.getJavaType(), parameterNames, new AttributeAccessor[1]);
            parameters.add(new ParameterManager.ParameterImpl<ParameterManager.ValuesParameterWrapper>(dualNode.getAlias(), false, null, null, valuesParameterWrapper));
            valuesParameters = new HashMap<String, String>(valuesParameters);
            valuesParameters.put(valueParameterName, dualNode.getAlias());
            valuesBinders.put(dualNode.getAlias(), valuesParameterWrapper.getBinder());
        }
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, parameters, parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), null);
        CustomSQLTypedQuery countQuery = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), valuesParameters, valuesBinders);
        if (dualNode == null) {
            this.parameterManager.parameterizeQuery(countQuery);
        } else {
            this.parameterManager.parameterizeQuery(countQuery, dualNode.getAlias());
            countQuery.setParameter(dualNode.getAlias(), Collections.singleton(0L));
        }
        return countQuery;
    }

    @Override
    public PaginatedTypedQueryImpl<T> getQuery() {
        boolean inlinedIdQuery;
        ObjectBuilder<T> objectBuilder;
        TypedQuery<T> objectQuery;
        boolean inlinedCountQuery;
        Object countQuery;
        this.prepareAndCheck();
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        boolean normalQueryMode = !this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && !this.joinManager.hasEntityFunctions() && keyRestrictedLeftJoins.isEmpty();
        String countQueryString = this.getPageCountQueryStringWithoutCheck();
        List<JoinNode> entityFunctions = null;
        Set<JoinNode> alwaysIncludedNodes = null;
        if (!normalQueryMode) {
            alwaysIncludedNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
            entityFunctions = this.joinManager.getEntityFunctions(COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, true, alwaysIncludedNodes);
        }
        if (this.maximumCount == Long.MAX_VALUE) {
            countQuery = this.entityId == null ? this.getCountQuery(countQueryString, Long.class, normalQueryMode, keyRestrictedLeftJoins, entityFunctions, null) : this.getCountQuery(countQueryString, Object[].class, normalQueryMode, keyRestrictedLeftJoins, entityFunctions, null);
        } else {
            ArrayList<JoinNode> countEntityFunctions = new ArrayList<JoinNode>();
            JoinNode valuesNode = this.createDualNode();
            countEntityFunctions.add(valuesNode);
            countQuery = this.entityId == null ? this.getCountQuery(countQueryString, Long.class, false, Collections.emptySet(), countEntityFunctions, valuesNode) : this.getCountQuery(countQueryString, Object[].class, false, Collections.emptySet(), countEntityFunctions, valuesNode);
        }
        TypedQuery<Object[]> idQuery = null;
        boolean bl = inlinedCountQuery = (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery;
        if (!this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery)) {
            String idQueryString = this.getPageIdQueryStringWithoutCheck();
            entityFunctions = normalQueryMode ? Collections.emptyList() : this.joinManager.getEntityFunctions(ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, true, alwaysIncludedNodes);
            idQuery = this.getIdQuery(idQueryString, normalQueryMode, keyRestrictedLeftJoins, entityFunctions);
            entityFunctions = normalQueryMode ? Collections.emptyList() : this.joinManager.getEntityFunctions(OBJECT_QUERY_CLAUSE_EXCLUSIONS, false, alwaysIncludedNodes);
            objectQuery = this.getObjectQueryById(normalQueryMode, keyRestrictedLeftJoins, entityFunctions);
            objectBuilder = null;
            inlinedIdQuery = false;
        } else {
            entityFunctions = normalQueryMode ? Collections.emptyList() : this.joinManager.getEntityFunctions(this.hasGroupBy ? NO_CLAUSE_EXCLUSION : OBJECT_QUERY_WITHOUT_GROUP_BY_EXCLUSIONS, false, alwaysIncludedNodes);
            Map.Entry<TypedQuery<T>, ObjectBuilder<T>> entry = this.getObjectQuery(normalQueryMode, keyRestrictedLeftJoins, entityFunctions);
            objectQuery = entry.getKey();
            objectBuilder = entry.getValue();
            inlinedIdQuery = this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery);
        }
        PaginatedTypedQueryImpl<T> query = new PaginatedTypedQueryImpl<T>(this.withExtractAllKeysets, (long)this.firstResult < this.maximumCount && this.withCountQuery, this.maximumCount != Long.MAX_VALUE, this.highestOffset, (TypedQuery<?>)countQuery, idQuery, objectQuery, objectBuilder, this.parameterManager.getParameterImpls(), this.parameterManager.getCriteriaNameMapping(), this.entityId, this.firstResult, this.maxResults, this.getIdentifierExpressionsToUse().length, this.needsNewIdList, this.keysetToSelectIndexMapping, this.keysetMode, this.keysetPage, this.forceFirstResult, inlinedIdQuery, inlinedCountQuery);
        return query;
    }

    @Override
    public PagedList<T> getResultList() {
        return this.getQuery().getResultList();
    }

    @Override
    public String getCountQueryString() {
        return this.getPageCountQueryString();
    }

    @Override
    public TypedQuery<Long> getCountQuery() {
        this.prepareAndCheck();
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        Set<JoinNode> alwaysIncludedNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
        boolean normalQueryMode = !this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && !this.joinManager.hasEntityFunctions() && keyRestrictedLeftJoins.isEmpty();
        String countQueryString = this.getPageCountQueryStringWithoutCheck();
        List<JoinNode> entityFunctions = this.joinManager.getEntityFunctions(COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, true, alwaysIncludedNodes);
        return this.getCountQuery(countQueryString, Long.class, normalQueryMode, keyRestrictedLeftJoins, entityFunctions, null);
    }

    public String getPageCountQueryString() {
        this.prepareAndCheck();
        return this.getExternalPageCountQueryString();
    }

    private String getPageCountQueryStringWithoutCheck() {
        if (this.cachedCountQueryString == null) {
            this.cachedCountQueryString = this.buildPageCountQueryString(false, false, this.maximumCount);
        }
        return this.cachedCountQueryString;
    }

    protected String getExternalPageCountQueryString() {
        if (this.cachedExternalCountQueryString == null) {
            this.cachedExternalCountQueryString = this.buildPageCountQueryString(true, false, this.maximumCount);
        }
        return this.cachedExternalCountQueryString;
    }

    public String getPageIdQueryString() {
        this.prepareAndCheck();
        return this.getExternalPageIdQueryString();
    }

    private String getPageIdQueryStringWithoutCheck() {
        if (this.cachedIdQueryString == null && !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery)) {
            this.cachedIdQueryString = this.buildPageIdQueryString(false);
        }
        return this.cachedIdQueryString;
    }

    protected String getExternalPageIdQueryString() {
        if (this.cachedExternalIdQueryString == null && !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery)) {
            this.cachedExternalIdQueryString = this.buildPageIdQueryString(true);
        }
        return this.cachedExternalIdQueryString;
    }

    @Override
    public String getQueryString() {
        this.prepareAndCheck();
        return this.getExternalQueryString();
    }

    @Override
    protected String getBaseQueryString(StringBuilder lateralSb, JoinNode lateralJoinNode) {
        if (this.cachedQueryString == null) {
            this.cachedQueryString = !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery) ? this.buildBaseQueryString(false) : this.buildObjectQueryString(false);
        }
        return this.cachedQueryString;
    }

    @Override
    protected String getExternalQueryString() {
        if (this.cachedExternalQueryString == null) {
            this.cachedExternalQueryString = !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery) ? this.buildBaseQueryString(true) : this.buildObjectQueryString(true);
        }
        return this.cachedExternalQueryString;
    }

    @Override
    protected void prepareForModification(ClauseType changedClause) {
        super.prepareForModification(changedClause);
        this.cachedIdQueryString = null;
        this.cachedExternalIdQueryString = null;
    }

    @Override
    protected void prepareAndCheck() {
        List<OrderByExpression> orderByExpressions;
        if (!this.needsCheck) {
            return;
        }
        this.verifyBuilderEnded();
        this.prepareAndCheckCtes();
        this.prepareSelect();
        if (!this.orderByManager.hasOrderBys()) {
            throw new IllegalStateException("Pagination requires at least one order by item!");
        }
        JoinVisitor joinVisitor = this.applyImplicitJoins(null);
        this.applyExpressionTransformersAndBuildGroupByClauses(joinVisitor);
        this.analyzeConstantifiedJoinNodes();
        this.hasCollections = this.joinManager.hasCollections();
        if (this.joinManager.hasFullJoin()) {
            throw new IllegalStateException("Cannot paginate with full outer joins!");
        }
        if (this.hasGroupBy) {
            ResolvedExpression[] missingExpressions;
            if (this.identifierExpressions != null && (missingExpressions = this.findMissingExpressions(this.getIdentifierExpressions(), this.identifierExpressions)) != null) {
                throw new IllegalStateException("Cannot paginate by expressions [" + PaginatedCriteriaBuilderImpl.expressionString(this.identifierExpressions) + "] because the expression [" + PaginatedCriteriaBuilderImpl.expressionString(missingExpressions) + "] is not part of the group by clause!");
            }
            if (this.hasCollections) {
                boolean groupedAway = true;
                for (JoinNode joinNode : this.joinManager.getCollectionJoins()) {
                    if (!joinNode.getClauseDependencies().contains((Object)ClauseType.GROUP_BY)) continue;
                    groupedAway = false;
                    break;
                }
                if (groupedAway) {
                    this.hasCollections = false;
                }
            }
        }
        if (!(orderByExpressions = this.orderByManager.getOrderByExpressions(false, this.whereManager.rootPredicate.getPredicate(), this.hasGroupBy ? Arrays.asList(this.getIdentifierExpressions()) : Collections.emptyList(), joinVisitor)).get(orderByExpressions.size() - 1).isResultUnique()) {
            throw new IllegalStateException("The order by items of the query builder are not guaranteed to produce unique tuples! Consider also ordering by the entity identifier!");
        }
        if (this.keysetManager.hasKeyset()) {
            this.keysetManager.initialize(orderByExpressions);
        }
        if (!this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery)) {
            this.initializeOrderByAliasesWithIdentifierToUse(orderByExpressions);
        } else if (this.keysetExtraction || this.withInlineCountQuery) {
            List<SelectInfo> selectInfos;
            if (this.isWithInlineIdQuery()) {
                this.initializeOrderByAliasesWithIdentifierToUse(orderByExpressions);
                if (this.selectManager.getSelectInfos().size() == 0) {
                    for (int j = 0; j < this.keysetToSelectIndexMapping.length; ++j) {
                        this.keysetToSelectIndexMapping[j] = j + 1;
                    }
                }
            } else {
                this.identifierToUseSelectAliases = null;
            }
            if ((selectInfos = this.selectManager.getSelectInfos()).size() == 0) {
                if (this.keysetToSelectIndexMapping == null) {
                    this.keysetToSelectIndexMapping = new int[orderByExpressions.size()];
                    Arrays.fill(this.keysetToSelectIndexMapping, -1);
                }
            } else {
                HashMap<String, Integer> selectExpressionStringMap = new HashMap<String, Integer>(selectInfos.size() * 2);
                for (int i = 0; i < selectInfos.size(); ++i) {
                    SelectInfo selectInfo = selectInfos.get(i);
                    selectExpressionStringMap.put(selectInfo.getExpression().toString(), i);
                    if (selectInfo.getAlias() == null) continue;
                    selectExpressionStringMap.put(selectInfo.getAlias(), i);
                }
                this.keysetToSelectIndexMapping = new int[orderByExpressions.size()];
                for (int i = 0; i < orderByExpressions.size(); ++i) {
                    Integer index = (Integer)selectExpressionStringMap.get(orderByExpressions.get(i).getExpression().toString());
                    this.keysetToSelectIndexMapping[i] = index == null ? -1 : index;
                }
            }
        } else {
            this.keysetToSelectIndexMapping = null;
            if (this.isWithInlineIdQuery()) {
                this.initializeOrderByAliasesWithIdentifierToUse(orderByExpressions);
            } else {
                this.identifierToUseSelectAliases = null;
            }
        }
        this.needsNewIdList = this.keysetExtraction || this.orderByManager.hasComplexOrderBys();
        this.needsCheck = false;
    }

    @Override
    protected void buildImplicitGroupByClauses(JoinVisitor joinVisitor) {
        if (this.hasGroupBy) {
            this.selectManager.buildImplicitGroupByClauses(this.cbf.getMetamodel(), this.groupByManager, this.hasGroupBy, joinVisitor);
        }
        this.havingManager.buildImplicitGroupByClauses(this.groupByManager, this.hasGroupBy, joinVisitor);
        this.orderByManager.buildImplicitGroupByClauses(this.groupByManager, this.hasGroupBy, joinVisitor);
    }

    private void initializeOrderByAliasesWithIdentifierToUse(List<OrderByExpression> orderByExpressions) {
        ResolvedExpression[] identifierExpressionsToUse = this.getIdentifierExpressionsToUse();
        HashMap<String, Integer> identifierExpressionStringMap = new HashMap<String, Integer>(identifierExpressionsToUse.length);
        for (int i = 0; i < identifierExpressionsToUse.length; ++i) {
            identifierExpressionStringMap.put(identifierExpressionsToUse[i].getExpressionString(), i);
        }
        this.keysetToSelectIndexMapping = new int[orderByExpressions.size()];
        this.identifierToUseSelectAliases = new String[identifierExpressionsToUse.length];
        for (int i = 0; i < orderByExpressions.size(); ++i) {
            String potentialSelectAlias = null;
            AliasInfo aliasInfo = null;
            if (orderByExpressions.get(i).getExpression() instanceof PathExpression) {
                potentialSelectAlias = orderByExpressions.get(i).getExpression().toString();
                aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            }
            if (aliasInfo instanceof SelectInfo) {
                Integer index = (Integer)identifierExpressionStringMap.get(((SelectInfo)aliasInfo).getExpression().toString());
                if (index == null) {
                    this.keysetToSelectIndexMapping[i] = -1;
                    continue;
                }
                this.identifierToUseSelectAliases[i] = potentialSelectAlias;
                this.keysetToSelectIndexMapping[i] = index;
                continue;
            }
            if (!this.keysetExtraction && !this.withInlineCountQuery) continue;
            Integer index = (Integer)identifierExpressionStringMap.get(potentialSelectAlias);
            this.keysetToSelectIndexMapping[i] = index == null ? -1 : index;
        }
        if (!this.keysetExtraction && !this.withInlineCountQuery) {
            this.keysetToSelectIndexMapping = null;
        }
    }

    private ResolvedExpression[] findMissingExpressions(ResolvedExpression[] targetIdentifierExpressions, ResolvedExpression[] identifierExpressions) {
        if (targetIdentifierExpressions == null || targetIdentifierExpressions.length < identifierExpressions.length) {
            return identifierExpressions;
        }
        int identifiersSize = identifierExpressions.length;
        int targetIdentifiersSize = targetIdentifierExpressions.length;
        ArrayList<ResolvedExpression> missingExpressions = null;
        block0: for (int i = 0; i < identifiersSize; ++i) {
            ResolvedExpression identifierExpression = identifierExpressions[i];
            for (int j = 0; j < targetIdentifiersSize; ++j) {
                if (identifierExpression.equals(targetIdentifierExpressions[j])) continue block0;
            }
            if (missingExpressions == null) {
                missingExpressions = new ArrayList<ResolvedExpression>();
            }
            missingExpressions.add(identifierExpression);
        }
        if (missingExpressions == null) {
            return null;
        }
        return missingExpressions.toArray(new ResolvedExpression[missingExpressions.size()]);
    }

    private Map.Entry<TypedQuery<T>, ObjectBuilder<T>> getObjectQuery(boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins, List<JoinNode> entityFunctions) {
        boolean inlinedCountQuery;
        Object query;
        String queryString = this.getBaseQueryString(null, null);
        Class expectedResultType = this.keysetExtraction || (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery ? Object[].class : this.selectManager.getExpectedQueryResultType();
        Set clauseExclusions = this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery) ? OBJECT_QUERY_CLAUSE_EXCLUSIONS : (this.hasGroupBy ? NO_CLAUSE_EXCLUSION : OBJECT_QUERY_WITHOUT_GROUP_BY_EXCLUSIONS);
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, clauseExclusions)) {
            boolean externalIdQuery;
            query = this.em.createQuery(queryString, expectedResultType);
            if (this.isCacheable()) {
                this.mainQuery.jpaProvider.setCacheable((Query)query);
            }
            boolean bl = externalIdQuery = !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery);
            if (!externalIdQuery && (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery && this.maximumCount != Long.MAX_VALUE) {
                this.parameterManager.parameterizeQuery((Query)query, this.getDualNodeAlias());
                query.setParameter(this.getDualNodeAlias() + "_value_0", 0L);
            } else {
                this.parameterManager.parameterizeQuery((Query)query);
            }
        } else {
            Collection<ParameterManager.ParameterImpl<?>> parameters;
            TypedQuery baseQuery = this.em.createQuery(queryString, expectedResultType);
            Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
            List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, clauseExclusions);
            List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery, entityFunctions);
            boolean shouldRenderCteNodes = this.renderCteNodes(false);
            List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
            Map<String, String> valuesParameters = this.parameterManager.getValuesParameters();
            Map<String, ValuesParameterBinder> valuesBinders = this.parameterManager.getValuesBinders();
            boolean externalIdQuery = !this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery);
            JoinNode dualNode = null;
            if (!externalIdQuery && (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery && this.maximumCount != Long.MAX_VALUE) {
                parameters = new ArrayList(this.parameterManager.getParameters());
                dualNode = this.createDualNode();
                String valueParameterName = dualNode.getAlias() + "_value_0";
                String[][] parameterNames = new String[1][1];
                parameterNames[0][0] = valueParameterName;
                ParameterManager.ValuesParameterWrapper valuesParameterWrapper = new ParameterManager.ValuesParameterWrapper(dualNode.getJavaType(), parameterNames, new AttributeAccessor[1]);
                parameters.add(new ParameterManager.ParameterImpl<ParameterManager.ValuesParameterWrapper>(dualNode.getAlias(), false, null, null, valuesParameterWrapper));
                valuesParameters = new HashMap<String, String>(valuesParameters);
                valuesParameters.put(valueParameterName, dualNode.getAlias());
                valuesBinders.put(dualNode.getAlias(), valuesParameterWrapper.getBinder());
            } else {
                parameters = this.parameterManager.getParameterImpls();
            }
            CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, parameters, parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), null);
            query = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), valuesParameters, valuesBinders);
            if (dualNode == null) {
                this.parameterManager.parameterizeQuery((Query)query);
            } else {
                this.parameterManager.parameterizeQuery((Query)query, dualNode.getAlias());
                query.setParameter(dualNode.getAlias(), Collections.singleton(0L));
            }
        }
        Object objectBuilder = null;
        ObjectBuilder transformerObjectBuilder = this.selectManager.getSelectObjectBuilder();
        boolean bl = inlinedCountQuery = (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery;
        if (this.keysetExtraction) {
            objectBuilder = transformerObjectBuilder == null ? new KeysetExtractionObjectBuilder(this.keysetToSelectIndexMapping, this.keysetMode, this.maxResults, this.highestOffset, this.selectManager.getExpectedQueryResultType() != Object[].class, this.withExtractAllKeysets, inlinedCountQuery) : new DelegatingKeysetExtractionObjectBuilder(transformerObjectBuilder, this.keysetToSelectIndexMapping, this.keysetMode, this.maxResults, this.highestOffset, this.withExtractAllKeysets, inlinedCountQuery);
            transformerObjectBuilder = objectBuilder;
        } else if (inlinedCountQuery && transformerObjectBuilder != null) {
            objectBuilder = new CountExtractionObjectBuilder(transformerObjectBuilder);
            transformerObjectBuilder = objectBuilder;
        }
        if (transformerObjectBuilder != null) {
            query = new ObjectBuilderTypedQuery((TypedQuery<?>)query, query instanceof AbstractCustomQuery ? null : this.parameterManager.getCriteriaNameMapping(), transformerObjectBuilder);
        } else if (this.parameterManager.getCriteriaNameMapping() != null && !(query instanceof CustomSQLTypedQuery)) {
            query = new TypedQueryWrapper(query, this.parameterManager.getCriteriaNameMapping());
        }
        return new AbstractMap.SimpleEntry<TypedQuery<T>, ObjectBuilder<T>>(query, objectBuilder);
    }

    private TypedQuery<Object[]> getIdQuery(String idQueryString, boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins, List<JoinNode> entityFunctions) {
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, ID_QUERY_CLAUSE_EXCLUSIONS)) {
            TypedQuery idQuery = this.em.createQuery(idQueryString, Object[].class);
            if (this.isCacheable()) {
                this.mainQuery.jpaProvider.setCacheable((Query)idQuery);
            }
            if ((long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery && this.maximumCount != Long.MAX_VALUE) {
                this.parameterManager.parameterizeQuery((Query)idQuery, this.getDualNodeAlias());
                idQuery.setParameter(this.getDualNodeAlias() + "_value_0", (Object)0L);
            } else {
                this.parameterManager.parameterizeQuery((Query)idQuery);
            }
            return this.parameterManager.getCriteriaNameMapping() == null ? idQuery : new TypedQueryWrapper(idQuery, this.parameterManager.getCriteriaNameMapping());
        }
        TypedQuery baseQuery = this.em.createQuery(idQueryString, Object[].class);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, ID_QUERY_CLAUSE_EXCLUSIONS);
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery, entityFunctions);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, this.parameterManager.getParameterImpls(), parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), null);
        CustomSQLTypedQuery<Object[]> idQuery = new CustomSQLTypedQuery<Object[]>(querySpecification, (Query)baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        if ((long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery && this.maximumCount != Long.MAX_VALUE) {
            this.parameterManager.parameterizeQuery(idQuery, this.getDualNodeAlias());
            idQuery.setParameter(this.getDualNodeAlias() + "_value_0", (Object)0L);
        } else {
            this.parameterManager.parameterizeQuery(idQuery);
        }
        return idQuery;
    }

    private TypedQuery<T> getObjectQueryById(boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins, List<JoinNode> entityFunctions) {
        Collection<ParameterManager.ParameterImpl<?>> parameters;
        List<CTENode> ctes;
        String skippedParameterPrefix;
        ResolvedExpression[] identifierExpressionsToUse = this.getIdentifierExpressionsToUse();
        String string = skippedParameterPrefix = identifierExpressionsToUse.length == 1 ? "ids" : "ids_";
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, OBJECT_QUERY_CLAUSE_EXCLUSIONS)) {
            TypedQuery query = this.em.createQuery(this.getBaseQueryString(null, null), this.selectManager.getExpectedQueryResultType());
            if (this.isCacheable()) {
                this.mainQuery.jpaProvider.setCacheable((Query)query);
            }
            this.parameterManager.parameterizeQuery((Query)query, skippedParameterPrefix);
            return this.applyObjectBuilder(query);
        }
        TypedQuery baseQuery = this.em.createQuery(this.getBaseQueryString(null, null), this.selectManager.getExpectedQueryResultType());
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery, "ids");
        if (identifierExpressionsToUse.length == 1) {
            parameterListNames.add("ids");
        }
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, OBJECT_QUERY_CLAUSE_EXCLUSIONS);
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery, entityFunctions);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> list = ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        if (identifierExpressionsToUse.length == 1) {
            parameters = new ArrayList(this.parameterManager.getParameters());
            parameters.add((ParameterManager.ParameterImpl<?>)baseQuery.getParameter("ids"));
        } else {
            parameters = this.parameterManager.getParameterImpls();
        }
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, parameters, parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled(), null);
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query, skippedParameterPrefix);
        return this.applyObjectBuilder(query);
    }

    @Override
    protected void appendPageCountQueryStringExtensions(StringBuilder sbSelectFrom) {
        if (this.entityId != null) {
            this.parameterManager.addParameterMapping(ENTITY_PAGE_POSITION_PARAMETER_NAME, this.entityId, ClauseType.SELECT, this);
            sbSelectFrom.append(", ");
            sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("page_position", 2));
            sbSelectFrom.append('(');
            this.appendSimplePageIdQueryString(sbSelectFrom);
            sbSelectFrom.append("),");
            sbSelectFrom.append(':').append(ENTITY_PAGE_POSITION_PARAMETER_NAME);
            sbSelectFrom.append(")");
        }
    }

    private String appendSimplePageIdQueryString(StringBuilder sbSelectFrom) {
        this.queryGenerator.setAliasPrefix(PAGE_POSITION_ID_QUERY_ALIAS_PREFIX);
        sbSelectFrom.append("SELECT ");
        this.appendIdentifierExpressions(sbSelectFrom, false);
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> idNodesToFetch = Collections.emptySet();
        Set<JoinNode> identifierExpressionsToUseNonRootJoinNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
        Set<JoinNode> collectionJoins = this.joinManager.buildClause(sbSelectFrom, ID_QUERY_CLAUSE_EXCLUSIONS, PAGE_POSITION_ID_QUERY_ALIAS_PREFIX, true, false, true, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, idNodesToFetch, identifierExpressionsToUseNonRootJoinNodes, null, true);
        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
        boolean inverseOrder = false;
        if (this.hasGroupBy || this.havingManager.hasPredicates() || !collectionJoins.isEmpty()) {
            this.groupByManager.buildGroupBy(sbSelectFrom, ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, this.getIdentifierExpressionsToUse());
            this.havingManager.buildClause(sbSelectFrom);
        }
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, true, false, false);
        this.queryGenerator.setAliasPrefix(null);
        return sbSelectFrom.toString();
    }

    private String buildPageIdQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildPageIdQueryString(sbSelectFrom, false, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private String buildPageIdQueryString(StringBuilder sbSelectFrom, boolean aliasFunction, boolean externalRepresentation) {
        boolean inverseOrder;
        int i;
        sbSelectFrom.append("SELECT ");
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        this.queryGenerator.setClauseType(ClauseType.SELECT);
        ResolvedExpression[] identifierExpressionsToUse = this.getIdentifierExpressionsToUse();
        if (aliasFunction && !externalRepresentation && this.needsNewIdList) {
            for (i = 0; i < identifierExpressionsToUse.length; ++i) {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("alias", 1));
                identifierExpressionsToUse[i].getExpression().accept((Expression.Visitor)this.queryGenerator);
                sbSelectFrom.append(",'").append("synth_col_");
                sbSelectFrom.append(i);
                sbSelectFrom.append("')");
                if (this.identifierToUseSelectAliases[i] != null) {
                    sbSelectFrom.append(" AS ");
                    sbSelectFrom.append(this.selectManager.getSubquerySelectAlias(this.identifierToUseSelectAliases[i]));
                }
                sbSelectFrom.append(", ");
            }
        } else {
            for (i = 0; i < identifierExpressionsToUse.length; ++i) {
                identifierExpressionsToUse[i].getExpression().accept((Expression.Visitor)this.queryGenerator);
                if (this.identifierToUseSelectAliases[i] != null) {
                    sbSelectFrom.append(" AS ");
                    sbSelectFrom.append(this.identifierToUseSelectAliases[i]);
                }
                sbSelectFrom.append(", ");
            }
        }
        sbSelectFrom.setLength(sbSelectFrom.length() - 2);
        if (this.needsNewIdList) {
            if (this.isWithInlineIdQuery()) {
                this.orderByManager.buildSelectClauses(sbSelectFrom, false, aliasFunction && !externalRepresentation, null);
            } else {
                this.orderByManager.buildSelectClauses(sbSelectFrom, this.keysetExtraction, aliasFunction && !externalRepresentation, this.keysetToSelectIndexMapping);
            }
        }
        if (!aliasFunction && (long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery) {
            sbSelectFrom.append(", ");
            this.appendPageCountQueryAsSubquery(sbSelectFrom, externalRepresentation);
        }
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> idNodesToFetch = Collections.emptySet();
        Set<JoinNode> identifierExpressionsToUseNonRootJoinNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
        Set<JoinNode> collectionJoins = this.joinManager.buildClause(sbSelectFrom, ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, null, true, externalRepresentation, true, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, idNodesToFetch, identifierExpressionsToUseNonRootJoinNodes, null, true);
        if (this.keysetMode == KeysetMode.NONE || this.keysetManager.getKeysetLink().getKeyset().getTuple() == null) {
            this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
        } else {
            sbSelectFrom.append(" WHERE ");
            int positionalOffset = this.parameterManager.getPositionalOffset();
            if (this.mainQuery.getQueryConfiguration().isOptimizedKeysetPredicateRenderingEnabled()) {
                this.keysetManager.buildOptimizedKeysetPredicate(sbSelectFrom, positionalOffset);
            } else {
                this.keysetManager.buildKeysetPredicate(sbSelectFrom, positionalOffset);
            }
            if (this.whereManager.hasPredicates() || !whereClauseConjuncts.isEmpty()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
            }
        }
        boolean bl = inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        if (this.hasGroupBy || this.havingManager.hasPredicates() || !collectionJoins.isEmpty()) {
            this.groupByManager.buildGroupBy(sbSelectFrom, ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS, this.getIdentifierExpressionsToUse());
            this.havingManager.buildClause(sbSelectFrom);
        }
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, !this.needsNewIdList, this.needsNewIdList, aliasFunction && !externalRepresentation);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    private void appendPageIdQueryLimit(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        if ((externalRepresentation || this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) && this.hasLimit()) {
            sbSelectFrom.append(" LIMIT ");
            sbSelectFrom.append(this.maxResults);
            if (this.firstResult != 0 && (this.keysetMode == KeysetMode.NONE || this.keysetManager.getKeysetLink().getKeyset().getTuple() == null)) {
                sbSelectFrom.append(" OFFSET ");
                sbSelectFrom.append(this.firstResult);
            }
        }
    }

    @Override
    protected String buildBaseQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildBaseQueryString(sbSelectFrom, externalRepresentation, null, false);
        return sbSelectFrom.toString();
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode, boolean countWrapped) {
        ArrayList<String> whereClauseConjuncts;
        this.selectManager.buildSelect(sbSelectFrom, false, externalRepresentation);
        ArrayList<String> optionalWhereClauseConjuncts = whereClauseConjuncts = new ArrayList<String>();
        this.joinManager.buildClause(sbSelectFrom, OBJECT_QUERY_CLAUSE_EXCLUSIONS, null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), null, true);
        sbSelectFrom.append(" WHERE ");
        ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
        ResolvedExpression[] resultUniqueExpressions = this.getUniqueIdentifierExpressions();
        if (resultUniqueExpressions != null) {
            identifierExpressions = resultUniqueExpressions;
        }
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        if (identifierExpressions.length == 1) {
            identifierExpressions[0].getExpression().accept((Expression.Visitor)this.queryGenerator);
            sbSelectFrom.append(" IN :").append("ids");
        } else {
            sbSelectFrom.append('(');
            for (int i = 0; i < this.maxResults; ++i) {
                for (int j = 0; j < identifierExpressions.length; ++j) {
                    identifierExpressions[j].getExpression().accept((Expression.Visitor)this.queryGenerator);
                    sbSelectFrom.append(" = :").append("ids");
                    sbSelectFrom.append('_').append(j).append('_').append(i);
                    sbSelectFrom.append(" AND ");
                }
                sbSelectFrom.setLength(sbSelectFrom.length() - " AND ".length());
                sbSelectFrom.append(" OR ");
            }
            sbSelectFrom.setLength(sbSelectFrom.length() - " OR ".length());
            sbSelectFrom.append(')');
        }
        for (String conjunct : whereClauseConjuncts) {
            sbSelectFrom.append(" AND ");
            sbSelectFrom.append(conjunct);
        }
        if (this.hasGroupBy) {
            this.groupByManager.buildGroupBy(sbSelectFrom, OBJECT_QUERY_CLAUSE_EXCLUSIONS);
            this.havingManager.buildClause(sbSelectFrom);
        }
        this.orderByManager.buildOrderBy(sbSelectFrom, false, false, false, false);
    }

    private String buildObjectQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildObjectQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private void appendPageIdQueryAsSubquery(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        this.appendQueryAsSubquery(false, sbSelectFrom, externalRepresentation);
    }

    private void appendPageCountQueryAsSubquery(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        this.appendQueryAsSubquery(true, sbSelectFrom, externalRepresentation);
    }

    private void appendQueryAsSubquery(boolean count, StringBuilder sbSelectFrom, boolean externalRepresentation) {
        Set<JoinNode> keyRestrictedLeftJoins = this.getKeyRestrictedLeftJoins();
        Set<JoinNode> alwaysIncludedNodes = this.getIdentifierExpressionsToUseNonRootJoinNodes();
        Set clauseExclusions = count ? COUNT_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS : ID_QUERY_GROUP_BY_CLAUSE_EXCLUSIONS;
        List<JoinNode> entityFunctions = null;
        boolean normalQueryMode = !this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && (entityFunctions = this.joinManager.getEntityFunctions(clauseExclusions, true, alwaysIncludedNodes)).isEmpty() && keyRestrictedLeftJoins.isEmpty();
        JoinNode dualNode = null;
        if (count && this.maximumCount != Long.MAX_VALUE) {
            dualNode = this.createDualNode();
        }
        if (externalRepresentation || normalQueryMode) {
            ArrayList<EntityFunctionNode> entityFunctionNodes = null;
            if (dualNode != null) {
                entityFunctionNodes = new ArrayList<EntityFunctionNode>();
                this.collectEntityFunctionNodes(entityFunctionNodes, null, Collections.singletonList(dualNode), Collections.emptyList(), false, 0);
                for (int i = 0; i < entityFunctionNodes.size(); ++i) {
                    sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("entity_function", 1));
                }
            }
            sbSelectFrom.append("(");
            if (count) {
                this.buildPageCountQueryString(sbSelectFrom, externalRepresentation, false, this.maximumCount);
            } else {
                this.buildPageIdQueryString(sbSelectFrom, true, externalRepresentation);
                this.appendPageIdQueryLimit(sbSelectFrom, externalRepresentation);
            }
            sbSelectFrom.append(')');
            if (dualNode != null) {
                this.finishEntityFunctionNodes(sbSelectFrom, entityFunctionNodes);
            }
        } else {
            if (dualNode != null) {
                entityFunctions = new ArrayList<JoinNode>();
                entityFunctions.add(dualNode);
            }
            if (entityFunctions == null) {
                entityFunctions = this.joinManager.getEntityFunctions(clauseExclusions, true, alwaysIncludedNodes);
            }
            if (entityFunctions.isEmpty()) {
                sbSelectFrom.append("(");
                if (count) {
                    this.buildPageCountQueryString(sbSelectFrom, externalRepresentation, false, this.maximumCount);
                } else {
                    this.buildPageIdQueryString(sbSelectFrom, true, externalRepresentation);
                    this.appendPageIdQueryLimit(sbSelectFrom, externalRepresentation);
                }
                sbSelectFrom.append(')');
            } else {
                List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(null, entityFunctions);
                for (int i = 0; i < entityFunctionNodes.size(); ++i) {
                    sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("entity_function", 1));
                }
                sbSelectFrom.append("(");
                if (count) {
                    this.buildPageCountQueryString(sbSelectFrom, externalRepresentation, false, this.maximumCount);
                } else {
                    this.buildPageIdQueryString(sbSelectFrom, true, externalRepresentation);
                    this.appendPageIdQueryLimit(sbSelectFrom, externalRepresentation);
                }
                sbSelectFrom.append(')');
                this.finishEntityFunctionNodes(sbSelectFrom, entityFunctionNodes);
            }
        }
    }

    private String buildObjectQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        this.selectManager.buildSelect(sbSelectFrom, false, externalRepresentation);
        if (this.keysetExtraction) {
            if (this.selectManager.getSelectInfos().size() == 0 && this.isWithInlineIdQuery()) {
                this.orderByManager.buildSelectClauses(sbSelectFrom, true, false, null);
            } else {
                this.orderByManager.buildSelectClauses(sbSelectFrom, true, false, this.keysetToSelectIndexMapping);
            }
        }
        if ((long)this.firstResult < this.maximumCount && this.withCountQuery && this.withInlineCountQuery) {
            sbSelectFrom.append(", ");
            this.appendPageCountQueryAsSubquery(sbSelectFrom, externalRepresentation);
        }
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        ArrayList<String> optionalWhereClauseConjuncts = new ArrayList<String>();
        if (this.isWithInlineIdQuery() && (this.hasCollections || this.withForceIdQuery)) {
            this.joinManager.buildClause(sbSelectFrom, OBJECT_QUERY_CLAUSE_EXCLUSIONS, null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), null, true);
            ResolvedExpression[] identifierExpressions = this.getIdentifierExpressions();
            ResolvedExpression[] resultUniqueExpressions = this.getUniqueIdentifierExpressions();
            if (resultUniqueExpressions != null) {
                identifierExpressions = resultUniqueExpressions;
            }
            sbSelectFrom.append(" WHERE ");
            this.appendPageIdPredicate(sbSelectFrom, externalRepresentation, identifierExpressions);
            if (!whereClauseConjuncts.isEmpty()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
            }
            if (this.hasGroupBy) {
                this.groupByManager.buildGroupBy(sbSelectFrom, OBJECT_QUERY_CLAUSE_EXCLUSIONS);
                this.havingManager.buildClause(sbSelectFrom);
            }
        } else {
            this.joinManager.buildClause(sbSelectFrom, this.hasGroupBy ? NO_CLAUSE_EXCLUSION : OBJECT_QUERY_WITHOUT_GROUP_BY_EXCLUSIONS, null, false, externalRepresentation, false, false, optionalWhereClauseConjuncts, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch, Collections.emptySet(), null, true);
            if (this.keysetMode == KeysetMode.NONE || this.keysetManager.getKeysetLink().getKeyset().getTuple() == null) {
                this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
            } else {
                sbSelectFrom.append(" WHERE ");
                int positionalOffset = this.parameterManager.getPositionalOffset();
                if (this.mainQuery.getQueryConfiguration().isOptimizedKeysetPredicateRenderingEnabled()) {
                    this.keysetManager.buildOptimizedKeysetPredicate(sbSelectFrom, positionalOffset);
                } else {
                    this.keysetManager.buildKeysetPredicate(sbSelectFrom, positionalOffset);
                }
                if (this.whereManager.hasPredicates() || !whereClauseConjuncts.isEmpty()) {
                    sbSelectFrom.append(" AND ");
                    this.whereManager.buildClausePredicate(sbSelectFrom, whereClauseConjuncts, optionalWhereClauseConjuncts);
                }
            }
            this.appendGroupByClause(sbSelectFrom);
        }
        boolean inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, false, false, false);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    private void appendPageIdPredicate(StringBuilder sbSelectFrom, boolean externalRepresentation, ResolvedExpression[] identifierExpressions) {
        StringBuilder original = this.queryGenerator.getQueryBuffer();
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        if (externalRepresentation) {
            if (identifierExpressions.length == 1) {
                identifierExpressions[0].getExpression().accept((Expression.Visitor)this.queryGenerator);
            } else {
                sbSelectFrom.append('(');
                identifierExpressions[0].getExpression().accept((Expression.Visitor)this.queryGenerator);
                for (int i = 1; i < identifierExpressions.length; ++i) {
                    sbSelectFrom.append(", ");
                    identifierExpressions[i].getExpression().accept((Expression.Visitor)this.queryGenerator);
                }
                sbSelectFrom.append(')');
            }
            sbSelectFrom.append(" IN ");
            this.appendPageIdQueryAsSubquery(sbSelectFrom, true);
        } else if (identifierExpressions.length == 1) {
            identifierExpressions[0].getExpression().accept((Expression.Visitor)this.queryGenerator);
            sbSelectFrom.append(" IN ");
            if (this.needsNewIdList) {
                sbSelectFrom.append('(');
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("column_trunc", 1));
            } else if (!this.mainQuery.dbmsDialect.supportsLimitInQuantifiedPredicateSubquery()) {
                sbSelectFrom.append('(');
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("query_wrapper", 1));
            } else if (!this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                sbSelectFrom.append('(');
            }
            if (this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                this.appendPageIdQueryAsSubquery(sbSelectFrom, externalRepresentation);
            } else {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("limit", 1));
                this.appendPageIdQueryAsSubquery(sbSelectFrom, externalRepresentation);
                sbSelectFrom.append(',').append(this.maxResults);
                if (this.firstResult != 0 && (this.keysetMode == KeysetMode.NONE || this.keysetManager.getKeysetLink().getKeyset().getTuple() == null)) {
                    sbSelectFrom.append(',').append(this.firstResult);
                }
                sbSelectFrom.append(')');
            }
            if (this.needsNewIdList) {
                sbSelectFrom.append(",").append(identifierExpressions.length).append(')');
                sbSelectFrom.append(')');
            } else if (!this.mainQuery.dbmsDialect.supportsLimitInQuantifiedPredicateSubquery()) {
                sbSelectFrom.append(')');
                sbSelectFrom.append(')');
            } else if (!this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                sbSelectFrom.append(')');
            }
        } else {
            sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("compare_row_value_subquery", 1)).append('\'').append("IN").append('\'');
            for (int j = 0; j < identifierExpressions.length; ++j) {
                sbSelectFrom.append(',');
                identifierExpressions[j].getExpression().accept((Expression.Visitor)this.queryGenerator);
            }
            sbSelectFrom.append(',');
            if (this.needsNewIdList) {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("column_trunc", 1));
            } else if (!this.mainQuery.dbmsDialect.supportsLimitInQuantifiedPredicateSubquery()) {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("query_wrapper", 1));
            }
            if (this.mainQuery.jpaProvider.supportsSubqueryLimitOffset()) {
                this.appendPageIdQueryAsSubquery(sbSelectFrom, externalRepresentation);
            } else {
                sbSelectFrom.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("limit", 1));
                this.appendPageIdQueryAsSubquery(sbSelectFrom, externalRepresentation);
                sbSelectFrom.append(',').append(this.maxResults);
                if (this.firstResult != 0 && (this.keysetMode == KeysetMode.NONE || this.keysetManager.getKeysetLink().getKeyset().getTuple() == null)) {
                    sbSelectFrom.append(',').append(this.firstResult);
                }
                sbSelectFrom.append(')');
            }
            if (this.needsNewIdList) {
                sbSelectFrom.append(",").append(identifierExpressions.length).append(')');
            } else if (!this.mainQuery.dbmsDialect.supportsLimitInQuantifiedPredicateSubquery()) {
                sbSelectFrom.append(')');
            }
            sbSelectFrom.append(") = 0");
        }
        this.queryGenerator.setQueryBuffer(original);
    }

    @Override
    public PaginatedCriteriaBuilder<T> distinct() {
        throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public RestrictionBuilder<PaginatedCriteriaBuilder<T>> having(String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public CaseWhenStarterBuilder<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingCase() {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSimpleCase(String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public HavingOrBuilder<PaginatedCriteriaBuilder<T>> havingOr() {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryInitiator<PaginatedCriteriaBuilder<T>> havingExists() {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryInitiator<PaginatedCriteriaBuilder<T>> havingNotExists() {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryBuilder<PaginatedCriteriaBuilder<T>> havingExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryBuilder<PaginatedCriteriaBuilder<T>> havingNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSubquery() {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryInitiator<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSubquery(String subqueryAlias, String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public MultipleSubqueryInitiator<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSubqueries(String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public SubqueryBuilder<RestrictionBuilder<PaginatedCriteriaBuilder<T>>> havingSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public PaginatedCriteriaBuilder<T> setHavingExpression(String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public MultipleSubqueryInitiator<PaginatedCriteriaBuilder<T>> setHavingExpressionSubqueries(String expression) {
        throw new IllegalStateException("Calling having() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public <Y> SelectObjectBuilder<PaginatedCriteriaBuilder<Y>> selectNew(Class<Y> clazz) {
        return super.selectNew(clazz);
    }

    public <Y> PaginatedCriteriaBuilder<Y> selectNew(ObjectBuilder<Y> builder) {
        return (PaginatedCriteriaBuilder)super.selectNew(builder);
    }
}

