/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.BetweenBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LikeBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.QuantifiableBinaryPredicateBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateAndSubqueryBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.AbstractQuantifiablePredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.BetweenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.EqPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.GePredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.GtPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LePredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LikeBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.LtPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.internal.RestrictionBuilderExperimental;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class RestrictionBuilderImpl<T>
extends PredicateAndSubqueryBuilderEndedListener<T>
implements RestrictionBuilderExperimental<T>,
LeftHandsideSubqueryPredicateBuilder {
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private Expression leftExpression;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private Predicate predicate;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clause;
    private final SubqueryBuilderListenerImpl<BetweenBuilder<T>> betweenStartSubqueryBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<BetweenBuilder<T>>();
    private SubqueryBuilderListenerImpl<T> rightSuperExprSubqueryBuilderListener;
    private SubqueryBuilderListenerImpl<BetweenBuilder<T>> leftSuperExprSubqueryPredicateBuilderListener;
    private SuperExpressionRightHandsideSubqueryPredicateBuilder rightSuperExprSubqueryPredicateBuilderListener;

    public RestrictionBuilderImpl(T result, PredicateBuilderEndedListener listener, Expression leftExpression, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clause) {
        this.leftExpression = leftExpression;
        this.listener = listener;
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.clause = clause;
    }

    public RestrictionBuilderImpl(T result, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clause) {
        this.listener = listener;
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.clause = clause;
    }

    @Override
    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    private T chain(Predicate predicate) {
        this.verifyBuilderEnded();
        this.predicate = predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public BetweenBuilder<T> between(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, (Expression)this.parameterManager.addParameterExpression(start, this.clause, this.subqueryInitFactory.getQueryBuilder()), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
    }

    public BetweenBuilder<T> betweenLiteral(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        String literal = TypeUtils.asLiteral((Object)start, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.between(start);
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createInItemExpression(literal), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
    }

    public BetweenBuilder<T> betweenExpression(String start) {
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createSimpleExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
    }

    public SubqueryInitiator<BetweenBuilder<T>> betweenSubquery() {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.betweenStartSubqueryBuilderListener, false, this.clause);
    }

    public SubqueryInitiator<BetweenBuilder<T>> betweenSubquery(String subqueryAlias, String expression) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener, false, this.clause);
    }

    public MultipleSubqueryInitiator<BetweenBuilder<T>> betweenSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, expr, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
        return this.simpleMultipleBuilder(betweenBuilder, expr);
    }

    public SubqueryBuilder<BetweenBuilder<T>> betweenSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
        return this.subqueryInitFactory.createSubqueryBuilder(betweenBuilder, this.betweenStartSubqueryBuilderListener, false, criteriaBuilder, this.clause);
    }

    public SubqueryBuilder<BetweenBuilder<T>> betweenSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause));
        return this.subqueryInitFactory.createSubqueryBuilder(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clause);
    }

    private <X> MultipleSubqueryInitiator<X> simpleMultipleBuilder(X result, Expression expr) {
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(result, expr, null, this.subqueryInitFactory, this.clause);
        return initiator;
    }

    private <X> MultipleSubqueryInitiator<X> simpleMultipleBuilder(X result, Expression expr, final AbstractQuantifiablePredicateBuilder predicateBuilder) {
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(result, expr, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                RestrictionBuilderImpl.this.predicate = (Predicate)predicateBuilder.createPredicate(RestrictionBuilderImpl.this.leftExpression, builder.getExpression(), PredicateQuantifier.ONE);
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        }, this.subqueryInitFactory, this.clause);
        this.startBuilder(predicateBuilder);
        predicateBuilder.startBuilder(initiator);
        return initiator;
    }

    public BetweenBuilder<T> notBetween(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, (Expression)this.parameterManager.addParameterExpression(start, this.clause, this.subqueryInitFactory.getQueryBuilder()), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
    }

    public BetweenBuilder<T> notBetweenLiteral(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        String literal = TypeUtils.asLiteral((Object)start, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.notBetween(start);
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createInItemExpression(literal), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
    }

    public BetweenBuilder<T> notBetweenExpression(String start) {
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createSimpleExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
    }

    public SubqueryInitiator<BetweenBuilder<T>> notBetweenSubquery() {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.betweenStartSubqueryBuilderListener, false, this.clause);
    }

    public SubqueryInitiator<BetweenBuilder<T>> notBetweenSubquery(String subqueryAlias, String expression) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener, false, this.clause);
    }

    public MultipleSubqueryInitiator<BetweenBuilder<T>> notBetweenSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, expr, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
        return this.simpleMultipleBuilder(betweenBuilder, expr);
    }

    public SubqueryBuilder<BetweenBuilder<T>> notBetweenSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
        return this.subqueryInitFactory.createSubqueryBuilder(betweenBuilder, this.betweenStartSubqueryBuilderListener, false, criteriaBuilder, this.clause);
    }

    public SubqueryBuilder<BetweenBuilder<T>> notBetweenSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, this.clause, true));
        return this.subqueryInitFactory.createSubqueryBuilder(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener, false, criteriaBuilder, this.clause);
    }

    public QuantifiableBinaryPredicateBuilder<T> eq() {
        return this.startBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T eq(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder())));
    }

    public T eqLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.eq(value);
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal)));
    }

    public T eqExpression(String expression) {
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false)));
    }

    public SubqueryInitiator<T> eq(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> eqSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new EqPredicateBuilder<T>(this.result, this, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> eq(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> eq(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public QuantifiableBinaryPredicateBuilder<T> notEq() {
        return this.startBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T notEq(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder()), true));
    }

    public T notEqLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.notEq(value);
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal), true));
    }

    public T notEqExpression(String expression) {
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false), true));
    }

    public SubqueryInitiator<T> notEq(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> notEqSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new EqPredicateBuilder<T>(this.result, this, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> notEq(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> notEq(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public QuantifiableBinaryPredicateBuilder<T> gt() {
        return this.startBuilder(new GtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T gt(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new GtPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder())));
    }

    public T gtLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.gt(value);
        }
        return this.chain((Predicate)new GtPredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal)));
    }

    public T gtExpression(String expression) {
        return this.chain((Predicate)new GtPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false)));
    }

    public SubqueryInitiator<T> gt(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new GtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> gtSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new GtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> gt(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new GtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> gt(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new GtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public QuantifiableBinaryPredicateBuilder<T> ge() {
        return this.startBuilder(new GePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T ge(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new GePredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder())));
    }

    public T geLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.ge(value);
        }
        return this.chain((Predicate)new GePredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal)));
    }

    public T geExpression(String expression) {
        return this.chain((Predicate)new GePredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false)));
    }

    public SubqueryInitiator<T> ge(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new GePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> geSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new GePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> ge(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new GePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> ge(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new GePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public QuantifiableBinaryPredicateBuilder<T> lt() {
        return this.startBuilder(new LtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T lt(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new LtPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder())));
    }

    public T ltLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.lt(value);
        }
        return this.chain((Predicate)new LtPredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal)));
    }

    public T ltExpression(String expression) {
        return this.chain((Predicate)new LtPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false)));
    }

    public SubqueryInitiator<T> lt(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new LtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> ltSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new LtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> lt(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new LtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> lt(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new LtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public QuantifiableBinaryPredicateBuilder<T> le() {
        return this.startBuilder(new LePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public T le(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new LePredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clause, this.subqueryInitFactory.getQueryBuilder())));
    }

    public T leLiteral(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String literal = TypeUtils.asLiteral((Object)value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
        if (literal == null) {
            return this.le(value);
        }
        return this.chain((Predicate)new LePredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal)));
    }

    public T leExpression(String expression) {
        return this.chain((Predicate)new LePredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false)));
    }

    public SubqueryInitiator<T> le(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new LePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public MultipleSubqueryInitiator<T> leSubqueries(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        return this.simpleMultipleBuilder(this.result, expr, new LePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause));
    }

    public SubqueryBuilder<T> le(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.startSubqueryBuilder(new LePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public SubqueryBuilder<T> le(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return this.startSubqueryBuilder(new LePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clause), criteriaBuilder);
    }

    public T inExpressions(String ... parameterOrLiteralExpressions) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, this.expressionFactory.createInItemExpressions(parameterOrLiteralExpressions)));
    }

    public T inCollectionExpression(String collectionParameterExpression) {
        if (collectionParameterExpression == null) {
            throw new NullPointerException("parameterOrCollectionExpression");
        }
        ParameterExpression collectionParameter = (ParameterExpression)this.expressionFactory.createInItemExpression(collectionParameterExpression);
        collectionParameter.setCollectionValued(true);
        return this.chain((Predicate)new InPredicate(this.leftExpression, new Expression[]{collectionParameter}));
    }

    public T in(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, new Expression[]{this.parameterManager.addParameterExpression(values, this.clause, this.subqueryInitFactory.getQueryBuilder())}));
    }

    public T in(Object ... values) {
        return this.in(Arrays.asList(values));
    }

    public T inLiterals(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        Expression[] literalValues = new Expression[values.size()];
        int i = 0;
        for (Object value : values) {
            String literal = TypeUtils.asLiteral(value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
            if (literal == null) {
                return this.in(values);
            }
            literalValues[i++] = this.expressionFactory.createInItemExpression(literal);
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, literalValues));
    }

    public T inLiterals(Object ... values) {
        return this.inLiterals(Arrays.asList(values));
    }

    public T notInExpressions(String ... parameterOrLiteralExpressions) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        return this.chain((Predicate)new InPredicate(true, this.leftExpression, this.expressionFactory.createInItemExpressions(parameterOrLiteralExpressions)));
    }

    public T notInCollectionExpression(String collectionParameterExpression) {
        if (collectionParameterExpression == null) {
            throw new NullPointerException("collectionParameterExpression");
        }
        ParameterExpression collectionParameter = (ParameterExpression)this.expressionFactory.createInItemExpression(collectionParameterExpression);
        collectionParameter.setCollectionValued(true);
        return this.chain((Predicate)new InPredicate(true, this.leftExpression, new Expression[]{collectionParameter}));
    }

    public T notIn(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        InPredicate inPredicate = new InPredicate(this.leftExpression, new Expression[]{this.parameterManager.addParameterExpression(values, this.clause, this.subqueryInitFactory.getQueryBuilder())});
        inPredicate.setNegated(true);
        return this.chain((Predicate)inPredicate);
    }

    public T notIn(Object ... values) {
        return this.notIn(Arrays.asList(values));
    }

    public T notInLiterals(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        Expression[] literalValues = new Expression[values.size()];
        int i = 0;
        for (Object value : values) {
            String literal = TypeUtils.asLiteral(value, this.subqueryInitFactory.getQueryBuilder().getMetamodel().getEnumTypes().keySet());
            if (literal == null) {
                return this.notIn(values);
            }
            literalValues[i++] = this.expressionFactory.createInItemExpression(literal);
        }
        InPredicate inPredicate = new InPredicate(this.leftExpression, literalValues);
        inPredicate.setNegated(true);
        return this.chain((Predicate)inPredicate);
    }

    public T notInLiterals(Object ... values) {
        return this.notInLiterals(Arrays.asList(values));
    }

    public T isNull() {
        return this.chain((Predicate)new IsNullPredicate(this.leftExpression));
    }

    public T isNotNull() {
        return this.chain((Predicate)new IsNullPredicate(this.leftExpression, true));
    }

    public T isEmpty() {
        return this.chain((Predicate)new IsEmptyPredicate(this.makeCollectionValued(this.leftExpression)));
    }

    public T isNotEmpty() {
        return this.chain((Predicate)new IsEmptyPredicate(this.makeCollectionValued(this.leftExpression), true));
    }

    public T isMemberOf(String expression) {
        return this.chain((Predicate)new MemberOfPredicate(this.leftExpression, this.makeCollectionValued((Expression)this.expressionFactory.createPathExpression(expression))));
    }

    public T isNotMemberOf(String expression) {
        return this.chain((Predicate)new MemberOfPredicate(this.leftExpression, this.makeCollectionValued((Expression)this.expressionFactory.createPathExpression(expression)), true));
    }

    public LikeBuilder<T> like(boolean caseSensitive) {
        return this.startBuilder(new LikeBuilderImpl<T>(this.result, this, this.leftExpression, this.expressionFactory, this.parameterManager, this.subqueryInitFactory, this.clause, false, caseSensitive));
    }

    public LikeBuilder<T> like() {
        return this.like(true);
    }

    public LikeBuilder<T> notLike(boolean caseSensitive) {
        return this.startBuilder(new LikeBuilderImpl<T>(this.result, this, this.leftExpression, this.expressionFactory, this.parameterManager, this.subqueryInitFactory, this.clause, true, caseSensitive));
    }

    public LikeBuilder<T> notLike() {
        return this.notLike(true);
    }

    public SubqueryInitiator<T> in() {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, new Expression[0]);
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clause);
    }

    public SubqueryInitiator<T> notIn() {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(true, this.leftExpression, new Expression[0]);
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clause);
    }

    public SubqueryInitiator<T> in(String subqueryAlias, String expression) {
        return this.in(subqueryAlias, expression, false);
    }

    public SubqueryInitiator<T> notIn(String subqueryAlias, String expression) {
        return this.in(subqueryAlias, expression, true);
    }

    public SubqueryBuilder<T> in(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.in(subqueryAlias, expression, false, criteriaBuilder);
    }

    public SubqueryBuilder<T> notIn(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.in(subqueryAlias, expression, true, criteriaBuilder);
    }

    public SubqueryBuilder<T> in(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, new Expression[0]);
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clause);
    }

    public SubqueryBuilder<T> notIn(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(true, this.leftExpression, new Expression[0]);
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clause);
    }

    private SubqueryInitiator<T> in(String subqueryAlias, String expression, boolean negated) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(negated, this.leftExpression, new Expression[0]);
        Expression superExpression = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryBuilderListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, superExpression){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                RestrictionBuilderImpl.this.onSubqueryBuilderEnded(this.superExpression);
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        };
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this.rightSuperExprSubqueryBuilderListener, false, this.clause);
    }

    private SubqueryBuilder<T> in(String subqueryAlias, String expression, boolean negated, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(negated, this.leftExpression, new Expression[0]);
        Expression superExpression = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryBuilderListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, superExpression){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                RestrictionBuilderImpl.this.onSubqueryBuilderEnded(this.superExpression);
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        };
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this.rightSuperExprSubqueryBuilderListener, false, criteriaBuilder, this.clause);
    }

    public MultipleSubqueryInitiator<T> inSubqueries(String expression) {
        return this.inSubqueries(expression, false);
    }

    public MultipleSubqueryInitiator<T> notInSubqueries(String expression) {
        return this.inSubqueries(expression, true);
    }

    private MultipleSubqueryInitiator<T> inSubqueries(String expression, boolean negated) {
        this.verifyBuilderEnded();
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.predicate = new InPredicate(negated, this.leftExpression, new Expression[0]);
        return new MultipleSubqueryInitiatorImpl<T>(this.result, expr, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                RestrictionBuilderImpl.this.onSubqueryBuilderEnded(builder.getExpression());
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        }, this.subqueryInitFactory, this.clause);
    }

    public RestrictionBuilderExperimental<T> nonPortable() {
        return this;
    }

    @Override
    protected <X extends PredicateBuilder> X startBuilder(X builder) {
        this.betweenStartSubqueryBuilderListener.verifySubqueryBuilderEnded();
        return super.startBuilder(builder);
    }

    protected <X> SubqueryBuilder<X> startSubqueryBuilder(AbstractQuantifiablePredicateBuilder<X> builder, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.betweenStartSubqueryBuilderListener.verifySubqueryBuilderEnded();
        return super.startBuilder(builder).one(criteriaBuilder);
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        this.predicate = builder.getPredicate();
        this.listener.onBuilderEnded(this);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        this.onSubqueryBuilderEnded((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    private void onSubqueryBuilderEnded(Expression rightHandsideExpression) {
        if (!(this.predicate instanceof InPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate was not an IN predicate");
        }
        ((InPredicate)this.predicate).setRight(new ArrayList<Expression>(Arrays.asList(rightHandsideExpression)));
    }

    @Override
    protected void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.betweenStartSubqueryBuilderListener.verifySubqueryBuilderEnded();
        if (this.rightSuperExprSubqueryBuilderListener != null) {
            this.rightSuperExprSubqueryBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.leftSuperExprSubqueryPredicateBuilderListener != null) {
            this.leftSuperExprSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
    }

    private Expression makeCollectionValued(Expression expr) {
        if (!(expr instanceof PathExpression)) {
            throw new SyntaxErrorException("Function expects collection valued path and cannot be applied to predicate [" + expr + "]");
        }
        ((PathExpression)expr).setUsedInCollectionFunction(true);
        return expr;
    }

    private class SuperExpressionRightHandsideSubqueryPredicateBuilder
    implements PredicateBuilderEndedListener {
        private final PredicateBuilderEndedListener listener;
        private final String subqueryAlias;
        private Expression superExpression;

        public SuperExpressionRightHandsideSubqueryPredicateBuilder(String subqueryAlias, Expression superExpression, PredicateBuilderEndedListener listener) {
            this.listener = listener;
            this.subqueryAlias = subqueryAlias;
            this.superExpression = superExpression;
        }

        @Override
        public void onBuilderEnded(PredicateBuilder builder) {
            Predicate expression = builder.getPredicate();
            BinaryExpressionPredicate binaryPred = (BinaryExpressionPredicate)builder.getPredicate();
            SubqueryExpression subqueryExpr = (SubqueryExpression)binaryPred.getRight();
            this.superExpression = ExpressionUtils.replaceSubexpression(this.superExpression, this.subqueryAlias, (Expression)subqueryExpr);
            binaryPred.setRight(this.superExpression);
            this.listener.onBuilderEnded(builder);
        }
    }
}

