/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.CharSequenceUtils;

public class SubSequence
implements CharSequence {
    private final CharSequence string;
    private final int start;
    private final int length;

    public SubSequence(CharSequence string, int start, int end) {
        this.string = string;
        this.start = start;
        this.length = end - start;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.string.charAt(index + this.start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return this.string.subSequence(this.start + start, this.start + end);
    }

    public int lastIndexOf(char c, int fromIndex, int endIndex) {
        int idx = CharSequenceUtils.lastIndexOf(this.string, c, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    public int indexOf(char c, int fromIndex, int endIndex) {
        int idx = CharSequenceUtils.indexOf(this.string, c, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    public int indexOf(String s, int fromIndex, int endIndex) {
        int idx = CharSequenceUtils.indexOf(this.string, s, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    @Override
    public String toString() {
        return this.string.subSequence(this.start, this.start + this.length).toString();
    }
}

