/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.TemporalLiteral;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Timestamp;
import java.util.Date;

public class TimestampLiteral
extends TemporalLiteral {
    public TimestampLiteral(Date value) {
        super(value);
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        return new TimestampLiteral((Date)this.value.clone());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.value instanceof Timestamp) {
            return TypeUtils.TIMESTAMP_CONVERTER.toString((Timestamp)this.value);
        }
        return TypeUtils.DATE_TIMESTAMP_CONVERTER.toString(this.value);
    }
}

