/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class LocalDateTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<LocalDate> {
    public static final TypeConverter<?> INSTANCE = new LocalDateTypeConverter();
    private static final long serialVersionUID = 1L;

    private LocalDateTypeConverter() {
        super("literal_local_date");
    }

    @Override
    public LocalDate convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return LocalDate.of(date.getYear(), date.getMonth(), date.getDate());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDate.of(calendar.get(1), calendar.get(2), calendar.get(5));
        }
        if (value instanceof String) {
            return java.sql.Date.valueOf((String)value).toLocalDate();
        }
        throw LocalDateTypeConverter.unknownConversion(value, LocalDate.class);
    }

    @Override
    public String toString(LocalDate value) {
        return TypeUtils.jdbcDate(value.getYear(), value.getMonthValue(), value.getDayOfMonth());
    }

    @Override
    public void appendTo(LocalDate value, StringBuilder stringBuilder) {
        TypeUtils.appendJdbcDate(stringBuilder, value.getYear(), value.getMonthValue(), value.getDayOfMonth());
    }
}

