/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.LiteralExpression;

public class EnumLiteral
extends AbstractExpression
implements LiteralExpression<Enum<?>> {
    private final Enum<?> value;
    private final String originalExpression;

    public EnumLiteral(Enum<?> value, String originalExpression) {
        this.value = value;
        this.originalExpression = originalExpression;
    }

    @Override
    public Enum<?> getValue() {
        return this.value;
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        return new EnumLiteral(this.value, this.originalExpression);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumLiteral)) {
            return false;
        }
        EnumLiteral that = (EnumLiteral)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.originalExpression;
    }
}

