/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import java.util.Objects;

public interface ExpressionCache<T> {
    public T get(String var1, Key var2);

    public T putIfAbsent(String var1, Key var2, T var3);

    public static class Key {
        private static final byte ALLOW_OUTER_MASK = 1;
        private static final byte ALLOW_QUANTIFIED_PREDICATES_MASK = 2;
        private static final byte ALLOW_OBJECT_EXPRESSION_MASK = 4;
        private final String expression;
        private final byte flags;

        public Key(String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression) {
            this.expression = expression;
            byte flags = 0;
            if (allowOuter) {
                flags = (byte)(flags | 1);
            }
            if (allowOuter) {
                flags = (byte)(flags | 2);
            }
            if (allowObjectExpression) {
                flags = (byte)(flags | 4);
            }
            this.flags = flags;
        }

        public boolean isAllowOuter() {
            return (this.flags & 1) != 0;
        }

        public boolean isAllowQuantifiedPredicates() {
            return (this.flags & 2) != 0;
        }

        public boolean isAllowObjectExpression() {
            return (this.flags & 4) != 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.flags == key.flags && this.expression.equals(key.expression);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.flags);
        }
    }
}

