/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class OffsetDateTimeTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<OffsetDateTime> {
    public static final TypeConverter<?> INSTANCE = new OffsetDateTimeTypeConverter();
    private static final long serialVersionUID = 1L;

    private OffsetDateTimeTypeConverter() {
        super("literal_offset_date_time");
    }

    @Override
    public OffsetDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof String) {
            return OffsetDateTime.ofInstant(Timestamp.valueOf((String)value).toInstant(), ZoneId.systemDefault());
        }
        throw OffsetDateTimeTypeConverter.unknownConversion(value, LocalDateTime.class);
    }

    @Override
    public String toString(OffsetDateTime value) {
        ZonedDateTime zonedDateTime = value.atZoneSameInstant(ZoneId.systemDefault());
        return TypeUtils.jdbcTimestamp(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano());
    }

    @Override
    public void appendTo(OffsetDateTime value, StringBuilder stringBuilder) {
        ZonedDateTime zonedDateTime = value.atZoneSameInstant(ZoneId.systemDefault());
        TypeUtils.appendJdbcTimestamp(stringBuilder, zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano());
    }
}

