/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFrameMode;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WindowDefinition {
    private final String windowName;
    private final List<Expression> partitionExpressions;
    private final List<OrderByItem> orderByExpressions;
    private Predicate filterPredicate;
    private final WindowFrameMode frameMode;
    private final WindowFramePositionType frameStartType;
    private Expression frameStartExpression;
    private final WindowFramePositionType frameEndType;
    private Expression frameEndExpression;
    private final WindowFrameExclusionType frameExclusionType;

    public WindowDefinition(String windowName, Predicate filterPredicate) {
        this.windowName = windowName;
        this.partitionExpressions = Collections.emptyList();
        this.filterPredicate = filterPredicate;
        this.orderByExpressions = Collections.emptyList();
        this.frameMode = null;
        this.frameStartType = null;
        this.frameStartExpression = null;
        this.frameEndType = null;
        this.frameEndExpression = null;
        this.frameExclusionType = null;
    }

    public WindowDefinition(String windowName, List<Expression> partitionExpressions, List<OrderByItem> orderByExpressions, Predicate filterPredicate, WindowFrameMode frameMode, WindowFramePositionType frameStartType, Expression frameStartExpression, WindowFramePositionType frameEndType, Expression frameEndExpression, WindowFrameExclusionType frameExclusionType) {
        this.windowName = windowName;
        this.partitionExpressions = partitionExpressions;
        this.orderByExpressions = orderByExpressions;
        this.filterPredicate = filterPredicate;
        this.frameMode = frameMode;
        this.frameStartType = frameStartType;
        this.frameStartExpression = frameStartExpression;
        this.frameEndType = frameEndType;
        this.frameEndExpression = frameEndExpression;
        this.frameExclusionType = frameExclusionType;
    }

    public WindowDefinition copy(ExpressionCopyContext copyContext) {
        int size = this.partitionExpressions.size();
        ArrayList<Expression> partitionExpressions = new ArrayList<Expression>(size);
        List<Expression> expressions = this.partitionExpressions;
        for (int i = 0; i < size; ++i) {
            partitionExpressions.add(expressions.get(i).copy(copyContext));
        }
        size = this.orderByExpressions.size();
        ArrayList<OrderByItem> orderByExpressions = new ArrayList<OrderByItem>(size);
        for (int i = 0; i < size; ++i) {
            orderByExpressions.add(this.orderByExpressions.get(i).copy(copyContext));
        }
        Predicate filterPredicate = null;
        if (this.filterPredicate != null) {
            filterPredicate = this.filterPredicate.copy(copyContext);
        }
        Expression frameStartExpression = null;
        if (this.frameStartExpression != null) {
            frameStartExpression = this.frameStartExpression.copy(copyContext);
        }
        Expression frameEndExpression = null;
        if (this.frameEndExpression != null) {
            frameEndExpression = this.frameEndExpression.copy(copyContext);
        }
        return new WindowDefinition(this.windowName, partitionExpressions, orderByExpressions, filterPredicate, this.frameMode, this.frameStartType, frameStartExpression, this.frameEndType, frameEndExpression, this.frameExclusionType);
    }

    public boolean isFilterOnly() {
        return this.filterPredicate != null && this.windowName == null && this.partitionExpressions.isEmpty() && this.orderByExpressions.isEmpty() && this.frameMode == null && this.frameExclusionType == null;
    }

    public boolean isEmpty() {
        return this.filterPredicate == null && this.windowName == null && this.partitionExpressions.isEmpty() && this.orderByExpressions.isEmpty() && this.frameMode == null && this.frameExclusionType == null;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public List<Expression> getPartitionExpressions() {
        return this.partitionExpressions;
    }

    public List<OrderByItem> getOrderByExpressions() {
        return this.orderByExpressions;
    }

    public Predicate getFilterPredicate() {
        return this.filterPredicate;
    }

    public void setFilterPredicate(Predicate filterPredicate) {
        this.filterPredicate = filterPredicate;
    }

    public WindowFrameMode getFrameMode() {
        return this.frameMode;
    }

    public WindowFramePositionType getFrameStartType() {
        return this.frameStartType;
    }

    public Expression getFrameStartExpression() {
        return this.frameStartExpression;
    }

    public void setFrameStartExpression(Expression frameStartExpression) {
        this.frameStartExpression = frameStartExpression;
    }

    public WindowFramePositionType getFrameEndType() {
        return this.frameEndType;
    }

    public Expression getFrameEndExpression() {
        return this.frameEndExpression;
    }

    public void setFrameEndExpression(Expression frameEndExpression) {
        this.frameEndExpression = frameEndExpression;
    }

    public WindowFrameExclusionType getFrameExclusionType() {
        return this.frameExclusionType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.windowName == null ? 0 : this.windowName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowDefinition other = (WindowDefinition)obj;
        return !(this.windowName == null ? other.windowName != null : !this.windowName.equals(other.windowName));
    }
}

