/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

public enum ArithmeticOperator {
    ADDITION("+"),
    SUBTRACTION("-"),
    DIVISION("/"),
    MULTIPLICATION("*");

    private final String symbol;

    private ArithmeticOperator(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isAddOrSubtract() {
        return this == ADDITION || this == SUBTRACTION;
    }

    public static ArithmeticOperator fromSymbol(String symbol) {
        for (ArithmeticOperator op : ArithmeticOperator.values()) {
            if (!op.getSymbol().equals(symbol)) continue;
            return op;
        }
        return null;
    }
}

