/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.List;

public abstract class LazyCopyingResultVisitorAdapter
implements Expression.ResultVisitor<Expression> {
    protected void onPathExpressionCopy(PathExpression expression) {
    }

    protected <T extends Expression> List<T> visitExpressionList(List<T> expressions) {
        ArrayList<Expression> newExpressions = null;
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            Expression originalExpr = (Expression)expressions.get(i);
            Expression newExpr = originalExpr.accept(this);
            if (newExpressions == null) {
                if (originalExpr == newExpr) continue;
                newExpressions = new ArrayList<Expression>(expressions.size());
                for (int j = 0; j < i; ++j) {
                    newExpressions.add((Expression)expressions.get(j));
                }
                newExpressions.add(newExpr);
                continue;
            }
            newExpressions.add(newExpr);
        }
        return newExpressions;
    }

    @Override
    public Expression visit(ArrayExpression expression) {
        Expression newBase = expression.getBase().accept(this);
        Expression newIndex = expression.getIndex().accept(this);
        if (expression.getBase() != newBase || expression.getIndex() != newIndex) {
            return new ArrayExpression((PropertyExpression)newBase, newIndex);
        }
        return expression;
    }

    @Override
    public Expression visit(TreatExpression expression) {
        Expression newExpression = expression.getExpression().accept(this);
        if (newExpression != expression.getExpression()) {
            return new TreatExpression(newExpression, expression.getType());
        }
        return expression;
    }

    @Override
    public Expression visit(PropertyExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(ParameterExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(ListIndexExpression expression) {
        Expression newExpression = expression.getPath().accept(this);
        if (newExpression != expression.getPath()) {
            return new ListIndexExpression((PathExpression)newExpression);
        }
        return expression;
    }

    @Override
    public Expression visit(MapEntryExpression expression) {
        Expression newExpression = expression.getPath().accept(this);
        if (newExpression != expression.getPath()) {
            return new MapEntryExpression((PathExpression)newExpression);
        }
        return expression;
    }

    @Override
    public Expression visit(MapKeyExpression expression) {
        Expression newExpression = expression.getPath().accept(this);
        if (newExpression != expression.getPath()) {
            return new MapKeyExpression((PathExpression)newExpression);
        }
        return expression;
    }

    @Override
    public Expression visit(MapValueExpression expression) {
        Expression newExpression = expression.getPath().accept(this);
        if (newExpression != expression.getPath()) {
            return new MapValueExpression((PathExpression)newExpression);
        }
        return expression;
    }

    @Override
    public Expression visit(NullExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(SubqueryExpression expression) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public Expression visit(FunctionExpression expression) {
        List<Expression> newExpressions = this.visitExpressionList(expression.getExpressions());
        boolean copy = false;
        if (newExpressions == null) {
            newExpressions = expression.getExpressions();
        } else {
            copy = true;
        }
        WindowDefinition newWindowDefinition = expression.getWindowDefinition();
        if (newWindowDefinition != null) {
            Expression newFrameEndExpression;
            Expression newFrameStartExpression;
            List<Expression> newPartitionExpressions;
            Predicate newFilterPredicate;
            Predicate predicate = newFilterPredicate = newWindowDefinition.getFilterPredicate() == null ? null : (Predicate)newWindowDefinition.getFilterPredicate().accept(this);
            if (newFilterPredicate != newWindowDefinition.getFilterPredicate()) {
                copy = true;
            }
            if ((newPartitionExpressions = this.visitExpressionList(newWindowDefinition.getPartitionExpressions())) == null) {
                newPartitionExpressions = newWindowDefinition.getPartitionExpressions();
            } else {
                copy = true;
            }
            List<OrderByItem> newOrderByExpressions = this.visitOrderByList(newWindowDefinition.getOrderByExpressions());
            if (newOrderByExpressions == null) {
                newOrderByExpressions = newWindowDefinition.getOrderByExpressions();
            } else {
                copy = true;
            }
            Expression expression2 = newFrameStartExpression = newWindowDefinition.getFrameStartExpression() == null ? null : newWindowDefinition.getFrameStartExpression().accept(this);
            if (newFrameStartExpression != newWindowDefinition.getFrameStartExpression()) {
                copy = true;
            }
            Expression expression3 = newFrameEndExpression = newWindowDefinition.getFrameEndExpression() == null ? null : newWindowDefinition.getFrameEndExpression().accept(this);
            if (newFrameEndExpression != newWindowDefinition.getFrameEndExpression()) {
                copy = true;
            }
            if (copy) {
                newWindowDefinition = new WindowDefinition(newWindowDefinition.getWindowName(), newPartitionExpressions, newOrderByExpressions, newFilterPredicate, newWindowDefinition.getFrameMode(), newWindowDefinition.getFrameStartType(), newFrameStartExpression, newWindowDefinition.getFrameEndType(), newFrameEndExpression, newWindowDefinition.getFrameExclusionType());
            }
        }
        if (copy) {
            return new FunctionExpression(expression.getFunctionName(), newExpressions, newWindowDefinition);
        }
        return expression;
    }

    private List<OrderByItem> visitOrderByList(List<OrderByItem> expressions) {
        ArrayList<OrderByItem> newExpressions = null;
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            OrderByItem orderByItem = expressions.get(i);
            Expression originalExpr = orderByItem.getExpression();
            Expression newExpr = originalExpr.accept(this);
            if (newExpressions == null) {
                if (originalExpr == newExpr) continue;
                newExpressions = new ArrayList<OrderByItem>(expressions.size());
                for (int j = 0; j < i; ++j) {
                    newExpressions.add(expressions.get(j));
                }
                newExpressions.add(new OrderByItem(orderByItem.isAscending(), orderByItem.isNullFirst(), newExpr));
                continue;
            }
            newExpressions.add(new OrderByItem(orderByItem.isAscending(), orderByItem.isNullFirst(), newExpr));
        }
        return newExpressions;
    }

    @Override
    public Expression visit(TypeFunctionExpression expression) {
        Expression newExpr;
        Expression originalExpr = expression.getExpressions().get(0);
        if (originalExpr != (newExpr = originalExpr.accept(this))) {
            return new TypeFunctionExpression(newExpr);
        }
        return expression;
    }

    @Override
    public Expression visit(TrimExpression expression) {
        Expression newTrimCharacter;
        Expression newTrimSource = expression.getTrimSource().accept(this);
        Expression expression2 = newTrimCharacter = expression.getTrimCharacter() == null ? null : expression.getTrimCharacter().accept(this);
        if (expression.getTrimSource() != newTrimSource || expression.getTrimCharacter() != newTrimCharacter) {
            return new TrimExpression(expression.getTrimspec(), newTrimSource, newTrimCharacter);
        }
        return expression;
    }

    @Override
    public Expression visit(WhenClauseExpression expression) {
        Expression newCondition = expression.getCondition().accept(this);
        Expression newResult = expression.getResult().accept(this);
        if (expression.getCondition() != newCondition || expression.getResult() != newResult) {
            return new WhenClauseExpression(newCondition, newResult);
        }
        return expression;
    }

    @Override
    public Expression visit(GeneralCaseExpression expression) {
        List<WhenClauseExpression> newExpressions = this.visitExpressionList(expression.getWhenClauses());
        Expression newDefaultExpr = null;
        if (expression.getDefaultExpr() != null) {
            newDefaultExpr = expression.getDefaultExpr().accept(this);
        }
        if (newExpressions != null) {
            return new GeneralCaseExpression(newExpressions, newDefaultExpr);
        }
        if (expression.getDefaultExpr() != newDefaultExpr) {
            return new GeneralCaseExpression(expression.getWhenClauses(), newDefaultExpr);
        }
        return expression;
    }

    @Override
    public Expression visit(SimpleCaseExpression expression) {
        Expression newCaseOperandExpr = expression.getCaseOperand().accept(this);
        List<WhenClauseExpression> newExpressions = this.visitExpressionList(expression.getWhenClauses());
        Expression newDefaultExpr = null;
        if (expression.getDefaultExpr() != null) {
            newDefaultExpr = expression.getDefaultExpr().accept(this);
        }
        if (newExpressions != null) {
            return new SimpleCaseExpression(newCaseOperandExpr, newExpressions, newDefaultExpr);
        }
        if (expression.getCaseOperand() != newCaseOperandExpr || expression.getDefaultExpr() != newDefaultExpr) {
            return new SimpleCaseExpression(newCaseOperandExpr, expression.getWhenClauses(), newDefaultExpr);
        }
        return expression;
    }

    @Override
    public Expression visit(PathExpression expression) {
        List<PathElementExpression> newExpressions = this.visitExpressionList(expression.getExpressions());
        if (newExpressions != null) {
            PathExpression pathExpression = new PathExpression(newExpressions);
            this.onPathExpressionCopy(pathExpression);
            return pathExpression;
        }
        return expression;
    }

    @Override
    public Expression visit(ArithmeticExpression expression) {
        Expression newLeft = expression.getLeft().accept(this);
        Expression newRight = expression.getRight().accept(this);
        if (newLeft != expression.getLeft() || newRight != expression.getRight()) {
            return new ArithmeticExpression(newLeft, newRight, expression.getOp());
        }
        return expression;
    }

    @Override
    public Expression visit(ArithmeticFactor expression) {
        Expression newExpr = expression.getExpression().accept(this);
        if (newExpr != expression.getExpression()) {
            return new ArithmeticFactor(newExpr, expression.isInvertSignum());
        }
        return expression;
    }

    @Override
    public Expression visit(NumericLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(BooleanLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(StringLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(DateLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(TimeLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(TimestampLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(EnumLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(EntityLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(CompoundPredicate predicate) {
        List<Predicate> newPredicates = this.visitExpressionList(predicate.getChildren());
        if (newPredicates != null) {
            return new CompoundPredicate(predicate.getOperator(), newPredicates, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(EqPredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new EqPredicate(leftExpr, rightExpr, predicate.getQuantifier(), predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(IsNullPredicate predicate) {
        Expression newExpr = predicate.getExpression().accept(this);
        if (newExpr != predicate.getExpression()) {
            return new IsNullPredicate(newExpr, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(IsEmptyPredicate predicate) {
        Expression newExpr = predicate.getExpression().accept(this);
        if (newExpr != predicate.getExpression()) {
            return new IsEmptyPredicate(newExpr, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(MemberOfPredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new MemberOfPredicate(leftExpr, rightExpr, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(LikePredicate predicate) {
        Expression escapeCharacterExpr;
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        Expression expression = escapeCharacterExpr = predicate.getEscapeCharacter() == null ? null : predicate.getEscapeCharacter().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight() || escapeCharacterExpr != predicate.getEscapeCharacter()) {
            return new LikePredicate(leftExpr, rightExpr, predicate.isCaseSensitive(), escapeCharacterExpr, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(BetweenPredicate predicate) {
        Expression newLeftExpr = predicate.getLeft().accept(this);
        Expression newStartExpr = predicate.getStart().accept(this);
        Expression newEndExpr = predicate.getEnd().accept(this);
        if (newLeftExpr != predicate.getLeft() || newStartExpr != predicate.getStart() || newEndExpr != predicate.getEnd()) {
            return new BetweenPredicate(newLeftExpr, newStartExpr, newEndExpr, predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(InPredicate predicate) {
        Expression newLeftExpr = predicate.getLeft().accept(this);
        List<Expression> newExpressions = this.visitExpressionList(predicate.getRight());
        if (newExpressions == null) {
            if (newLeftExpr != predicate.getLeft()) {
                return new InPredicate(predicate.isNegated(), newLeftExpr, predicate.getRight());
            }
        } else {
            return new InPredicate(predicate.isNegated(), newLeftExpr, newExpressions);
        }
        return predicate;
    }

    @Override
    public Expression visit(GtPredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new GtPredicate(leftExpr, rightExpr, predicate.getQuantifier(), predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(GePredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new GePredicate(leftExpr, rightExpr, predicate.getQuantifier(), predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(LtPredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new LtPredicate(leftExpr, rightExpr, predicate.getQuantifier(), predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(LePredicate predicate) {
        Expression leftExpr = predicate.getLeft().accept(this);
        Expression rightExpr = predicate.getRight().accept(this);
        if (leftExpr != predicate.getLeft() || rightExpr != predicate.getRight()) {
            return new LePredicate(leftExpr, rightExpr, predicate.getQuantifier(), predicate.isNegated());
        }
        return predicate;
    }

    @Override
    public Expression visit(ExistsPredicate predicate) {
        Expression newExpr = predicate.getExpression().accept(this);
        if (newExpr != predicate.getExpression()) {
            return new ExistsPredicate(newExpr, predicate.isNegated());
        }
        return predicate;
    }
}

