/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.FunctionKind;
import com.blazebit.persistence.parser.JPQLNextLexer;
import com.blazebit.persistence.parser.JPQLNextParser;
import com.blazebit.persistence.parser.antlr.ANTLRErrorListener;
import com.blazebit.persistence.parser.antlr.CharStreams;
import com.blazebit.persistence.parser.antlr.CodePointCharStream;
import com.blazebit.persistence.parser.antlr.CommonTokenStream;
import com.blazebit.persistence.parser.antlr.Parser;
import com.blazebit.persistence.parser.antlr.ParserRuleContext;
import com.blazebit.persistence.parser.antlr.RecognitionException;
import com.blazebit.persistence.parser.antlr.Recognizer;
import com.blazebit.persistence.parser.antlr.atn.ATNConfigSet;
import com.blazebit.persistence.parser.antlr.atn.ParserATNSimulator;
import com.blazebit.persistence.parser.antlr.atn.PredictionMode;
import com.blazebit.persistence.parser.antlr.dfa.DFA;
import com.blazebit.persistence.parser.expression.AbstractExpressionFactoryMacroAdapter;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionOptimizer;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.JPQLNextExpressionVisitorImpl;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractExpressionFactory
extends AbstractExpressionFactoryMacroAdapter {
    protected static final Logger LOG = Logger.getLogger("com.blazebit.persistence.parser");
    protected static final ANTLRErrorListener ERR_LISTENER = new ANTLRErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new SyntaxErrorException("line " + line + ":" + charPositionInLine + " " + msg);
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    };
    private static final RuleInvoker PATH_RULE_INVOKER = new RuleInvoker(){

        @Override
        public ParserRuleContext invokeRule(JPQLNextParser parser) {
            return parser.parsePathExpression();
        }
    };
    private static final RuleInvoker IN_ITEM_EXPRESSION_RULE_INVOKER = new RuleInvoker(){

        @Override
        public ParserRuleContext invokeRule(JPQLNextParser parser) {
            return parser.parseInItemExpression();
        }
    };
    private static final RuleInvoker IN_ITEM_OR_PATH_EXPRESSION_RULE_INVOKER = new RuleInvoker(){

        @Override
        public ParserRuleContext invokeRule(JPQLNextParser parser) {
            return parser.parseInItemOrPathExpression();
        }
    };
    private static final RuleInvoker PREDICATE_EXPRESSION_RULE_INVOKER = new RuleInvoker(){

        @Override
        public ParserRuleContext invokeRule(JPQLNextParser parser) {
            return parser.parsePredicate();
        }
    };
    private final boolean optimize;
    private final Map<String, FunctionKind> functions;
    private final Map<String, Class<?>> entityTypes;
    private final Map<String, Class<Enum<?>>> enumTypes;
    private final Map<String, Class<Enum<?>>> enumTypesForLiterals;
    private final int minEnumSegmentCount;
    private final int minEntitySegmentCount;
    private final ExpressionOptimizer optimizer = new ExpressionOptimizer();

    protected AbstractExpressionFactory(Map<String, FunctionKind> functions, Map<String, Class<?>> entityTypes, Map<String, Class<Enum<?>>> enumTypes, Map<String, Class<Enum<?>>> enumTypesForLiterals, boolean optimize) {
        int i;
        int count;
        this.functions = functions;
        this.entityTypes = entityTypes;
        this.enumTypes = enumTypes;
        this.enumTypesForLiterals = enumTypesForLiterals;
        this.optimize = optimize;
        int minSegmentCount = Integer.MAX_VALUE;
        for (String fqn : enumTypes.keySet()) {
            count = 1;
            for (i = 0; i < fqn.length(); ++i) {
                if (fqn.charAt(i) != '.') continue;
                ++count;
            }
            minSegmentCount = Math.min(minSegmentCount, count);
        }
        this.minEnumSegmentCount = minSegmentCount;
        minSegmentCount = Integer.MAX_VALUE;
        if (!entityTypes.isEmpty()) {
            for (String fqn : entityTypes.keySet()) {
                count = 0;
                for (i = 0; i < fqn.length(); ++i) {
                    if (fqn.charAt(i) != '.') continue;
                    ++count;
                }
                if (count == 0) continue;
                minSegmentCount = Math.min(minSegmentCount, count);
            }
            if (minSegmentCount == Integer.MAX_VALUE) {
                minSegmentCount = 0;
            }
        }
        this.minEntitySegmentCount = minSegmentCount;
    }

    private Expression createExpression(RuleInvoker ruleInvoker, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        ParserRuleContext ctx;
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("expression");
        }
        CodePointCharStream inputCharStream = CharStreams.fromString(expression);
        JPQLNextLexer l = new JPQLNextLexer(inputCharStream);
        this.configureLexer(l);
        CommonTokenStream tokens = new CommonTokenStream(l);
        JPQLNextParser p = new JPQLNextParser(tokens);
        ((ParserATNSimulator)p.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        this.configureParser(p);
        try {
            try {
                ctx = ruleInvoker.invokeRule(p);
            }
            catch (Exception ex) {
                tokens.seek(0);
                p.reset();
                ((ParserATNSimulator)p.getInterpreter()).setPredictionMode(PredictionMode.LL);
                ctx = ruleInvoker.invokeRule(p);
            }
        }
        catch (SyntaxErrorException ex) {
            throw new SyntaxErrorException("Could not parse expression '" + expression + "', " + ex.getMessage(), ex);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(ctx.toStringTree());
        }
        JPQLNextExpressionVisitorImpl visitor = new JPQLNextExpressionVisitorImpl(this.functions, this.enumTypes, this.enumTypesForLiterals, this.entityTypes, this.minEnumSegmentCount, this.minEntitySegmentCount, macroConfiguration == null ? Collections.EMPTY_MAP : macroConfiguration.macros, usedMacros, allowOuter, allowQuantifiedPredicates, allowObjectExpression, inputCharStream);
        Expression parsedExpression = (Expression)visitor.visit(ctx);
        if (this.optimize) {
            parsedExpression = parsedExpression.accept(this.optimizer);
        }
        return parsedExpression;
    }

    protected abstract RuleInvoker getSimpleExpressionRuleInvoker();

    @Override
    public Expression createPathExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        Expression expr = this.createExpression(PATH_RULE_INVOKER, expression, false, false, false, macroConfiguration, usedMacros);
        if (expr instanceof PathExpression) {
            return expr;
        }
        if (expr instanceof PathElementExpression) {
            ArrayList<PathElementExpression> pathElements = new ArrayList<PathElementExpression>(1);
            pathElements.add((PathElementExpression)expr);
            return new PathExpression(pathElements);
        }
        if (expr instanceof EntityLiteral) {
            String[] parts = ((EntityLiteral)expr).getOriginalExpression().split("\\.");
            ArrayList<PathElementExpression> pathElements = new ArrayList<PathElementExpression>(parts.length);
            for (String part : parts) {
                pathElements.add(new PropertyExpression(part));
            }
            return new PathExpression(pathElements);
        }
        if (expr instanceof FunctionExpression) {
            return expr;
        }
        throw new SyntaxErrorException("Expression does not resolve to a path expression: " + expression);
    }

    @Override
    public Expression createSimpleExpression(String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.createExpression(this.getSimpleExpressionRuleInvoker(), expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, usedMacros);
    }

    @Override
    public List<Expression> createInItemExpressions(String[] parameterOrLiteralExpressions, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        ArrayList<Expression> inItemExpressions = new ArrayList<Expression>();
        if (parameterOrLiteralExpressions.length == 1) {
            inItemExpressions.add(this.createInItemOrPathExpression(parameterOrLiteralExpressions[0], macroConfiguration, usedMacros));
        } else {
            for (String parameterOrLiteralExpression : parameterOrLiteralExpressions) {
                inItemExpressions.add(this.createInItemExpression(parameterOrLiteralExpression, macroConfiguration, usedMacros));
            }
        }
        return inItemExpressions;
    }

    @Override
    public Predicate createBooleanExpression(String expression, boolean allowQuantifiedPredicates, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return (Predicate)this.createExpression(PREDICATE_EXPRESSION_RULE_INVOKER, expression, false, allowQuantifiedPredicates, false, macroConfiguration, usedMacros);
    }

    @Override
    public Expression createInItemExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.createExpression(IN_ITEM_EXPRESSION_RULE_INVOKER, expression, false, false, false, macroConfiguration, usedMacros);
    }

    @Override
    public Expression createInItemOrPathExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.createExpression(IN_ITEM_OR_PATH_EXPRESSION_RULE_INVOKER, expression, false, false, false, macroConfiguration, usedMacros);
    }

    protected void configureLexer(JPQLNextLexer lexer) {
        lexer.removeErrorListeners();
        lexer.addErrorListener(ERR_LISTENER);
    }

    protected void configureParser(JPQLNextParser parser) {
        parser.removeErrorListeners();
        parser.addErrorListener(ERR_LISTENER);
    }

    protected static interface RuleInvoker {
        public ParserRuleContext invokeRule(JPQLNextParser var1);
    }
}

