/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;

public final class OrderByItem {
    private final boolean ascending;
    private final boolean nullFirst;
    private Expression expression;

    public OrderByItem(boolean ascending, boolean nullFirst, Expression expression) {
        this.ascending = ascending;
        this.nullFirst = nullFirst;
        this.expression = expression;
    }

    public OrderByItem copy(ExpressionCopyContext copyContext) {
        return new OrderByItem(this.ascending, this.nullFirst, this.expression.copy(copyContext));
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    public boolean isNullFirst() {
        return this.nullFirst;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.ascending ? 1 : 0);
        hash = 37 * hash + (this.nullFirst ? 1 : 0);
        hash = 37 * hash + (this.expression != null ? this.expression.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderByItem other = (OrderByItem)obj;
        if (this.ascending != other.ascending) {
            return false;
        }
        if (this.nullFirst != other.nullFirst) {
            return false;
        }
        return this.expression == other.expression || this.expression != null && this.expression.equals(other.expression);
    }
}

