/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.InstantTypeConverter;
import com.blazebit.persistence.parser.util.LiteralFunctionTypeConverter;
import com.blazebit.persistence.parser.util.LocalDateTimeTypeConverter;
import com.blazebit.persistence.parser.util.LocalDateTypeConverter;
import com.blazebit.persistence.parser.util.LocalTimeTypeConverter;
import com.blazebit.persistence.parser.util.OffsetDateTimeTypeConverter;
import com.blazebit.persistence.parser.util.OffsetTimeTypeConverter;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeConverterContributor;
import com.blazebit.persistence.parser.util.ZonedDateTimeTypeConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeUtils {
    public static final TypeConverter<Enum<?>> ENUM_CONVERTER = new AbstractTypeConverter<Enum<?>>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Enum<?> convert(Object value) {
            throw 1.unknownConversion(value, Enum.class);
        }

        @Override
        public String toString(Enum<?> value) {
            StringBuilder sb = new StringBuilder(value.getDeclaringClass().getName().length() + value.name().length() + 1);
            this.appendTo(value, sb);
            return sb.toString();
        }

        @Override
        public void appendTo(Enum<?> value, StringBuilder sb) {
            sb.append(value.getDeclaringClass().getName());
            sb.append('.');
            sb.append(value.name());
        }
    };
    public static final TypeConverter<Character> CHARACTER_CONVERTER = new AbstractTypeConverter<Character>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Character convert(Object value) {
            return value == null ? null : Character.valueOf(value.toString().charAt(0));
        }

        @Override
        public String toString(Character value) {
            StringBuilder sb = new StringBuilder(3);
            this.appendTo(value, sb);
            return sb.toString();
        }

        @Override
        public void appendTo(Character value, StringBuilder sb) {
            sb.append('\'');
            char c = value.charValue();
            if (c == '\'') {
                sb.append('\'');
                sb.append('\'');
            } else {
                sb.append(c);
            }
            sb.append('\'');
        }
    };
    public static final TypeConverter<String> STRING_CONVERTER = new AbstractTypeConverter<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String convert(Object value) {
            return value == null ? null : value.toString();
        }

        @Override
        public String toString(String value) {
            StringBuilder sb = new StringBuilder(value.length() + 20);
            this.appendTo(value, sb);
            return sb.toString();
        }

        @Override
        public void appendTo(String value, StringBuilder sb) {
            sb.append('\'');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                    sb.append('\'');
                    continue;
                }
                sb.append(c);
            }
            sb.append('\'');
        }
    };
    public static final TypeConverter<Boolean> BOOLEAN_CONVERTER = new AbstractTypeConverter<Boolean>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Boolean convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            throw 4.unknownConversion(value, Boolean.class);
        }

        @Override
        public void appendTo(Boolean value, StringBuilder stringBuilder) {
            stringBuilder.append(value);
        }
    };
    public static final TypeConverter<Byte> BYTE_CONVERTER = new AbstractTypeConverter<Byte>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Byte convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            throw 5.unknownConversion(value, Byte.class);
        }

        @Override
        public void appendTo(Byte value, StringBuilder stringBuilder) {
            stringBuilder.append(value.byteValue());
        }
    };
    public static final TypeConverter<Short> SHORT_CONVERTER = new AbstractTypeConverter<Short>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Short convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            throw 6.unknownConversion(value, Short.class);
        }

        @Override
        public void appendTo(Short value, StringBuilder stringBuilder) {
            stringBuilder.append(value.shortValue());
        }
    };
    public static final TypeConverter<Integer> INTEGER_CONVERTER = new AbstractTypeConverter<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Integer convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            throw 7.unknownConversion(value, Integer.class);
        }

        @Override
        public void appendTo(Integer value, StringBuilder stringBuilder) {
            stringBuilder.append(value);
        }
    };
    public static final TypeConverter<Long> LONG_CONVERTER = new AbstractTypeConverter<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Long convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            throw 8.unknownConversion(value, Long.class);
        }

        @Override
        public void appendTo(Long value, StringBuilder sb) {
            sb.append(value).append('L');
        }
    };
    public static final TypeConverter<Float> FLOAT_CONVERTER = new AbstractTypeConverter<Float>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Float convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            throw 9.unknownConversion(value, Float.class);
        }

        @Override
        public void appendTo(Float value, StringBuilder sb) {
            sb.append(value.floatValue()).append('F');
        }
    };
    public static final TypeConverter<Double> DOUBLE_CONVERTER = new AbstractTypeConverter<Double>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Double convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            throw 10.unknownConversion(value, Double.class);
        }

        @Override
        public void appendTo(Double value, StringBuilder sb) {
            sb.append(value).append('D');
        }
    };
    public static final TypeConverter<BigInteger> BIG_INTEGER_CONVERTER = new AbstractTypeConverter<BigInteger>(){
        private static final long serialVersionUID = 1L;

        @Override
        public BigInteger convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (value instanceof String) {
                return new BigInteger((String)value);
            }
            throw 11.unknownConversion(value, BigInteger.class);
        }

        @Override
        public void appendTo(BigInteger value, StringBuilder sb) {
            sb.append(value).append("BI");
        }
    };
    public static final TypeConverter<BigDecimal> BIG_DECIMAL_CONVERTER = new AbstractTypeConverter<BigDecimal>(){
        private static final long serialVersionUID = 1L;

        @Override
        public BigDecimal convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Number) {
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            throw 12.unknownConversion(value, BigDecimal.class);
        }

        @Override
        public void appendTo(BigDecimal value, StringBuilder sb) {
            sb.append(value).append("BD");
        }
    };
    public static final TypeConverter<Time> TIME_CONVERTER = new AbstractLiteralFunctionTypeConverter<Time>("literal_time"){
        private static final long serialVersionUID = 1L;

        @Override
        public Time convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Time result = new Time(date.getHours(), date.getMinutes(), date.getSeconds());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Time result = new Time(calendar.get(11), calendar.get(12), calendar.get(13));
                return result;
            }
            if (value instanceof String) {
                return Time.valueOf((String)value);
            }
            throw 13.unknownConversion(value, Time.class);
        }

        @Override
        public String toString(Time value) {
            return TypeUtils.jdbcTime(value.getHours(), value.getMinutes(), value.getSeconds());
        }

        @Override
        public void appendTo(Time value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcTime(stringBuilder, value.getHours(), value.getMinutes(), value.getSeconds());
        }
    };
    public static final TypeConverter<java.util.Date> DATE_AS_TIME_CONVERTER = new AbstractLiteralFunctionTypeConverter<java.util.Date>("literal_util_date"){
        private static final long serialVersionUID = 1L;

        @Override
        public java.util.Date convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Time result = new Time(date.getHours(), date.getMinutes(), date.getSeconds());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Time result = new Time(calendar.get(11), calendar.get(12), calendar.get(13));
                return result;
            }
            if (value instanceof String) {
                return Time.valueOf((String)value);
            }
            throw 14.unknownConversion(value, java.util.Date.class);
        }

        @Override
        public String toString(java.util.Date value) {
            return TypeUtils.jdbcTime(value.getHours(), value.getMinutes(), value.getSeconds());
        }

        @Override
        public void appendTo(java.util.Date value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcTime(stringBuilder, value.getHours(), value.getMinutes(), value.getSeconds());
        }
    };
    public static final TypeConverter<Date> DATE_CONVERTER = new AbstractLiteralFunctionTypeConverter<Date>("literal_date"){
        private static final long serialVersionUID = 1L;

        @Override
        public Date convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Date result = new Date(date.getYear(), date.getMonth(), date.getDate());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Date result = new Date(calendar.get(1), calendar.get(2), calendar.get(5));
                return result;
            }
            if (value instanceof String) {
                return Date.valueOf((String)value);
            }
            throw 15.unknownConversion(value, Date.class);
        }

        @Override
        public String toString(Date value) {
            return TypeUtils.jdbcDate(value.getYear() + 1900, value.getMonth() + 1, value.getDate());
        }

        @Override
        public void appendTo(Date value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcDate(stringBuilder, value.getYear() + 1900, value.getMonth() + 1, value.getDate());
        }
    };
    public static final TypeConverter<java.util.Date> DATE_AS_DATE_CONVERTER = new AbstractLiteralFunctionTypeConverter<java.util.Date>("literal_date"){
        private static final long serialVersionUID = 1L;

        @Override
        public Date convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Date result = new Date(date.getYear(), date.getMonth(), date.getDate());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Date result = new Date(calendar.get(1), calendar.get(2), calendar.get(5));
                return result;
            }
            if (value instanceof String) {
                return Date.valueOf((String)value);
            }
            throw 16.unknownConversion(value, Date.class);
        }

        @Override
        public String toString(java.util.Date value) {
            return TypeUtils.jdbcDate(value.getYear() + 1900, value.getMonth() + 1, value.getDate());
        }

        @Override
        public void appendTo(java.util.Date value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcDate(stringBuilder, value.getYear() + 1900, value.getMonth() + 1, value.getDate());
        }
    };
    public static final TypeConverter<Timestamp> TIMESTAMP_CONVERTER = new AbstractLiteralFunctionTypeConverter<Timestamp>("literal_timestamp"){
        private static final long serialVersionUID = 1L;

        @Override
        public Timestamp convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Timestamp result = new Timestamp(date.getTime());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Timestamp result = new Timestamp(calendar.getTimeInMillis());
                return result;
            }
            if (value instanceof String) {
                return Timestamp.valueOf((String)value);
            }
            throw 17.unknownConversion(value, Timestamp.class);
        }

        @Override
        public String toString(Timestamp value) {
            return TypeUtils.jdbcTimestamp(value.getYear() + 1900, value.getMonth() + 1, value.getDate(), value.getHours(), value.getMinutes(), value.getSeconds(), value.getNanos());
        }

        @Override
        public void appendTo(Timestamp value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcTimestamp(stringBuilder, value.getYear() + 1900, value.getMonth() + 1, value.getDate(), value.getHours(), value.getMinutes(), value.getSeconds(), value.getNanos());
        }
    };
    public static final TypeConverter<java.util.Date> DATE_TIMESTAMP_CONVERTER = new AbstractLiteralFunctionTypeConverter<java.util.Date>("literal_util_date"){
        private static final long serialVersionUID = 1L;

        @Override
        public java.util.Date convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Timestamp result = new Timestamp(date.getTime());
                return result;
            }
            if (value instanceof Calendar) {
                Calendar calendar = (Calendar)value;
                Timestamp result = new Timestamp(calendar.getTimeInMillis());
                return result;
            }
            if (value instanceof String) {
                return Timestamp.valueOf((String)value);
            }
            throw 18.unknownConversion(value, java.util.Date.class);
        }

        @Override
        public String toString(java.util.Date value) {
            return TypeUtils.jdbcTimestamp(value.getYear() + 1900, value.getMonth() + 1, value.getDate(), value.getHours(), value.getMinutes(), value.getSeconds(), (int)(value.getTime() % 1000L * 1000L));
        }

        @Override
        public void appendTo(java.util.Date value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcTimestamp(stringBuilder, value.getYear() + 1900, value.getMonth() + 1, value.getDate(), value.getHours(), value.getMinutes(), value.getSeconds(), (int)(value.getTime() % 1000L * 1000L));
        }
    };
    public static final TypeConverter<Calendar> CALENDAR_CONVERTER = new AbstractLiteralFunctionTypeConverter<Calendar>("literal_calendar"){
        private static final long serialVersionUID = 1L;

        @Override
        public Calendar convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Calendar result = Calendar.getInstance();
                result.setTime(date);
                return result;
            }
            if (value instanceof Calendar) {
                return (Calendar)value;
            }
            if (value instanceof String) {
                Calendar result = Calendar.getInstance();
                result.setTime(Timestamp.valueOf((String)value));
                return result;
            }
            throw 19.unknownConversion(value, Calendar.class);
        }

        @Override
        public String toString(Calendar value) {
            return TypeUtils.jdbcTimestamp(value.get(1), value.get(2) + 1, value.get(5), value.get(11), value.get(12), value.get(13), value.get(14) * 1000000);
        }

        @Override
        public void appendTo(Calendar value, StringBuilder stringBuilder) {
            TypeUtils.appendJdbcTimestamp(stringBuilder, value.get(1), value.get(2) + 1, value.get(5), value.get(11), value.get(12), value.get(13), value.get(14) * 1000000);
        }
    };
    private static final Logger LOG = Logger.getLogger(TypeUtils.class.getName());
    private static final Map<Class<?>, TypeConverter<?>> CONVERTERS;
    private static final Set<TypeConverter<?>> TEMPORAL_CONVERTERS;

    private TypeUtils() {
    }

    static String jdbcTimestamp(int year, int month, int date, int hour, int minute, int second, int nanos) {
        StringBuilder sb = new StringBuilder(36);
        TypeUtils.appendJdbcTimestamp(sb, year, month, date, hour, minute, second, nanos);
        return sb.toString();
    }

    static void appendJdbcTimestamp(StringBuilder sb, int year, int month, int date, int hour, int minute, int second, int nanos) {
        sb.append("{ts '");
        sb.append(year);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date);
        sb.append(' ');
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        if (nanos > 0) {
            sb.append('.');
            String nanoString = Integer.toString(nanos);
            for (int zeros = 9 - nanoString.length(); zeros > 0; --zeros) {
                sb.append('0');
            }
            sb.append(nanoString);
        }
        sb.append("'}");
    }

    static String jdbcDate(int year, int month, int date) {
        StringBuilder sb = new StringBuilder(16);
        TypeUtils.appendJdbcDate(sb, year, month, date);
        return sb.toString();
    }

    static void appendJdbcDate(StringBuilder sb, int year, int month, int date) {
        sb.append("{d '");
        sb.append(year);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date);
        sb.append("'}");
    }

    static String jdbcTime(int hour, int minute, int second) {
        StringBuilder sb = new StringBuilder(14);
        TypeUtils.appendJdbcTime(sb, hour, minute, second);
        return sb.toString();
    }

    static void appendJdbcTime(StringBuilder sb, int hour, int minute, int second) {
        sb.append("{t '");
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        sb.append("'}");
    }

    public static String asLiteral(Object value, Set<String> supportedEnumTypes) {
        TypeConverter<?> converter = TypeUtils.getConverter(value.getClass(), supportedEnumTypes);
        if (converter == null) {
            return null;
        }
        return converter.toString(value);
    }

    public static <T> TypeConverter<T> getConverter(Class<T> targetType, Set<String> supportedEnumTypes) {
        TypeConverter<Object> t = CONVERTERS.get(targetType);
        if (t == null) {
            if (targetType.isEnum()) {
                if (supportedEnumTypes == null || supportedEnumTypes.contains(targetType.getName())) {
                    t = ENUM_CONVERTER;
                }
            } else if (Time.class.isAssignableFrom(targetType)) {
                t = TIME_CONVERTER;
            } else if (Date.class.isAssignableFrom(targetType)) {
                t = DATE_CONVERTER;
            } else if (Timestamp.class.isAssignableFrom(targetType)) {
                t = TIMESTAMP_CONVERTER;
            } else if (java.util.Date.class.isAssignableFrom(targetType)) {
                t = DATE_TIMESTAMP_CONVERTER;
            } else if (Calendar.class.isAssignableFrom(targetType)) {
                t = CALENDAR_CONVERTER;
            }
        }
        return t;
    }

    public static boolean isCharacter(Object value) {
        return value instanceof String || value instanceof Character;
    }

    public static boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    public static boolean isNumeric(Object value) {
        return Number.class.isInstance(value);
    }

    public static boolean isBoolean(Object value) {
        return Boolean.class.isInstance(value);
    }

    public static boolean isTemporalConverter(TypeConverter<?> c) {
        return TEMPORAL_CONVERTERS.contains(c);
    }

    public static <T> T convert(Object value, Class<T> targetType, Set<String> supportedEnumTypes) {
        if (value == null) {
            return null;
        }
        if (targetType.equals(value.getClass())) {
            return (T)value;
        }
        TypeConverter<T> valueHandler = TypeUtils.getConverter(targetType, supportedEnumTypes);
        if (valueHandler == null) {
            throw TypeUtils.unknownConversion(value, targetType);
        }
        return valueHandler.convert(value);
    }

    private static IllegalArgumentException unknownConversion(Object value, Class<?> targetType) {
        String type = value == null ? "unknown" : value.getClass().getName();
        return new IllegalArgumentException("Could not convert '" + value + "' of type '" + type + "' to the type '" + targetType.getName() + "'!");
    }

    static {
        HashMap<Class<Object>, TypeConverter<Object>> c = new HashMap();
        c.put(String.class, STRING_CONVERTER);
        c.put(Boolean.class, BOOLEAN_CONVERTER);
        c.put(Boolean.TYPE, BOOLEAN_CONVERTER);
        c.put(Byte.class, BYTE_CONVERTER);
        c.put(Byte.TYPE, BYTE_CONVERTER);
        c.put(Short.class, SHORT_CONVERTER);
        c.put(Short.TYPE, SHORT_CONVERTER);
        c.put(Character.class, CHARACTER_CONVERTER);
        c.put(Character.TYPE, CHARACTER_CONVERTER);
        c.put(Integer.class, INTEGER_CONVERTER);
        c.put(Integer.TYPE, INTEGER_CONVERTER);
        c.put(Long.class, LONG_CONVERTER);
        c.put(Long.TYPE, LONG_CONVERTER);
        c.put(Float.class, FLOAT_CONVERTER);
        c.put(Float.TYPE, FLOAT_CONVERTER);
        c.put(Double.class, DOUBLE_CONVERTER);
        c.put(Double.TYPE, DOUBLE_CONVERTER);
        c.put(BigInteger.class, BIG_INTEGER_CONVERTER);
        c.put(BigDecimal.class, BIG_DECIMAL_CONVERTER);
        c.put(Time.class, TIME_CONVERTER);
        c.put(Date.class, DATE_CONVERTER);
        c.put(Timestamp.class, TIMESTAMP_CONVERTER);
        c.put(java.util.Date.class, DATE_TIMESTAMP_CONVERTER);
        c.put(Calendar.class, CALENDAR_CONVERTER);
        HashSet temporalConverters = new HashSet();
        temporalConverters.add(TIME_CONVERTER);
        temporalConverters.add(DATE_CONVERTER);
        temporalConverters.add(TIMESTAMP_CONVERTER);
        temporalConverters.add(DATE_TIMESTAMP_CONVERTER);
        temporalConverters.add(CALENDAR_CONVERTER);
        try {
            c.put(Class.forName("java.time.LocalDate"), LocalDateTypeConverter.INSTANCE);
            temporalConverters.add(LocalDateTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.LocalTime"), LocalTimeTypeConverter.INSTANCE);
            temporalConverters.add(LocalTimeTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.LocalDateTime"), LocalDateTimeTypeConverter.INSTANCE);
            temporalConverters.add(LocalDateTimeTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.Instant"), InstantTypeConverter.INSTANCE);
            temporalConverters.add(InstantTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.ZonedDateTime"), ZonedDateTimeTypeConverter.INSTANCE);
            temporalConverters.add(ZonedDateTimeTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.OffsetTime"), OffsetTimeTypeConverter.INSTANCE);
            temporalConverters.add(OffsetTimeTypeConverter.INSTANCE);
            c.put(Class.forName("java.time.OffsetDateTime"), OffsetDateTimeTypeConverter.INSTANCE);
            temporalConverters.add(OffsetDateTimeTypeConverter.INSTANCE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TreeSet<TypeConverterContributor> contributors = new TreeSet<TypeConverterContributor>(new TypeConverterContributorComparator());
        Iterator<TypeConverterContributor> iterator = ServiceLoader.load(TypeConverterContributor.class).iterator();
        while (iterator.hasNext()) {
            try {
                TypeConverterContributor typeConverterContributor = iterator.next();
                contributors.add(typeConverterContributor);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Couldn't load contributor", t);
            }
        }
        for (TypeConverterContributor contributor : contributors) {
            try {
                contributor.registerTypeConverters(c);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "An error occurred while trying to register type converters through: " + contributor.getClass().getName(), t);
            }
        }
        if (!contributors.isEmpty()) {
            c = new HashMap(c);
        }
        CONVERTERS = Collections.unmodifiableMap(c);
        TEMPORAL_CONVERTERS = temporalConverters;
    }

    private static final class TypeConverterContributorComparator
    implements Comparator<TypeConverterContributor> {
        private TypeConverterContributorComparator() {
        }

        @Override
        public int compare(TypeConverterContributor o1, TypeConverterContributor o2) {
            int cmp = Integer.compare(o1.priority(), o2.priority());
            if (cmp == 0) {
                cmp = o1.getClass().getName().compareTo(o2.getClass().getName());
            }
            return cmp;
        }
    }

    static abstract class AbstractLiteralFunctionTypeConverter<T>
    extends AbstractTypeConverter<T>
    implements LiteralFunctionTypeConverter<T> {
        private static final long serialVersionUID = 1L;
        private final String literalFunctionName;

        public AbstractLiteralFunctionTypeConverter(String literalFunctionName) {
            this.literalFunctionName = literalFunctionName;
        }

        @Override
        public String getLiteralFunctionName() {
            return this.literalFunctionName;
        }
    }

    static abstract class AbstractTypeConverter<T>
    implements TypeConverter<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        AbstractTypeConverter() {
        }

        @Override
        public String toString(T value) {
            StringBuilder sb = new StringBuilder();
            this.appendTo(value, sb);
            return sb.toString();
        }

        protected static IllegalArgumentException unknownConversion(Object value, Class<?> targetType) {
            String type = value == null ? "unknown" : value.getClass().getName();
            return new IllegalArgumentException("Could not convert '" + value + "' of type '" + type + "' to the type '" + targetType.getName() + "'!");
        }
    }
}

