/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArithmeticOperator;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.predicate.QuantifiableBinaryExpressionPredicate;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.lang.ref.WeakReference;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SimpleQueryGenerator
implements Expression.Visitor {
    private static final ThreadLocal<WeakReference<SimpleQueryGenerator>> INSTANCE_CACHE = new ThreadLocal();
    protected StringBuilder sb;
    private BooleanLiteralRenderingContext booleanLiteralRenderingContext;
    private ParameterRenderingMode parameterRenderingMode = ParameterRenderingMode.PLACEHOLDER;

    public SimpleQueryGenerator() {
    }

    private SimpleQueryGenerator(StringBuilder sb) {
        this.sb = sb;
    }

    public static SimpleQueryGenerator getThreadLocalInstance() {
        SimpleQueryGenerator simpleQueryGenerator;
        WeakReference<SimpleQueryGenerator> weakReference = INSTANCE_CACHE.get();
        if (weakReference == null || (simpleQueryGenerator = (SimpleQueryGenerator)weakReference.get()) == null) {
            simpleQueryGenerator = new SimpleQueryGenerator(new StringBuilder());
            INSTANCE_CACHE.set(new WeakReference<SimpleQueryGenerator>(simpleQueryGenerator));
        }
        return simpleQueryGenerator;
    }

    public void generate(Expression expression) {
        expression.accept(this);
    }

    public void clear() {
        this.sb.setLength(0);
        this.booleanLiteralRenderingContext = null;
        this.parameterRenderingMode = ParameterRenderingMode.PLACEHOLDER;
    }

    public BooleanLiteralRenderingContext setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext booleanLiteralRenderingContext) {
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.booleanLiteralRenderingContext;
        this.booleanLiteralRenderingContext = booleanLiteralRenderingContext;
        return oldBooleanLiteralRenderingContext;
    }

    public BooleanLiteralRenderingContext getBooleanLiteralRenderingContext() {
        return this.booleanLiteralRenderingContext;
    }

    public StringBuilder getQueryBuffer() {
        return this.sb;
    }

    public void setQueryBuffer(StringBuilder sb) {
        this.sb = sb;
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public ParameterRenderingMode setParameterRenderingMode(ParameterRenderingMode parameterRenderingMode) {
        ParameterRenderingMode oldParameterRenderingMode = this.parameterRenderingMode;
        this.parameterRenderingMode = parameterRenderingMode;
        return oldParameterRenderingMode;
    }

    protected String getBooleanExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    protected String escapeCharacter(char character) {
        return Character.toString(character);
    }

    protected void renderLikePattern(LikePredicate predicate) {
        predicate.getRight().accept(this);
    }

    @Override
    public void visit(CompoundPredicate predicate) {
        boolean parenthesisRequired;
        BooleanLiteralRenderingContext oldConditionalContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PREDICATE);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        boolean bl = parenthesisRequired = predicate.getChildren().size() > 1;
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
            if (parenthesisRequired) {
                this.sb.append('(');
            }
        }
        if (predicate.getChildren().size() == 1) {
            predicate.getChildren().get(0).accept(this);
            return;
        }
        int startLen = this.sb.length();
        String operator = " " + predicate.getOperator().toString() + " ";
        List<Predicate> children = predicate.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Predicate child = children.get(i);
            if (child instanceof CompoundPredicate && ((CompoundPredicate)child).getOperator() != predicate.getOperator() && !child.isNegated()) {
                this.sb.append("(");
                int len = this.sb.length();
                child.accept(this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    continue;
                }
                this.sb.append(")");
                this.sb.append(operator);
                continue;
            }
            child.accept(this);
            this.sb.append(operator);
        }
        if (startLen < this.sb.length()) {
            this.sb.delete(this.sb.length() - operator.length(), this.sb.length());
        }
        if (predicate.isNegated() && parenthesisRequired) {
            this.sb.append(')');
        }
        this.setBooleanLiteralRenderingContext(oldConditionalContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(EqPredicate predicate) {
        if (predicate.isNegated()) {
            this.visitQuantifiableBinaryPredicate(predicate, " <> ");
        } else {
            this.visitQuantifiableBinaryPredicate(predicate, " = ");
        }
    }

    @Override
    public void visit(IsNullPredicate predicate) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        predicate.getExpression().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT NULL");
        } else {
            this.sb.append(" IS NULL");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(IsEmptyPredicate predicate) {
        predicate.getExpression().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT EMPTY");
        } else {
            this.sb.append(" IS EMPTY");
        }
    }

    @Override
    public void visit(MemberOfPredicate predicate) {
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        predicate.getLeft().accept(this);
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
        if (predicate.isNegated()) {
            this.sb.append(" NOT MEMBER OF ");
        } else {
            this.sb.append(" MEMBER OF ");
        }
        predicate.getRight().accept(this);
    }

    @Override
    public void visit(LikePredicate predicate) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        if (!predicate.isCaseSensitive()) {
            this.sb.append("UPPER(");
        }
        predicate.getLeft().accept(this);
        if (!predicate.isCaseSensitive()) {
            this.sb.append(")");
        }
        if (predicate.isNegated()) {
            this.sb.append(" NOT LIKE ");
        } else {
            this.sb.append(" LIKE ");
        }
        if (!predicate.isCaseSensitive()) {
            this.sb.append("UPPER(");
        }
        this.renderLikePattern(predicate);
        if (!predicate.isCaseSensitive()) {
            this.sb.append(")");
        }
        if (predicate.getEscapeCharacter() != null) {
            this.sb.append(" ESCAPE ");
            if (predicate.getEscapeCharacter() instanceof StringLiteral) {
                TypeUtils.STRING_CONVERTER.appendTo(this.escapeCharacter(((StringLiteral)predicate.getEscapeCharacter()).getValue().charAt(0)), this.sb);
            } else {
                predicate.getEscapeCharacter().accept(this);
            }
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(BetweenPredicate predicate) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        predicate.getLeft().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" NOT BETWEEN ");
        } else {
            this.sb.append(" BETWEEN ");
        }
        predicate.getStart().accept(this);
        this.sb.append(" AND ");
        predicate.getEnd().accept(this);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(InPredicate predicate) {
        Expression singleRightExpression;
        List<Expression> rightList = predicate.getRight();
        if (rightList.size() == 1) {
            Expression right = rightList.get(0);
            if (right instanceof ParameterExpression) {
                Object collection;
                ParameterExpression parameterExpr = (ParameterExpression)right;
                if (parameterExpr.getValue() != null && parameterExpr.isCollectionValued() && ((Collection)(collection = parameterExpr.getValue())).isEmpty()) {
                    if (this.booleanLiteralRenderingContext == BooleanLiteralRenderingContext.PREDICATE) {
                        this.sb.append(this.getBooleanConditionalExpression(predicate.isNegated()));
                    } else {
                        this.sb.append(this.getBooleanExpression(predicate.isNegated()));
                    }
                    return;
                }
            } else if (right instanceof PathExpression) {
                BooleanLiteralRenderingContext oldConditionalContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
                predicate.getLeft().accept(this);
                if (predicate.isNegated()) {
                    this.sb.append(" <> ");
                } else {
                    this.sb.append(" = ");
                }
                right.accept(this);
                this.setBooleanLiteralRenderingContext(oldConditionalContext);
                return;
            }
        }
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        predicate.getLeft().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" NOT IN ");
        } else {
            this.sb.append(" IN ");
        }
        boolean parenthesisRequired = rightList.size() == 1 ? ((singleRightExpression = rightList.get(0)) instanceof ParameterExpression && ((ParameterExpression)singleRightExpression).isCollectionValued() ? false : !(singleRightExpression instanceof SubqueryExpression) || !this.isSimpleSubquery((SubqueryExpression)singleRightExpression)) : true;
        if (parenthesisRequired) {
            this.sb.append('(');
        }
        if (!rightList.isEmpty()) {
            rightList.get(0).accept(this);
            for (int i = 1; i < rightList.size(); ++i) {
                this.sb.append(", ");
                rightList.get(i).accept(this);
            }
        }
        if (parenthesisRequired) {
            this.sb.append(')');
        }
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    protected boolean isSimpleSubquery(SubqueryExpression expression) {
        return true;
    }

    @Override
    public void visit(ExistsPredicate predicate) {
        if (predicate.isNegated()) {
            this.sb.append("NOT EXISTS ");
        } else {
            this.sb.append("EXISTS ");
        }
        predicate.getExpression().accept(this);
    }

    private void visitQuantifiableBinaryPredicate(QuantifiableBinaryExpressionPredicate predicate, String operator) {
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        predicate.getLeft().accept(this);
        this.sb.append(operator);
        if (predicate.getQuantifier() != PredicateQuantifier.ONE) {
            this.sb.append(predicate.getQuantifier().toString());
        }
        predicate.getRight().accept(this);
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(GtPredicate predicate) {
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
        }
        this.visitQuantifiableBinaryPredicate(predicate, " > ");
    }

    @Override
    public void visit(GePredicate predicate) {
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
        }
        this.visitQuantifiableBinaryPredicate(predicate, " >= ");
    }

    @Override
    public void visit(LtPredicate predicate) {
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
        }
        this.visitQuantifiableBinaryPredicate(predicate, " < ");
    }

    @Override
    public void visit(LePredicate predicate) {
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
        }
        this.visitQuantifiableBinaryPredicate(predicate, " <= ");
    }

    @Override
    public void visit(ParameterExpression expression) {
        String value;
        if (expression.getName() == null) {
            throw new IllegalStateException("Unsatisfied parameter " + expression.getName());
        }
        String paramName = expression.getName();
        if ((ParameterRenderingMode.LITERAL == this.parameterRenderingMode || this.getSupportedEnumTypes() == null && expression.getValue() instanceof Enum) && (value = this.getLiteralParameterValue(expression)) != null) {
            this.sb.append(value);
        } else {
            if (Character.isDigit(paramName.charAt(0))) {
                this.sb.append("?");
            } else {
                this.sb.append(":");
            }
            this.sb.append(paramName);
        }
    }

    protected Set<String> getSupportedEnumTypes() {
        return null;
    }

    protected String getLiteralParameterValue(ParameterExpression expression) {
        Object value = expression.getValue();
        if (value != null) {
            TypeConverter<?> converter = TypeUtils.getConverter(value.getClass(), this.getSupportedEnumTypes());
            return converter.toString(value);
        }
        return null;
    }

    @Override
    public void visit(NullExpression expression) {
        this.sb.append("NULL");
    }

    @Override
    public void visit(PathExpression expression) {
        List<PathElementExpression> pathProperties = expression.getExpressions();
        int size = pathProperties.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            pathProperties.get(0).accept(this);
            return;
        }
        pathProperties.get(0).accept(this);
        for (int i = 1; i < size; ++i) {
            this.sb.append(".");
            pathProperties.get(i).accept(this);
        }
    }

    @Override
    public void visit(PropertyExpression expression) {
        this.sb.append(expression.getProperty());
    }

    @Override
    public void visit(SubqueryExpression expression) {
        this.sb.append('(');
        this.sb.append(expression.getSubquery().getQueryString());
        this.sb.append(')');
    }

    @Override
    public void visit(ListIndexExpression expression) {
        this.sb.append("INDEX(");
        expression.getPath().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(MapEntryExpression expression) {
        this.sb.append("ENTRY(");
        expression.getPath().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(MapKeyExpression expression) {
        this.sb.append("KEY(");
        expression.getPath().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(MapValueExpression expression) {
        this.sb.append("VALUE(");
        expression.getPath().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(FunctionExpression expression) {
        if (expression.getRealArgument() != null) {
            expression.getRealArgument().accept(this);
            return;
        }
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        List<Expression> expressions = expression.getExpressions();
        int size = expressions.size();
        boolean hasExpressions = size != 0;
        String functionName = expression.getFunctionName();
        WindowDefinition windowDefinition = expression.getWindowDefinition();
        if (expression instanceof AggregateExpression && windowDefinition != null && windowDefinition.isFilterOnly()) {
            this.sb.append(functionName, "window_".length(), functionName.length());
        } else {
            this.sb.append(functionName);
        }
        if (!("CURRENT_TIME".equalsIgnoreCase(functionName) || "CURRENT_DATE".equalsIgnoreCase(functionName) || "CURRENT_TIMESTAMP".equalsIgnoreCase(functionName))) {
            this.sb.append('(');
            if (expression instanceof AggregateExpression) {
                AggregateExpression aggregateExpression = (AggregateExpression)expression;
                if (aggregateExpression.isDistinct()) {
                    this.sb.append("DISTINCT ");
                }
                if (!hasExpressions && "COUNT".equalsIgnoreCase(aggregateExpression.getFunctionName())) {
                    this.sb.append('*');
                }
            }
            if (hasExpressions) {
                expressions.get(0).accept(this);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    expressions.get(i).accept(this);
                }
            }
            this.sb.append(')');
            List<OrderByItem> withinGroup = expression.getWithinGroup();
            if (withinGroup != null && !withinGroup.isEmpty()) {
                this.sb.append(" WITHIN GROUP (");
                for (int i = 0; i < withinGroup.size(); ++i) {
                    this.visit(withinGroup.get(i));
                    this.sb.append(", ");
                }
                this.sb.setLength(this.sb.length() - 1);
                this.sb.setCharAt(this.sb.length() - 1, ')');
            }
            this.visitWindowDefinition(windowDefinition);
        }
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    protected void visitWindowDefinition(WindowDefinition windowDefinition) {
        if (windowDefinition != null) {
            boolean needsOverClause;
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null) {
                this.sb.append(" FILTER (WHERE ");
                filterPredicate.accept(this);
                this.sb.append(")");
            }
            List<Expression> partitionExpressions = windowDefinition.getPartitionExpressions();
            List<OrderByItem> orderByExpressions = windowDefinition.getOrderByExpressions();
            boolean hasPartitionOrderByOrFrameClause = partitionExpressions.size() != 0 || orderByExpressions.size() != 0 || windowDefinition.getFrameMode() != null || windowDefinition.getFrameExclusionType() != null;
            boolean bl = needsOverClause = hasPartitionOrderByOrFrameClause || windowDefinition.getWindowName() != null;
            if (needsOverClause) {
                int i;
                int size;
                this.sb.append(" OVER ");
                if (hasPartitionOrderByOrFrameClause) {
                    this.sb.append('(');
                }
                if (windowDefinition.getWindowName() != null) {
                    this.sb.append(windowDefinition.getWindowName());
                    if (hasPartitionOrderByOrFrameClause) {
                        this.sb.append(' ');
                    }
                }
                if ((size = partitionExpressions.size()) != 0) {
                    this.sb.append("PARTITION BY ");
                    partitionExpressions.get(0).accept(this);
                    for (i = 1; i < size; ++i) {
                        this.sb.append(", ");
                        partitionExpressions.get(i).accept(this);
                    }
                }
                if ((size = orderByExpressions.size()) != 0) {
                    if (partitionExpressions.size() != 0) {
                        this.sb.append(' ');
                    }
                    this.sb.append("ORDER BY ");
                    this.visit(orderByExpressions.get(0));
                    for (i = 1; i < size; ++i) {
                        this.sb.append(", ");
                        this.visit(orderByExpressions.get(i));
                    }
                }
                if (windowDefinition.getFrameMode() != null) {
                    this.sb.append(' ');
                    this.sb.append(windowDefinition.getFrameMode().name());
                    if (windowDefinition.getFrameEndType() != null) {
                        this.sb.append(" BETWEEN ");
                    }
                    if (windowDefinition.getFrameStartExpression() != null) {
                        windowDefinition.getFrameStartExpression().accept(this);
                        this.sb.append(' ');
                    }
                    this.sb.append(this.getFrameType(windowDefinition.getFrameStartType()));
                    if (windowDefinition.getFrameEndType() != null) {
                        this.sb.append(" AND ");
                        if (windowDefinition.getFrameEndExpression() != null) {
                            windowDefinition.getFrameEndExpression().accept(this);
                            this.sb.append(' ');
                        }
                        this.sb.append(this.getFrameType(windowDefinition.getFrameEndType()));
                    }
                    if (windowDefinition.getFrameExclusionType() != null) {
                        this.sb.append(' ');
                        this.sb.append(this.getFrameExclusionType(windowDefinition.getFrameExclusionType()));
                    }
                }
                if (hasPartitionOrderByOrFrameClause) {
                    this.sb.append(')');
                }
            }
        }
    }

    protected String getFrameExclusionType(WindowFrameExclusionType frameExclusionType) {
        switch (frameExclusionType) {
            case EXCLUDE_CURRENT_ROW: {
                return "EXCLUDE CURRENT ROW";
            }
            case EXCLUDE_GROUP: {
                return "EXCLUDE GROUP";
            }
            case EXCLUDE_NO_OTHERS: {
                return "EXCLUDE NO OTHERS";
            }
            case EXCLUDE_TIES: {
                return "EXCLUDE TIES";
            }
        }
        throw new IllegalArgumentException("No branch for " + (Object)((Object)frameExclusionType));
    }

    protected String getFrameType(WindowFramePositionType frameStartType) {
        switch (frameStartType) {
            case CURRENT_ROW: {
                return "CURRENT ROW";
            }
            case BOUNDED_FOLLOWING: {
                return "FOLLOWING";
            }
            case BOUNDED_PRECEDING: {
                return "PRECEDING";
            }
            case UNBOUNDED_FOLLOWING: {
                return "UNBOUNDED FOLLOWING";
            }
            case UNBOUNDED_PRECEDING: {
                return "UNBOUNDED PRECEDING";
            }
        }
        throw new IllegalArgumentException("No branch for " + (Object)((Object)frameStartType));
    }

    private void visit(OrderByItem orderByItem) {
        orderByItem.getExpression().accept(this);
        this.sb.append(orderByItem.isAscending() ? " ASC" : " DESC");
        this.sb.append(orderByItem.isNullFirst() ? " NULLS FIRST" : " NULLS LAST");
    }

    @Override
    public void visit(TypeFunctionExpression expression) {
        this.visit((FunctionExpression)expression);
    }

    @Override
    public void visit(TrimExpression expression) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        this.sb.append("TRIM(").append(expression.getTrimspec().name()).append(' ');
        if (expression.getTrimCharacter() != null) {
            expression.getTrimCharacter().accept(this);
            this.sb.append(' ');
        }
        this.sb.append("FROM ");
        expression.getTrimSource().accept(this);
        this.sb.append(')');
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(GeneralCaseExpression expression) {
        this.handleCaseWhen(null, expression.getWhenClauses(), expression.getDefaultExpr());
    }

    @Override
    public void visit(SimpleCaseExpression expression) {
        this.handleCaseWhen(expression.getCaseOperand(), expression.getWhenClauses(), expression.getDefaultExpr());
    }

    @Override
    public void visit(WhenClauseExpression expression) {
        this.sb.append("WHEN ");
        BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PREDICATE);
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        this.visitWhenClauseCondition(expression.getCondition());
        this.setParameterRenderingMode(oldParameterRenderingMode);
        this.sb.append(" THEN ");
        boolean requiresParenthesis = this.needsParenthesisForCaseResult(expression.getResult());
        if (requiresParenthesis) {
            this.sb.append('(');
        }
        this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
        expression.getResult().accept(this);
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        if (requiresParenthesis) {
            this.sb.append(')');
        }
    }

    protected void visitWhenClauseCondition(Expression condition) {
        condition.accept(this);
    }

    private void handleCaseWhen(Expression caseOperand, List<WhenClauseExpression> whenClauses, Expression defaultExpr) {
        this.sb.append("CASE ");
        if (caseOperand != null) {
            ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
            caseOperand.accept(this);
            this.setParameterRenderingMode(oldParameterRenderingMode);
            this.sb.append(' ');
        }
        int size = whenClauses.size();
        for (int i = 0; i < size; ++i) {
            whenClauses.get(i).accept(this);
            this.sb.append(' ');
        }
        if (defaultExpr != null) {
            this.sb.append("ELSE ");
            BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(BooleanLiteralRenderingContext.PLAIN);
            boolean requiresParenthesis = this.needsParenthesisForCaseResult(defaultExpr);
            if (requiresParenthesis) {
                this.sb.append('(');
            }
            defaultExpr.accept(this);
            if (requiresParenthesis) {
                this.sb.append(')');
            }
            this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
            this.sb.append(' ');
        } else {
            this.sb.append("ELSE ");
            this.visit((NullExpression)null);
            this.sb.append(' ');
        }
        this.sb.append("END");
    }

    protected boolean needsParenthesisForCaseResult(Expression expression) {
        return false;
    }

    @Override
    public void visit(ArrayExpression expression) {
        expression.getBase().accept(this);
        this.sb.append('[');
        expression.getIndex().accept(this);
        this.sb.append(']');
    }

    @Override
    public void visit(TreatExpression expression) {
        this.sb.append("TREAT(");
        expression.getExpression().accept(this);
        this.sb.append(" AS ");
        this.sb.append(expression.getType());
        this.sb.append(')');
    }

    @Override
    public void visit(ArithmeticExpression expression) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        ArithmeticOperator op = expression.getOp();
        if (expression.getLeft() instanceof ArithmeticExpression) {
            ArithmeticExpression left = (ArithmeticExpression)expression.getLeft();
            ArithmeticOperator leftOp = left.getOp();
            if (leftOp == ArithmeticOperator.DIVISION || !op.isAddOrSubtract() && leftOp.isAddOrSubtract()) {
                this.sb.append("(");
                expression.getLeft().accept(this);
                this.sb.append(")");
            } else {
                expression.getLeft().accept(this);
            }
        } else {
            expression.getLeft().accept(this);
        }
        this.sb.append(" ").append(expression.getOp().getSymbol()).append(" ");
        if (expression.getRight() instanceof ArithmeticExpression) {
            ArithmeticExpression right = (ArithmeticExpression)expression.getRight();
            ArithmeticOperator rightOp = right.getOp();
            if (rightOp == ArithmeticOperator.DIVISION || op == ArithmeticOperator.SUBTRACTION || !op.isAddOrSubtract() && rightOp.isAddOrSubtract()) {
                this.sb.append("(");
                expression.getRight().accept(this);
                this.sb.append(")");
            } else {
                expression.getRight().accept(this);
            }
        } else {
            expression.getRight().accept(this);
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(ParameterRenderingMode.PLACEHOLDER);
        if (expression.isInvertSignum()) {
            this.sb.append('-');
        }
        expression.getExpression().accept(this);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    @Override
    public void visit(NumericLiteral expression) {
        this.sb.append(expression.getValue());
    }

    @Override
    public void visit(BooleanLiteral expression) {
        if (expression.isNegated()) {
            this.sb.append(" NOT ");
        }
        switch (this.booleanLiteralRenderingContext) {
            case PLAIN: {
                this.sb.append(expression.getValue());
                break;
            }
            case PREDICATE: {
                this.sb.append(this.getBooleanConditionalExpression(expression.getValue()));
                break;
            }
            case CASE_WHEN: {
                this.sb.append(this.getBooleanExpression(expression.getValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid boolean literal rendering context: " + (Object)((Object)this.booleanLiteralRenderingContext));
            }
        }
    }

    @Override
    public void visit(StringLiteral expression) {
        TypeUtils.STRING_CONVERTER.appendTo(expression.getValue(), this.sb);
    }

    @Override
    public void visit(DateLiteral expression) {
        TypeUtils.DATE_AS_DATE_CONVERTER.appendTo(expression.getValue(), this.sb);
    }

    @Override
    public void visit(TimeLiteral expression) {
        TypeUtils.DATE_AS_TIME_CONVERTER.appendTo(expression.getValue(), this.sb);
    }

    @Override
    public void visit(TimestampLiteral expression) {
        Date value = expression.getValue();
        if (value instanceof Timestamp) {
            TypeUtils.TIMESTAMP_CONVERTER.appendTo((Timestamp)value, this.sb);
        } else {
            TypeUtils.DATE_TIMESTAMP_CONVERTER.appendTo(expression.getValue(), this.sb);
        }
    }

    @Override
    public void visit(EnumLiteral expression) {
        this.sb.append(expression.getOriginalExpression());
    }

    @Override
    public void visit(EntityLiteral expression) {
        this.sb.append(expression.getOriginalExpression());
    }

    public static enum ParameterRenderingMode {
        LITERAL,
        PLACEHOLDER;

    }

    public static enum BooleanLiteralRenderingContext {
        PLAIN,
        PREDICATE,
        CASE_WHEN;

    }
}

